/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.util.xml;

import br.com.taragona.nfe.classes.CabecMsg;
import br.com.taragona.nfe.classes.cancelamento.TCancNFe;
import br.com.taragona.nfe.classes.consulta.TConsSitNFe;
import br.com.taragona.nfe.classes.estadoservicos.TConsStatServ;
import br.com.taragona.nfe.classes.inutilizacao.TInutNFe;
import br.com.taragona.nfe.classes.recepcao.TEnviNFe;
import br.com.taragona.nfe.classes.retrecepcao.TConsReciNFe;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.ParChave;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class XMLFactory {
    private static Hashtable<String, Hashtable<String, String>> versaoEsquema = new Hashtable();
    private static int lote_vazio = 0;
    private static Hashtable<String, String> cnpjsUfs = new Hashtable();
    private static String tipoAmbienteDefault;
    private static Hashtable<ParChave, String> tipoServicos;
    private static XMLGenerator xmlsRecepcao;
    private static XMLGenerator xmlsRetRecepcao;
    private static XMLGenerator xmlsConsulta;
    private static XMLGenerator xmlsConsultav200;
    private static XMLGenerator xmlsCancelamento;
    private static XMLGenerator xmlsInut;
    private static XMLGenerator xmlsCab;
    private static XMLGenerator xmlsStatus;
    private static XMLGenerator xmlsRetCanc;
    private static XMLGenerator xmlsDpec;
    private static Random rand;

    static {
        xmlsRecepcao = new XMLGenerator("br.com.tti.nfev310.retreci");
        xmlsRetRecepcao = new XMLGenerator("br.com.taragona.nfe.classes.retrecepcao");
        xmlsConsulta = new XMLGenerator("br.com.taragona.nfe.controle.eventoret");
        xmlsConsultav200 = new XMLGenerator("br.com.tti.nfev200");
        xmlsCancelamento = new XMLGenerator("br.com.taragona.nfe.classes.cancelamento");
        xmlsInut = new XMLGenerator("br.com.taragona.nfe.classes.inutilizacao");
        xmlsCab = new XMLGenerator("br.com.taragona.nfe.classes");
        xmlsStatus = new XMLGenerator("br.com.taragona.nfe.classes.estadoservicos");
        xmlsRetCanc = new XMLGenerator("br.com.taragona.nfe.classes.retcancelamento");
        xmlsDpec = new XMLGenerator("br.com.tti.dpec.classes");
        rand = new Random(Calendar.getInstance().getTimeInMillis());
    }

    public static String generarId() {
        return String.valueOf(Math.abs(rand.nextInt()));
    }

    public static String obterTipoAmbiente(String cnpj, String tpAmb) {
        if (tpAmb != null && !tpAmb.equals("")) {
            return tpAmb;
        }
        ParChave chave = new ParChave(cnpj, tpAmb);
        String tipoAmbiente = tipoServicos.get(chave);
        if (tipoAmbiente == null) {
            tipoAmbiente = "";
        }
        if (tipoAmbiente.equals(PropriedadesSistema.ID_PRODUCAO) || tipoAmbiente.equals(PropriedadesSistema.ID_SCAN)) {
            return "1";
        }
        return "2";
    }

    public static synchronized String montarLote(String idLote, Vector<String> notasXML, String CNPJ) {
        String versao = XMLFactory.obterVersaoUF(TEnviNFe.class, cnpjsUfs.get(CNPJ), CNPJ);
        String loteString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><enviNFe xmlns=\"http://www.portalfiscal.inf.br/nfe\" versao=\"" + versao + "\">";
        String tipoenvio = ConfiguracaoSys.getTipoEnvio().get(CNPJ);
        String string = tipoenvio = tipoenvio.equals("ASYNC") ? "1" : "0";
        if (notasXML.size() < 2) {
            tipoenvio = "1";
        }
        loteString = String.valueOf(loteString) + "<idLote>" + idLote + "</idLote><indSinc>" + tipoenvio + "</indSinc>";
        for (String nota : notasXML) {
            loteString = String.valueOf(loteString) + nota;
        }
        loteString = String.valueOf(loteString) + "</enviNFe>";
        return loteString;
    }

    public static synchronized long tamanhoLoteVazio() {
        if (lote_vazio == 0) {
            lote_vazio = XMLFactory.montarLoteTempo("123456789012345", new Vector<String>()).length();
        }
        return lote_vazio;
    }

    public static synchronized String montarLoteTempo(String idLote, Vector<String> notasXML) {
        String loteString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><enviNFe xmlns=\"http://www.portalfiscal.inf.br/nfe\" versao=\"1.10\">";
        loteString = String.valueOf(loteString) + "<idLote>" + idLote + "</idLote>";
        for (String nota : notasXML) {
            loteString = String.valueOf(loteString) + nota;
        }
        loteString = String.valueOf(loteString) + "</enviNFe>";
        return loteString;
    }

    public static synchronized String montarLoteRPS(String idLote, String rps) {
        String loteString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><enviNFe xmlns=\"http://www.portalfiscal.inf.br/nfe\" versao=\"1.10\">";
        loteString = String.valueOf(loteString) + "<idLote>" + idLote + "</idLote>";
        loteString = String.valueOf(loteString) + rps;
        loteString = String.valueOf(loteString) + "</enviNFe>";
        return loteString;
    }

    public static synchronized String criarConsultaLote(String reciboId, String tpAmb, String CNPJ) {
        String versao = XMLFactory.obterVersaoUF(TConsReciNFe.class, cnpjsUfs.get(CNPJ), CNPJ);
        String tipoAmbiente = XMLFactory.obterTipoAmbienteDefault(tipoAmbienteDefault, tpAmb);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><consReciNFe xmlns=\"http://www.portalfiscal.inf.br/nfe\" versao=\"" + versao + "\"><tpAmb>" + tipoAmbiente + "</tpAmb><nRec>" + reciboId + "</nRec></consReciNFe>";
        return xml;
    }

    public static synchronized String criarConsultaNota(String idNota, String tpAmb, String CNPJ) {
        String versao = XMLFactory.obterVersaoUF(TConsSitNFe.class, cnpjsUfs.get(CNPJ), CNPJ);
        String tipoAmbiente = XMLFactory.obterTipoAmbiente(CNPJ, tpAmb);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><consSitNFe xmlns=\"http://www.portalfiscal.inf.br/nfe\" versao=\"" + versao + "\"><tpAmb>" + tipoAmbiente + "</tpAmb><xServ>CONSULTAR</xServ><chNFe>" + idNota + "</chNFe></consSitNFe>";
        return xml;
    }

    private static synchronized String obterTipoAmbienteDefault(String tipoAmbiente, String tpAmb) {
        if (tpAmb != null && !tpAmb.equals("")) {
            return tpAmb;
        }
        if (tipoAmbiente.equals(PropriedadesSistema.ID_PRODUCAO) || tipoAmbiente.equals(PropriedadesSistema.ID_SCAN)) {
            return "1";
        }
        return "2";
    }

    public static synchronized String criarConsultaNotaUF(String idNota, String tpAmb, String UF) {
        String tipoAmbiente = XMLFactory.obterTipoAmbienteDefault(tipoAmbienteDefault, tpAmb);
        String versao = XMLFactory.obterVersaoUF(TConsSitNFe.class, UF, null);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><consSitNFe xmlns=\"http://www.portalfiscal.inf.br/nfe\" versao=\"" + versao + "\"><tpAmb>" + tipoAmbiente + "</tpAmb><xServ>CONSULTAR</xServ><chNFe>" + idNota + "</chNFe></consSitNFe>";
        return xml;
    }

    public static synchronized String montarCancelamento(String idNota, String tpAmb, String protocolo, String CNPJ, String justificativa) {
        String versao = XMLFactory.obterVersaoUF(TCancNFe.class, cnpjsUfs.get(CNPJ), CNPJ);
        String tipoAmbiente = XMLFactory.obterTipoAmbienteDefault(tipoAmbienteDefault, tpAmb);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><cancNFe versao=\"" + versao + "\" xmlns=\"http://www.portalfiscal.inf.br/nfe\"><infCanc Id=\"ID" + idNota + "\"><tpAmb>" + tipoAmbiente + "</tpAmb><xServ>CANCELAR</xServ><chNFe>" + idNota + "</chNFe><nProt>" + protocolo + "</nProt><xJust>" + justificativa + "</xJust></infCanc></cancNFe>";
        return xml;
    }

    public static synchronized String montarCabecalho(Class c, String CNPJ) {
        String versao = XMLFactory.obterVersaoUF(c, cnpjsUfs.get(CNPJ), CNPJ);
        try {
            CabecMsg cc = new CabecMsg();
            cc.setVersao("1.02");
            cc.setVersaoDados(String.valueOf(versao));
            return xmlsCab.toXMLString(cc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized String montarCabecalhoUF(Class c, String UF) {
        String versao = XMLFactory.obterVersaoUF(c, UF, null);
        try {
            CabecMsg cc = new CabecMsg();
            cc.setVersao("1.02");
            cc.setVersaoDados(String.valueOf(versao));
            return xmlsCab.toXMLString(cc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized String montarInutilizacao(String UF, String ano, String cnpj, String mod, String serie, String ini, String fim, String just, String tpAmb) {
        String versao = XMLFactory.obterVersaoUF(TInutNFe.class, cnpjsUfs.get(cnpj), cnpj);
        String tipoAmbiente = XMLFactory.obterTipoAmbiente(cnpj, tpAmb);
        DecimalFormat fnn = new DecimalFormat("000000000");
        DecimalFormat fser = new DecimalFormat("000");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><inutNFe xmlns=\"http://www.portalfiscal.inf.br/nfe\" versao=\"" + versao + "\"><infInut Id=\"ID" + UF + ano + cnpj + mod + serie + fnn.format(Integer.parseInt(ini)) + fnn.format(Integer.parseInt(fim)) + "\"><tpAmb>" + tipoAmbiente + "</tpAmb><xServ>INUTILIZAR</xServ><cUF>" + UF + "</cUF><ano>" + ano + "</ano><CNPJ>" + cnpj + "</CNPJ><mod>" + mod + "</mod><serie>" + Integer.parseInt(serie) + "</serie><nNFIni>" + ini + "</nNFIni><nNFFin>" + fim + "</nNFFin><xJust>" + just + "</xJust></infInut></inutNFe>";
        return xml;
    }

    public static synchronized String montarInutilizacaoNota(String idNota, String tpAmb, String CNPJ, String justificativa) {
        String[] partes = GerenciadorChavesNota.descomporChaveNFe(idNota);
        Integer n = Integer.parseInt(partes[5]);
        return XMLFactory.montarInutilizacao(partes[0], partes[1].substring(0, 2), partes[2], partes[3], partes[4], n.toString(), n.toString(), justificativa, tpAmb);
    }

    public static String montarEstadoServicos(String cnpj) {
        String versao = XMLFactory.obterVersaoUF(TConsStatServ.class, cnpjsUfs.get(cnpj), cnpj);
        try {
            TConsStatServ status = new TConsStatServ();
            status.setCUF("51");
            status.setVersao(versao);
            status.setTpAmb("1");
            status.setXServ("STATUS");
            return xmlsStatus.toXMLString(status);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static XMLGenerator getXmlsRetRecepcao() {
        return xmlsRetRecepcao;
    }

    public static XMLGenerator getXmlsConsulta() {
        return xmlsConsulta;
    }

    public static XMLGenerator getXmlsCancelamento() {
        return xmlsCancelamento;
    }

    public static XMLGenerator getXmlsRetCanc() {
        return xmlsRetCanc;
    }

    public static XMLGenerator getXmlsInut() {
        return xmlsInut;
    }

    public static XMLGenerator getXmlsRecepcao() {
        return xmlsRecepcao;
    }

    public static String obterVersaoUF(Class c, String UF, String cnpj) {
        ParChave chave;
        Hashtable<String, String> entradas = versaoEsquema.get(UF);
        String version = "";
        System.out.println("tipoServicos:" + tipoServicos);
        Enumeration<ParChave> chavesEnum = tipoServicos.keys();
        while (chavesEnum.hasMoreElements()) {
            chave = chavesEnum.nextElement();
            if (cnpj == null || !chave.getChave1().equals(String.valueOf(cnpj) + "v200")) continue;
            version = "v200";
            break;
        }
        chavesEnum = tipoServicos.keys();
        while (chavesEnum.hasMoreElements()) {
            chave = chavesEnum.nextElement();
            if (cnpj == null || !chave.getChave1().equals(String.valueOf(cnpj) + "v310")) continue;
            version = "v310";
            break;
        }
        for (String nomeClasse : entradas.keySet()) {
            String csimples = String.valueOf(c.getSimpleName()) + version;
            if (!csimples.toLowerCase().equals("t" + nomeClasse.toLowerCase())) continue;
            return entradas.get(nomeClasse);
        }
        return null;
    }

    public static void setVersaoEsquema(Hashtable<String, Hashtable<String, String>> versaoEsquema) {
        XMLFactory.versaoEsquema = versaoEsquema;
    }

    public static void setTipoAmbienteDefault(String tipoAmbiente) {
        tipoAmbienteDefault = tipoAmbiente;
    }

    public static void setCnpjsUfs(Hashtable<String, String> cnpjsUfs) {
        XMLFactory.cnpjsUfs = cnpjsUfs;
    }

    public static void setTipoServicos(Hashtable<ParChave, String> tipoServicos) {
        XMLFactory.tipoServicos = tipoServicos;
    }

    public static XMLGenerator getXmlsDpec() {
        return xmlsDpec;
    }

    public static XMLGenerator getXmlsConsultav200() {
        return xmlsConsultav200;
    }
}

