/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.xmlgenerator;

import br.com.taragona.nfe.classes.recepcao.TEnviNFe;
import br.com.taragona.nfe.classes.recepcao.TNFe;
import br.com.taragona.nfe.classes.recepcao.TRetEnviNFe;
import br.com.taragona.nfe.persistence.CodigoNFe;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import java.io.File;
import java.io.FileWriter;
import java.util.Collection;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;

public class FileManager {
    private static String TMP_FILE = ConfiguracaoSys.getPastaWrapper();
    private static String BASE_DIR_NOTAS = ConfiguracaoSys.getPastaWrapper();
    private static String BASE_DIR_RECIBOS = ConfiguracaoSys.getPastaWrapper();
    private static String BASE_DIR_LOTES = ConfiguracaoSys.getPastaWrapper();
    private static String BASE_DIR_OK = ConfiguracaoSys.getPastaWrapper();
    private static String BASE_DIR_ERRO = ConfiguracaoSys.getPastaWrapper();
    private static String BASE_DIR_CANCELADAS = ConfiguracaoSys.getPastaWrapper();
    private static DAOGenerico<CodigoNFe> daoCod = new DAOGenerico(CodigoNFe.class);

    public static File obterArquivoLote(String name) {
        File file = new File(String.valueOf(BASE_DIR_LOTES) + "/" + name + "-env-lot.xml");
        return file;
    }

    public static File obterArquivoNota(String name) {
        File file = new File(String.valueOf(BASE_DIR_NOTAS) + "/" + name + "-nfe.xml");
        return file;
    }

    public static File obterArquivoRecibo(String name) {
        File file = new File(String.valueOf(BASE_DIR_RECIBOS) + "/" + name + "-rec.xml");
        return file;
    }

    public static File obterArquivoTemporal() {
        File file = new File(TMP_FILE);
        return file;
    }

    public static TEnviNFe obterLote(String idLote) throws Exception {
        File file = new File(String.valueOf(BASE_DIR_LOTES) + "/" + idLote + "-env-lot.xml");
        if (!file.exists()) {
            return null;
        }
        XMLGenerator xmls = new XMLGenerator("br.com.taragona.nfe.classes.recepcao");
        JAXBElement obj = (JAXBElement)xmls.toObjectFromFile(file);
        return (TEnviNFe)obj.getValue();
    }

    public static Collection<TEnviNFe> obterLotes() {
        File dir = new File(BASE_DIR_LOTES);
        File[] lotesFiles = dir.listFiles();
        Vector<TEnviNFe> lotes = new Vector<TEnviNFe>();
        XMLGenerator xmls = new XMLGenerator("br.com.taragona.nfe.classes.recepcao");
        File[] fileArray = lotesFiles;
        int n = lotesFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                if (file.isFile() && file.getCanonicalPath().endsWith("-env-lot.xml")) {
                    lotes.add((TEnviNFe)xmls.toObjectFromFile(file));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
        return lotes;
    }

    public static TNFe obterNota(String id) throws Exception {
        File file = new File(String.valueOf(BASE_DIR_NOTAS) + "/" + id + "-nfe.xml");
        if (!file.exists()) {
            return null;
        }
        XMLGenerator xmls = new XMLGenerator("br.com.taragona.nfe.classes.recepcao");
        JAXBElement obj = (JAXBElement)xmls.toObjectFromFile(file);
        return (TNFe)obj.getValue();
    }

    public static Collection<TNFe> obterNotas() {
        File dir = new File(BASE_DIR_NOTAS);
        File[] notasFiles = dir.listFiles();
        Vector<TNFe> notas = new Vector<TNFe>();
        XMLGenerator xmls = new XMLGenerator("br.com.taragona.nfe.classes.recepcao");
        File[] fileArray = notasFiles;
        int n = notasFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File nota = fileArray[n2];
            try {
                if (nota.isFile() && nota.getCanonicalPath().endsWith("-nfe.xml")) {
                    notas.add((TNFe)xmls.toObjectFromFile(nota));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
        return notas;
    }

    public static Collection<TRetEnviNFe> obterRecibos() {
        File dir = new File(BASE_DIR_RECIBOS);
        File[] recibosFiles = dir.listFiles();
        Vector<TRetEnviNFe> recibos = new Vector<TRetEnviNFe>();
        XMLGenerator xmls = new XMLGenerator("br.com.taragona.nfe.classes.recepcao");
        File[] fileArray = recibosFiles;
        int n = recibosFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                if (file.isFile() && file.getCanonicalPath().endsWith("-rec.xml")) {
                    recibos.add((TRetEnviNFe)xmls.toObjectFromFile(file));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
        return recibos;
    }

    public static TRetEnviNFe obterRecibo(String id) throws Exception {
        File file = new File(String.valueOf(BASE_DIR_RECIBOS) + "/" + id + "-rec.xml");
        if (!file.exists()) {
            return null;
        }
        XMLGenerator xmls = new XMLGenerator("br.com.taragona.nfe.classes.recepcao");
        return (TRetEnviNFe)xmls.toObjectFromFile(file);
    }

    public static void removerRecibo(String id) {
        File file = new File(String.valueOf(BASE_DIR_RECIBOS) + "/" + id + "-rec.xml");
        file.delete();
    }

    public static void salvarNotaOK(String idNota, String protocolo) {
        File file = new File(String.valueOf(BASE_DIR_OK) + "/NFE_OK_" + idNota + ".txt");
        try {
            FileWriter fw = new FileWriter(file);
            fw.write("Protocolo:" + protocolo);
            fw.close();
        }
        catch (Exception e) {
            System.out.println("Arquivo nao salvo: " + file.getAbsolutePath());
        }
    }

    public static void salvarNotaErro(String idNota, Integer codigoErro) {
        File file = new File(String.valueOf(BASE_DIR_ERRO) + "/NFE_ERRO_" + idNota + ".txt");
        try {
            FileWriter fw = new FileWriter(file);
            fw.write(String.valueOf(codigoErro.toString()) + ":" + daoCod.buscarPorIdInt(codigoErro).getName());
            fw.close();
        }
        catch (Exception e) {
            System.out.println("Arquivo nao salvo: " + file.getAbsolutePath());
        }
    }

    public static void salvarNotaCancelada(String idNota, String protocolo) {
        File file = new File(String.valueOf(BASE_DIR_CANCELADAS) + "/NFE_CANCELADA_" + idNota + ".txt");
        try {
            FileWriter fw = new FileWriter(file);
            fw.write(protocolo);
            fw.close();
        }
        catch (Exception e) {
            System.out.println("Arquivo nao salvado: " + file.getAbsolutePath());
        }
    }

    public static void main(String[] argv) {
        try {
            TNFe notaXML = FileManager.obterNota("10_34929_43060992665611012850550079000000011485651995");
            System.out.println("->" + notaXML.getInfNFe().getId());
        }
        catch (Exception ex) {
            Logger.getLogger(FileManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        FileManager.salvarNotaOK("12", "123");
    }
}

