/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.xmlgenerator;

import br.com.taragona.nfe.classes.CabecMsg;
import br.com.taragona.nfe.xmlgenerator.FileManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class XMLGenerator {
    private JAXBContext jc;
    private Unmarshaller unmarshaller;
    private Marshaller marshaller;

    public XMLGenerator(String packageName) {
        try {
            this.jc = JAXBContext.newInstance((String)packageName);
            this.unmarshaller = this.jc.createUnmarshaller();
            this.marshaller = this.jc.createMarshaller();
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
        }
    }

    private synchronized void toXMLFile(Object obj, File file) throws Exception {
        FileOutputStream os = new FileOutputStream(file);
        this.marshaller.marshal(obj, (OutputStream)os);
        os.close();
    }

    public synchronized File notaToXMLFile(Object obj, String name) throws Exception {
        File file = FileManager.obterArquivoNota(name);
        this.toXMLFile(obj, file);
        return file;
    }

    public synchronized File loteToXMLFile(Object obj, String name) throws Exception {
        File file = FileManager.obterArquivoLote(name);
        this.toXMLFile(obj, file);
        return file;
    }

    public synchronized File reciboToXMLFile(Object obj, String name) throws Exception {
        File file = FileManager.obterArquivoRecibo(name);
        this.toXMLFile(obj, file);
        return file;
    }

    public synchronized String toXMLString(Object obj) throws Exception {
        StringWriter w = new StringWriter();
        this.marshaller.marshal(obj, (Writer)w);
        return w.toString();
    }

    public synchronized Object toObjectFromFile(File file) throws Exception {
        return this.unmarshaller.unmarshal(file);
    }

    public synchronized Object toObject(String str) throws Exception {
        StringReader r = new StringReader(str);
        return this.unmarshaller.unmarshal((Reader)r);
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public static void main(String[] argv) {
        try {
            XMLGenerator f = new XMLGenerator("br.com.taragona.nfe.classes");
            CabecMsg c = new CabecMsg();
            c.setVersao("cdf");
            c.setVersaoDados("abc");
            String s = f.toXMLString(c);
            CabecMsg c1 = (CabecMsg)f.toObject(s);
            System.out.println("->s" + c1.getVersaoDados());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

