/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class ThreadQuiescenceBarrier {
    private final Set<Long> baselineIds;
    private final List<String> includeNamePrefixes;
    private final List<String> includePackagePrefixes;
    private final List<String> excludeNamePrefixes;
    private final boolean includeDaemons;
    private final long quietPeriodMillis;

    public static Builder newBarrier() {
        return new Builder();
    }

    private ThreadQuiescenceBarrier(Set<Long> base, List<String> inclName, List<String> inclPkg, List<String> exclName, boolean includeDaemons, long quietMs) {
        this.baselineIds = new HashSet<Long>(base);
        this.includeNamePrefixes = new ArrayList<String>(inclName);
        this.includePackagePrefixes = new ArrayList<String>(inclPkg);
        this.excludeNamePrefixes = new ArrayList<String>(exclName);
        this.includeDaemons = includeDaemons;
        this.quietPeriodMillis = quietMs;
    }

    public boolean awaitQuiescence(long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        long lastActiveTs = System.currentTimeMillis();
        long now;
        while ((now = System.nanoTime()) < deadline) {
            Set<Thread> active = this.findActiveNewRelevantThreads();
            if (active.isEmpty()) {
                long since = System.currentTimeMillis() - lastActiveTs;
                if (since >= this.quietPeriodMillis) {
                    return true;
                }
                Thread.sleep(50L);
                continue;
            }
            lastActiveTs = System.currentTimeMillis();
            Thread.sleep(100L);
        }
        return false;
    }

    private Set<Thread> findActiveNewRelevantThreads() {
        Map<Thread, StackTraceElement[]> all = Thread.getAllStackTraces();
        HashSet<Thread> out = new HashSet<Thread>();
        block0: for (Map.Entry<Thread, StackTraceElement[]> e : all.entrySet()) {
            Thread t = e.getKey();
            if (!t.isAlive() || this.baselineIds.contains(t.getId()) || !this.includeDaemons && t.isDaemon()) continue;
            String name = t.getName();
            for (String p : this.excludeNamePrefixes) {
                if (name != null && name.startsWith(p)) continue block0;
            }
            if (!this.includeNamePrefixes.isEmpty()) {
                boolean ok = false;
                for (String p : this.includeNamePrefixes) {
                    if (name == null || !name.startsWith(p)) continue;
                    ok = true;
                    break;
                }
                if (!ok && this.includePackagePrefixes.isEmpty()) continue;
            }
            if (!this.includePackagePrefixes.isEmpty()) {
                boolean ok = false;
                StackTraceElement[] st = e.getValue();
                if (st != null) {
                    StackTraceElement[] stackTraceElementArray = st;
                    int n = st.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StackTraceElement ste = stackTraceElementArray[n2];
                        String cls = ste.getClassName();
                        for (String p : this.includePackagePrefixes) {
                            if (cls == null || !cls.startsWith(p)) continue;
                            ok = true;
                            break;
                        }
                        if (ok) break;
                        ++n2;
                    }
                }
                if (!ok) continue;
            }
            out.add(t);
        }
        return out;
    }

    /* synthetic */ ThreadQuiescenceBarrier(Set set, List list, List list2, List list3, boolean bl, long l, ThreadQuiescenceBarrier threadQuiescenceBarrier) {
        this(set, list, list2, list3, bl, l);
    }

    public static final class Builder {
        private final Set<Long> baselineIds = new HashSet<Long>();
        private final List<String> includeNamePrefixes = new ArrayList<String>();
        private final List<String> includePackagePrefixes = new ArrayList<String>();
        private final List<String> excludeNamePrefixes = new ArrayList<String>(Arrays.asList("Finalizer", "Reference Handler", "Signal Dispatcher", "Attach Listener", "GC Thread", "JDWP", "RMI", "JMX", "Common-Cleaner", "Okio Watchdog"));
        private boolean includeDaemons = false;
        private long quietPeriodMillis = 1000L;

        private Builder() {
        }

        public Builder includeNamePrefixes(String ... p) {
            if (p != null) {
                this.includeNamePrefixes.addAll(Arrays.asList(p));
            }
            return this;
        }

        public Builder includePackagePrefixes(String ... p) {
            if (p != null) {
                this.includePackagePrefixes.addAll(Arrays.asList(p));
            }
            return this;
        }

        public Builder excludeNamePrefixes(String ... p) {
            if (p != null) {
                this.excludeNamePrefixes.addAll(Arrays.asList(p));
            }
            return this;
        }

        public Builder includeDaemons(boolean v) {
            this.includeDaemons = v;
            return this;
        }

        public Builder quietPeriodMillis(long ms) {
            this.quietPeriodMillis = Math.max(0L, ms);
            return this;
        }

        public ThreadQuiescenceBarrier begin() {
            Map<Thread, StackTraceElement[]> all = Thread.getAllStackTraces();
            for (Thread t : all.keySet()) {
                this.baselineIds.add(t.getId());
            }
            return new ThreadQuiescenceBarrier(this.baselineIds, this.includeNamePrefixes, this.includePackagePrefixes, this.excludeNamePrefixes, this.includeDaemons, this.quietPeriodMillis, null);
        }
    }
}

