/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.DescriptorEvent;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.ModifyAllQuery;

public class DeleteAllQuery
extends ModifyAllQuery {
    protected Vector objects;

    public DeleteAllQuery() {
    }

    public DeleteAllQuery(Class referenceClass) {
        super(referenceClass);
    }

    public DeleteAllQuery(Class referenceClass, Expression selectionCriteria) {
        super(referenceClass, selectionCriteria);
    }

    public boolean isDeleteAllQuery() {
        return true;
    }

    public Object executeInUnitOfWork(UnitOfWorkImpl unitOfWork, AbstractRecord translationRow) throws DatabaseException, OptimisticLockException {
        if (this.getObjects() != null) {
            if (unitOfWork.isAfterWriteChangesButBeforeCommit()) {
                throw ValidationException.illegalOperationForUnitOfWorkLifecycle(unitOfWork.getLifecycle(), "executeQuery(DeleteAllQuery)");
            }
            if (!unitOfWork.getCommitManager().isActive()) {
                return unitOfWork.getParent().executeQuery((DatabaseQuery)this, translationRow);
            }
            this.result = (Integer)super.execute(unitOfWork, translationRow);
            return this.result;
        }
        return super.executeInUnitOfWork(unitOfWork, translationRow);
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.getObjects() != null) {
            if (this.isExpressionQuery() && this.getSelectionCriteria() == null) {
                throw QueryException.deleteAllQuerySpecifiesObjectsButNotSelectionCriteria(this.getDescriptor(), this, this.getObjects().toString());
            }
            try {
                DescriptorEvent event;
                Enumeration deletedObjectsEnum;
                this.getSession().beginTransaction();
                if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                    deletedObjectsEnum = this.getObjects().elements();
                    while (deletedObjectsEnum.hasMoreElements()) {
                        event = new DescriptorEvent(deletedObjectsEnum.nextElement());
                        event.setEventCode(2);
                        event.setSession(this.getSession());
                        event.setQuery(this);
                        this.getDescriptor().getEventManager().executeEvent(event);
                    }
                }
                this.result = this.getQueryMechanism().deleteAll();
                if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                    deletedObjectsEnum = this.getObjects().elements();
                    while (deletedObjectsEnum.hasMoreElements()) {
                        event = new DescriptorEvent(deletedObjectsEnum.nextElement());
                        event.setEventCode(3);
                        event.setSession(this.getSession());
                        event.setQuery(this);
                        this.getDescriptor().getEventManager().executeEvent(event);
                    }
                }
                if (this.shouldMaintainCache()) {
                    Enumeration objectsEnum = this.getObjects().elements();
                    while (objectsEnum.hasMoreElements()) {
                        Object deleted = objectsEnum.nextElement();
                        if (this.getSession().isUnitOfWork()) {
                            deleted = this.getDescriptor().getObjectBuilder().unwrapObject(deleted, this.getSession());
                            ((UnitOfWorkImpl)this.getSession()).addObjectDeletedDuringCommit(deleted, this.getDescriptor());
                            continue;
                        }
                        this.getSession().getIdentityMapAccessor().removeFromIdentityMap(deleted);
                    }
                }
                this.getSession().commitTransaction();
            }
            catch (RuntimeException exception) {
                this.getSession().rollbackTransaction();
                throw exception;
            }
        } else {
            this.result = this.getQueryMechanism().deleteAll();
            this.mergeChangesIntoSharedCache();
        }
        return this.result;
    }

    public void executeDeleteAll(AbstractSession session, AbstractRecord translationRow, Vector objects) throws DatabaseException {
        this.checkPrepare(session, translationRow);
        DeleteAllQuery queryToExecute = (DeleteAllQuery)this.clone();
        queryToExecute.setTranslationRow(translationRow);
        queryToExecute.setSession(session);
        queryToExecute.setObjects(objects);
        queryToExecute.prepareForExecution();
        queryToExecute.executeDatabaseQuery();
    }

    public Vector getObjects() {
        return this.objects;
    }

    protected void prepare() throws QueryException {
        super.prepare();
        if (this.getReferenceClass() == null) {
            throw QueryException.referenceClassMissing(this);
        }
        if (this.getDescriptor() == null) {
            ClassDescriptor referenceDescriptor = this.getSession().getDescriptor(this.getReferenceClass());
            if (referenceDescriptor == null) {
                throw QueryException.descriptorIsMissing(this.getReferenceClass(), this);
            }
            this.setDescriptor(referenceDescriptor);
        }
        if (this.getDescriptor().isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(this.getDescriptor(), this);
        }
        this.getQueryMechanism().prepareDeleteAll();
    }

    public void setObjects(Vector objectCollection) {
        this.objects = objectCollection;
    }
}

