/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.cockpitrap.dialogs;

import br.com.taragona.nfe.persistence.CodigoNFe;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.LogEnvioEmail;
import br.com.taragona.nfe.persistence.LogNFe;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.tti.cockpitrap.dialogs.HistoryTableContentProvider;
import br.com.tti.cockpitrap.dialogs.HistoryTableLabelProvider;
import br.com.tti.cockpitrap.session.ClientSession;
import br.com.tti.cockpitrap.util.ManagerProxy;
import br.com.tti.cockpitrap.util.SystemProperties;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class XMLDetailDialog
extends Dialog {
    private EstadoNFe xmlData;

    public XMLDetailDialog(Shell parentShell, EstadoNFe xml) {
        super(parentShell);
        this.xmlData = xml;
        this.setBlockOnOpen(true);
    }

    protected Point getInitialSize() {
        return new Point(650, 600);
    }

    protected void configureShell(Shell shell) {
        shell.setMenu(null);
        shell.setMenuBar(null);
        super.configureShell(shell);
        shell.setText("Detalhes da MDF-e: " + this.xmlData.getId());
        this.setShellStyle(1120);
    }

    protected Control createDialogArea(Composite parent) {
        try {
            Composite grid = new Composite(parent, 0);
            GridLayout gl = new GridLayout(2, false);
            grid.setLayout((Layout)gl);
            Group groupDados = new Group(grid, 0);
            groupDados.setText("Dados da MDF-e");
            GridLayout ggl1 = new GridLayout(1, false);
            groupDados.setLayout((Layout)ggl1);
            GridData gdda = new GridData();
            gdda.horizontalSpan = 2;
            gdda.horizontalAlignment = 0x1000000;
            groupDados.setLayoutData((Object)gdda);
            GerenciadorChavesNota chave = new GerenciadorChavesNota(this.xmlData.getId());
            Label label = new Label((Composite)groupDados, 0);
            label.setText("Serie - Numero: " + chave.getSerie() + " - " + chave.getNumeroNota());
            label.setFont(SystemProperties.FONT_BOLD);
            Label label1 = new Label((Composite)groupDados, 0);
            label1.setFont(SystemProperties.FONT_BOLD);
            label1.setText("Estado: " + this.xmlData.getEstado());
            Label label01 = new Label((Composite)groupDados, 0);
            label01.setFont(SystemProperties.FONT_BOLD);
            label01.setText("Email Dest: " + this.extractEmailDest());
            GridData g11 = new GridData();
            g11.widthHint = 600;
            label01.setLayoutData((Object)g11);
            Label label02 = new Label((Composite)groupDados, 0);
            label02.setFont(SystemProperties.FONT_BOLD);
            label02.setText("Email Transp: " + this.extractEmailTransp());
            GridData g12 = new GridData();
            g12.widthHint = 600;
            label02.setLayoutData((Object)g12);
            Label label2 = new Label((Composite)groupDados, 0);
            label2.setFont(SystemProperties.FONT_BOLD);
            label2.setText("Mensagem ");
            Text description = new Text((Composite)groupDados, 2562);
            GridData griddata = new GridData();
            griddata.widthHint = 600;
            griddata.heightHint = 50;
            description.setLayoutData((Object)griddata);
            if (this.xmlData.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.ERRO_VALIDACAO)) {
                description.setText(this.xmlData.getMotivoErro());
            } else if (this.xmlData.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.PROBLEMAS_DPEC_ENVIADO)) {
                description.setText(this.xmlData.getMotivoErro());
            } else {
                ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
                CodigoNFe codigo = null;
                if (this.xmlData.getEstadoNFe() != null && this.xmlData.getEstadoNFe() == 124L) {
                    codigo = new CodigoNFe(124, "DPEC recebido pelo Sistema de Contingencia Eletronica");
                } else if (this.xmlData.getEstadoNFe() != null) {
                    codigo = manager.obterCodigo(Integer.parseInt(this.xmlData.getEstadoNFe().toString()));
                }
                if (codigo != null) {
                    description.setText("Codigo SEFAZ: " + this.xmlData.getEstadoNFe() + " Mensagem: " + codigo.getName());
                } else {
                    description.setText("Codigo SEFAZ: " + this.xmlData.getEstadoNFe());
                }
            }
            Group groupDest = new Group(grid, 0);
            groupDest.setText("Historico de Opera\u00e7\u00f5es");
            GridLayout ggl3 = new GridLayout(2, false);
            groupDest.setLayout((Layout)ggl3);
            GridData gddd1 = new GridData();
            gddd1.heightHint = 300;
            gddd1.widthHint = 600;
            groupDest.setLayoutData((Object)gddd1);
            TableViewer tableviewer = new TableViewer((Composite)groupDest);
            Table table = tableviewer.getTable();
            table.setLinesVisible(true);
            table.setHeaderVisible(true);
            GridData gddd11 = new GridData();
            gddd11.verticalAlignment = 4;
            gddd11.grabExcessVerticalSpace = true;
            gddd11.widthHint = 580;
            table.setLayoutData((Object)gddd11);
            HistoryTableLabelProvider provider = new HistoryTableLabelProvider();
            ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
            List<LogNFe> logs = manager.obterHistorico(this.xmlData.getId(), ClientSession.getInstance().getAmbiente());
            HistoryTableContentProvider content = new HistoryTableContentProvider(logs);
            provider.initColumnProp(table);
            tableviewer.setContentProvider((IContentProvider)content);
            tableviewer.setLabelProvider((IBaseLabelProvider)provider);
            tableviewer.setInput((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return parent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String extractEmailDest() {
        try {
            LogEnvioEmail logEnvioEmail;
            ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
            List list = manager.logemail(this.xmlData.getId(), ClientSession.getInstance().getAmbiente(), null);
            if (list == null) return "Email n\u00e3o cadastrado";
            if (list.isEmpty()) {
                return "Email n\u00e3o cadastrado";
            }
            Iterator iterator = list.iterator();
            do {
                if (!iterator.hasNext()) {
                    return "Email n\u00e3o cadastrado";
                }
                logEnvioEmail = (LogEnvioEmail)iterator.next();
                if (logEnvioEmail.getEstado().equals((Object)LogEnvioEmail.ESTADO_EMAIL.NAO_CADASTRADO) && logEnvioEmail.getTipo().equals((Object)LogEnvioEmail.TIPO_EMAIL.DESTINATARIO)) {
                    return "Email n\u00e3o cadastrado";
                }
                if (!logEnvioEmail.getEstado().equals((Object)LogEnvioEmail.ESTADO_EMAIL.NAO_ENVIADO) || !logEnvioEmail.getTipo().equals((Object)LogEnvioEmail.TIPO_EMAIL.DESTINATARIO)) continue;
                return logEnvioEmail.getMessage1();
            } while (!logEnvioEmail.getEstado().equals((Object)LogEnvioEmail.ESTADO_EMAIL.ENVIADO) || !logEnvioEmail.getTipo().equals((Object)LogEnvioEmail.TIPO_EMAIL.DESTINATARIO));
            return logEnvioEmail.getDestinatario();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "Email n\u00e3o cadastrado";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String extractEmailTransp() {
        try {
            LogEnvioEmail logEnvioEmail;
            ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
            List list = manager.logemail(this.xmlData.getId(), ClientSession.getInstance().getAmbiente(), null);
            if (list == null) return "Email n\u00e3o cadastrado";
            if (list.isEmpty()) {
                return "Email n\u00e3o cadastrado";
            }
            Iterator iterator = list.iterator();
            do {
                if (!iterator.hasNext()) {
                    return "Email n\u00e3o cadastrado";
                }
                logEnvioEmail = (LogEnvioEmail)iterator.next();
                if (logEnvioEmail.getEstado().equals((Object)LogEnvioEmail.ESTADO_EMAIL.NAO_CADASTRADO) && logEnvioEmail.getTipo().equals((Object)LogEnvioEmail.TIPO_EMAIL.TRANSPORTADORA)) {
                    return "Email n\u00e3o cadastrado";
                }
                if (!logEnvioEmail.getEstado().equals((Object)LogEnvioEmail.ESTADO_EMAIL.NAO_ENVIADO) || !logEnvioEmail.getTipo().equals((Object)LogEnvioEmail.TIPO_EMAIL.TRANSPORTADORA)) continue;
                return logEnvioEmail.getMessage1();
            } while (!logEnvioEmail.getEstado().equals((Object)LogEnvioEmail.ESTADO_EMAIL.ENVIADO) || !logEnvioEmail.getTipo().equals((Object)LogEnvioEmail.TIPO_EMAIL.TRANSPORTADORA));
            return logEnvioEmail.getDestinatario();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "Email n\u00e3o cadastrado";
    }
}

