/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.cockpitrap.events;

import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.tti.cockpitrap.session.ClientSession;
import br.com.tti.cockpitrap.util.ManagerProxy;
import br.com.tti.cockpitrap.util.UIWindows;
import br.com.tti.cockpitrap.views.CancelInutView;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CancelEvent
implements SelectionListener {
    private CancelInutView view;
    private boolean cancel;
    private SimpleDateFormat df = new SimpleDateFormat("yyMM");

    public CancelEvent(CancelInutView view, boolean cancel) {
        this.view = view;
        this.cancel = cancel;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void makeCancel() {
        String keys = this.view.getKeyXml().getText();
        String just = this.view.getJust().getText();
        String message = null;
        try {
            ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
            GerenciadorChavesNota chave = new GerenciadorChavesNota(keys);
            manager.cancelarNota(chave.getCnpj(), keys, ClientSession.getInstance().getAmbiente(), just, ClientSession.getInstance().getUser().getId());
            this.view.getKeyXml().setText("");
            this.view.getJust().setText("");
            UIWindows.openMyConfirm(this.view.getViewSite().getShell(), "Cancelamento", "Requisi\u00e7\u00e3o enviada com sucesso");
            try {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                window.getActivePage().showView("TTICockpit.view.query", "query", 1);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            return;
        }
        catch (Exception e1) {
            message = e1.getLocalizedMessage();
            e1.printStackTrace();
            message = message.replace(String.valueOf(RemoteException.class.getCanonicalName()) + ":", "");
            message = message.replace("RemoteException occurred in server thread; nested exception is:", "");
            UIWindows.openMyError(this.view.getViewSite().getShell(), "Cancelamento", "Problemas no cancelamento:" + message);
            return;
        }
    }

    private void makeInut() {
        String uf = this.view.getUf().getText();
        String ano = this.view.getAno().getText();
        String serie = this.view.getSerie().getText();
        String nI = this.view.getnInicial().getText();
        String nF = this.view.getnFinal().getText();
        String just = this.view.getJustinut().getText();
        String cnpj = this.view.getCnpjcombo().getItem(this.view.getCnpjcombo().getSelectionIndex());
        cnpj = cnpj.split(":")[0];
        cnpj = cnpj.trim();
        ManagerProxy manager = null;
        try {
            manager = ClientSession.getInstance().getManagerproxy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String message = null;
        try {
            int n1 = Integer.parseInt(nI);
            int n2 = Integer.parseInt(nF);
            int i = n1;
            while (i <= n2) {
                try {
                    String chave = this.createChave(uf, ano, cnpj, serie, String.valueOf(i));
                    manager.cancelarNota(cnpj, chave, ClientSession.getInstance().getAmbiente(), just, ClientSession.getInstance().getUser().getId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            this.view.getUf().setText("");
            this.view.getAno().setText("");
            this.view.getSerie().setText("");
            this.view.getnInicial().setText("");
            this.view.getnFinal().setText("");
            this.view.getJustinut().setText("");
            this.view.getCnpjcombo().select(0);
            UIWindows.openMyConfirm(this.view.getViewSite().getShell(), "Inutilizacao", "Requisi\u00e7\u00e3o enviada com sucesso");
            try {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                window.getActivePage().showView("TTICockpit.view.query", "query", 1);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            return;
        }
        catch (Exception e1) {
            message = e1.getLocalizedMessage();
            e1.printStackTrace();
            UIWindows.openMyError(this.view.getViewSite().getShell(), "Inutilizacao", "Problemas no inutilizacao:" + message);
            return;
        }
    }

    private String fillZeros(String serie, int length) {
        Integer i = null;
        try {
            i = Integer.parseInt(serie);
        }
        catch (Exception e) {
            return "";
        }
        String str = i.toString();
        int size = length - str.length();
        int ii = 0;
        while (ii < size) {
            str = "0" + str;
            ++ii;
        }
        return str;
    }

    public String createChave(String uf, String anomes, String cnpj, String serie, String numero) {
        String modo = "55";
        serie = this.fillZeros(serie, 3);
        numero = this.fillZeros(numero, 9);
        String cnf = "100000001";
        String chave = String.valueOf(uf) + anomes + cnpj + modo + serie + numero + cnf;
        String dv = this.calcularDV(chave);
        return String.valueOf(chave) + dv;
    }

    private String calcularDV(String chave) {
        int counter = 2;
        int accumulated = 0;
        int i = chave.length() - 1;
        while (i >= 0) {
            int digito = Integer.parseInt(chave.substring(i, i + 1));
            accumulated += counter * digito;
            counter = counter > 8 ? 2 : ++counter;
            --i;
        }
        int resto = accumulated - accumulated / 11 * 11;
        if (resto == 0 || resto == 1) {
            return "0";
        }
        return String.valueOf(11 - resto);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.cancel) {
            this.makeCancel();
        } else {
            this.makeInut();
        }
    }
}

