/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.cockpitrap.events;

import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.tti.cockpitrap.session.ClientSession;
import br.com.tti.cockpitrap.util.ManagerProxy;
import br.com.tti.cockpitrap.util.UIWindows;
import br.com.tti.cockpitrap.views.ManagerStateView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;

public class ChangeOpEvent
implements SelectionListener {
    private ManagerStateView view;

    public ChangeOpEvent(ManagerStateView view) {
        this.view = view;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private String obterCNPJ(String cnpj) {
        String[] split = cnpj.split(":");
        return split[0];
    }

    public void widgetSelected(SelectionEvent e) {
        int pos1 = this.view.getCnpj().getSelectionIndex();
        String cnpj = this.view.getCnpj().getItem(pos1);
        cnpj = this.obterCNPJ(cnpj);
        int pos2 = this.view.getMode().getSelectionIndex();
        String modos = this.view.getMode().getItem(pos2).toLowerCase();
        PropriedadesSistema.MODO_OP modo = null;
        if (modos.contains("dpec")) {
            modo = PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC;
        }
        if (modos.contains("normal")) {
            modo = PropriedadesSistema.MODO_OP.NORMAL;
        }
        if (modos.contains("papel")) {
            modo = PropriedadesSistema.MODO_OP.CONTINGENCIA;
        }
        if (modos.contains("scan")) {
            modo = PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN;
        }
        if (modos.contains("svc-an")) {
            modo = PropriedadesSistema.MODO_OP.SVC_AN;
        }
        if (modos.contains("svc-rs")) {
            modo = PropriedadesSistema.MODO_OP.SVC_RS;
        }
        if (modos.contains("epec")) {
            modo = PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC;
        }
        String tpEmiss = "";
        tpEmiss = modo.equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA) ? "CONTING\u00caNCIA PAPEL MOEDA" : modo.toString();
        boolean res = UIWindows.openMyConfirm(this.view.getMode().getShell(), "Modo Opera\u00e7\u00e3o", "Deseja mudar o estado do CNPJ " + cnpj + " para " + tpEmiss + "?");
        if (res) {
            String error = "";
            try {
                ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
                if (modo == PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC) {
                    manager.mudarEstadoDpec(cnpj, ClientSession.getInstance().getAmbiente());
                }
                if (modo == PropriedadesSistema.MODO_OP.CONTINGENCIA) {
                    manager.mudarEstadoContingencia(cnpj, ClientSession.getInstance().getAmbiente());
                }
                if (modo == PropriedadesSistema.MODO_OP.NORMAL) {
                    manager.mudarEstadoNormalSemEnvio(cnpj, ClientSession.getInstance().getAmbiente());
                }
                if (modo == PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN) {
                    manager.mudarEstadoScan(cnpj, ClientSession.getInstance().getAmbiente());
                }
                if (modo == PropriedadesSistema.MODO_OP.SVC_AN) {
                    manager.changeModeTo(cnpj, PropriedadesSistema.MODO_OP.SVC_AN, null);
                }
                if (modo == PropriedadesSistema.MODO_OP.SVC_RS) {
                    manager.changeModeTo(cnpj, PropriedadesSistema.MODO_OP.SVC_RS, null);
                }
                if (modo == PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC) {
                    manager.changeModeTo(cnpj, PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC, null);
                }
                this.view.updateList();
                return;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                MessageDialog.openError((Shell)this.view.getMode().getShell(), (String)"Modo Opera\u00e7\u00e3o", (String)("Problemas na opera\u00e7\u00e3o:" + error));
            }
        }
    }
}

