/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.cockpitrap.events;

import br.com.taragona.nfe.persistence.Empresa;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.tti.cockpitrap.session.ClientSession;
import br.com.tti.cockpitrap.table.TableContentProvider;
import br.com.tti.cockpitrap.views.QueryView;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.DateTime;

public class SearchEvent
implements SelectionListener {
    private QueryView view;
    private SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    private Vector<EstadoNFe> lastdata;

    public SearchEvent(QueryView view) {
        this.view = view;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private Date convertData(DateTime date, boolean floor) {
        Date d1 = null;
        if (floor) {
            d1 = new Date(date.getYear() - 1900, date.getMonth(), date.getDay());
            d1.setHours(0);
        } else {
            d1 = new Date(date.getYear() - 1900, date.getMonth(), date.getDay() + 1);
            d1.setHours(23);
        }
        return d1;
    }

    private String convertDataString(DateTime date, boolean floor) {
        Date dateconv = this.convertData(date, floor);
        if (dateconv != null) {
            return this.sdf.format(dateconv);
        }
        return null;
    }

    private Date convertDate(DateTime date, boolean floor) {
        Date dateconv = this.convertData(date, floor);
        return dateconv;
    }

    public void widgetSelected(SelectionEvent e) {
        int pos = this.view.getCnpj().getSelectionIndex();
        String cnpj = this.view.getCnpj().getItem(pos).trim();
        String cnpjdest = "";
        StructuredSelection sel = (StructuredSelection)this.view.getComboDest().getSelection();
        Object data = sel.getFirstElement();
        if (data instanceof Empresa) {
            Empresa emp = (Empresa)data;
            cnpjdest = emp.getCnpj();
        }
        String nInicial = this.view.getnInicial().getText().trim();
        String nFim = this.view.getnFinal().getText().trim();
        String serie = this.view.getSerie().getText();
        Date dInicio = this.convertData(this.view.getdInicio(), true);
        Date dFim = this.convertData(this.view.getdFim(), false);
        boolean hoje = this.view.getrHoje().getSelection();
        boolean periodo = this.view.getrPeriodo().getSelection();
        if (hoje) {
            dInicio = Calendar.getInstance().getTime();
            dFim = new Date(dInicio.getYear(), dInicio.getMonth(), dInicio.getDate() + 1);
        }
        int i = -1;
        if (!nInicial.isEmpty()) {
            try {
                i = Integer.parseInt(nInicial);
            }
            catch (Exception ex) {
                System.out.println("Parsing problem:" + nInicial);
            }
        }
        int f = -1;
        if (!nFim.isEmpty()) {
            try {
                f = Integer.parseInt(nFim);
            }
            catch (Exception ex) {
                System.out.println("Parsing problem:" + nFim);
            }
        }
        Vector<String> cnpjv = new Vector<String>();
        if (cnpj.equals("Todos")) {
            String[] cnpjs;
            String[] stringArray = cnpjs = ClientSession.getInstance().getUser().getPerfil().getCnpjs();
            int n = cnpjs.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                cnpjv.add(c);
                ++n2;
            }
        } else {
            String[] parts = cnpj.split(":");
            if (parts.length >= 2) {
                cnpj = parts[0];
                cnpjv.add(cnpj);
            }
        }
        TableViewer table = this.view.getTableviewer();
        Vector<EstadoNFe.ESTADO_NFE> estados = this.convertToString(this.view.getEstado());
        boolean iscce = this.view.getEstado().getSelectionIndex() == 9;
        Vector<PropriedadesSistema.MODO_OP> modos = this.convertToStringModo(this.view.getModocomb());
        TableContentProvider provider = (TableContentProvider)table.getContentProvider();
        if (provider == null) {
            provider = new TableContentProvider();
            table.setContentProvider((IContentProvider)provider);
        }
        provider.fillData(cnpjv, cnpjdest, serie, nInicial, nFim, dInicio, dFim, estados, modos, iscce);
        table.refresh();
        this.view.getLbl_quantidade().setText(String.valueOf(provider.getData().size()) + " notas encontradas    ");
        this.lastdata = provider.getData();
    }

    public Vector<EstadoNFe> estadoNFeInTable() {
        return this.lastdata;
    }

    private Vector<PropriedadesSistema.MODO_OP> convertToStringModo(Combo modocomb) {
        Vector<PropriedadesSistema.MODO_OP> modos = new Vector<PropriedadesSistema.MODO_OP>();
        switch (modocomb.getSelectionIndex()) {
            case 0: {
                modos = null;
                break;
            }
            case 1: {
                modos.add(PropriedadesSistema.MODO_OP.NORMAL);
                break;
            }
            case 2: {
                modos.add(PropriedadesSistema.MODO_OP.CONTINGENCIA);
                break;
            }
            case 3: {
                modos.add(PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC);
                break;
            }
            case 4: {
                modos.add(PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN);
                break;
            }
            case 5: {
                modos.add(PropriedadesSistema.MODO_OP.SVC_AN);
                break;
            }
            case 6: {
                modos.add(PropriedadesSistema.MODO_OP.SVC_RS);
                break;
            }
        }
        return modos;
    }

    private Vector<EstadoNFe.ESTADO_NFE> convertToString(Combo estado) {
        Vector<EstadoNFe.ESTADO_NFE> list = new Vector<EstadoNFe.ESTADO_NFE>();
        switch (estado.getSelectionIndex()) {
            case 0: {
                list = null;
                break;
            }
            case 1: {
                list.add(EstadoNFe.ESTADO_NFE.TENTANDO_ENVIO);
                list.add(EstadoNFe.ESTADO_NFE.GERADA);
                list.add(EstadoNFe.ESTADO_NFE.ERRO_ENVIO);
                list.add(EstadoNFe.ESTADO_NFE.DPEC_ENVIADO);
                break;
            }
            case 2: {
                list.add(EstadoNFe.ESTADO_NFE.ENVIADA);
                list.add(EstadoNFe.ESTADO_NFE.TEMPO_PROCESSAMENTO_LIMITE);
                break;
            }
            case 3: {
                list.add(EstadoNFe.ESTADO_NFE.AUTORIZADA);
                break;
            }
            case 4: {
                list.add(EstadoNFe.ESTADO_NFE.REJEITADA);
                list.add(EstadoNFe.ESTADO_NFE.ERRO);
                break;
            }
            case 5: {
                list.add(EstadoNFe.ESTADO_NFE.CANCELADA);
                break;
            }
            case 6: {
                list.add(EstadoNFe.ESTADO_NFE.INUTILIZADA);
                break;
            }
            case 7: {
                list.add(EstadoNFe.ESTADO_NFE.ERRO_VALIDACAO);
                list.add(EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA);
                list.add(EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA_LOTE);
                break;
            }
            case 8: {
                list.add(EstadoNFe.ESTADO_NFE.ERRO_INUTILIZACAO);
                list.add(EstadoNFe.ESTADO_NFE.ERRO_CANCELAMENTO);
                break;
            }
            case 10: {
                list.add(EstadoNFe.ESTADO_NFE.MINI_DANFE);
                break;
            }
            case 11: {
                list.add(EstadoNFe.ESTADO_NFE.USO_DENEGADO);
                break;
            }
        }
        return list;
    }
}

