/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.cockpitrap.util;

import br.com.taragona.nfe.util.data.ServicosConfig;
import br.com.tti.cockpitrap.session.ClientSession;
import br.com.tti.cockpitrap.util.ManagerProxy;
import br.com.tti.cockpitrap.views.GeraMyRootView;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.rmi.RemoteException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GenerateSefazWSCerts {
    ManagerProxy manager;
    ServicosConfig conf;
    private String p_Ambiente;
    private String[] urlsProducao;
    private String[] urlsHomologacao;
    private GeraMyRootView view;
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public GenerateSefazWSCerts(GeraMyRootView view) {
        this(view, null);
    }

    public GenerateSefazWSCerts(GeraMyRootView view, String ambiente) {
        this.view = view;
        this.manager = view != null ? view.manager : ClientSession.getInstance().getManagerproxy();
        try {
            this.conf = this.manager.obterServicosConfig();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        String myrootPath = this.conf.getArquivoServicos();
        int i = 0;
        i = myrootPath.length() - 1;
        while (i >= 0) {
            if (myrootPath.charAt(i) == File.separatorChar) {
                myrootPath = String.valueOf(myrootPath.substring(0, i + 1)) + "myroot.xml";
                break;
            }
            --i;
        }
        File fileMyRoot = new File(myrootPath);
        if (fileMyRoot.exists()) {
            this.urlsProducao = this.getUrls("1", myrootPath);
            this.urlsHomologacao = this.getUrls("2", myrootPath);
            this.p_Ambiente = ambiente;
            try {
                this.doIt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void doIt() {
        String url;
        String sUrl;
        int n;
        int n2;
        String[] stringArray;
        ArrayList<String> list = new ArrayList<String>();
        if (this.p_Ambiente == null || this.p_Ambiente.equals("1")) {
            stringArray = this.urlsProducao;
            n2 = this.urlsProducao.length;
            n = 0;
            while (n < n2) {
                url = sUrl = stringArray[n];
                url = url.substring(url.indexOf("//") + 2);
                if (!list.contains(url = url.substring(0, url.indexOf("/")))) {
                    list.add(url);
                }
                ++n;
            }
        }
        if (this.p_Ambiente == null || this.p_Ambiente.equals("2")) {
            stringArray = this.urlsHomologacao;
            n2 = this.urlsHomologacao.length;
            n = 0;
            while (n < n2) {
                url = sUrl = stringArray[n];
                url = url.substring(url.indexOf("//") + 2);
                if (!list.contains(url = url.substring(0, url.indexOf("/")))) {
                    list.add(url);
                }
                ++n;
            }
        }
        String[] passphrases = new String[list.size()];
        list.toArray(passphrases);
        this.generateCertificate(passphrases);
    }

    private void generateCertificate(String[] passphrases) {
        String myrootPath = "";
        try {
            myrootPath = this.manager.obterTrustStore();
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] store = "crhisn".toCharArray();
            ks.load(null, store);
            String[] stringArray = passphrases;
            int n = passphrases.length;
            int n2 = 0;
            while (n2 < n) {
                block12: {
                    X509Certificate cert;
                    String passphrase = stringArray[n2];
                    String[] conexao = passphrase.split(":");
                    String host = conexao[0];
                    int port = conexao.length == 1 ? 443 : Integer.parseInt(conexao[1]);
                    SSLContext context = SSLContext.getInstance("TLS");
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ks);
                    X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
                    SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
                    context.init(null, new TrustManager[]{tm}, null);
                    SSLSocketFactory factory = context.getSocketFactory();
                    System.out.println("Opening connection to " + host + ":" + port + "...");
                    this.view.addLogMessage("Opening connection to " + host + ":" + port + "...");
                    SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
                    socket.setSoTimeout(10000);
                    try {
                        System.out.println("Starting SSL handshake...");
                        this.view.addLogMessage("Starting SSL handshake...");
                        socket.startHandshake();
                        socket.close();
                        System.out.println();
                        System.out.println("No errors, certificate is already trusted");
                        this.view.addLogMessage("");
                        this.view.addLogMessage("No errors, certificate is already trusted");
                    }
                    catch (SocketTimeoutException eTimeout) {
                        break block12;
                    }
                    catch (SSLException e) {
                        System.out.println("Certificate chain needed");
                        this.view.addLogMessage("Certificate chain needed");
                    }
                    X509Certificate[] chain = tm.chain;
                    if (chain == null) {
                        System.out.println("Could not obtain server certificate chain");
                        this.view.addLogMessage("Could not obtain server certificate chain");
                        return;
                    }
                    System.out.println();
                    System.out.println("Server sent " + chain.length + " certificate(s):");
                    System.out.println();
                    this.view.addLogMessage("");
                    this.view.addLogMessage("Server sent " + chain.length + " certificate(s):");
                    this.view.addLogMessage("");
                    MessageDigest sha1 = MessageDigest.getInstance("SHA1");
                    MessageDigest md5 = MessageDigest.getInstance("MD5");
                    int i = 0;
                    while (i < chain.length) {
                        cert = chain[i];
                        System.out.println(" " + (i + 1) + " Subject " + cert.getSubjectDN());
                        System.out.println("   Issuer  " + cert.getIssuerDN());
                        this.view.addLogMessage(" " + (i + 1) + " Subject " + cert.getSubjectDN());
                        this.view.addLogMessage("   Issuer  " + cert.getIssuerDN());
                        sha1.update(cert.getEncoded());
                        System.out.println("   sha1    " + GenerateSefazWSCerts.toHexString(sha1.digest()));
                        this.view.addLogMessage("   sha1    " + GenerateSefazWSCerts.toHexString(sha1.digest()));
                        md5.update(cert.getEncoded());
                        System.out.println("   md5     " + GenerateSefazWSCerts.toHexString(md5.digest()));
                        System.out.println();
                        this.view.addLogMessage("   md5     " + GenerateSefazWSCerts.toHexString(md5.digest()));
                        this.view.addLogMessage("");
                        ++i;
                    }
                    System.out.println("Enter certificate to add to trusted keystore");
                    this.view.addLogMessage("Enter certificate to add to trusted keystore");
                    int k = 0;
                    cert = chain[k];
                    String alias = String.valueOf(host) + "-" + (k + 1);
                    ks.setCertificateEntry(alias, cert);
                    System.out.println();
                    System.out.println(cert);
                    System.out.println();
                    System.out.println("Added certificate to keystore using alias '" + alias + "'");
                    this.view.addLogMessage("");
                    this.view.addLogMessage(cert.toString());
                    this.view.addLogMessage("");
                    this.view.addLogMessage("Added certificate to keystore using alias '" + alias + "'");
                }
                ++n2;
            }
            File file = new File(myrootPath);
            FileOutputStream out = new FileOutputStream(file);
            ks.store(out, store);
            ((OutputStream)out).close();
            System.out.println();
            System.out.println(String.valueOf(myrootPath) + " gerado com sucesso !");
            this.view.addLogMessage("");
            this.view.addLogMessage(String.valueOf(myrootPath) + " gerado com sucesso !");
            this.view.showMessage(String.valueOf(myrootPath) + " gerado com sucesso !", "Sucesso");
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            this.view.showMessage(String.valueOf(myrootPath) + " nao pode ser gerado !\n" + e.getMessage(), "Erro");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            this.view.showMessage(String.valueOf(myrootPath) + " nao pode ser gerado !\n" + e.getMessage(), "Erro");
        }
        catch (CertificateException e) {
            e.printStackTrace();
            this.view.showMessage(String.valueOf(myrootPath) + " nao pode ser gerado !\n" + e.getMessage(), "Erro");
        }
        catch (IOException e) {
            e.printStackTrace();
            this.view.showMessage(String.valueOf(myrootPath) + " nao pode ser gerado !\n" + e.getMessage(), "Erro");
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
            this.view.showMessage(String.valueOf(myrootPath) + " nao pode ser gerado !\n" + e.getMessage(), "Erro");
        }
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            int b = byArray[n2];
            sb.append(HEXDIGITS[(b &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[b & 0xF]);
            sb.append(' ');
            ++n2;
        }
        return sb.toString();
    }

    public String[] getUrls(String ambiente, String filename) {
        ArrayList<String> urls = new ArrayList<String>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document d = builder.parse(new FileInputStream(filename));
            d.getDocumentElement().normalize();
            NodeList amb = d.getElementsByTagName(ambiente.equals("1") ? "producao" : "homologacao");
            int i = 0;
            while (i < amb.getLength()) {
                try {
                    Node ufNode = amb.item(i).getParentNode();
                    Node sigla = ufNode.getChildNodes().item(1);
                    sigla = sigla.getChildNodes().item(0);
                    Node urlNodes = amb.item(i);
                    int j = 0;
                    while (j < urlNodes.getChildNodes().getLength()) {
                        if (urlNodes.getChildNodes().item(j).getAttributes() != null && !urlNodes.getChildNodes().item(j).getAttributes().item(0).getNodeValue().equals("") && urlNodes.getChildNodes().item(j).getFirstChild() != null && !urlNodes.getChildNodes().item(j).getFirstChild().getNodeValue().toString().trim().equals("")) {
                            urls.add(urlNodes.getChildNodes().item(j).getFirstChild().getNodeValue().toString().trim());
                        }
                        ++j;
                    }
                }
                catch (DOMException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Object[] objArr = urls.toArray();
        String[] s = (String[])Arrays.copyOf(objArr, objArr.length, String[].class);
        return s;
    }

    public static final void main(String[] args) {
        GenerateSefazWSCerts gswc = new GenerateSefazWSCerts(null);
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

