/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.cockpitrap.views;

import br.com.taragona.nfe.clientreferencia.ReferenciaGerenciador;
import br.com.taragona.nfe.event.xml.classes.TEvento;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.EventoInfo;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.tti.cockpitrap.events.SendEventEvent;
import br.com.tti.cockpitrap.session.ClientSession;
import br.com.tti.cockpitrap.table.EventTableContentProvider;
import br.com.tti.cockpitrap.table.EventTableLabelProvider;
import br.com.tti.cockpitrap.util.LoadImages;
import br.com.tti.cockpitrap.util.ManagerProxy;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class CCEView
extends ViewPart {
    public static String ID = CCEView.class.getCanonicalName();
    private Text keyXml;
    private EstadoNFe xmldata;
    private Text description;
    private Combo cnpj;
    private Hashtable<String, String> tabelaUF;
    private Combo ufcombo;
    private int selectionIndex;
    private Button eventocce;
    private Button eventooutro;
    private TableViewer tableviewer;

    public CCEView() {
        this.initUF();
    }

    public void createPartControl(Composite parent) {
        FillLayout pp = new FillLayout(576);
        parent.setLayout((Layout)pp);
        Composite grid = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        grid.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        Label label = new Label(grid, 0x1000000);
        label.setText("CC-e Carta de Corre\u00e7\u00e3o Eletr\u00f4nica");
        label.setLayoutData((Object)gd);
        this.xmldata = ClientSession.getInstance().getXmlSel();
        Group groupDados = new Group(grid, 0);
        groupDados.setText("Dados da NF-e");
        GridLayout ggl1 = new GridLayout(2, false);
        groupDados.setLayout((Layout)ggl1);
        GridData gd1 = new GridData();
        gd1.grabExcessVerticalSpace = true;
        gd1.verticalAlignment = 4;
        groupDados.setLayoutData((Object)gd1);
        new Label((Composite)groupDados, 0).setText("Chave NF-e");
        this.keyXml = new Text((Composite)groupDados, 2048);
        GridData gdd = new GridData();
        gdd.widthHint = 300;
        this.keyXml.setLayoutData((Object)gdd);
        if (this.xmldata != null) {
            this.keyXml.setText(this.xmldata.getId().replace("NFe", ""));
        }
        GerenciadorChavesNota kk = new GerenciadorChavesNota(this.xmldata.getId());
        int poscnpj = 0;
        new Label((Composite)groupDados, 0).setText("CNPJ ");
        this.cnpj = new Combo((Composite)groupDados, 8);
        Vector<String> cnpjUser = ClientSession.getInstance().getCnpjs();
        int i = 0;
        while (i < cnpjUser.size()) {
            String cnpj1 = cnpjUser.get(i);
            this.cnpj.add(cnpj1);
            if (cnpj1.startsWith(kk.getCnpj())) {
                poscnpj = i;
            }
            ++i;
        }
        this.cnpj.select(poscnpj);
        new Label((Composite)groupDados, 0).setText("Codigo Org\u00e3o Receptor");
        this.ufcombo = new Combo((Composite)groupDados, 8);
        this.selectionIndex = -1;
        for (String uf : this.tabelaUF.keySet()) {
            this.ufcombo.add(String.valueOf(this.tabelaUF.get(uf)) + " - " + uf);
            if (!this.tabelaUF.get(uf).equals(kk.getUF())) continue;
            this.selectionIndex = this.ufcombo.getItemCount() - 1;
        }
        if (this.selectionIndex == -1) {
            String[] stringArray = this.ufcombo.getItems();
            int n = stringArray.length;
            int cnpj1 = 0;
            while (cnpj1 < n) {
                String uf = stringArray[cnpj1];
                if (uf.equals("SP")) {
                    this.selectionIndex = this.ufcombo.getItemCount() - 1;
                }
                ++cnpj1;
            }
            if (this.selectionIndex == -1) {
                this.selectionIndex = 0;
            }
        }
        this.ufcombo.add("99 - SVAN");
        this.ufcombo.select(this.selectionIndex);
        new Label((Composite)groupDados, 0).setText("Tipo de Evento");
        Group groupeventos = new Group((Composite)groupDados, 0);
        GridLayout glevent = new GridLayout(4, false);
        groupeventos.setLayout((Layout)glevent);
        this.eventocce = new Button((Composite)groupeventos, 16);
        this.eventocce.setText("Carta de Corre\u00e7\u00e3o");
        this.eventocce.setSelection(true);
        this.eventooutro = new Button((Composite)groupeventos, 16);
        this.eventooutro.setText("Outro Evento");
        new Label((Composite)groupeventos, 0);
        new Label((Composite)groupeventos, 0);
        Label label_2 = new Label((Composite)groupDados, 0);
        label_2.setText("Descri\u00e7\u00e3o");
        this.description = new Text((Composite)groupDados, 2562);
        GridData griddata = new GridData();
        griddata.heightHint = 100;
        griddata.widthHint = 450;
        this.description.setLayoutData((Object)griddata);
        Button enviarCCe = new Button((Composite)groupDados, 2048);
        enviarCCe.setText("Enviar CC-e");
        enviarCCe.addSelectionListener((SelectionListener)new SendEventEvent(this));
        enviarCCe.setVisible(false);
        Button saveCCe = new Button((Composite)groupDados, 2048);
        saveCCe.setText("Enviar CC-e");
        saveCCe.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CCEView.this.createCCE();
                List<Object> list = new ArrayList<EventoInfo>();
                if (CCEView.this.xmldata != null) {
                    try {
                        ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
                        list = manager.obterEventos(CCEView.this.xmldata.getId().replace("NFe", ""), ClientSession.getInstance().getAmbiente(), null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (list != null && !list.isEmpty()) {
                    EventTableContentProvider provider = new EventTableContentProvider(list);
                    CCEView.this.tableviewer.setContentProvider((IContentProvider)provider);
                    CCEView.this.tableviewer.getTable().redraw();
                } else {
                    MessageDialog.openInformation(null, (String)"Gera\u00e7\u00e3o de Evento", (String)"Nenhum evento encontrado para a NF-e ");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ArrayList<EventoInfo> list = new ArrayList();
        if (this.xmldata != null) {
            try {
                ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
                list = manager.obterEventos(this.xmldata.getId().replace("NFe", ""), ClientSession.getInstance().getAmbiente(), null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        new Label((Composite)groupDados, 0);
        Button procurarCCe = new Button((Composite)groupDados, 2048);
        procurarCCe.setText("Procurar CC-e");
        procurarCCe.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                List<Object> list = new ArrayList<EventoInfo>();
                if (CCEView.this.xmldata != null) {
                    try {
                        ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
                        list = manager.obterEventos(CCEView.this.keyXml.getText(), ClientSession.getInstance().getAmbiente(), null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (list != null && !list.isEmpty()) {
                    EventTableContentProvider provider = new EventTableContentProvider(list);
                    CCEView.this.tableviewer.setContentProvider((IContentProvider)provider);
                    CCEView.this.tableviewer.getTable().redraw();
                } else {
                    MessageDialog.openInformation(null, (String)"Gera\u00e7\u00e3o de Evento", (String)"Nenhum evento encontrado para a NF-e");
                    CCEView.this.tableviewer.setContentProvider((IContentProvider)new EventTableContentProvider(new ArrayList<EventoInfo>()));
                    CCEView.this.tableviewer.getTable().redraw();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label_1 = new Label((Composite)groupDados, 0);
        label_1.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        label_1.setText("CC-e Anteriores");
        this.tableviewer = new TableViewer((Composite)groupDados, 2048);
        EventTableContentProvider provider = new EventTableContentProvider(list);
        EventTableLabelProvider labelProvider = new EventTableLabelProvider();
        this.tableviewer.setContentProvider((IContentProvider)provider);
        this.tableviewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        GridData gdtable = new GridData();
        gdtable.verticalAlignment = 4;
        gdtable.grabExcessVerticalSpace = true;
        gdtable.widthHint = 600;
        Table table = this.tableviewer.getTable();
        table.setLayoutData((Object)gdtable);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.tableviewer.setColumnProperties(provider.initColumnProp(this.tableviewer.getTable()));
        this.tableviewer.setInput((Object)this);
        new Label((Composite)groupDados, 0);
        Button visualizarCCe = new Button((Composite)groupDados, 0);
        visualizarCCe.setText("Detalhes CC-e");
        new Label(grid, 0);
        visualizarCCe.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selecteds;
                TableItem[] tableItemArray = selecteds = CCEView.this.tableviewer.getTable().getSelection();
                int n = selecteds.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    EventoInfo info = (EventoInfo)item.getData();
                    String messagem = "";
                    messagem = String.valueOf(messagem) + "Chave:               " + info.getEvent().getInfEvento().getChNFe() + "\n";
                    messagem = String.valueOf(messagem) + "CNPJ:                 " + info.getEvent().getInfEvento().getCNPJ() + "\n";
                    messagem = String.valueOf(messagem) + "Data Gerada:     " + info.getDataGerada() + "\n";
                    messagem = String.valueOf(messagem) + "Mensagem:   " + info.getEvent().getInfEvento().getDetEvento().getXCorrecao();
                    MessageDialog.openInformation(null, (String)"Gera\u00e7\u00e3o de Evento", (String)messagem);
                    ++n2;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        super.setTitleImage(LoadImages.resizeImage(LoadImages.loadImage("CARTA_CORRECAO.gif")));
    }

    public void initUF() {
        this.tabelaUF = new Hashtable();
        this.tabelaUF.put("RO", "11");
        this.tabelaUF.put("AC", "12");
        this.tabelaUF.put("AM", "13");
        this.tabelaUF.put("RR", "14");
        this.tabelaUF.put("PA", "15");
        this.tabelaUF.put("TO", "17");
        this.tabelaUF.put("MA", "21");
        this.tabelaUF.put("PI", "22");
        this.tabelaUF.put("CE", "23");
        this.tabelaUF.put("RN", "24");
        this.tabelaUF.put("PB", "25");
        this.tabelaUF.put("PE", "26");
        this.tabelaUF.put("AL", "27");
        this.tabelaUF.put("SE", "28");
        this.tabelaUF.put("BA", "29");
        this.tabelaUF.put("MG", "31");
        this.tabelaUF.put("ES", "32");
        this.tabelaUF.put("RJ", "33");
        this.tabelaUF.put("SP", "35");
        this.tabelaUF.put("PR", "41");
        this.tabelaUF.put("SC", "42");
        this.tabelaUF.put("RS", "43");
        this.tabelaUF.put("MS", "50");
        this.tabelaUF.put("MT", "51");
        this.tabelaUF.put("GO", "52");
        this.tabelaUF.put("DF", "53");
    }

    public void restart() {
        EstadoNFe xmldata = ClientSession.getInstance().getXmlSel();
        List<Object> elems = new ArrayList<EventoInfo>();
        if (xmldata != null) {
            this.keyXml.setText(xmldata.getId().replace("NFe", ""));
            if (xmldata != null) {
                try {
                    ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
                    elems = manager.obterEventos(xmldata.getId().replace("NFe", ""), ClientSession.getInstance().getAmbiente(), null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            GerenciadorChavesNota chave = new GerenciadorChavesNota(xmldata.getId());
            this.setUpCNPJ(chave.getCnpj());
            this.setUpUF(chave.getUF());
        } else {
            this.keyXml.setText("");
        }
        EventTableContentProvider provider = new EventTableContentProvider(elems);
        this.tableviewer.setContentProvider((IContentProvider)provider);
        this.tableviewer.refresh();
        this.ufcombo.select(this.selectionIndex);
        this.eventocce.setSelection(true);
        this.description.setText("");
    }

    private void setUpCNPJ(String cnpj) {
        String[] items = this.cnpj.getItems();
        int position = 0;
        int i = 0;
        while (i < items.length) {
            String s = items[i];
            if (s.startsWith(cnpj)) {
                position = i;
                break;
            }
            ++i;
        }
        this.cnpj.select(position);
        this.cnpj.redraw();
    }

    private void setUpUF(String ufToSel) {
        for (String uf : this.tabelaUF.keySet()) {
            this.ufcombo.add(String.valueOf(this.tabelaUF.get(uf)) + " - " + uf);
            if (uf.equals("SP")) {
                this.selectionIndex = this.ufcombo.getItemCount() - 1;
            }
            if (!this.tabelaUF.get(uf).equals(ufToSel)) continue;
            this.selectionIndex = this.ufcombo.getItemCount() - 1;
        }
        this.ufcombo.add("99 - SVAN");
        this.ufcombo.select(this.selectionIndex);
        this.ufcombo.redraw();
    }

    private void createCCE() {
        EventoInfo evento = new EventoInfo();
        TEvento tevento = new TEvento();
        TEvento.InfEvento infevento = new TEvento.InfEvento();
        TEvento.InfEvento.DetEvento detevento = new TEvento.InfEvento.DetEvento();
        evento.setIdUsuario(ClientSession.getInstance().getUser().getId());
        evento.setEvent(tevento);
        tevento.setInfEvento(infevento);
        infevento.setDetEvento(detevento);
        infevento.setChNFe(this.keyXml.getText());
        String cnpjtext = this.cnpj.getItem(this.cnpj.getSelectionIndex());
        String[] splitsnpjtext = cnpjtext.split(":");
        String cnpj = splitsnpjtext[0];
        infevento.setChNFe(this.keyXml.getText());
        infevento.setCNPJ(cnpj);
        if (this.eventocce.getSelection()) {
            infevento.setTpEvento("110110");
            detevento.setDescEvento("Carta de Correcao");
        }
        String corgaotext = this.ufcombo.getItem(this.ufcombo.getSelectionIndex());
        String[] splitsnpjtext1 = corgaotext.split("-");
        String corgao = splitsnpjtext1[0].trim();
        infevento.setCOrgao(corgao);
        infevento.setVerEvento("1.00");
        String descript = this.description.getText();
        descript = descript.replace("\n", "");
        descript = descript.replace("\t", "");
        detevento.setXCorrecao(descript.trim());
        detevento.setVersao("1.00");
        ClientSession.getInstance().setCurrentevento(evento);
        GerenciadorInterface manager = null;
        try {
            manager = ReferenciaGerenciador.obterReferenciaGerenciador((String)"localhost");
            String result = manager.adicionarEvento(evento.getEvent().getInfEvento().getChNFe(), ClientSession.getInstance().getAmbiente(), evento, null, ClientSession.getInstance().getUser().getId());
            MessageDialog.openInformation(null, (String)"Gera\u00e7\u00e3o de Evento", (String)("Resultado do processamento: " + result));
            ClientSession.getInstance().setXmlSel(null);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError(null, (String)"Gera\u00e7\u00e3o de Evento", (String)("Erro no processamento: " + e.getLocalizedMessage()));
            return;
        }
    }

    public void setFocus() {
    }

    public Text getKeyXml() {
        return this.keyXml;
    }

    public void setKeyXml(Text keyXml) {
        this.keyXml = keyXml;
    }

    public EstadoNFe getXmldata() {
        return this.xmldata;
    }

    public void setXmldata(EstadoNFe xmldata) {
        this.xmldata = xmldata;
    }

    public Text getDescription() {
        return this.description;
    }

    public void setDescription(Text description) {
        this.description = description;
    }
}

