/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.cockpitrap.views;

import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.persistence.Empresa;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.tti.cockpitrap.dialogs.BuscaEmpressas;
import br.com.tti.cockpitrap.dialogs.DownloadDialog;
import br.com.tti.cockpitrap.dialogs.PDFDialog;
import br.com.tti.cockpitrap.dialogs.SelectDownloadlDialog;
import br.com.tti.cockpitrap.dialogs.ShowFileDialog;
import br.com.tti.cockpitrap.dialogs.ShowTextDialog;
import br.com.tti.cockpitrap.dialogs.TypeEmailDialog;
import br.com.tti.cockpitrap.dialogs.XMLDetailDialog;
import br.com.tti.cockpitrap.events.SearchEvent;
import br.com.tti.cockpitrap.events.TableSelectionEvent;
import br.com.tti.cockpitrap.session.ClientSession;
import br.com.tti.cockpitrap.table.TableContentProvider;
import br.com.tti.cockpitrap.table.TableLabelProvider;
import br.com.tti.cockpitrap.uiupdate.UIUpdateManager;
import br.com.tti.cockpitrap.util.LoadImages;
import br.com.tti.cockpitrap.util.ManagerProxy;
import br.com.tti.cockpitrap.views.CCEView;
import br.com.tti.cockpitrap.views.CancelInutView;
import br.com.tti.sefaz.listeners.Launcher;
import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.JavaScriptExecutor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class QueryView
extends ViewPart {
    public static final String ID = "TTICockpit.view.query";
    private TableViewer tableviewer;
    private TableContentProvider provider;
    private TableLabelProvider labelProvider;
    private Combo cnpj;
    private Text nInicial;
    private Text nFinal;
    private Button rHoje;
    private Button rPeriodo;
    private DateTime dInicio;
    private DateTime dFim;
    private String[] columnNames = new String[]{"Serie - Numero", "CNPJ Emitente", "Empresa Destinatario", "Data Enviada", "Data Autorizada", "Estado", "Valor Total R$", "Etiq", "Status Canc/Inut", "Mini DANFE", "Serial", "Email Dest", "Email Trans", "CC-e", "Modo", "Chave"};
    private Text serie;
    private Text currentXML;
    private Text currentSerie;
    private Text currentNumber;
    private Text currentCNPJ;
    private Combo estado;
    private Combo modocomb;
    private ComboViewer comboDest;
    private SearchEvent searchevent;
    private Label lbl_quantidade;

    public QueryView() {
        this.provider = new TableContentProvider();
        this.labelProvider = new TableLabelProvider();
        this.createSelectionListener();
    }

    private String[] initColumnProp(Table table) {
        TableColumn tc = new TableColumn(table, 16777300);
        tc.setText(this.columnNames[0]);
        tc.setWidth(200);
        tc.setAlignment(16384);
        TableColumn tc1 = new TableColumn(table, 16777300);
        tc1.setText(this.columnNames[1]);
        tc1.setWidth(150);
        tc1.setAlignment(16384);
        TableColumn tc01 = new TableColumn(table, 16777300);
        tc01.setText(this.columnNames[2]);
        tc01.setWidth(250);
        tc01.setAlignment(16384);
        TableColumn tc3 = new TableColumn(table, 16777300);
        tc3.setText(this.columnNames[3]);
        tc3.setWidth(120);
        tc3.setAlignment(16384);
        TableColumn tc4 = new TableColumn(table, 16777300);
        tc4.setText(this.columnNames[4]);
        tc4.setWidth(120);
        tc4.setAlignment(16384);
        TableColumn tc5 = new TableColumn(table, 16777300);
        tc5.setText(this.columnNames[5]);
        tc5.setWidth(90);
        tc5.setAlignment(16384);
        TableColumn tc0a5 = new TableColumn(table, 16777300);
        tc0a5.setText(this.columnNames[6]);
        tc0a5.setWidth(100);
        tc0a5.setAlignment(131072);
        TableColumn tc0b5 = new TableColumn(table, 16777300);
        tc0b5.setText(this.columnNames[7]);
        tc0b5.setWidth(0);
        tc0b5.setAlignment(16384);
        TableColumn tc067 = new TableColumn(table, 16777300);
        tc067.setText(this.columnNames[8]);
        tc067.setWidth(50);
        tc067.setAlignment(16384);
        TableColumn tcMiniDanfe = new TableColumn(table, 16777300);
        tcMiniDanfe.setText(this.columnNames[9]);
        tcMiniDanfe.setWidth(50);
        tcMiniDanfe.setAlignment(16384);
        TableColumn tcSerial = new TableColumn(table, 16777300);
        tcSerial.setText(this.columnNames[10]);
        tcSerial.setWidth(200);
        tcSerial.setAlignment(16384);
        TableColumn tcEmailDest = new TableColumn(table, 16777300);
        tcEmailDest.setText(this.columnNames[11]);
        tcEmailDest.setWidth(50);
        tcEmailDest.setAlignment(16384);
        TableColumn tcEmailTrans = new TableColumn(table, 16777300);
        tcEmailTrans.setText(this.columnNames[12]);
        tcEmailTrans.setWidth(50);
        tcEmailTrans.setAlignment(16384);
        TableColumn tc167 = new TableColumn(table, 16777300);
        tc167.setText(this.columnNames[13]);
        tc167.setWidth(50);
        tc167.setAlignment(16384);
        TableColumn tc6 = new TableColumn(table, 16777300);
        tc6.setText(this.columnNames[14]);
        tc6.setWidth(80);
        tc6.setAlignment(16384);
        TableColumn tc7 = new TableColumn(table, 16777300);
        tc7.setText(this.columnNames[15]);
        tc7.setWidth(320);
        tc7.setAlignment(16384);
        return this.columnNames;
    }

    public void createPartControl(Composite parent) {
        GridLayout pp = new GridLayout(1, false);
        parent.setLayout((Layout)pp);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        GridData ggg1 = new GridData();
        ggg1.verticalAlignment = 128;
        Composite grid = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        grid.setLayout((Layout)gl);
        GridData gdcomposite = new GridData();
        gdcomposite.heightHint = 200;
        gdcomposite.horizontalAlignment = 4;
        gdcomposite.grabExcessHorizontalSpace = true;
        grid.setLayoutData((Object)gdcomposite);
        Label label = new Label(grid, 0x1000000);
        label.setText("Consuta de NF-e");
        label.setLayoutData((Object)gd);
        Group groupDados = new Group(grid, 0);
        groupDados.setText("Dados da NF-e");
        GridLayout ggl1 = new GridLayout(10, false);
        groupDados.setLayout((Layout)ggl1);
        GridData ggd3 = new GridData();
        ggd3.verticalAlignment = 4;
        ggd3.horizontalAlignment = 4;
        ggd3.grabExcessHorizontalSpace = true;
        groupDados.setLayoutData((Object)ggd3);
        Label l3 = new Label((Composite)groupDados, 0);
        l3.setText("Empresa Emitente");
        Composite composite0 = new Composite((Composite)groupDados, 0);
        composite0.setLayout((Layout)new GridLayout(2, false));
        composite0.setLayoutData((Object)new GridData(4, 128, true, false));
        this.cnpj = new Combo(composite0, 8);
        this.cnpj.add("Todos");
        Vector<String> cnpjUser = ClientSession.getInstance().getCnpjs();
        for (String cnpj1 : cnpjUser) {
            this.cnpj.add(cnpj1);
        }
        this.cnpj.select(0);
        GridData gdata = new GridData();
        gdata.widthHint = 250;
        gdata.horizontalAlignment = 4;
        gdata.grabExcessHorizontalSpace = true;
        this.cnpj.setLayoutData((Object)gdata);
        Label l34 = new Label((Composite)groupDados, 0);
        l34.setText("Estado");
        this.estado = new Combo((Composite)groupDados, 8);
        this.estado.add("Todos");
        GridData gdata1 = new GridData();
        gdata1.widthHint = 150;
        gdata1.horizontalAlignment = 4;
        gdata1.grabExcessHorizontalSpace = true;
        this.estado.setLayoutData((Object)gdata1);
        this.estado.add("Pendentes de Envio");
        this.estado.add("Enviadas");
        this.estado.add("Autorizadas");
        this.estado.add("Rejeitadas");
        this.estado.add("Canceladas");
        this.estado.add("Inutilizadas");
        this.estado.add("Erro de Valida\u00e7\u00e3o");
        this.estado.add("Erro de Cancel/Inut");
        this.estado.add("Com Carta de Corre\u00e7\u00e3o");
        this.estado.add("Mini Danfe");
        this.estado.add("Uso Denegado");
        this.estado.select(0);
        Label l33 = new Label((Composite)groupDados, 0);
        l33.setText("Serie");
        this.serie = new Text((Composite)groupDados, 2048);
        Label l1 = new Label((Composite)groupDados, 0);
        l1.setText("Numero Inicial");
        this.nInicial = new Text((Composite)groupDados, 2048);
        Label l2 = new Label((Composite)groupDados, 0);
        l2.setText("Numero Final");
        this.nFinal = new Text((Composite)groupDados, 2048);
        GridData gdnumbers = new GridData();
        gdnumbers.widthHint = 80;
        GridData gdnumbers2 = new GridData();
        gdnumbers2.widthHint = 50;
        this.serie.setLayoutData((Object)gdnumbers2);
        this.nInicial.setLayoutData((Object)gdnumbers);
        this.nFinal.setLayoutData((Object)gdnumbers);
        this.nInicial.setTextLimit(9);
        this.nFinal.setTextLimit(9);
        this.serie.setTextLimit(3);
        new Label((Composite)groupDados, 0).setText("Empresa Destino");
        Composite composite = new Composite((Composite)groupDados, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.comboDest = new ComboViewer(composite, 2056);
        this.comboDest.getCombo().setLayoutData((Object)new GridData(4, 128, true, false));
        Empresa todoempresa = new Empresa();
        todoempresa.setCnpj("Todos");
        String arg0 = String.valueOf(ClientSession.getInstance().getLogin()) + Empresa.TIPO_EMPRESA.DEST;
        List<Empresa> empresasluf = new ArrayList<Empresa>();
        try {
            empresasluf = ClientSession.getInstance().getManagerproxy().empresasLFU(ClientSession.getInstance().getAmbiente(), arg0);
        }
        catch (RemoteException e2) {
            e2.printStackTrace();
        }
        empresasluf.add(0, todoempresa);
        this.comboDest.setContentProvider((IContentProvider)new ListContentProvider((ArrayList)empresasluf));
        this.comboDest.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private static final long serialVersionUID = 1L;

            public String getText(Object element) {
                if (element instanceof Empresa) {
                    Empresa empresa = (Empresa)element;
                    return String.valueOf(empresa.getCnpj()) + (empresa.getNome() != null ? ": " + empresa.getNome() : "");
                }
                return super.getText(element);
            }
        });
        this.comboDest.setInput((Object)this);
        this.comboDest.getCombo().select(0);
        Button btnAddDest = new Button(composite, 2048);
        btnAddDest.setImage(LoadImages.loadImage("Add.png"));
        btnAddDest.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BuscaEmpressas dialoglist = new BuscaEmpressas(QueryView.this.getSite().getShell(), new ArrayList<Empresa>(), Empresa.TIPO_EMPRESA.DEST);
                dialoglist.setBlockOnOpen(true);
                dialoglist.open();
                Vector<Empresa> listempresasel = dialoglist.getEmpresas();
                if (listempresasel != null && !listempresasel.isEmpty()) {
                    Empresa empresasel = listempresasel.get(0);
                    String arg0 = String.valueOf(ClientSession.getInstance().getLogin()) + Empresa.TIPO_EMPRESA.DEST;
                    Empresa arg1 = empresasel;
                    try {
                        ClientSession.getInstance().getManagerproxy().registerEmpresaLFU(ClientSession.getInstance().getAmbiente(), arg0, arg1);
                    }
                    catch (RemoteException e1) {
                        e1.printStackTrace();
                    }
                    ListContentProvider content = (ListContentProvider)QueryView.this.comboDest.getContentProvider();
                    ArrayList empresas = content.getListempresas();
                    if (!empresas.contains(empresasel)) {
                        empresas.add(empresasel);
                    }
                    QueryView.this.comboDest.refresh();
                    QueryView.this.comboDest.setSelection((ISelection)new StructuredSelection(new Object[]{empresasel}));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label l4 = new Label((Composite)groupDados, 0);
        l4.setText("Modo");
        this.modocomb = new Combo((Composite)groupDados, 8);
        this.modocomb.add("Todos");
        this.modocomb.add("Normal");
        this.modocomb.add("Conting\u00eancia");
        this.modocomb.add("DPEC");
        this.modocomb.add("SCAN");
        this.modocomb.add("SVC-AN");
        this.modocomb.add("SVC-RS");
        this.modocomb.select(0);
        Group groupData = new Group(grid, 0);
        GridLayout ggl = new GridLayout(10, false);
        groupData.setLayout((Layout)ggl);
        groupData.setText("Data");
        GridData fff = new GridData(4, 4, true, true);
        groupData.setLayoutData((Object)fff);
        this.rHoje = new Button((Composite)groupData, 16);
        this.rHoje.setText("Hoje");
        this.rHoje.setSelection(true);
        this.rPeriodo = new Button((Composite)groupData, 16);
        this.rPeriodo.setText("Periodo");
        Label gl1 = new Label((Composite)groupData, 0);
        gl1.setText("Inicio");
        this.dInicio = new DateTime((Composite)groupData, 2052);
        Label gl2 = new Label((Composite)groupData, 0);
        this.dFim = new DateTime((Composite)groupData, 2052);
        Button search = new Button((Composite)groupData, 0);
        search.setText("Procurar");
        Label spacing = new Label((Composite)groupData, 0);
        GridData ggggg = new GridData(0, 4, false, true);
        ggggg.widthHint = 30;
        spacing.setLayoutData((Object)ggggg);
        Button download = new Button((Composite)groupData, 0);
        download.setText("Download");
        download.setLayoutData((Object)new GridData(0, 4, true, true));
        Button relatorio = new Button((Composite)groupData, 0);
        relatorio.setText("Gerar Relatorio");
        relatorio.setVisible(false);
        relatorio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                Hashtable<String, String> headerdata = new Hashtable<String, String>();
                headerdata.put("dataconsulta", Calendar.getInstance().getTime().toGMTString());
                headerdata.put("paginanumero", "1");
                headerdata.put("totalpagina", "3");
                headerdata.put("emitente", QueryView.this.cnpj.getItem(QueryView.this.cnpj.getSelectionIndex()));
                headerdata.put("destinatario", "");
                headerdata.put("datainicio", new Date(QueryView.this.dInicio.getYear() - 1900, QueryView.this.dInicio.getMonth(), QueryView.this.dInicio.getDay()).toGMTString());
                headerdata.put("datafim", new Date(QueryView.this.dFim.getYear() - 1900, QueryView.this.dFim.getMonth(), QueryView.this.dFim.getDay()).toGMTString());
                Vector<EstadoNFe> infoss = new Vector<EstadoNFe>();
                TableItem[] tableItemArray = items = QueryView.this.tableviewer.getTable().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    infoss.add((EstadoNFe)item.getData());
                    ++n2;
                }
                System.out.println(infoss.toString());
                File filedown = null;
                try {
                    filedown = ClientSession.getInstance().getManagerproxy().createRelatorio(headerdata, infoss);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                System.out.println("down file:" + filedown.getAbsolutePath());
                PDFDialog dialog = new PDFDialog(QueryView.this.getSite().getShell(), filedown.getAbsolutePath(), "down", "pdf");
                dialog.setBlockOnOpen(false);
                dialog.open();
                MessageDialog.openConfirm((Shell)QueryView.this.getSite().getShell(), (String)"Relatorio", (String)"Gerando XMLs");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lbl_quantidade = new Label(parent, 0);
        this.tableviewer = new TableViewer(parent);
        this.tableviewer.setContentProvider((IContentProvider)this.provider);
        this.tableviewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        GridData gdtable = new GridData();
        gdtable.widthHint = 1220;
        gdtable.horizontalAlignment = 4;
        gdtable.verticalAlignment = 4;
        gdtable.grabExcessHorizontalSpace = true;
        gdtable.grabExcessVerticalSpace = true;
        this.tableviewer.getTable().setLayoutData((Object)gdtable);
        Table table = this.tableviewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.tableviewer.setColumnProperties(this.initColumnProp(table));
        this.tableviewer.setInput((Object)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableviewer);
        this.tableviewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window1 = workbench.getActiveWorkbenchWindow();
                EstadoNFe xml = ClientSession.getInstance().getXmlSel();
                XMLDetailDialog d1 = new XMLDetailDialog(window1.getShell(), xml);
                d1.setBlockOnOpen(true);
                d1.open();
            }
        });
        this.searchevent = new SearchEvent(this);
        search.addSelectionListener((SelectionListener)this.searchevent);
        this.searchevent.widgetSelected(null);
        this.cnpj.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                QueryView.this.searchevent.widgetSelected(null);
            }
        });
        this.estado.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                QueryView.this.searchevent.widgetSelected(null);
            }
        });
        this.modocomb.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                QueryView.this.searchevent.widgetSelected(null);
            }
        });
        UIUpdateManager manager = ClientSession.getInstance().getUIManager();
        manager.registerControl("br.com.taragona.nfe.persistence.EstadoNFe", "br.com.tti.cockpitrap.uiupdate.UIUpdateTable", this.tableviewer.getControl().getDisplay(), this.tableviewer);
        this.tableviewer.getTable().addMouseListener((MouseListener)new MenuCreator());
        this.reCreateListener();
        this.dInicio.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent event) {
                QueryView.this.rHoje.setSelection(false);
                QueryView.this.rPeriodo.setSelection(true);
            }

            public void focusGained(FocusEvent event) {
            }
        });
        this.dFim.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent event) {
                QueryView.this.rHoje.setSelection(false);
                QueryView.this.rPeriodo.setSelection(true);
            }

            public void focusGained(FocusEvent event) {
            }
        });
        search.setImage(LoadImages.loadImage("CONUSULTA2.gif"));
        download.setImage(LoadImages.loadImage("PDF_FILE.GIF"));
        download.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectDownloadlDialog dialog = new SelectDownloadlDialog(QueryView.this.getSerie().getShell());
                dialog.setBlockOnOpen(true);
                dialog.open();
                if (dialog.isClicoubotao()) {
                    int n;
                    String params = null;
                    Date d1 = new Date(QueryView.this.dInicio.getYear() - 1900, QueryView.this.dInicio.getMonth(), QueryView.this.dInicio.getDay());
                    Date d2 = new Date(QueryView.this.dFim.getYear() - 1900, QueryView.this.dFim.getMonth(), QueryView.this.dFim.getDay());
                    Vector<String> cnpjsemit = new Vector<String>();
                    int pos = QueryView.this.cnpj.getSelectionIndex();
                    String cnpjstring = QueryView.this.cnpj.getItem(pos).trim();
                    if (cnpjstring.equals("Todos")) {
                        String[] stringArray = QueryView.this.cnpj.getItems();
                        n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String str = stringArray[n2];
                            System.out.println(str);
                            cnpjsemit.add(str.split(":")[0].trim());
                            ++n2;
                        }
                    } else {
                        String[] parts = cnpjstring.split(":");
                        if (parts.length >= 2) {
                            cnpjstring = parts[0];
                            cnpjsemit.add(cnpjstring);
                        }
                    }
                    Vector<String> cnpjsdest = new Vector<String>();
                    int pos2 = QueryView.this.comboDest.getCombo().getSelectionIndex();
                    String cnpjstring2 = QueryView.this.comboDest.getCombo().getItem(pos2).trim();
                    if (cnpjstring2.equals("Todos")) {
                        String[] stringArray = QueryView.this.comboDest.getCombo().getItems();
                        int n3 = stringArray.length;
                        n = 0;
                        while (n < n3) {
                            String str = stringArray[n];
                            System.out.println(str);
                            cnpjsdest.add(str.split(":")[0].trim());
                            ++n;
                        }
                    } else {
                        String[] parts = cnpjstring2.split(":");
                        if (parts.length >= 2) {
                            cnpjstring2 = parts[0];
                            cnpjsdest.add(cnpjstring2);
                        }
                    }
                    File filezip = null;
                    try {
                        Hashtable<String, String> props = new Hashtable<String, String>();
                        props.put("xml", String.valueOf(dialog.isXmlb()));
                        props.put("pdf", String.valueOf(dialog.isPdfb()));
                        filezip = ClientSession.getInstance().getManagerproxy().process(ClientSession.getInstance().getAmbiente(), cnpjsemit, cnpjsdest, d1, d2, props);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        MessageDialog.openError((Shell)QueryView.this.getSite().getShell(), (String)"Extrator XML", (String)("Problemas na gera\u00e7\u00e3o do arquivo zipado:" + e1.getLocalizedMessage()));
                    }
                    if (filezip == null) {
                        MessageDialog.openError((Shell)QueryView.this.getSite().getShell(), (String)"Extractor XML", (String)"Nenhuma NF-e encontrada para a consulta");
                    } else {
                        try {
                            DownloadDialog dialog2 = new DownloadDialog(QueryView.this.getSite().getShell(), params, filezip, "zip");
                            dialog2.setBlockOnOpen(false);
                            dialog2.open();
                            dialog2.getShell().setMinimized(true);
                            MessageDialog.openConfirm((Shell)QueryView.this.getSite().getShell(), (String)"Extrator XML", (String)"Arquivo Zipado com os XML gerado com sucesso");
                        }
                        catch (Exception e12) {
                            e12.printStackTrace();
                            MessageDialog.openError((Shell)QueryView.this.getSite().getShell(), (String)"Extrator XML", (String)("Problemas na gera\u00e7\u00e3o do arquivo zipado:" + e12.getLocalizedMessage()));
                        }
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.hideColumn(3);
    }

    public void reCreateListener() {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Launcher launcher = ClientSession.getInstance().getListenerLaucher();
                if (launcher != null) {
                    try {
                        launcher.stopPush();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Launcher l = new Launcher();
                l.register((Control)QueryView.this.tableviewer.getTable());
                ClientSession.getInstance().setListenerLaucher(l);
            }
        });
    }

    private void createSelectionListener() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        ISelectionService selectionService = window.getSelectionService();
        selectionService.addSelectionListener((ISelectionListener)new TableSelectionEvent());
        selectionService.addSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                EstadoNFe ev;
                IStructuredSelection sselection = (IStructuredSelection)selection;
                Object firstElement = sselection.getFirstElement();
                if (firstElement instanceof EstadoNFe && (ev = (EstadoNFe)firstElement) != null) {
                    GerenciadorChavesNota gerenciadorChavesNota = new GerenciadorChavesNota(ev.getId());
                }
            }
        });
        super.setTitleImage(LoadImages.resizeImage(LoadImages.loadImage("CONUSULTA2.gif")));
    }

    public void setFocus() {
    }

    public TableViewer getTableviewer() {
        return this.tableviewer;
    }

    public Combo getCnpj() {
        return this.cnpj;
    }

    public Text getnInicial() {
        return this.nInicial;
    }

    public Text getnFinal() {
        return this.nFinal;
    }

    public Button getrHoje() {
        return this.rHoje;
    }

    public Button getrPeriodo() {
        return this.rPeriodo;
    }

    public DateTime getdInicio() {
        return this.dInicio;
    }

    public void setdInicio(DateTime dInicio) {
        this.dInicio = dInicio;
    }

    public DateTime getdFim() {
        return this.dFim;
    }

    public void setdFim(DateTime dFim) {
        this.dFim = dFim;
    }

    public Text getSerie() {
        return this.serie;
    }

    public Combo getEstado() {
        return this.estado;
    }

    public Combo getModocomb() {
        return this.modocomb;
    }

    public void setModocomb(Combo modocomb) {
        this.modocomb = modocomb;
    }

    public void updateTable(Vector<EstadoNFe> infos) {
        TableContentProvider provider1 = new TableContentProvider();
        provider1.setData(infos);
        this.tableviewer.setContentProvider((IContentProvider)provider1);
        this.tableviewer.refresh();
    }

    public ComboViewer getComboDest() {
        return this.comboDest;
    }

    public Vector<EstadoNFe> estadoNFeInTable() {
        return this.searchevent.estadoNFeInTable();
    }

    public Label getLbl_quantidade() {
        return this.lbl_quantidade;
    }

    private void hideColumn(int index) {
        TableColumn c = this.tableviewer.getTable().getColumn(index);
        c.setResizable(false);
        c.setMoveable(false);
        c.setWidth(0);
    }

    private void hideColumnForced(int index) {
        TableColumn c = this.tableviewer.getTable().getColumn(index);
        c.setData("forcedHidden", (Object)Boolean.TRUE);
        c.setResizable(false);
        c.setMoveable(false);
        c.setWidth(0);
        Listener & Serializable keepZero = (Listener & Serializable)e -> {
            TableColumn col = (TableColumn)e.widget;
            if (Boolean.TRUE.equals(col.getData("forcedHidden")) && col.getWidth() != 0) {
                col.setWidth(0);
            }
        };
        c.addListener(11, (Listener)keepZero);
    }

    private void showColumn(int index, int width) {
        TableColumn c = this.tableviewer.getTable().getColumn(index);
        c.setWidth(width);
        c.setResizable(true);
        c.setMoveable(true);
    }

    public class ListContentProvider
    implements IStructuredContentProvider {
        private ArrayList listempresas;

        public ListContentProvider(ArrayList listempresas) {
            this.listempresas = listempresas;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.listempresas.toArray();
        }

        public ArrayList getListempresas() {
            return this.listempresas;
        }

        public void setListempresas(ArrayList listempresas) {
            this.listempresas = listempresas;
        }
    }

    public class MenuCreator
    implements MouseListener {
        private Menu menu;
        private MenuItem item0;

        public void mouseUp(MouseEvent e) {
            this.createPopupMenu(e);
        }

        private void createPopupMenu(MouseEvent e) {
            if (ClientSession.getInstance().getXmlSel() == null) {
                return;
            }
            Vector<EstadoNFe> estados = ClientSession.getInstance().getXmlselecteds();
            final EstadoNFe estado = estados.get(0);
            GerenciadorChavesNota chave = new GerenciadorChavesNota(estado.getId());
            if (e.button == 3) {
                this.menu = new Menu((Decorations)QueryView.this.tableviewer.getTable().getShell(), 8);
                if (estados.size() == 1) {
                    this.item0 = new MenuItem(this.menu, 8);
                    this.item0.setText("Nota: " + chave.getSerie() + " - " + chave.getNumeroNota());
                    new MenuItem(this.menu, 2);
                    if (ClientSession.getInstance().getUser().getPerfil().isSenhas()) {
                        MenuItem item = new MenuItem(this.menu, 8);
                        item.setText("Cancelar/Inutilizar NF-e");
                        item.setImage(LoadImages.resizeImage(LoadImages.loadImage("CANCELAR_INUTILIZACAO.gif")));
                        item.addListener(13, new Listener(){

                            public void handleEvent(Event e) {
                                if (ClientSession.getInstance().getLogin() != null) {
                                    try {
                                        IViewPart[] views;
                                        IWorkbench workbench = PlatformUI.getWorkbench();
                                        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                                        IViewPart[] iViewPartArray = views = window.getActivePage().getViews();
                                        int n = views.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IViewPart v = iViewPartArray[n2];
                                            if (v instanceof CancelInutView) {
                                                CancelInutView cce = (CancelInutView)v;
                                                cce.restart();
                                            }
                                            ++n2;
                                        }
                                        window.getActivePage().showView("TTICockpit.view.cancelinut", "query", 1);
                                    }
                                    catch (PartInitException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                            }
                        });
                    }
                    if (ClientSession.getInstance().getUser().getPerfil().isConfigurarMsn()) {
                        MenuItem item4 = new MenuItem(this.menu, 8);
                        item4.setText("Carta de Corre\u00e7\u00e3o");
                        item4.setImage(LoadImages.resizeImage(LoadImages.loadImage("CARTA_CORRECAO.gif")));
                        item4.addListener(13, new Listener(){

                            public void handleEvent(Event e) {
                                if (ClientSession.getInstance().getLogin() != null) {
                                    try {
                                        IViewPart[] views;
                                        IWorkbench workbench = PlatformUI.getWorkbench();
                                        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                                        IViewPart[] iViewPartArray = views = window.getActivePage().getViews();
                                        int n = views.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IViewPart v = iViewPartArray[n2];
                                            if (v instanceof CCEView) {
                                                CCEView cce = (CCEView)v;
                                                cce.restart();
                                            }
                                            ++n2;
                                        }
                                        window.getActivePage().showView(CCEView.ID, CCEView.ID, 1);
                                    }
                                    catch (Exception e22) {
                                        e22.printStackTrace();
                                    }
                                }
                            }
                        });
                    }
                    new MenuItem(this.menu, 2);
                    MenuItem item6 = new MenuItem(this.menu, 8);
                    item6.setText("Visualizar XML-NFe");
                    item6.setImage(LoadImages.resizeImage(LoadImages.loadImage("icon_xml.gif")));
                    item6.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            EstadoNFe selected = ClientSession.getInstance().getXmlSel();
                            ShowFileDialog dd = new ShowFileDialog(null, selected.getId(), "xml");
                            dd.setBlockOnOpen(true);
                            dd.open();
                        }
                    });
                    MenuItem item06 = new MenuItem(this.menu, 8);
                    item06.setText("Visualizar XML-CCe");
                    item06.setImage(LoadImages.resizeImage(LoadImages.loadImage("icon_xml.gif")));
                    item06.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            EstadoNFe selected = ClientSession.getInstance().getXmlSel();
                            ShowFileDialog dd = new ShowFileDialog(null, selected.getId(), "xmlcce");
                            dd.setBlockOnOpen(true);
                            dd.open();
                        }
                    });
                    MenuItem item7 = new MenuItem(this.menu, 8);
                    item7.setText("Visualizar DANFE");
                    item7.setImage(LoadImages.resizeImage(LoadImages.loadImage("PDF_FILE.GIF")));
                    item7.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            EstadoNFe selected = ClientSession.getInstance().getXmlSel();
                            if (selected.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.AUTORIZADA) || selected.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.GERADA) && selected.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA) || selected.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.GERADA) && selected.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC) || selected.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.EPEC_AUTORIZADO) && selected.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC) || selected.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.CANCELADA)) {
                                ShowFileDialog dd = new ShowFileDialog(null, selected.getId(), "pdf");
                                dd.setBlockOnOpen(false);
                                dd.open();
                            } else {
                                MessageDialog.openError((Shell)QueryView.this.getSite().getShell(), (String)"Visualizar DANFE", (String)"N\u00e3o \u00e9 possivel visualizar o DANFE desta NF-e neste status");
                            }
                        }
                    });
                }
                MenuItem item002 = new MenuItem(this.menu, 8);
                item002.setText("Gerar XML/PDF");
                item002.setImage(LoadImages.resizeImage(LoadImages.loadImage("icon_xml_2.jpg")));
                item002.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        if (ClientSession.getInstance().getLogin() != null) {
                            try {
                                Job job = new Job("gerar XML/PDF"){
                                    private GerenciadorInterface manager;
                                    private Vector<EstadoNFe> list;
                                    private Vector<String> dontprintnfe;
                                    private String tpAmb;
                                    private String idUser;
                                    {
                                        this.manager = ClientSession.getInstance().getManagerproxy();
                                        this.list = ClientSession.getInstance().getXmlselecteds();
                                        this.dontprintnfe = new Vector();
                                        this.tpAmb = ClientSession.getInstance().getAmbiente();
                                        this.idUser = ClientSession.getInstance().getUser().getId();
                                    }

                                    protected IStatus run(IProgressMonitor monitor) {
                                        try {
                                            monitor.beginTask("gerar XML/PDF", -1);
                                            for (EstadoNFe estado : this.list) {
                                                if (estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.AUTORIZADA) || estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.GERADA) && estado.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA) || estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.GERADA) && estado.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC) || estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.EPEC_AUTORIZADO) && estado.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC) || estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.CANCELADA)) {
                                                    Hashtable<String, String> params = new Hashtable<String, String>();
                                                    params.put("gerarxmlpdf", estado.getId());
                                                    this.manager.genericRemoteCall(params, this.tpAmb, this.idUser);
                                                    continue;
                                                }
                                                this.dontprintnfe.add(estado.getId());
                                            }
                                            if (this.dontprintnfe.isEmpty()) {
                                                QueryView.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        MessageDialog.openInformation(null, (String)"Gerar XML/PDF", (String)"Opera\u00e7\u00e3o executada com sucesso");
                                                    }
                                                });
                                            } else {
                                                QueryView.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        MessageDialog.openError(null, (String)"Gerar XML/PDF", (String)("As seguintes notas n\u00e3o podem ser impresas neste status: " + dontprintnfe.toString()));
                                                    }
                                                });
                                            }
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            QueryView.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                                                @Override
                                                public void run() {
                                                    MessageDialog.openError(null, (String)"Gerar XML/PDF", (String)("Erro executando a Opera\u00e7\u00e3o: " + e.getLocalizedMessage()));
                                                }
                                            });
                                        }
                                        monitor.done();
                                        return Status.OK_STATUS;
                                    }
                                };
                                job.setUser(false);
                                job.schedule();
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                });
                new MenuItem(this.menu, 2);
                MenuItem item2 = new MenuItem(this.menu, 8);
                item2.setText("Reimprimir NF-e");
                item2.setImage(LoadImages.resizeImage(LoadImages.loadImage("IMPRESSORAS.gif")));
                item2.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        if (ClientSession.getInstance().getLogin() != null) {
                            try {
                                ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
                                Vector<EstadoNFe> list = ClientSession.getInstance().getXmlselecteds();
                                Vector<String> dontprintnfe = new Vector<String>();
                                for (EstadoNFe estado : list) {
                                    if (estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.AUTORIZADA) || estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.GERADA) && estado.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA) || estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.EPEC_AUTORIZADO) && estado.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC) || estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.GERADA) && estado.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC) || estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.CANCELADA)) {
                                        manager.reImprimirNota(estado.getId(), ClientSession.getInstance().getAmbiente(), ClientSession.getInstance().getUser().getId());
                                        continue;
                                    }
                                    dontprintnfe.add(estado.getId());
                                }
                                if (dontprintnfe.isEmpty()) {
                                    MessageDialog.openInformation(null, (String)"Reimpress\u00e3o de NF-e", (String)"Opera\u00e7\u00e3o executada com sucesso");
                                } else {
                                    MessageDialog.openError(null, (String)"Reimpress\u00e3o de NF-e", (String)("As seguintes notas n\u00e3o podem ser impresas neste status: " + dontprintnfe.toString()));
                                }
                                return;
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                MessageDialog.openError(null, (String)"Reimpress\u00e3o de NF-e", (String)"Falha na execu\u00e7\u00e3o");
                            }
                        }
                    }
                });
                new MenuItem(this.menu, 2);
                MenuItem mnuReimprimeEtiqueta = new MenuItem(this.menu, 8);
                mnuReimprimeEtiqueta.setText("Reimprimir Mini-DANFE");
                mnuReimprimeEtiqueta.setImage(LoadImages.resizeImage(LoadImages.loadImage("PDF_FILE.GIF")));
                mnuReimprimeEtiqueta.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        if (ClientSession.getInstance().getLogin() != null) {
                            try {
                                ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
                                Vector<EstadoNFe> list = ClientSession.getInstance().getXmlselecteds();
                                Vector dontprintnfe = new Vector();
                                for (EstadoNFe estado : list) {
                                    if (!(estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.AUTORIZADA) || estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.GERADA) && estado.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA) || estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.EPEC_AUTORIZADO) && estado.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC) || estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.GERADA) && estado.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC)) && !estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.CANCELADA)) continue;
                                    manager.reImprimirNota(estado.getId(), ClientSession.getInstance().getAmbiente(), "MINIDANFE");
                                }
                                if (dontprintnfe.isEmpty()) {
                                    MessageDialog.openInformation(null, (String)"Reimpress\u00e3o de mini-DANFE", (String)"Opera\u00e7\u00e3o executada com sucesso");
                                } else {
                                    MessageDialog.openError(null, (String)"Reimpress\u00e3o de mini-DANFE", (String)("As seguintes notas n\u00e3o podem ser impresas neste status: " + dontprintnfe.toString()));
                                }
                                return;
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                MessageDialog.openError(null, (String)"Reimpress\u00e3o de mini-DANFE", (String)"Falha na execu\u00e7\u00e3o");
                            }
                        }
                    }
                });
                MenuItem mnuVisualizarMiniDanfe = new MenuItem(this.menu, 8);
                mnuVisualizarMiniDanfe.setText("Visualizar Mini-DANFE");
                mnuVisualizarMiniDanfe.setImage(LoadImages.resizeImage(LoadImages.loadImage("PDF_FILE.GIF")));
                mnuVisualizarMiniDanfe.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        if (ClientSession.getInstance().getLogin() != null) {
                            try {
                                ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
                                Vector<EstadoNFe> list = ClientSession.getInstance().getXmlselecteds();
                                for (EstadoNFe estado : list) {
                                    if (!(estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.AUTORIZADA) || estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.GERADA) && estado.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA) || estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.EPEC_AUTORIZADO) && estado.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC) || estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.GERADA) && estado.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC)) && !estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.CANCELADA)) continue;
                                    byte[] bytes = manager.obterPdfMiniDanfe(estado.getId(), ClientSession.getInstance().getAmbiente(), "MINIDANFE/TXT");
                                    String pdf = "<div class=\"pdf\" width=\"100%\" height=\"100%\">\r\n";
                                    pdf = String.valueOf(pdf) + "  <embed src=\"data:application/pdf;base64," + Base64.getEncoder().encodeToString(bytes) + "\" type=\"application/pdf\" width=\"100%\" height=\"100%\" />\r\n";
                                    pdf = String.valueOf(pdf) + "</div>\r\n";
                                    ShowTextDialog dd = new ShowTextDialog(QueryView.this.getSite().getShell(), pdf);
                                    dd.setBlockOnOpen(false);
                                    dd.open();
                                }
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                });
                MenuItem mnuVisualizarTXTMiniDanfe = new MenuItem(this.menu, 8);
                mnuVisualizarTXTMiniDanfe.setText("Visualizar TXT Mini-DANFE");
                mnuVisualizarTXTMiniDanfe.setImage(LoadImages.resizeImage(LoadImages.loadImage("IMPRESSORAS.gif")));
                mnuVisualizarTXTMiniDanfe.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        if (ClientSession.getInstance().getLogin() != null) {
                            try {
                                ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
                                Vector<EstadoNFe> list = ClientSession.getInstance().getXmlselecteds();
                                for (EstadoNFe estado : list) {
                                    if (!(estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.AUTORIZADA) || estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.GERADA) && estado.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA) || estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.EPEC_AUTORIZADO) && estado.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC) || estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.GERADA) && estado.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC)) && !estado.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.CANCELADA)) continue;
                                    String txt = manager.obterTxtMiniDanfe(estado.getId(), ClientSession.getInstance().getAmbiente(), "MINIDANFE/TXT");
                                    String[] campos = new String[]{"chave", "protocolo", "cfop", "entrada_saida", "numero_nota", "serie_nota", "data_emissao", "emitente_nome", "emitente_uf", "emitente_cnpj_cpf", "emitente_ie", "destinatario_nome", "destinatario_xlgr", "destinatario_nro", "destinatario_xbairro", "destinatario_cep", "destinatario_xmun", "destinatario_uf", "destinatario_cnpj_cpf", "destinatario_ie", "total_nota_fiscal", "EC", "total_FECP", "total_ICMS_uf_origem", "total_ICMS_uf_destino", "observacao", "entrega", "qVol"};
                                    String[] dados = txt.split("\\|");
                                    String html = "<table width=\"100%\" height=\"100%\">\r\n";
                                    System.out.println("len: " + dados.length);
                                    int i = 0;
                                    while (i < dados.length) {
                                        html = String.valueOf(html) + "   <tr>\r\n";
                                        html = String.valueOf(html) + "      <td width=\"150px\">" + campos[i] + "</td>\r\n";
                                        html = String.valueOf(html) + "      <td>" + dados[i] + "</td>\r\n";
                                        html = String.valueOf(html) + "   </tr>\r\n";
                                        ++i;
                                    }
                                    html = String.valueOf(html) + "</table>\r\n";
                                    ShowTextDialog dd = new ShowTextDialog(QueryView.this.getSite().getShell(), html);
                                    dd.setBlockOnOpen(false);
                                    dd.open();
                                }
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                });
                new MenuItem(this.menu, 2);
                MenuItem item3 = new MenuItem(this.menu, 8);
                item3.setText("Reprocessar NF-e");
                item3.setImage(LoadImages.resizeImage(LoadImages.loadImage("CONTINGENCIA.gif")));
                item3.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        if (ClientSession.getInstance().getLogin() != null) {
                            try {
                                ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
                                Vector<EstadoNFe> list = ClientSession.getInstance().getXmlselecteds();
                                Vector<String> lisnfe = new Vector<String>();
                                Vector dontprintnfe = new Vector();
                                lisnfe.add(estado.getId());
                                manager.checarConsistencia(lisnfe, ClientSession.getInstance().getAmbiente(), ClientSession.getInstance().getUser().getId());
                                MessageDialog.openInformation(null, (String)"Checagem de NF-e", (String)"Opera\u00e7\u00e3o executada com sucesso");
                                if (!dontprintnfe.isEmpty()) {
                                    MessageDialog.openError(null, (String)"Checagem de NF-e", (String)("As seguintes notas n\u00e3o foram reprocessadas:" + dontprintnfe.toString()));
                                }
                                return;
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                MessageDialog.openError(null, (String)"Checagem de NF-e", (String)"Falha na execu\u00e7\u00e3o");
                            }
                        }
                    }
                });
                MenuItem item5 = new MenuItem(this.menu, 8);
                item5.setText("Reenviar E-mail");
                item5.setImage(LoadImages.resizeImage(LoadImages.loadImage("EMAIL.gif")));
                item5.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        if (ClientSession.getInstance().getLogin() != null) {
                            try {
                                ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
                                Vector<EstadoNFe> list = ClientSession.getInstance().getXmlselecteds();
                                String tpAmb = ClientSession.getInstance().getAmbiente();
                                String idUser = ClientSession.getInstance().getUser().getId();
                                for (EstadoNFe estado : list) {
                                    manager.enviarEmailNota(estado.getId(), tpAmb, null);
                                }
                                MessageDialog.openInformation(null, (String)"Reenvio de E-mail", (String)"Opera\u00e7\u00e3o executada com sucesso");
                                return;
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                MessageDialog.openError(null, (String)"Reenvio de E-mail", (String)"Falha na execu\u00e7\u00e3o");
                            }
                        }
                    }
                });
                MenuItem item6 = new MenuItem(this.menu, 8);
                item6.setText("Envio de Email XML/PDF/CCe");
                item6.setImage(LoadImages.resizeImage(LoadImages.loadImage("EMAIL.gif")));
                item6.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        if (ClientSession.getInstance().getLogin() != null) {
                            try {
                                TypeEmailDialog dialog = new TypeEmailDialog(QueryView.this.getSerie().getShell());
                                dialog.setBlockOnOpen(true);
                                dialog.open();
                                if (dialog.isClicoubotao()) {
                                    ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
                                    Hashtable<String, String> params = new Hashtable<String, String>();
                                    params.put("sendemail", dialog.getEmailsss());
                                    params.put("pdf", String.valueOf(dialog.isPdfb()));
                                    params.put("xml", String.valueOf(dialog.isXmlb()));
                                    params.put("cce", String.valueOf(dialog.isCceb()));
                                    Vector<EstadoNFe> list = ClientSession.getInstance().getXmlselecteds();
                                    for (EstadoNFe estado : list) {
                                        try {
                                            manager.enviarEmailNota(estado.getId(), ClientSession.getInstance().getAmbiente(), params);
                                        }
                                        catch (RemoteException e1) {
                                            MessageDialog.openError(null, (String)"Reenvio de E-mail", (String)("Falha na execu\u00e7\u00e3o:" + e1.getLocalizedMessage()));
                                        }
                                    }
                                    MessageDialog.openInformation(null, (String)"Reenvio de E-mail", (String)"Opera\u00e7\u00e3o executada com sucesso");
                                }
                                return;
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                MessageDialog.openError(null, (String)"Reenvio de E-mail", (String)("Falha na execu\u00e7\u00e3o:" + e1.getLocalizedMessage()));
                            }
                        }
                    }
                });
                new MenuItem(this.menu, 2);
                MenuItem item0007 = new MenuItem(this.menu, 8);
                item0007.setText("Baixar XML");
                item0007.setImage(LoadImages.resizeImage(LoadImages.loadImage("icon_xml.gif")));
                item0007.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        EstadoNFe selected = ClientSession.getInstance().getXmlSel();
                        String url = RWT.getServiceManager().getServiceHandlerUrl("download");
                        url = String.valueOf(url) + "&id=" + selected.getId() + "&type=xmldownload";
                        JavaScriptExecutor jsex = (JavaScriptExecutor)RWT.getClient().getService(JavaScriptExecutor.class);
                        if (jsex != null) {
                            jsex.execute("parent.window.location.href=\"" + url + "\";");
                        }
                    }
                });
                item0007 = new MenuItem(this.menu, 8);
                item0007.setText("Baixar PDF");
                item0007.setImage(LoadImages.resizeImage(LoadImages.loadImage("PDF_FILE.GIF")));
                item0007.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        EstadoNFe selected = ClientSession.getInstance().getXmlSel();
                        String url = RWT.getServiceManager().getServiceHandlerUrl("download");
                        url = String.valueOf(url) + "&id=" + selected.getId() + "&type=pdfdownload";
                        JavaScriptExecutor jsex = (JavaScriptExecutor)RWT.getClient().getService(JavaScriptExecutor.class);
                        if (jsex != null) {
                            jsex.execute("parent.window.location.href=\"" + url + "\";");
                        }
                    }
                });
                MenuItem item07 = new MenuItem(this.menu, 8);
                item07.setText("Baixar PS");
                item07.setImage(LoadImages.resizeImage(LoadImages.loadImage("PDF_FILE.GIF")));
                item07.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        EstadoNFe selected = ClientSession.getInstance().getXmlSel();
                        String url = RWT.getServiceManager().getServiceHandlerUrl("download");
                        url = String.valueOf(url) + "&id=" + selected.getId() + "&type=ps";
                        JavaScriptExecutor jsex = (JavaScriptExecutor)RWT.getClient().getService(JavaScriptExecutor.class);
                        if (jsex != null) {
                            jsex.execute("parent.window.location.href=\"" + url + "\";");
                        }
                    }
                });
                this.menu.setLocation(e.x, ((QueryView)QueryView.this).tableviewer.getTable().getLocation().y + e.y + 100);
                this.menu.setVisible(true);
            }
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    }
}

