/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.cockpitrap.views;

import br.com.taragona.nfe.util.data.ServicosConfig;
import br.com.tti.cockpitrap.data.Certificado;
import br.com.tti.cockpitrap.session.ClientSession;
import br.com.tti.cockpitrap.util.ManagerProxy;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class ValidaMyRootView
extends ViewPart {
    public static final String ID = "seu.pacote.CertificadoView";
    private TableViewer viewer;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout(512));
        this.viewer = new TableViewer(parent, 67584);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.createColumns();
        Certificado[] certificados = this.getCertificados();
        this.viewer.setInput((Object)certificados);
    }

    private void createColumns() {
        String[] titles = new String[]{"Alias", "Site", "Emissor", "Data Inicial", "Data Final", "V\u00e1lido"};
        int[] bounds = new int[]{250, 250, 450, 150, 150, 50};
        TableViewerColumn colAlias = this.createTableViewerColumn(titles[0], bounds[0]);
        colAlias.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Certificado certificado = (Certificado)element;
                return certificado.getAlias();
            }
        });
        TableViewerColumn colSite = this.createTableViewerColumn(titles[1], bounds[1]);
        colSite.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Certificado certificado = (Certificado)element;
                return certificado.getSite();
            }
        });
        TableViewerColumn colEmissor = this.createTableViewerColumn(titles[2], bounds[2]);
        colEmissor.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Certificado certificado = (Certificado)element;
                return certificado.getEmissor();
            }
        });
        TableViewerColumn colDataInicial = this.createTableViewerColumn(titles[3], bounds[3]);
        colDataInicial.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Certificado certificado = (Certificado)element;
                return certificado.getDataInicial();
            }
        });
        TableViewerColumn colDataFinal = this.createTableViewerColumn(titles[4], bounds[4]);
        colDataFinal.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Certificado certificado = (Certificado)element;
                return certificado.getDataFinal();
            }
        });
        TableViewerColumn colValido = this.createTableViewerColumn(titles[5], bounds[5]);
        colValido.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Certificado certificado = (Certificado)element;
                return certificado.isValido() ? "Sim" : "N\u00e3o";
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        viewerColumn.getColumn().setText(title);
        viewerColumn.getColumn().setWidth(bound);
        viewerColumn.getColumn().setResizable(true);
        viewerColumn.getColumn().setMoveable(true);
        return viewerColumn;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public Certificado[] getCertificados() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        ArrayList<Certificado> certs = new ArrayList<Certificado>();
        try {
            ManagerProxy manager = ClientSession.getInstance().getManagerproxy();
            ServicosConfig conf = manager.obterServicosConfig();
            String jksFilePath = manager.obterTrustStore();
            char[] jksPassword = "crhisn".toCharArray();
            FileInputStream fis = new FileInputStream(jksFilePath);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(fis, jksPassword);
            Enumeration<String> aliases = keyStore.aliases();
            Date currentDate = new Date();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate certificate = keyStore.getCertificate(alias);
                if (!(certificate instanceof X509Certificate)) continue;
                X509Certificate x509Certificate = (X509Certificate)certificate;
                boolean check = false;
                try {
                    x509Certificate.checkValidity(currentDate);
                    check = true;
                }
                catch (Exception e) {
                    check = false;
                }
                String subjectDN = x509Certificate.getSubjectDN().toString();
                String issuerDN = x509Certificate.getIssuerDN().toString();
                String siteName = ValidaMyRootView.extractSiteName(subjectDN);
                Certificado cert = new Certificado(alias, siteName, issuerDN, sdf.format(x509Certificate.getNotBefore()), sdf.format(x509Certificate.getNotAfter()), check);
                certs.add(cert);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Certificado[] certificados = new Certificado[certs.size()];
        int i = 0;
        while (i < certs.size()) {
            certificados[i] = (Certificado)certs.get(i);
            ++i;
        }
        return certificados;
    }

    private static String extractSiteName(String subjectDN) throws CertificateParsingException {
        int cnIndex = subjectDN.indexOf("CN=");
        if (cnIndex != -1) {
            int endIndex = subjectDN.indexOf(",", cnIndex);
            if (endIndex == -1) {
                endIndex = subjectDN.length();
            }
            return subjectDN.substring(cnIndex + 3, endIndex);
        }
        return "Nome do site nao encontrado";
    }
}

