/*
 * Decompiled with CFR 0.152.
 */
package assinador.pkcs11;

import assinador.Main;
import br.com.taragona.nfe.danfe.ImprimirDANFEImpl;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.security.pkcs11.SunPKCS11;

public class AssinadorPKCS11
extends Main {
    public static Hashtable<String, Provider> providers = new Hashtable();

    public AssinadorPKCS11(String configname, String senha) {
        Provider p = providers.get(configname);
        if (p == null) {
            p = new SunPKCS11(configname);
            Security.addProvider(p);
            providers.put(configname, p);
        }
        char[] pin = senha.toCharArray();
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("pkcs11");
        }
        catch (KeyStoreException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, "Nao conseguiu criar keystore com pkcs11", ex);
        }
        try {
            ks.load(null, pin);
        }
        catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, "certificado ou senha invalidos", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, "algoritmo do certificado invalido", ex);
        }
        catch (CertificateException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, "certificado ou senha invalidos", ex);
        }
        Enumeration<String> aliases = null;
        try {
            aliases = ks.aliases();
        }
        catch (KeyStoreException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, "nenhuma entrada no keystore", ex);
        }
        Object alias = null;
        KeyStore.PrivateKeyEntry entry = null;
        try {
            while (aliases.hasMoreElements()) {
                String alias1 = aliases.nextElement();
                if (!ks.isKeyEntry(alias1)) continue;
                entry = (KeyStore.PrivateKeyEntry)ks.getEntry(alias1, new KeyStore.PasswordProtection(senha.toCharArray()));
                this.privateKey = entry.getPrivateKey();
                this.certificate = entry.getCertificate();
                break;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnrecoverableEntryException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (KeyStoreException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        AssinadorPKCS11 ass = new AssinadorPKCS11("E:\\hsm.cfg", "SNICOSP");
        String xml = ImprimirDANFEImpl.lerArquivo("C:\\35081017256512000116550220000000091987526811-nfe.xml");
        try {
            String assinado = ass.assina(xml, "infNFe");
            System.out.println(assinado);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }
}

