/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.assinador;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Assinador {
    private XMLSignatureFactory sig;
    private Reference ref;
    private KeyStore ks;
    private X509Certificate cert;
    private KeyStore.PrivateKeyEntry keyEntry;
    private String arquivo;

    Assinador(String arquivoCertificado) {
        try {
            this.arquivo = arquivoCertificado;
            this.sig = XMLSignatureFactory.getInstance();
            this.ref = this.sig.newReference("", this.sig.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null));
            this.ks = KeyStore.getInstance("JKS");
            this.ks.load(new FileInputStream(arquivoCertificado), "changeit".toCharArray());
            this.keyEntry = (KeyStore.PrivateKeyEntry)this.ks.getEntry("mykey", new KeyStore.PasswordProtection("changeit".toCharArray()));
            this.cert = (X509Certificate)this.keyEntry.getCertificate();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (UnrecoverableEntryException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SignedInfo getSigned() {
        SignedInfo si = null;
        try {
            si = this.sig.newSignedInfo(this.sig.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), this.sig.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(this.ref));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        return si;
    }

    public KeyInfo getKeyInfo() throws Exception {
        KeyInfoFactory kif = this.sig.getKeyInfoFactory();
        ArrayList<Object> x509Content = new ArrayList<Object>();
        x509Content.add(this.cert.getSubjectX500Principal().getName());
        x509Content.add(this.cert);
        X509Data xd = kif.newX509Data(x509Content);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
        return ki;
    }

    public XMLSignature getXMLSignature() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().parse(new FileInputStream("purchaseOrder.xml"));
        DOMSignContext dsc = new DOMSignContext(this.keyEntry.getPrivateKey(), (Node)doc.getDocumentElement());
        XMLSignature signature = this.sig.newXMLSignature(this.getSigned(), this.getKeyInfo());
        return signature;
    }
}

