/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.cancinut;

import br.com.taragona.nfe.classes.inutilizacao.TInutNFe;
import br.com.taragona.nfe.classes.inutilizacao.TRetInutNFe;
import br.com.taragona.nfe.mensageiro.caches.CacheNotas;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.CodigoNFeManager;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.logger.LoggingJava;
import br.com.taragona.nfe.util.xml.XMLFactory;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import java.rmi.RemoteException;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.bind.JAXBElement;

public class InutilizacaoThreadOriginalV310
implements Runnable {
    private XMLGenerator xmlsInut = XMLFactory.getXmlsInut();
    private String CNPJ;
    private CacheNotas cacheNotas = CacheNotas.obterInstancia();
    private String idNota;
    private String UF;
    private String ano;
    private String cnpj;
    private String mod;
    private String serie;
    private String ini;
    private String fim;
    private String just;
    boolean contingencia;
    private boolean once;
    private Exception e;
    private GerenciadorChavesNota chave;
    private String codigoResult = "";
    private String tpAmb;
    private String idUsuario;

    public InutilizacaoThreadOriginalV310(String idNota, String just, boolean contingencia, String tpAmb, String idUsuario) {
        this.idNota = idNota;
        this.chave = new GerenciadorChavesNota(idNota);
        this.CNPJ = this.chave.getCnpj();
        this.just = just;
        this.once = true;
        this.contingencia = contingencia;
        this.tpAmb = tpAmb;
        this.idUsuario = idUsuario;
    }

    public InutilizacaoThreadOriginalV310(String uf, String ano, String cnpj, String mod, String serie, String ini, String fim, String just, boolean contingencia, String tpAmb, String idUsuario) {
        this.UF = uf;
        this.ano = ano;
        this.cnpj = cnpj;
        this.mod = mod;
        this.serie = serie;
        this.ini = ini;
        this.fim = fim;
        this.just = just;
        this.once = false;
        this.contingencia = contingencia;
        this.tpAmb = tpAmb;
        this.idUsuario = idUsuario;
    }

    private boolean processarRespostaInut(String idNota, String resultado) {
        int codigo;
        JAXBElement inut;
        block9: {
            try {
                String chaveNota = idNota.replace("NFe", "");
                if (this.contingencia) {
                    GerenciadorProxy.getGerenciador().notificarProtocoloInutilizcaoContingecia(chaveNota, this.tpAmb, resultado);
                } else {
                    GerenciadorProxy.getGerenciador().notificarProtocoloInutilizcaoNormal(chaveNota, this.tpAmb, resultado);
                }
            }
            catch (Exception e1) {
                System.out.println("Nao foi possivel notificar ao ERP");
            }
            inut = (JAXBElement)this.xmlsInut.toObject(resultado);
            codigo = Integer.parseInt(((TRetInutNFe)inut.getValue()).getInfInut().getCStat());
            CodigoNFeManager.insereCodigo(codigo, ((TRetInutNFe)inut.getValue()).getInfInut().getXMotivo());
            LoggingJava.logger.log(Level.WARNING, " Ajustando nota inutilizacao: " + idNota + " codigo: " + codigo);
            if (codigo != PropriedadesSistema.NOTA_INUTILIZADA.getId() && codigo != 563) break block9;
            this.cacheNotas.ajustarEstado(idNota, this.tpAmb, EstadoNFe.ESTADO_NFE.INUTILIZADA, true, this.idUsuario);
            this.cacheNotas.ajustarEstadoNota(idNota, this.tpAmb, new Long(PropriedadesSistema.NOTA_INUTILIZADA.getId()), this.idUsuario);
            EstadoNFe estado = this.cacheNotas.obterEstadoNota(idNota, this.tpAmb);
            estado.setProtocolo(String.valueOf(((TRetInutNFe)inut.getValue()).getInfInut().getNProt()) + "|" + ((TRetInutNFe)inut.getValue()).getInfInut().getDhRecbto().toString());
            this.cacheNotas.salvarNota(estado);
            return true;
        }
        try {
            if (codigo != PropriedadesSistema.NOTA_INUTILIZADA.getId()) {
                EstadoNFe estado = this.cacheNotas.obterEstadoNota(idNota, this.tpAmb);
                estado.setEstado(EstadoNFe.ESTADO_NFE.ERRO_INUTILIZACAO);
                estado.setEstadoNFe(new Long(codigo));
                if (((TRetInutNFe)inut.getValue()).getInfInut().getXMotivo() != null) {
                    estado.setProtocolo(((TRetInutNFe)inut.getValue()).getInfInut().getXMotivo());
                }
                GerenciadorProxy.notificarNota(estado);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean processarRespostaInutVarias(Vector<EstadoNFe> notas, String resultado) {
        String cont;
        Integer codigo;
        JAXBElement inut;
        block5: {
            inut = (JAXBElement)this.xmlsInut.toObject(resultado);
            codigo = Integer.parseInt(((TRetInutNFe)inut.getValue()).getInfInut().getCStat());
            this.codigoResult = ((TRetInutNFe)inut.getValue()).getInfInut().getXMotivo();
            cont = " normal";
            if (this.contingencia) {
                cont = " contingencia";
            }
            if (!codigo.equals(PropriedadesSistema.NOTA_INUTILIZADA.getId())) break block5;
            GerenciadorProxy.getGerenciador().atualizarInut(this.serie, this.cnpj, this.ini, "" + codigo, "Inutilizacao de numero homologado", cont);
            for (EstadoNFe nota : notas) {
                this.cacheNotas.ajustarEstado(nota.getId(), this.tpAmb, EstadoNFe.ESTADO_NFE.INUTILIZADA, true, this.idUsuario);
                this.cacheNotas.ajustarEstadoNota(nota.getId(), nota.getAmbiente(), new Long(PropriedadesSistema.NOTA_INUTILIZADA.getId()), this.idUsuario);
                GerenciadorProxy.notificarNota(nota);
            }
            return true;
        }
        try {
            GerenciadorProxy.getGerenciador().atualizarInut(this.serie, this.cnpj, this.ini, "" + codigo, ((TRetInutNFe)inut.getValue()).getInfInut().getXMotivo(), cont);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean inutilizarNota(String tpAmb, String UF, String ano, String cnpj, String mod, String serie, String ini, String fim, String just) throws RemoteException {
        String cabecalho = XMLFactory.montarCabecalho(TInutNFe.class, this.cnpj);
        String inutString = XMLFactory.montarInutilizacao(UF, ano, cnpj, mod, serie, ini, fim, just, tpAmb);
        String resultado = null;
        try {
            inutString = GerenciadorProxy.getGerenciador().assinar(this.cnpj, inutString, "infInut");
            System.out.println(inutString);
            resultado = GerenciadorProxy.enviarMensagemXML(PropriedadesSistema.ID_SERVICO_INUTILIZACAO, this.cnpj, cabecalho, inutString, this.UF, this.idUsuario);
            System.out.println("Resultado inut:" + resultado);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Vector<EstadoNFe> notas = this.cacheNotas.filtrarNotas(tpAmb, UF, ano, cnpj, mod, serie, ini, fim);
        return this.processarRespostaInutVarias(notas, resultado);
    }

    public boolean inutilizarNota(String idNota) {
        LoggingJava.logger.log(Level.WARNING, "inutilizar nota: " + idNota);
        String cabecalho = XMLFactory.montarCabecalho(TInutNFe.class, this.CNPJ);
        String inutString = XMLFactory.montarInutilizacaoNota(idNota, this.tpAmb, this.CNPJ, this.just);
        String resultado = null;
        try {
            System.out.println("Inutilizando nota: " + inutString);
            LoggingJava.logger.log(Level.WARNING, "Nota ID: " + idNota + " xml: " + inutString);
            inutString = GerenciadorProxy.getGerenciador().assinar(this.CNPJ, inutString, "infInut");
            resultado = GerenciadorProxy.enviarMensagemXML(PropriedadesSistema.ID_SERVICO_INUTILIZACAO, this.CNPJ, cabecalho, inutString, this.chave.getUF(), this.idUsuario);
            System.out.println("result inut" + resultado);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (resultado != null) {
            return this.processarRespostaInut(idNota, resultado);
        }
        return false;
    }

    public Exception getE() {
        return this.e;
    }

    @Override
    public void run() {
        boolean result = false;
        int counter = 0;
        while (!result) {
            if (++counter >= 3) {
                return;
            }
            try {
                result = this.once ? this.inutilizarNota(this.idNota) : this.inutilizarNota(this.tpAmb, this.UF, this.ano, this.cnpj, this.mod, this.serie, this.ini, this.fim, this.just);
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.e = e;
            }
        }
    }

    public String getCodigoResult() {
        return this.codigoResult;
    }

    public static void main(String[] args) {
    }
}

