/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.cancinut;

import br.com.taragona.nfe.danfe.CancelEmailThread;
import br.com.taragona.nfe.email.MailSender;
import br.com.taragona.nfe.tools.PathFileFinder;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.ResourceBundle;

public class SenderCancel {
    private static SenderCancel INSTANCE = null;
    private MailSender sender = new MailSender();
    private ResourceBundle bundle = ResourceBundle.getBundle("pastas_cnpj");

    public static SenderCancel getInstace() {
        if (INSTANCE == null) {
            INSTANCE = new SenderCancel();
        }
        return INSTANCE;
    }

    private SenderCancel() {
    }

    private String getNameFile(String id, String tpAmb) {
        String path = PathFileFinder.getINSTANCE().findXMLCancelPath(id, tpAmb, Calendar.getInstance().getTime());
        String filename = String.valueOf(id) + "_canc_prot.xml";
        return String.valueOf(path) + "/" + filename;
    }

    private String writeProtocol(String id, String tpAmb, String xml) {
        String filename = this.getNameFile(id, tpAmb);
        try {
            FileWriter fw = new FileWriter(filename);
            fw.write(xml);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filename;
    }

    public void sendCancel(String id, String tpAmb, String cnpj, String xml) {
        System.out.println("Enviando email cancelamento:" + id);
        String file = "";
        try {
            file = this.writeProtocol(id, tpAmb, xml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CancelEmailThread c = new CancelEmailThread(this.sender, cnpj, new String[]{file}, tpAmb);
        Thread t = new Thread(c);
        t.start();
    }
}

