/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.cockpitserver;

import br.com.taragona.nfe.cockpitserver.CockpitServer;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.Empresa;
import br.com.taragona.nfe.persistence.EntidadeCnpj;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.LogEnvioEmail;
import br.com.taragona.nfe.persistence.Notificacao;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.tti.util.DataUtil;
import java.io.IOException;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.persistence.Query;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CockpitPartch
extends CockpitServer {
    private Vector<EstadoNFe> obterNotasSQL(String tpAmb, int serie, int n1, int n2, Date d1, Date d2, Vector<String> cnpjs) {
        DAOGenerico dao = new DAOGenerico(EstadoNFe.class);
        DAOGenerico daoEmp = new DAOGenerico(Empresa.class);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String sql = "select e\n";
        sql = String.valueOf(sql) + "  from EstadoNFe e\n";
        sql = String.valueOf(sql) + " where e.dataGerada >= :d1\n";
        sql = String.valueOf(sql) + "   and e.ambiente = :tpAmb\n";
        if (d2 != null) {
            sql = String.valueOf(sql) + "   and e.dataGerada <= :d2\n";
        } else if (d1 == null) {
            try {
                d1 = sf.parse("2009-01-01");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (serie != -1) {
            sql = String.valueOf(sql) + "   and SUBSTRING(e.id, 26, 3) = '" + String.format("%03d", serie) + "'\n";
        }
        if (n1 != -1) {
            // empty if block
        }
        if (cnpjs.size() > 0) {
            sql = String.valueOf(sql) + "   and e.cnpj in ('" + cnpjs.get(0) + "'";
            int i = 1;
            while (i < cnpjs.size()) {
                sql = String.valueOf(sql) + ", '" + cnpjs.get(i) + "'";
                ++i;
            }
            sql = String.valueOf(sql) + ")\n";
        }
        if (PropriedadesMain.getServerName() != null) {
            sql = String.valueOf(sql) + "   and (e.serverName = '" + PropriedadesMain.getServerName() + "' OR e.serverName IS NULL)\n";
        }
        sql = String.valueOf(sql) + "order by e.dataGerada DESC\n";
        d1 = DataUtil.truncate(d1);
        if (d2 != null) {
            d2 = DataUtil.truncate(d2);
        }
        Query q = null;
        try {
            q = dao.criarQuery(sql);
            q.setParameter("d1", (Object)d1);
            if (d2 != null) {
                q.setParameter("d2", (Object)d2);
            }
            q.setParameter("tpAmb", (Object)tpAmb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List o = q.getResultList();
        System.out.println("Result set size:" + o.size());
        Vector<EstadoNFe> nfes = new Vector<EstadoNFe>();
        for (EstadoNFe e : o) {
            GerenciadorChavesNota chave;
            int nn;
            if (n1 != -1 && n2 != -1 && (n1 > (nn = Integer.parseInt((chave = new GerenciadorChavesNota(e.getId())).getNumeroNota())) || nn > n2)) continue;
            String xml = e.getXmlString();
            if (e.getCnpjDestino() != null && !e.getCnpjDestino().equals("")) {
                EntidadeCnpj eCnpj = new EntidadeCnpj(e.getCnpjDestino(), tpAmb);
                Empresa empdest = (Empresa)daoEmp.buscarPorIdObject(eCnpj);
                if (empdest != null) {
                    if (e.getCnpjDestino().length() == 11) {
                        e.setCnpjDestino("CPF: " + empdest.getCnpj() + ": " + empdest.getNome());
                    } else {
                        e.setCnpjDestino("CNPJ: " + empdest.getCnpj() + ": " + empdest.getNome());
                    }
                } else {
                    e.setCnpjDestino("");
                }
            } else if (xml != null && !CockpitPartch.getValueByTag(xml, "NFe.infNFe.dest.idEstrangeiro").equals("")) {
                String idEstrangeiro = CockpitPartch.getValueByTag(xml, "NFe.infNFe.dest.idEstrangeiro");
                String nome = CockpitPartch.getValueByTag(xml, "NFe.infNFe.dest.xNome");
                e.setCnpjDestino("ID EST: " + idEstrangeiro + ": " + (nome != null ? nome : ""));
            }
            String query = "select l\n";
            query = String.valueOf(query) + "  from LogEnvioEmail l\n";
            query = String.valueOf(query) + " where l.keyxml = '" + e.getId() + "'\n";
            query = String.valueOf(query) + "   and l.tipo = ?1\n";
            query = String.valueOf(query) + "   and l.ambiente = ?2\n";
            query = String.valueOf(query) + "order by l.id desc\n";
            q = dao.criarQuery(query);
            q.setParameter(1, (Object)LogEnvioEmail.TIPO_EMAIL.DESTINATARIO);
            q.setParameter(2, (Object)tpAmb);
            List listDest = q.getResultList();
            for (LogEnvioEmail logEnvioEmail : listDest) {
                if (logEnvioEmail.getEstado().equals((Object)LogEnvioEmail.ESTADO_EMAIL.ENVIADO)) {
                    e.setEmailDest("S");
                    break;
                }
                if (logEnvioEmail.getEstado().equals((Object)LogEnvioEmail.ESTADO_EMAIL.NAO_CADASTRADO)) {
                    e.setEmailDest("");
                    break;
                }
                if (!logEnvioEmail.getEstado().equals((Object)LogEnvioEmail.ESTADO_EMAIL.NAO_ENVIADO)) continue;
                e.setEmailDest("N");
                break;
            }
            query = "select l\n";
            query = String.valueOf(query) + "  from LogEnvioEmail l\n";
            query = String.valueOf(query) + " where l.keyxml = '" + e.getId() + "'\n";
            query = String.valueOf(query) + "   and l.tipo = ?1\n";
            query = String.valueOf(query) + "   and l.ambiente = ?2\n";
            query = String.valueOf(query) + "order by l.id desc\n";
            q = dao.criarQuery(query);
            q.setParameter(1, (Object)LogEnvioEmail.TIPO_EMAIL.TRANSPORTADORA);
            q.setParameter(2, (Object)tpAmb);
            List listTrans = q.getResultList();
            for (LogEnvioEmail logEnvioEmail : listTrans) {
                if (logEnvioEmail.getEstado().equals((Object)LogEnvioEmail.ESTADO_EMAIL.ENVIADO)) {
                    e.setEmailTrans("S");
                    break;
                }
                if (logEnvioEmail.getEstado().equals((Object)LogEnvioEmail.ESTADO_EMAIL.NAO_CADASTRADO)) {
                    e.setEmailTrans("");
                    break;
                }
                if (!logEnvioEmail.getEstado().equals((Object)LogEnvioEmail.ESTADO_EMAIL.NAO_ENVIADO)) continue;
                e.setEmailTrans("N");
                break;
            }
            nfes.add(e);
        }
        o.clear();
        o = null;
        daoEmp.clear();
        daoEmp.close();
        daoEmp = null;
        dao.clear();
        dao.close();
        dao = null;
        System.gc();
        return nfes;
    }

    private PropriedadesSistema.MODO_OP getModo(int modoint) {
        switch (modoint) {
            case 0: {
                return PropriedadesSistema.MODO_OP.CONTINGENCIA;
            }
            case 1: {
                return PropriedadesSistema.MODO_OP.NORMAL;
            }
            case 2: {
                return PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN;
            }
            case 3: {
                return PropriedadesSistema.MODO_OP.LASER;
            }
            case 4: {
                return PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC;
            }
            case 5: {
                return PropriedadesSistema.MODO_OP.SVC_AN;
            }
            case 6: {
                return PropriedadesSistema.MODO_OP.SVC_RS;
            }
            case 7: {
                return PropriedadesSistema.MODO_OP.SVC_RS;
            }
            case 8: {
                return PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC;
            }
        }
        return null;
    }

    private EstadoNFe.ESTADO_NFE getEstado(int n) {
        switch (n) {
            case 0: {
                return EstadoNFe.ESTADO_NFE.USO_DENEGADO;
            }
            case 1: {
                return EstadoNFe.ESTADO_NFE.REJEITADA;
            }
            case 2: {
                return EstadoNFe.ESTADO_NFE.AUTORIZADA;
            }
            case 3: {
                return EstadoNFe.ESTADO_NFE.GERADA;
            }
            case 4: {
                return EstadoNFe.ESTADO_NFE.ASSINADA;
            }
            case 5: {
                return EstadoNFe.ESTADO_NFE.ENVIADA;
            }
            case 6: {
                return EstadoNFe.ESTADO_NFE.ERRO_VALIDACAO;
            }
            case 7: {
                return EstadoNFe.ESTADO_NFE.IMPRESSA_NORMAL;
            }
            case 8: {
                return EstadoNFe.ESTADO_NFE.IMPRESSA_CONT;
            }
            case 9: {
                return EstadoNFe.ESTADO_NFE.CANCELADA;
            }
            case 10: {
                return EstadoNFe.ESTADO_NFE.INUTILIZADA;
            }
            case 11: {
                return EstadoNFe.ESTADO_NFE.TENTANDO_ENVIO;
            }
            case 12: {
                return EstadoNFe.ESTADO_NFE.ERRO_ENVIO;
            }
            case 13: {
                return EstadoNFe.ESTADO_NFE.RESULTADO_SEFAZ;
            }
            case 14: {
                return EstadoNFe.ESTADO_NFE.ERRO;
            }
            case 15: {
                return EstadoNFe.ESTADO_NFE.PEDIDO_CANCELAMENTO;
            }
            case 16: {
                return EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA;
            }
            case 17: {
                return EstadoNFe.ESTADO_NFE.TEMPO_PROCESSAMENTO_LIMITE;
            }
            case 18: {
                return EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA_LOTE;
            }
            case 19: {
                return EstadoNFe.ESTADO_NFE.ERRO_CANCELAMENTO;
            }
            case 20: {
                return EstadoNFe.ESTADO_NFE.ERRO_INUTILIZACAO;
            }
            case 21: {
                return EstadoNFe.ESTADO_NFE.ERRO_IMPRESSAO;
            }
            case 22: {
                return EstadoNFe.ESTADO_NFE.IMPRESSA_LASER;
            }
            case 23: {
                return EstadoNFe.ESTADO_NFE.CANCELADA_CONTINGENCIA;
            }
            case 24: {
                return EstadoNFe.ESTADO_NFE.ERRO_XML_SEFAZ;
            }
            case 25: {
                return EstadoNFe.ESTADO_NFE.CANCELAR_SAIDA_CONTINGENCIA;
            }
            case 26: {
                return EstadoNFe.ESTADO_NFE.DPEC_ENVIADO;
            }
            case 27: {
                return EstadoNFe.ESTADO_NFE.PROBLEMAS_DPEC_ENVIADO;
            }
            case 28: {
                return EstadoNFe.ESTADO_NFE.EPEC_AUTORIZADO;
            }
            case 29: {
                return EstadoNFe.ESTADO_NFE.EPEC_REJEITADO;
            }
        }
        return null;
    }

    private int convertToInt(String ss) {
        if (ss == null || ss.isEmpty()) {
            return -1;
        }
        try {
            return Integer.parseInt(ss);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public Vector<EstadoNFe> obterNotas(String tpAmb, Vector<String> cnpjs, String serie, String n1, String n2, Date d1, Date d2) throws RemoteException {
        int iserie = this.convertToInt(serie);
        int in1 = this.convertToInt(n1);
        int in2 = this.convertToInt(n2);
        Vector<EstadoNFe> notasData = this.obterNotasSQL(tpAmb, iserie, in1, in2, d1, d2, cnpjs);
        return notasData;
    }

    private Vector<EstadoNFe> obterSerie(List<EstadoNFe> notas, String serie) {
        Vector<EstadoNFe> novas = new Vector<EstadoNFe>();
        for (EstadoNFe nota : notas) {
            GerenciadorChavesNota chave = new GerenciadorChavesNota(nota.getId());
            if (!chave.getSerie().trim().equals(serie.trim())) continue;
            novas.add(nota);
        }
        return novas;
    }

    private Vector<EstadoNFe> obterNumerosNotas(List<EstadoNFe> notas, String n1, String n2) {
        Long l1 = Long.parseLong(n1);
        Long l2 = Long.parseLong(n2);
        Vector<EstadoNFe> novas = new Vector<EstadoNFe>();
        for (EstadoNFe nota : notas) {
            GerenciadorChavesNota chave = new GerenciadorChavesNota(nota.getId());
            Long l = Long.parseLong(chave.getNumeroNota());
            if (l1 > l || l > l2) continue;
            novas.add(nota);
        }
        return novas;
    }

    public List<Notificacao> obterNotificacoes(Date d1, Date d2) {
        DAOGenerico daoNot = new DAOGenerico(Notificacao.class);
        String sql = "select n from Notificacao as n where :d1 <= n.data and n.data <= :d2";
        Query q = daoNot.criarQuery(sql);
        if (d1 == null) {
            d1 = Calendar.getInstance().getTime();
        }
        if (d2 == null) {
            d2 = Calendar.getInstance().getTime();
        }
        q.setParameter("d1", (Object)d1);
        q.setParameter("d2", (Object)d2);
        List rs = q.getResultList();
        daoNot.clear();
        daoNot.close();
        daoNot = null;
        return rs;
    }

    public void salvarNot(Notificacao not) {
        DAOGenerico<Notificacao> daoNot = new DAOGenerico<Notificacao>(Notificacao.class);
        try {
            daoNot.salvar(not);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        daoNot.clear();
        daoNot.close();
        daoNot = null;
    }

    public static void main(String[] args) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        System.out.println(sf.format(new Date()).toUpperCase());
    }

    public static String getValueByTag(String xml, String tag) {
        String value = "";
        String path = null;
        if (tag == null || tag.equals("")) {
            return value;
        }
        if (tag.indexOf(46) > -1) {
            path = tag;
            String[] fields = tag.split("\\.");
            tag = fields[fields.length - 1];
        }
        if (xml == null || xml.equals("")) {
            return value;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document d = builder.parse(new InputSource(new StringReader(xml)));
            d.getDocumentElement().normalize();
            NodeList elements = d.getElementsByTagName(tag);
            int i = 0;
            while (i < elements.getLength()) {
                block18: {
                    try {
                        if (path == null) {
                            value = elements.item(i).getChildNodes().item(0).getNodeValue();
                            break;
                        }
                        Node node = elements.item(i).getChildNodes().item(0);
                        Node pai = node.getParentNode();
                        String pathString = "";
                        while (pai != null) {
                            if (pai.getNodeType() == 1) {
                                pathString = pathString.equals("") ? pai.getNodeName() : String.valueOf(pai.getNodeName()) + "." + pathString;
                            }
                            pai = pai.getParentNode();
                        }
                        if (node.getNodeType() == 1 && node.getNodeName() != null) {
                            if (!pathString.equals("")) {
                                pathString = String.valueOf(pathString) + ".";
                            }
                            pathString = String.valueOf(pathString) + node.getNodeName();
                        }
                        if (!pathString.toLowerCase().equals(path.toLowerCase())) break block18;
                        value = elements.item(i).getChildNodes().item(0).getNodeValue();
                        break;
                    }
                    catch (DOMException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            value = null;
            e.printStackTrace();
        }
        catch (SAXException e) {
            value = null;
            e.printStackTrace();
        }
        catch (IOException e) {
            value = null;
            e.printStackTrace();
        }
        if (value == null) {
            value = "";
        }
        return value;
    }
}

