/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.cockpitserver;

import br.com.taragona.nfe.danfe.ImprimirDANFEImpl;
import br.com.taragona.nfe.mensageiro.caches.CacheNotas;
import br.com.taragona.nfe.nfecockpitdesktop.data.Perfil;
import br.com.taragona.nfe.nfecockpitdesktop.data.Usuario;
import br.com.taragona.nfe.persistence.CodigoNFe;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EntidadeId;
import br.com.taragona.nfe.persistence.EstadoLote;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.EstadoRecibo;
import br.com.taragona.nfe.persistence.LogEnvioEmail;
import br.com.taragona.nfe.persistence.LogNFe;
import br.com.taragona.nfe.tools.PathFileFinder;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.persistence.Query;

public class CockpitServer {
    private DAOGenerico<Usuario> daoUsuario;
    private DAOGenerico<Perfil> daoPerfil;
    private DAOGenerico<LogNFe> daoLog;
    private DAOGenerico<LogEnvioEmail> daoEmail;
    private DAOGenerico<EstadoNFe> daoNotas;
    private DAOGenerico<EstadoLote> daoLotes;
    private DAOGenerico<CodigoNFe> daoCodigo;
    private DAOGenerico<EstadoRecibo> daoRecibo;
    private ImprimirDANFEImpl imp;
    private SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
    private SimpleDateFormat dffano = new SimpleDateFormat("yyyy");
    private SimpleDateFormat dffmes = new SimpleDateFormat("MMM_yyyy");
    private SimpleDateFormat dffdia = new SimpleDateFormat("dd_MMM");
    private ResourceBundle rb = ResourceBundle.getBundle("pastas_cnpj");

    public CockpitServer() {
        this.daoUsuario = new DAOGenerico(Usuario.class);
        this.daoPerfil = new DAOGenerico(Perfil.class);
        this.daoLog = new DAOGenerico(LogNFe.class);
        this.daoNotas = new DAOGenerico(EstadoNFe.class);
        this.daoLotes = new DAOGenerico(EstadoLote.class);
        this.daoCodigo = new DAOGenerico(CodigoNFe.class);
        this.daoRecibo = new DAOGenerico(EstadoRecibo.class);
        this.daoEmail = new DAOGenerico(LogEnvioEmail.class);
        this.imp = new ImprimirDANFEImpl();
    }

    public EstadoNFe getEstadoNFe(String id, String tpAmb) {
        if (!id.startsWith("NFe")) {
            id = "NFe" + id;
        }
        System.out.println("Finded:" + id);
        System.out.println("Ambiente:" + (tpAmb.equals("1") ? "producao" : "homologacao"));
        EstadoNFe estado = null;
        try {
            EntidadeId eid = new EntidadeId(id, tpAmb);
            estado = this.daoNotas.buscarPorIdObject(eid);
            this.daoNotas.refresh(estado);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return estado;
    }

    public String criptografarSenha(String senha) {
        byte[] bytess = senha.getBytes();
        long soma = 0L;
        byte[] byArray = bytess;
        int n = bytess.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            soma += (long)b;
            ++n2;
        }
        return String.valueOf(soma);
    }

    public void trocarSenha(String login, String senha) {
        Usuario u = this.daoUsuario.buscarPorIdString(login);
        u.setSenha(this.criptografarSenha(senha));
        this.daoUsuario.unir(u);
    }

    public void registrarUsuario(Usuario usuario, Perfil perfil) throws RemoteException {
        Usuario u = this.daoUsuario.buscarPorIdString(usuario.getId().toLowerCase());
        this.daoPerfil.salvar(perfil);
        if (u == null) {
            usuario.setPerfil(perfil);
            usuario.setSenha(this.criptografarSenha(usuario.getSenha()));
            this.daoUsuario.salvar(usuario);
        } else {
            usuario.setSenha(u.getSenha());
            this.daoUsuario.unir(usuario);
        }
    }

    public void removerUsuario(Usuario usuario) {
        Usuario u = this.daoUsuario.buscarPorIdString(usuario.getId());
        if (u != null) {
            this.daoUsuario.removerEntity(u);
        }
    }

    public Usuario cloneU(Usuario u) {
        Usuario novo = new Usuario();
        novo.setEndereco(u.getEndereco());
        novo.setId(u.getId());
        novo.setNome(u.getNome());
        novo.setPerfil(u.getPerfil());
        novo.setSenha(u.getSenha());
        return novo;
    }

    private Usuario ccc(Usuario u, String senha) {
        String cript2;
        Usuario novo = this.cloneU(u);
        String cript1 = u.getSenha();
        if (cript1.equals(cript2 = this.criptografarSenha(senha))) {
            novo.setSenha(senha);
        } else {
            novo.setSenha(cript2);
        }
        return novo;
    }

    public List<Usuario> findUser(String login, String nome) throws RemoteException {
        String query = "SELECT u\n";
        query = String.valueOf(query) + " from Usuario as u\n";
        query = String.valueOf(query) + " WHERE u.id like '%" + login + "%'\n";
        query = String.valueOf(query) + "   AND u.nome like '%" + nome + "%'\n";
        System.out.println(query);
        ArrayList<Usuario> aa = new ArrayList<Usuario>();
        List users = this.daoUsuario.criarQuery(query).getResultList();
        for (Object object : users) {
            if (!(object instanceof Usuario)) continue;
            Usuario new_name = (Usuario)object;
            System.out.println("user: " + new_name.getId());
            aa.add(this.ccc(new_name, "nulo"));
        }
        return aa;
    }

    public Usuario obterUsuario(String login, String senha) throws RemoteException {
        String cript2;
        Usuario u = this.daoUsuario.buscarPorIdString(login);
        if (u == null) {
            return null;
        }
        Usuario novo = this.cloneU(u);
        String cript1 = u.getSenha();
        if (cript1.equals(cript2 = this.criptografarSenha(senha))) {
            novo.setSenha(senha);
        } else {
            novo.setSenha(cript2);
        }
        return novo;
    }

    public boolean login(String login, String senha) throws RemoteException {
        Usuario u = this.daoUsuario.buscarPorIdString(login);
        if (u == null) {
            throw new RemoteException("Usuario nao registrado");
        }
        if (!u.getSenha().equals(senha)) {
            throw new RemoteException("Senha invalida");
        }
        return true;
    }

    public CodigoNFe obterCodigo(int id) {
        return this.daoCodigo.buscarPorIdInt(id);
    }

    public List<LogNFe> obterHistorico(String idNota, String tpAmb) throws RemoteException {
        String query = "select l\n";
        query = String.valueOf(query) + "  from LogNFe as l\n";
        query = String.valueOf(query) + " where l.idNota = '" + idNota + "'\n";
        query = String.valueOf(query) + "   and l.ambiente = '" + tpAmb + "'\n";
        List<LogNFe> lista = this.daoLog.fazerConsulta(query);
        return lista;
    }

    public List<LogEnvioEmail> logEmail(String idNota, String tpAmb) throws RemoteException {
        String query = "select l\n";
        query = String.valueOf(query) + "  from LogEnvioEmail l\n";
        query = String.valueOf(query) + " where l.keyxml = '" + idNota + "'\n";
        query = String.valueOf(query) + "   and l.ambiente = '" + tpAmb + "'\n";
        query = String.valueOf(query) + "order by l.id desc\n";
        List<LogEnvioEmail> lista = this.daoEmail.fazerConsulta(query);
        return lista;
    }

    public Vector<EstadoLote> obterLotes(String tpAmb, Date d1) throws RemoteException {
        String query = "SELECT e\n";
        query = String.valueOf(query) + "  FROM EstadoLote e\n";
        query = String.valueOf(query) + " WHERE e.data >= :dataD1\n";
        query = String.valueOf(query) + "   AND e.ambiente = :tpAmb\n";
        query = String.valueOf(query) + "ORDER BY e.data DESC\n";
        Query q = this.daoLotes.criarQuery(query);
        q.setParameter("dataD1", (Object)d1);
        q.setParameter("tpAmb", (Object)tpAmb);
        if (d1 == null) {
            d1 = Calendar.getInstance().getTime();
        }
        Vector<EstadoLote> novos = new Vector<EstadoLote>();
        List lotes = null;
        try {
            lotes = q.getResultList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (EstadoLote lote : lotes) {
            if (!lote.getData().equals(d1)) continue;
            novos.add(lote);
        }
        return novos;
    }

    public Vector<EstadoNFe> obterNotas(String tpAmb, Date d1, Date d2) throws RemoteException {
        List notas = null;
        Vector<EstadoNFe> novas = new Vector<EstadoNFe>();
        this.daoNotas.clear();
        System.gc();
        if (d1 != null && d2 == null) {
            String query = "SELECT e\n";
            query = String.valueOf(query) + "  FROM EstadoNFe e\n";
            query = String.valueOf(query) + " WHERE e.dataGerada >= :dataLim\n";
            query = String.valueOf(query) + "   AND e.ambiente = :tpAmb\n";
            query = String.valueOf(query) + "ORDER BY e.dataGerada DESC\n";
            Query q = this.daoNotas.criarQuery(query);
            q.setParameter("dataLim", (Object)d1);
            q.setParameter("tpAmb", (Object)tpAmb);
            notas = q.getResultList();
            for (EstadoNFe nota : notas) {
                novas.add(nota);
            }
            return novas;
        }
        if (d1 == null && d2 == null) {
            String query = "SELECT e\n";
            query = String.valueOf(query) + "  FROM EstadoNFe e\n";
            query = String.valueOf(query) + " WHERE e.ambiente = :tpAmb\n";
            query = String.valueOf(query) + "ORDER BY e.dataGerada DESC\n";
            Query q = this.daoNotas.criarQuery(query);
            q.setParameter("tpAmb", (Object)tpAmb);
            notas = q.getResultList();
            for (EstadoNFe nota : notas) {
                novas.add(nota);
            }
            return novas;
        }
        String query = "SELECT e\n";
        query = String.valueOf(query) + "  FROM EstadoNFe e\n";
        query = String.valueOf(query) + " WHERE (e.dataGerada >= :dataD1\n";
        query = String.valueOf(query) + "   AND  e.dataGerada <= :dataD2)\n";
        query = String.valueOf(query) + "   AND e.ambiente = :tpAmb\n";
        query = String.valueOf(query) + "ORDER BY e.dataGerada DESC\n";
        Query q = this.daoNotas.criarQuery(query);
        q.setParameter("dataD1", (Object)d1);
        q.setParameter("dataD2", (Object)d2);
        q.setParameter("tpAmb", (Object)tpAmb);
        notas = q.getResultList();
        for (EstadoNFe nota : notas) {
            novas.add(nota);
        }
        return novas;
    }

    public boolean mesmodia(Date d1, Date d2) {
        String[] ss2;
        String s1 = d1.toString();
        String s2 = d2.toString();
        String[] ss1 = s1.split(" ");
        return ss1[1].equals((ss2 = s2.split(" "))[1]) && ss1[2].equals(ss2[2]) && ss1[5].equals(ss2[5]);
    }

    public EstadoLote obterLote(String idNota, String tpAmb) throws RemoteException {
        EntidadeId eid = new EntidadeId(idNota, tpAmb);
        EstadoNFe nota = this.daoNotas.buscarPorIdObject(eid);
        if (nota != null) {
            this.daoNotas.refresh(nota);
            return nota.getLote();
        }
        return null;
    }

    private Vector<EstadoNFe> obterCNPJ(Vector<EstadoNFe> notas, String CNPJ) {
        Vector<EstadoNFe> novas = new Vector<EstadoNFe>();
        for (EstadoNFe nota : notas) {
            if (nota.getCnpjDestino() == null || !nota.getCnpjDestino().trim().equals(CNPJ.trim())) continue;
            novas.add(nota);
        }
        return novas;
    }

    private Vector<EstadoNFe> obterSerie(Vector<EstadoNFe> notas, String serie) {
        Vector<EstadoNFe> novas = new Vector<EstadoNFe>();
        for (EstadoNFe nota : notas) {
            GerenciadorChavesNota chave = new GerenciadorChavesNota(nota.getId());
            if (!chave.getSerie().trim().equals(serie.trim())) continue;
            novas.add(nota);
        }
        return novas;
    }

    private Vector<EstadoNFe> obterNumerosNotas(Vector<EstadoNFe> notas, String n1, String n2) {
        Long l1 = Long.parseLong(n1);
        Long l2 = Long.parseLong(n2);
        Vector<EstadoNFe> novas = new Vector<EstadoNFe>();
        for (EstadoNFe nota : notas) {
            GerenciadorChavesNota chave = new GerenciadorChavesNota(nota.getId());
            Long l = Long.parseLong(chave.getNumeroNota());
            if (l1 > l || l > l2) continue;
            novas.add(nota);
        }
        return novas;
    }

    public Vector<EstadoNFe> obterNotas(String tpAmb, String CNPJDestinatario, String serie, String n1, String n2, Date d1, Date d2) throws RemoteException {
        Vector<EstadoNFe> notasData = this.obterNotas(tpAmb, d1, d2);
        Vector<EstadoNFe> novasSerie = new Vector();
        Vector<EstadoNFe> novasCNPJ = new Vector();
        Vector<EstadoNFe> novasNSs = new Vector<EstadoNFe>();
        if (CNPJDestinatario != null && CNPJDestinatario.trim().isEmpty()) {
            CNPJDestinatario = null;
        }
        if (serie != null && serie.trim().isEmpty()) {
            CNPJDestinatario = null;
        }
        novasCNPJ = CNPJDestinatario != null ? this.obterCNPJ(notasData, CNPJDestinatario) : notasData;
        novasSerie = serie != null ? this.obterSerie(novasCNPJ, serie) : novasCNPJ;
        novasNSs = n1 != null && n2 != null ? this.obterNumerosNotas(novasSerie, n1, n2) : novasSerie;
        return novasNSs;
    }

    public Vector<EstadoNFe> obterNotas(String idLote, String tpAmb) throws RemoteException {
        EntidadeId id = new EntidadeId(idLote, tpAmb);
        EstadoLote lote = this.daoLotes.buscarPorIdObject(id);
        if (lote != null) {
            this.daoLotes.refresh(lote);
            Vector<EstadoNFe> notas = new Vector<EstadoNFe>();
            for (EstadoNFe nn : lote.getNotas()) {
                notas.add(nn);
            }
            return notas;
        }
        return null;
    }

    public EstadoRecibo obterRecibo(String idLote, String tpAmb) throws RemoteException {
        EntidadeId id = new EntidadeId(idLote, tpAmb);
        EstadoLote lote = this.daoLotes.buscarPorIdObject(id);
        if (lote != null) {
            this.daoLotes.refresh(lote);
            id.setId(lote.getNumeroRecibo());
            return this.daoRecibo.buscarPorIdObject(id);
        }
        return null;
    }

    public static String flipData(String data) {
        String[] dd = data.split("/");
        return String.valueOf(dd[1]) + "/" + dd[0] + "/" + dd[2];
    }

    public static void main2(String[] args) {
        PropriedadesMain.processarComandos(args);
        BaseDadosConfig bd = new BaseDadosConfig();
        bd.setNomeDriver(ConfiguracaoSys.getDRIVER());
        bd.setUsuario(ConfiguracaoSys.getUSER_NAME());
        bd.setSenha(ConfiguracaoSys.getPASSWORD());
        bd.setUrl(ConfiguracaoSys.getURL_CONECTION());
        bd.setToplinkProp("update");
        PropriedadesSistema.setBdConfig(bd);
        SimpleDateFormat formato = new SimpleDateFormat("dd/MM/yyyy");
        System.out.println("data:" + formato.format(new Date()));
        Date d2 = new Date(Date.parse("28/08/2008 24:00"));
        Date d1 = new Date(Date.parse(CockpitServer.flipData("21/10/2008")));
        GerenciadorChavesNota ch = new GerenciadorChavesNota("NFe12312317256512666123660060001000095512179444");
        CockpitServer c = new CockpitServer();
        try {
            Vector<EstadoNFe> novas = c.obterNotas("2", null, null, null, null, d1, null);
            System.out.println("size- >" + novas.size());
            for (EstadoNFe estadoNFe : novas) {
                GerenciadorChavesNota gerenciadorChavesNota = new GerenciadorChavesNota(estadoNFe.getId());
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public String obterXml(String idNota, String tpAmb) {
        try {
            EstadoNFe notas = CacheNotas.obterInstancia().obterEstadoNota(idNota, tpAmb);
            return notas.getXmlString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Vector<EstadoNFe> findNota(String tpAmb, String cnpj, String serie, String ini, String fim, Date data) {
        Query q = null;
        if (data == null) {
            try {
                data = this.df.parse("01/01/2009");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        String query = "select e\n";
        query = String.valueOf(query) + "  from EstadoNFe as e\n";
        query = String.valueOf(query) + " where e.id like '%";
        if (cnpj != null) {
            query = String.valueOf(query) + cnpj + "%";
        }
        query = String.valueOf(query) + serie + "%'\n";
        query = String.valueOf(query) + "   and e.dataGerada > :data\n";
        q = this.daoNotas.criarQuery(query);
        System.out.println(String.valueOf(cnpj) + serie + ini + fim);
        q.setParameter("data", (Object)data);
        Vector<EstadoNFe> notas = new Vector<EstadoNFe>();
        List r = null;
        try {
            r = q.getResultList();
            for (EstadoNFe estadoNFe : r) {
                GerenciadorChavesNota chave = new GerenciadorChavesNota(estadoNFe.getId());
                int serienota = Integer.parseInt(chave.getSerie());
                int seriei = Integer.parseInt(serie);
                int numeronota = Integer.parseInt(chave.getNumeroNota());
                int inii = Integer.parseInt(ini);
                int fimi = Integer.parseInt(fim);
                if (inii > numeronota || numeronota > fimi || serienota != seriei) continue;
                notas.add(estadoNFe);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return notas;
    }

    public Vector<File> logList(Hashtable<String, String> props) {
        Vector<File> listvector = new Vector<File>();
        String pastawrapper = ConfiguracaoSys.getPastaWrapper();
        pastawrapper = String.valueOf(pastawrapper) + "/logs";
        File pastalogs = new File(pastawrapper);
        System.out.println("Finding log from:" + pastalogs.getAbsolutePath());
        File[] fileArray = pastalogs.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File logfile = fileArray[n2];
            if (logfile.getAbsolutePath().contains(".log") && logfile.length() <= 1500000L) {
                listvector.add(logfile);
            }
            ++n2;
        }
        return listvector;
    }

    public String dowloadLog(File file, Hashtable<String, String> props) {
        try {
            System.out.println("Downloading file: " + file.getAbsolutePath());
            String xml = "";
            String linha = "";
            FileReader fr = new FileReader(file);
            BufferedReader r = new BufferedReader(fr);
            try {
                while ((linha = r.readLine()) != null) {
                    xml = String.valueOf(xml) + linha + "\n";
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            r.close();
            fr.close();
            return xml;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] downloadPDF(String id, String tpAmb, String idUsuario) {
        String fileName;
        this.imp.imprimirNota(id, tpAmb, "PDF", false, null, idUsuario);
        EntidadeId eid = new EntidadeId(id, tpAmb);
        EstadoNFe nota = this.daoNotas.buscarPorIdObject(eid);
        if (nota != null && (fileName = this.findPDF(id, tpAmb, nota.getDataGerada())) != null) {
            try {
                File file = new File(fileName);
                byte[] buffer = new byte[(int)file.length()];
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(fileName));
                input.read(buffer, 0, buffer.length);
                input.close();
                return buffer;
            }
            catch (Exception e) {
                System.out.println("FileImpl: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return null;
    }

    public byte[] downloadPS(String id, String tpAmb) {
        EntidadeId eid = new EntidadeId(id, tpAmb);
        EstadoNFe nota = this.daoNotas.buscarPorIdObject(eid);
        if (nota != null) {
            String fileName = this.findPS(id, tpAmb, nota.getDataGerada());
            try {
                File file = new File(fileName);
                byte[] buffer = new byte[(int)file.length()];
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(fileName));
                input.read(buffer, 0, buffer.length);
                input.close();
                return buffer;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String findPS(String id, String tpAmb, Date dataGerada) {
        String basePath = String.valueOf(PathFileFinder.getINSTANCE().findPSPath(id, tpAmb, dataGerada)) + "/";
        File f = new File(String.valueOf(basePath) + id + ".ps");
        long timeout = System.currentTimeMillis() + 3000L;
        long lastSize = -1L;
        while (System.currentTimeMillis() <= timeout) {
            if (f.exists()) {
                long size = f.length();
                if (size > 0L && size == lastSize) {
                    return f.getAbsolutePath();
                }
                lastSize = size;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        return null;
    }

    private String findPDF_old(String id, String tpAmb, Date dataGerada) {
        String path = String.valueOf(PathFileFinder.getINSTANCE().findPDFPath(id, tpAmb, dataGerada)) + "/";
        File f = new File(String.valueOf(path) + id + ".pdf");
        boolean finded = false;
        int i = 0;
        while (i < 30) {
            long last;
            long currentTime;
            System.out.println("Procurando PDF!" + f.getAbsolutePath());
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (f.exists() && (currentTime = Calendar.getInstance().getTimeInMillis()) - (last = f.lastModified()) > 2000L) {
                finded = true;
                break;
            }
            ++i;
        }
        if (finded) {
            return f.getAbsolutePath();
        }
        return null;
    }

    private String findPDF(String id, String tpAmb, Date dataGerada) {
        String basePath = String.valueOf(PathFileFinder.getINSTANCE().findPDFPath(id, tpAmb, dataGerada)) + "/";
        File f = new File(String.valueOf(basePath) + id + ".pdf");
        long timeout = System.currentTimeMillis() + 3000L;
        long lastSize = -1L;
        while (System.currentTimeMillis() <= timeout) {
            if (f.exists()) {
                long size = f.length();
                if (size > 0L && size == lastSize) {
                    return f.getAbsolutePath();
                }
                lastSize = size;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        return null;
    }

    void registerOperacao(Hashtable<String, String> props) {
    }

    public static void main(String[] args) {
        PropriedadesMain.processarComandos(args);
        BaseDadosConfig bd = new BaseDadosConfig();
        bd.setNomeDriver(ConfiguracaoSys.getDRIVER());
        bd.setUsuario(ConfiguracaoSys.getUSER_NAME());
        bd.setSenha(ConfiguracaoSys.getPASSWORD());
        bd.setUrl(ConfiguracaoSys.getURL_CONECTION());
        bd.setToplinkProp("update");
        PropriedadesSistema.setBdConfig(bd);
        CockpitServer server = new CockpitServer();
    }
}

