/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.controle;

import br.com.taragona.nfe.classes.retrecepcao.TConsReciNFe;
import br.com.taragona.nfe.classes.retrecepcao.TProtNFe;
import br.com.taragona.nfe.classes.retrecepcao.TRetConsReciNFe;
import br.com.taragona.nfe.controle.ControleLotesAsStringInstance;
import br.com.taragona.nfe.danfe.ImprimirDANFE;
import br.com.taragona.nfe.mensageiro.caches.CacheLotesPendentes;
import br.com.taragona.nfe.mensageiro.caches.CacheNotas;
import br.com.taragona.nfe.mensageiro.caches.CacheRecibos;
import br.com.taragona.nfe.persistence.EstadoLote;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.EstadoRecibo;
import br.com.taragona.nfe.util.CodigoNFeManager;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.logger.LoggingJava;
import br.com.taragona.nfe.util.xml.XMLFactory;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.bind.JAXBElement;

public class ChecarLoteThread
implements Runnable {
    private CacheRecibos cacheRecibos;
    private CacheLotesPendentes cacheLotes;
    private CacheNotas cacheNotas;
    private ImprimirDANFE imprimir;
    private XMLGenerator xmlsRetRecepcao;
    private EstadoRecibo recibo;
    private Long TEMPO_PROCESSAMENTO;
    private String CNPJ;
    private String UF;
    private Set<String> notas;
    private String tpAmb;
    private String idUsuario;

    public ChecarLoteThread(String cnpj, String UF, String nRecibo, Set<String> notas, ImprimirDANFE imprimir, Long TEMPO_PROCESSAMENTO, String tpAmb, String idUsuario) {
        this.UF = UF;
        this.cacheNotas = CacheNotas.obterInstancia();
        this.cacheRecibos = CacheRecibos.obterInstancia();
        this.cacheLotes = CacheLotesPendentes.obterInstancia();
        this.xmlsRetRecepcao = XMLFactory.getXmlsRetRecepcao();
        this.recibo = this.cacheRecibos.obterRecibo(nRecibo, tpAmb);
        this.notas = notas != null ? notas : new HashSet<String>();
        this.imprimir = imprimir;
        this.CNPJ = cnpj;
        this.TEMPO_PROCESSAMENTO = TEMPO_PROCESSAMENTO;
        this.tpAmb = tpAmb;
        this.idUsuario = idUsuario;
    }

    public boolean checarRecibo() {
        String resultado;
        block3: {
            try {
                LoggingJava.logger.log(Level.WARNING, "Checando recibo:" + this.recibo.getId());
                String consulta = XMLFactory.criarConsultaLote(this.recibo.getId(), this.tpAmb, this.CNPJ);
                String cabecalho = XMLFactory.montarCabecalho(TConsReciNFe.class, this.CNPJ);
                resultado = GerenciadorProxy.enviarMensagemXML(PropriedadesSistema.ID_SERVICO_RETRECEPCAO, this.CNPJ, cabecalho, consulta, this.UF, this.idUsuario);
                if (resultado != null) break block3;
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        JAXBElement resposta = (JAXBElement)this.xmlsRetRecepcao.toObject(resultado);
        CodigoNFeManager.insereCodigo(Integer.valueOf(((TRetConsReciNFe)resposta.getValue()).getCStat()), ((TRetConsReciNFe)resposta.getValue()).getXMotivo());
        return this.processarResposta(this.recibo.getId(), (TRetConsReciNFe)resposta.getValue(), this.recibo.getIdLote());
    }

    public boolean processarResposta(String nRec, TRetConsReciNFe resposta, String idLote) {
        int codigo;
        block15: {
            block16: {
                block14: {
                    codigo = Integer.parseInt(resposta.getCStat());
                    System.out.println("Codigo retorno consulta: " + codigo + " lote: " + idLote);
                    LoggingJava.logger.log(Level.WARNING, "Checando recibo:" + this.recibo.getId() + " codigo: " + codigo);
                    if (codigo != PropriedadesSistema.FALHA_ESQUEMA.getId() && codigo != PropriedadesSistema.FALHA_ESQUEMA_NFE.getId() && codigo != PropriedadesSistema.XML_MAL_FORMADO.getId()) break block14;
                    for (String idNota : this.notas) {
                        this.cacheNotas.ajustarEstado(idNota, this.tpAmb, EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA_LOTE, true, this.idUsuario);
                    }
                    this.cacheLotes.ajustarEstado(idLote, this.tpAmb, EstadoLote.ESTADO_LOTE.ERRO_ESQUEMA);
                    this.cacheLotes.ajustarEstadoNFe(idLote, this.tpAmb, new Long(codigo));
                    this.cacheRecibos.estadoRecibo(nRec, this.tpAmb, true);
                    return true;
                }
                if (codigo == PropriedadesSistema.LOTE_PROCESSADO.getId()) break block15;
                Date hoje = new Date();
                EstadoLote lote = this.cacheLotes.obterLotePendente(idLote, this.tpAmb);
                if (hoje.getTime() - lote.getDataEnvio().getTime() <= this.TEMPO_PROCESSAMENTO) break block16;
                this.cacheLotes.ajustarEstado(idLote, this.tpAmb, EstadoLote.ESTADO_LOTE.TEMPO_PROCESSAMENTO_LIMITE);
                this.cacheLotes.ajustarEstadoNFe(idLote, this.tpAmb, new Long(codigo));
                GerenciadorProxy.notificarLote(this.cacheLotes.obterLotePendente(idLote, this.tpAmb));
                return true;
            }
            this.cacheLotes.ajustarTempoDeTentativa(idLote, this.tpAmb);
            return false;
        }
        try {
            List<TProtNFe> protocolos = resposta.getProtNFe();
            Hashtable<String, TProtNFe> selectedProtocols = new Hashtable<String, TProtNFe>();
            for (TProtNFe protocolo : protocolos) {
                if (selectedProtocols.containsKey(protocolo.getInfProt().getChNFe())) {
                    TProtNFe pp = (TProtNFe)selectedProtocols.get(protocolo.getInfProt().getChNFe());
                    String codigo1 = pp.getInfProt().getCStat().trim();
                    if (PropriedadesSistema.isCodigoAutorizado(codigo1.trim())) continue;
                    selectedProtocols.put(protocolo.getInfProt().getChNFe(), protocolo);
                    continue;
                }
                selectedProtocols.put(protocolo.getInfProt().getChNFe(), protocolo);
            }
            LoggingJava.logger.log(Level.WARNING, "Protocolos pre-processados:" + selectedProtocols.toString());
            for (TProtNFe protocolo : selectedProtocols.values()) {
                try {
                    int codigoProt = Integer.parseInt(protocolo.getInfProt().getCStat());
                    System.out.println("processando nota -> " + protocolo.getInfProt().getChNFe() + " com codigo " + codigoProt);
                    String xMotivo = null;
                    if (protocolo.getInfProt().getXMotivo() != null) {
                        xMotivo = protocolo.getInfProt().getXMotivo();
                    }
                    String protNumber = null;
                    if (protocolo.getInfProt().getNProt() != null) {
                        protNumber = protocolo.getInfProt().getNProt();
                    }
                    if (protocolo.getInfProt().getDhRecbto() != null) {
                        protNumber = String.valueOf(protNumber) + "|" + protocolo.getInfProt().getDhRecbto().toString();
                    }
                    this.processarCodigoConsulta(codigoProt, protocolo.getInfProt().getChNFe(), protNumber, this.xmlsRetRecepcao.toXMLString(protocolo), xMotivo);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.cacheLotes.ajustarEstado(idLote, this.tpAmb, EstadoLote.ESTADO_LOTE.PROCESSADO);
            this.cacheLotes.ajustarEstadoNFe(idLote, this.tpAmb, new Long(codigo));
            this.cacheRecibos.estadoRecibo(nRec, this.tpAmb, true);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public void processarCodigoConsulta(int codigo, String idNota, String numeroProtocolo, String protocolo, String xMotivo) {
        if (!idNota.startsWith("NFe")) {
            idNota = "NFe" + idNota;
        }
        System.out.println("processarCodigoConsulta: " + idNota + " com codigo " + codigo + " protocolo: " + protocolo);
        try {
            EstadoNFe estado = this.cacheNotas.obterEstadoNota(idNota, this.tpAmb);
            System.out.println("modoOp: " + estado.getModoOperacao().toString());
            GerenciadorProxy.gerenciador.notificarNotaERP(idNota.replace("NFe", ""), this.tpAmb, estado.getModoOperacao().toString(), protocolo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!PropriedadesSistema.isCodigoAutorizado(codigo)) {
            String motivo = CodigoNFeManager.obterDescricao(codigo);
            if (motivo == null || motivo.trim().isEmpty()) {
                motivo = xMotivo;
            }
            if ((motivo == null || motivo.trim().isEmpty()) && protocolo != null) {
                motivo = ControleLotesAsStringInstance.extrairXMotivo(protocolo);
            }
            if (motivo != null && !motivo.trim().isEmpty()) {
                this.cacheNotas.ajustarXMotivo(idNota, this.tpAmb, motivo.trim());
            }
        }
        try {
            if (codigo == 204) {
                GerenciadorChavesNota chave = new GerenciadorChavesNota(idNota);
                ControleLotesAsStringInstance controle = new ControleLotesAsStringInstance(this.tpAmb, chave.getCnpj(), chave.getUF());
                controle.consularNota(idNota, this.tpAmb, true, this.idUsuario);
                return;
            }
            this.cacheNotas.ajustarEstadoNota(idNota, this.tpAmb, new Long(codigo), this.idUsuario);
            if (PropriedadesSistema.isCodigoAutorizado(codigo)) {
                EstadoNFe estadoNota = this.cacheNotas.obterEstadoNota(idNota, this.tpAmb);
                this.cacheNotas.ajustarAutorizada(idNota, this.tpAmb, protocolo, numeroProtocolo, true, this.idUsuario);
                if (estadoNota.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.NORMAL) || estadoNota.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN) || estadoNota.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC) || estadoNota.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC) || estadoNota.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.SVC_AN) || estadoNota.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.SVC_RS)) {
                    System.out.println("Imprimindo Normal");
                    if (estadoNota.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC) || estadoNota.getModoOperacao().equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC)) {
                        this.imprimir.imprimirNota(idNota, this.tpAmb, "PDF", true, null, this.idUsuario);
                    } else {
                        this.imprimir.imprimirNota(idNota, this.tpAmb, "IMPRIMIR/PDF", true, null, this.idUsuario);
                    }
                } else {
                    this.imprimir.imprimirNota(idNota, this.tpAmb, "PDF", true, null, this.idUsuario);
                    this.imprimir.enviarEmail(idNota, this.tpAmb);
                }
            } else if (201 <= codigo && codigo <= 299 || 401 <= codigo && codigo <= 600) {
                EstadoNFe current = this.cacheNotas.obterEstadoNota(idNota, this.tpAmb);
                if (current != null && current.getEstado() != null && current.getEstado() == EstadoNFe.ESTADO_NFE.AUTORIZADA) {
                    return;
                }
                this.cacheNotas.ajustarEstado(idNota, this.tpAmb, EstadoNFe.ESTADO_NFE.REJEITADA, true, this.idUsuario);
            } else if (301 <= codigo && codigo <= 302) {
                this.cacheNotas.ajustarDenegada(idNota, this.tpAmb, protocolo, numeroProtocolo, true, true, this.idUsuario);
            } else if (codigo == 999) {
                this.cacheNotas.ajustarEstado(idNota, this.tpAmb, EstadoNFe.ESTADO_NFE.REJEITADA, true, this.idUsuario);
            } else {
                this.cacheNotas.ajustarEstado(idNota, this.tpAmb, EstadoNFe.ESTADO_NFE.ERRO, true, this.idUsuario);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void run() {
        boolean checar = false;
        while (!checar) {
            try {
                checar = this.checarRecibo();
            }
            catch (Exception e) {
                break;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

