/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.controle;

import br.com.taragona.nfe.controle.ChecarLoteThread;
import br.com.taragona.nfe.controle.ControleInterface;
import br.com.taragona.nfe.controle.ControleLotesAsStringInstance;
import br.com.taragona.nfe.danfe.ImprimirDANFEImpl;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.MensageiroConfig;
import br.com.taragona.nfe.util.data.ServicosConfig;
import br.com.taragona.nfe.util.xml.XMLFactory;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class Controle
implements ControleInterface {
    private Hashtable<String, PropriedadesSistema.MODO_OP> modos;
    private Hashtable<String, Long> tempos;
    private GerenciadorInterface gerenciador;
    private ImprimirDANFEImpl imprimir;
    private Hashtable<String, String> cnpjsUFs;
    private Vector<String> cnpjsRegistrados;
    private ServicosConfig servicosConf;

    public Controle(GerenciadorInterface gerenciador) throws RemoteException {
        this.gerenciador = gerenciador;
        this.servicosConf = gerenciador.obterServicosConfig();
        this.imprimir = new ImprimirDANFEImpl();
        this.modos = new Hashtable();
        this.tempos = new Hashtable();
        this.cnpjsUFs = this.servicosConf.getCnpjsUf();
        this.cnpjsRegistrados = this.gerenciador.obterCNPJRegistrados();
        GerenciadorProxy.setGerenciador(gerenciador);
        PropriedadesSistema.setBdConfig(gerenciador.obterBDConfig());
        XMLFactory.setVersaoEsquema(this.servicosConf.getTodosEsquemas());
        XMLFactory.setTipoAmbienteDefault(this.servicosConf.getTipoAmbiente());
        XMLFactory.setTipoServicos(gerenciador.obterTipoServicos());
        XMLFactory.setCnpjsUfs(this.cnpjsUFs);
        try {
            this.inicializarConsultores();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void inicializarConsultores() throws Exception {
        for (String cnpj : this.cnpjsRegistrados) {
            int estado = this.gerenciador.estadoOperacao(cnpj);
            if (estado == 0) {
                this.modos.put(cnpj, PropriedadesSistema.MODO_OP.CONTINGENCIA);
            } else {
                this.modos.put(cnpj, PropriedadesSistema.MODO_OP.NORMAL);
            }
            MensageiroConfig config = this.gerenciador.obterMensageiroConfig(cnpj);
            Long tempo = config.getTempoProc();
            this.tempos.put(cnpj, tempo);
        }
    }

    @Override
    public Long estadoNota(String id) throws RemoteException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Long estadoLote(String id) throws RemoteException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection<String> obterNotasPendentes() {
        return null;
    }

    public Collection<String> obterLotesPendentes() {
        return null;
    }

    @Override
    public void ajustarModoEnvio() throws RemoteException {
        System.out.println("[Consultor] Modo Envio");
        for (String cnpj : this.modos.keySet()) {
            this.modos.put(cnpj, PropriedadesSistema.MODO_OP.NORMAL);
        }
    }

    @Override
    public void ajustarModoContigencia() throws RemoteException {
        System.out.println("[Consultor] Modo Contingencia");
        for (String cnpj : this.modos.keySet()) {
            this.modos.put(cnpj, PropriedadesSistema.MODO_OP.CONTINGENCIA);
        }
    }

    @Override
    public void tempoProcessamento(String cnpj, Long time) throws RemoteException {
        Long tempo = this.tempos.get(cnpj);
        if (tempo == null) {
            throw new RemoteException("CNPj nao registrado: " + cnpj);
        }
        this.tempos.put(cnpj, time);
    }

    @Override
    public Long tempoProcessamento(String cnpj) throws RemoteException {
        Long tempo = this.tempos.get(cnpj);
        if (tempo == null) {
            throw new RemoteException("CNPj nao registrado: " + cnpj);
        }
        return this.tempos.get(cnpj);
    }

    @Override
    public void mudarEstadoContingencia(String cnpj) throws RemoteException {
        try {
            System.out.println("[Consultor] Modo Contingencia");
            PropriedadesSistema.MODO_OP modo = this.modos.get(cnpj);
            if (modo == null) {
                throw new RemoteException("CNPj nao registrado: " + cnpj);
            }
            this.modos.put(cnpj, PropriedadesSistema.MODO_OP.CONTINGENCIA);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mudarEstadoNormal(String cnpj) throws RemoteException {
        try {
            System.out.println("[Consultor] Modo Normal");
            PropriedadesSistema.MODO_OP modo = this.modos.get(cnpj);
            if (modo == null) {
                throw new RemoteException("CNPj nao registrado: " + cnpj);
            }
            this.modos.put(cnpj, PropriedadesSistema.MODO_OP.NORMAL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void tentarChecarRecibos(String cnpj, String idUsuario) throws RemoteException {
        if (!this.cnpjsRegistrados.contains(cnpj)) {
            throw new RemoteException("CNPJ nao cadastrado no TaragonaNFe: " + cnpj);
        }
    }

    @Override
    public void ajustarServicos(String cnpj, Hashtable<String, String>[] servicosLista) throws RemoteException {
    }

    @Override
    public void registrarGerenciador(GerenciadorInterface gerenciador) throws RemoteException {
        GerenciadorProxy.setGerenciador(gerenciador);
    }

    @Override
    public String consultarNota(String idNota, String tpAmb, String idUsuario) throws RemoteException {
        GerenciadorChavesNota chave = new GerenciadorChavesNota(idNota);
        String cnpj = this.cnpjsRegistrados.firstElement();
        Vector<String> ufs = this.servicosConf.getUfs();
        System.out.println("->" + ((Object)ufs).toString());
        if (!ufs.contains(chave.getUF())) {
            throw new RemoteException("UF nao cadastrado no TaragonaNFe:" + chave.getUF());
        }
        ControleLotesAsStringInstance ins = new ControleLotesAsStringInstance(tpAmb, cnpj, chave.getUF());
        return ins.consultarNotaInstance(idNota, idUsuario);
    }

    @Override
    public String consultarNotaXml(String idNota, String tpAmb, String idUsuario) throws RemoteException {
        GerenciadorChavesNota chave = new GerenciadorChavesNota(idNota);
        String cnpj = this.cnpjsRegistrados.firstElement();
        Vector<String> ufs = this.servicosConf.getUfs();
        System.out.println("->2" + ((Object)ufs).toString());
        if (!ufs.contains(chave.getUF())) {
            throw new RemoteException("UF nao cadastrado no TaragonaNFe:" + chave.getUF());
        }
        ControleLotesAsStringInstance ins = new ControleLotesAsStringInstance(tpAmb, cnpj, chave.getUF());
        return ins.consultarNotaInstanceXml(idNota, tpAmb, idUsuario);
    }

    @Override
    public synchronized void notificarControle(String cnpj, String idLote, String recibo, Set<String> notas, String tpAmb, String idUsuario) throws RemoteException {
        PropriedadesSistema.MODO_OP modo = this.modos.get(cnpj);
        String UF = this.cnpjsUFs.get(cnpj);
        MensageiroConfig config = this.gerenciador.obterMensageiroConfig(cnpj);
        if (modo == PropriedadesSistema.MODO_OP.NORMAL || modo == PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN || modo == PropriedadesSistema.MODO_OP.SVC_AN || modo == PropriedadesSistema.MODO_OP.SVC_RS) {
            ChecarLoteThread check = new ChecarLoteThread(cnpj, UF, recibo, notas, this.imprimir, config.getTempoProc(), tpAmb, idUsuario);
            Thread t = new Thread(check);
            t.start();
        }
    }
}

