/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.controle;

import br.com.taragona.nfe.cancinut.SenderCancel;
import br.com.taragona.nfe.classes.consulta.TConsSitNFe;
import br.com.taragona.nfe.controle.ChecarLoteThread;
import br.com.taragona.nfe.controle.eventoret.TProcEvento;
import br.com.taragona.nfe.controle.eventoret.TProtNFe;
import br.com.taragona.nfe.controle.eventoret.TRetConsSitNFe;
import br.com.taragona.nfe.controle.eventoret.TRetEvento;
import br.com.taragona.nfe.danfe.ImprimirDANFE;
import br.com.taragona.nfe.danfe.ImprimirDANFEImpl;
import br.com.taragona.nfe.mensageiro.caches.CacheLotesPendentes;
import br.com.taragona.nfe.mensageiro.caches.CacheNotas;
import br.com.taragona.nfe.mensageiro.caches.CacheRecibos;
import br.com.taragona.nfe.persistence.CodigoNFe;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.EstadoRecibo;
import br.com.taragona.nfe.util.CodigoNFeManager;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.xml.XMLFactory;
import br.com.taragona.nfe.xmlgenerator.FileManager;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import javax.xml.bind.JAXBElement;

public class ControleLotesAsString
extends Thread {
    private Long TEMPO_PROCESSAMENTO = 10000L;
    private Long DELAY = 5000L;
    private CacheRecibos cacheRecibos;
    private CacheLotesPendentes cacheLotes;
    private boolean checar = true;
    protected XMLGenerator xmlsConsulta;
    protected CacheNotas cacheNotas;
    protected String tpAmb;
    protected String CNPJ;
    private PropriedadesSistema.MODO_OP modoAtual;
    protected ImprimirDANFE imprimir;
    private Hashtable<EstadoRecibo, ChecarLoteThread> threads;
    protected String UF;
    private DAOGenerico<CodigoNFe> daoCodigo;

    public ControleLotesAsString(String tpAmb, String CNPJ, String UF, PropriedadesSistema.MODO_OP modoAtual) {
        this.tpAmb = tpAmb;
        this.CNPJ = CNPJ;
        this.UF = UF;
        this.modoAtual = modoAtual;
        this.cacheNotas = CacheNotas.obterInstancia();
        this.cacheRecibos = CacheRecibos.obterInstancia();
        this.cacheLotes = CacheLotesPendentes.obterInstancia();
        this.xmlsConsulta = XMLFactory.getXmlsConsulta();
        this.imprimir = new ImprimirDANFEImpl();
        this.threads = new Hashtable();
        this.daoCodigo = new DAOGenerico(CodigoNFe.class);
    }

    public void consularNota(String id, String tpAmb, boolean notificar, String idUsuario) {
        id = id.replace("NFe", "");
        try {
            String consulta = XMLFactory.criarConsultaNota(id, tpAmb, this.CNPJ);
            String cabecalho = XMLFactory.montarCabecalho(TConsSitNFe.class, this.CNPJ);
            String resultado = GerenciadorProxy.enviarMensagemXML(PropriedadesSistema.ID_SERVICO_CONSULTA, this.CNPJ, cabecalho, consulta, this.UF, idUsuario);
            TRetConsSitNFe protocolo = (TRetConsSitNFe)((JAXBElement)this.xmlsConsulta.toObject(resultado)).getValue();
            int codigo = Integer.parseInt(protocolo.getCStat());
            CodigoNFeManager.insereCodigo(codigo, protocolo.getXMotivo());
            if (codigo == 217) {
                return;
            }
            List<TProcEvento> eventsprot = protocolo.getProcEventoNFe();
            if (!eventsprot.isEmpty()) {
                for (TProcEvento t : eventsprot) {
                    if (t.getRetEvento() == null || t.getRetEvento().getInfEvento() == null || !"110111".equals(t.getRetEvento().getInfEvento().getTpEvento()) || !"135".equals(t.getRetEvento().getInfEvento().getCStat())) continue;
                    codigo = 101;
                }
            }
            String protocoloNumber = "";
            String protocoloXML = "";
            if (PropriedadesSistema.isCodigoAutorizado(codigo)) {
                TProtNFe.InfProt prot = null;
                if (protocolo.getProtNFe() != null) {
                    codigo = Integer.parseInt(protocolo.getProtNFe().getInfProt().getCStat());
                    prot = protocolo.getProtNFe().getInfProt();
                }
                if (prot != null && prot.getNProt() != null) {
                    protocoloNumber = prot.getNProt();
                }
                if (prot != null && prot.getDhRecbto() != null) {
                    protocoloNumber = String.valueOf(protocoloNumber) + "|" + prot.getDhRecbto().toString();
                }
                if (protocolo.getProtNFe() != null) {
                    protocoloXML = this.xmlsConsulta.toXMLString(protocolo.getProtNFe());
                }
            }
            if (codigo == 101) {
                List<TProcEvento> events = protocolo.getProcEventoNFe();
                for (TProcEvento event : events) {
                    TRetEvento eventret = event.getRetEvento();
                    if (!eventret.getInfEvento().getTpEvento().equals("110111") || !eventret.getInfEvento().getCStat().equals("135")) continue;
                    protocoloNumber = String.valueOf(eventret.getInfEvento().getNProt()) + "|" + eventret.getInfEvento().getDhRegEvento();
                    protocoloXML = this.xmlsConsulta.toXMLString(event);
                }
            }
            protocoloXML = protocoloXML.replace("ns2:", "");
            protocoloXML = protocoloXML.replace(":ns2", "");
            System.out.println("codigo:" + codigo);
            System.out.println("protocolo XML:" + protocoloXML);
            System.out.println("protocolo:" + protocoloNumber);
            this.processarCodigoConsulta(codigo, id, tpAmb, protocoloNumber, protocoloXML, notificar, idUsuario);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected synchronized void processarCodigoConsulta(int codigo, String idNota, String tpAmb, String numeroProtocolo, String protocoloXML, boolean notificar, String idUsuario) {
        if (!idNota.startsWith("NFe")) {
            idNota = "NFe" + idNota;
        }
        try {
            this.cacheNotas.ajustarEstadoNota(idNota, tpAmb, new Long(codigo), idUsuario);
            if (codigo == 217) {
                this.cacheNotas.ajustarEstado(idNota, tpAmb, EstadoNFe.ESTADO_NFE.GERADA, notificar, idUsuario);
                return;
            }
            if (codigo == 101) {
                this.cacheNotas.ajustarCancelada(idNota, tpAmb, numeroProtocolo, protocoloXML, notificar, idUsuario);
                EstadoNFe nota = this.cacheNotas.obterEstadoNota(idNota, tpAmb);
                String protxmlcancel = "<procEventoNFe xmlns=\"http://www.portalfiscal.inf.br/nfe\" versao=\"1.00\">" + nota.getProtocoloCancelamentoXML() + "</procEventoNFe>";
                SenderCancel.getInstace().sendCancel(nota.getId(), tpAmb, nota.getCnpjDestino().trim(), protxmlcancel);
                return;
            }
            if (PropriedadesSistema.isCodigoAutorizado(codigo)) {
                EstadoNFe estadoNota = this.cacheNotas.obterEstadoNota(idNota, tpAmb);
                this.cacheNotas.ajustarAutorizada(idNota, tpAmb, protocoloXML, numeroProtocolo, notificar, idUsuario);
                if (!estadoNota.isAssinada()) {
                    this.imprimir.imprimirNota(idNota, tpAmb, "IMPRIMIR/PDF", true, null, idUsuario);
                }
                return;
            }
            if (201 <= codigo && codigo <= 299 || 401 <= codigo && codigo <= 407) {
                this.cacheNotas.ajustarEstado(idNota, tpAmb, EstadoNFe.ESTADO_NFE.REJEITADA, notificar, idUsuario);
                FileManager.salvarNotaErro(idNota, codigo);
            } else if (301 <= codigo && codigo <= 302) {
                this.cacheNotas.ajustarDenegada(idNota, tpAmb, protocoloXML, numeroProtocolo, notificar, false, idUsuario);
                this.imprimir.enviarDenegadaEmail(idNota, tpAmb);
            } else {
                this.cacheNotas.ajustarEstado(idNota, tpAmb, EstadoNFe.ESTADO_NFE.ERRO, notificar, idUsuario);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isChecar() {
        return this.checar;
    }

    public void setChecar(boolean checar) {
        this.checar = checar;
    }

    public EstadoNFe.ESTADO_NFE estadoNota(String id, String tpAmb) {
        return this.cacheNotas.obterEstado(id, tpAmb);
    }

    public Long estadoNotaNFe(String id, String tpAmb) {
        return this.cacheNotas.obterEstadoNFe(id, tpAmb);
    }

    public PropriedadesSistema.MODO_OP getModoAtual() {
        return this.modoAtual;
    }

    public void setModoAtual(PropriedadesSistema.MODO_OP modoAtual) {
        this.modoAtual = modoAtual;
    }

    public void tentarChecarRecibos() {
        this.threads = new Hashtable();
    }

    @Override
    public void run() {
        try {
            if (this.modoAtual == PropriedadesSistema.MODO_OP.NORMAL) {
                Collection<EstadoRecibo> recibos = this.cacheRecibos.obterRecibosPendentesDB(this.tpAmb, this.CNPJ);
                for (EstadoRecibo recibo : recibos) {
                    if (this.threads.containsKey(recibo)) continue;
                    System.out.println("Checando lote" + recibo.getIdLote());
                    ChecarLoteThread check = new ChecarLoteThread(this.CNPJ, this.UF, recibo.getId(), null, this.imprimir, this.TEMPO_PROCESSAMENTO, null, null);
                    Thread t = new Thread(check);
                    t.start();
                    this.threads.put(recibo, check);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Long getTEMPO_PROCESSAMENTO() {
        return this.TEMPO_PROCESSAMENTO;
    }

    public void setTEMPO_PROCESSAMENTO(Long tempo_processamento) {
        this.TEMPO_PROCESSAMENTO = tempo_processamento;
    }
}

