/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.danfe;

import br.com.taragona.nfe.danfe.ImprimirDANFE;
import br.com.taragona.nfe.danfe.JRDataSourceGeneric;
import br.com.taragona.nfe.danfe.SendEmailThread;
import br.com.taragona.nfe.email.MailSender;
import br.com.taragona.nfe.mensageiro.caches.CacheNotas;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EntidadeId;
import br.com.taragona.nfe.persistence.EstadoLote;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.EventoInfo;
import br.com.taragona.nfe.persistence.ExtraXMLInfo;
import br.com.taragona.nfe.tools.PathFileFinder;
import br.com.taragona.nfe.unilog.NfeTxtGenerator;
import br.com.taragona.nfe.unilog.UnilogZ025;
import br.com.taragona.nfe.util.BoletoManager;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PrintFinder;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.extract.XMLFormer;
import br.com.taragona.nfe.util.logger.NFeLogger;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import br.com.tti.nfev310.TNFe;
import br.com.tti.util.PdfReadyChecker;
import br.com.tti.util.ThreadQuiescenceBarrier;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.persistence.Query;
import javax.xml.bind.JAXBElement;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.export.JRPdfExporter;

public class ImprimirDANFEImpl
implements ImprimirDANFE {
    private DAOGenerico<EstadoLote> daoLote = new DAOGenerico(EstadoLote.class);
    private DAOGenerico<EstadoNFe> daoNota = new DAOGenerico(EstadoNFe.class);
    private DAOGenerico<EventoInfo> daoEvento = new DAOGenerico(EventoInfo.class);
    private DAOGenerico<ExtraXMLInfo> daoExtrainfo = new DAOGenerico(ExtraXMLInfo.class);
    private XMLFormer former = new XMLFormer(ConfiguracaoSys.getTipoAmbiente());
    private MailSender sender;
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat dflast = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private static SimpleDateFormat dfnormal = new SimpleDateFormat("dd/MM/yyyy");
    private static SimpleDateFormat sdfcce = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    private static SimpleDateFormat sdfcceBrazil = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");

    public ImprimirDANFEImpl() {
        if (PropriedadesMain.isEmail()) {
            this.sender = new MailSender();
        }
    }

    private String obterInfoMarketplace(EstadoNFe nota) {
        if (nota.getOutros() != null && !nota.getOutros().isEmpty()) {
            return nota.getOutros();
        }
        return nota.getMotivoErro();
    }

    private static String makeFormat(String format) {
        try {
            String[] partes = format.split(" ");
            String data = partes[1];
            data = data.replace("T", " ");
            Date d1 = null;
            try {
                d1 = df.parse(data);
            }
            catch (com.sun.org.apache.xerces.internal.impl.xpath.regex.ParseException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            String ddd = "";
            try {
                ddd = String.valueOf(partes[0]) + " " + dflast.format(d1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ddd;
        }
        catch (Exception exception) {
            return format;
        }
    }

    @Override
    public void gerarXMLProtAndPDF(String idNota, String tpAmb, String tipo, boolean email, String idUsuario) throws Exception {
        this.imprimirNota(idNota, tpAmb, tipo, email, null, idUsuario);
    }

    @Override
    public void reImprimirNota(String idNota, String tpAmb, String tipo, String etiqueta, String idUsuario) throws Exception {
        this.imprimirNota(idNota, tpAmb, tipo, false, null, idUsuario);
    }

    public String obterTxtMiniDanfe(String idNota, String tpAmb, String tipo, String etiqueta) {
        return this.obterTxtMiniDanfe(idNota, tpAmb, tipo, false, null);
    }

    public byte[] obterPdfMiniDanfe(String idNota, String tpAmb, String tipo, String etiqueta) {
        return this.obterPdfMiniDanfe(idNota, tpAmb, tipo, false, null);
    }

    private String tirarCabecalho(String nota) {
        return nota;
    }

    public static String obterCNPJTransp(String xml) {
        int pos2;
        int pos1;
        String cnpj = null;
        String transpcnpj = "<transporta><CNPJ>";
        String transpcnpj2 = "</CNPJ>";
        String transpcpf = "<transporta><CPF>";
        String transpcpf2 = "</CPF>";
        if (xml.contains(transpcnpj)) {
            pos1 = xml.indexOf(transpcnpj);
            pos2 = xml.indexOf(transpcnpj2, pos1);
            cnpj = xml.substring(pos1 + transpcnpj.length(), pos2);
        }
        if (xml.contains(transpcpf)) {
            pos1 = xml.indexOf(transpcpf);
            pos2 = xml.indexOf(transpcpf2, pos1);
            cnpj = xml.substring(pos1 + transpcpf.length(), pos2);
        }
        return cnpj;
    }

    @Override
    public void imprimirNota(EstadoNFe nota, String tipo, boolean email, String etiquetas, String idUsuario) {
        Hashtable<String, String> prop;
        String print;
        String xmlFile;
        boolean casoUnilog;
        ThreadQuiescenceBarrier barrier;
        ResourceBundle rb;
        boolean nota_cancelada;
        String fileProt;
        Date dataGerada;
        String ambiente;
        String idNota;
        String motivoErro;
        block79: {
            String protocolo;
            String infoMarketplace;
            block78: {
                motivoErro = "";
                infoMarketplace = this.obterInfoMarketplace(nota);
                idNota = nota.getId();
                ambiente = nota.getAmbiente();
                dataGerada = nota.getDataGerada();
                fileProt = null;
                nota_cancelada = false;
                rb = null;
                try {
                    rb = ResourceBundle.getBundle("olist");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                barrier = null;
                boolean bl = casoUnilog = infoMarketplace != null && infoMarketplace.toUpperCase().contains("UNILOG") && rb != null && rb.containsKey("caminho_unilog");
                if (casoUnilog) {
                    motivoErro = infoMarketplace;
                    if (nota.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.CANCELADA)) {
                        nota_cancelada = true;
                    } else if (nota.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.CANCELADA_CONTINGENCIA)) {
                        nota_cancelada = true;
                    } else if (nota.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.CANCELAR_SAIDA_CONTINGENCIA)) {
                        nota_cancelada = true;
                    }
                    barrier = ThreadQuiescenceBarrier.newBarrier().includePackagePrefixes("br.com.taragona").includeDaemons(false).quietPeriodMillis(800L).begin();
                }
                System.out.println("Imprimindo DANFE da Nota " + nota.getId());
                GerenciadorChavesNota chave = new GerenciadorChavesNota(nota.getId());
                String filename = null;
                String path = null;
                try {
                    System.out.println("Antes de criar o arquivo e o xml");
                    path = this.former.createFile(nota.getId(), nota.getAmbiente(), nota.getCnpj(), String.valueOf(nota.getId()) + "_prot.xml", nota.getDataGerada(), nota.getMotivoErro() != null && !nota.getMotivoErro().isEmpty(), idUsuario);
                    System.out.println("Depois de criar o arquivo e o xml");
                    fileProt = filename = this.former.getFilename();
                    System.out.println("File send name:" + filename);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (PropriedadesMain.isEmail() && email) {
                    try {
                        if (filename != null && this.sender != null) {
                            String cnpjtransp = ImprimirDANFEImpl.obterCNPJTransp(nota.getXmlString());
                            SendEmailThread sendert = new SendEmailThread(this, this.sender, nota.getId(), nota.getAmbiente(), nota.getCnpj(), nota.getCnpjDestino(), cnpjtransp, new String[]{filename}, path);
                            Thread t = new Thread(sendert);
                            t.start();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                xmlFile = null;
                if (PropriedadesMain.isPrintfile()) {
                    String file = "";
                    if (path != null) {
                        file = String.valueOf(path) + "/";
                    }
                    file = fileProt;
                    System.out.println("Printing file: " + file);
                    try {
                        xmlFile = ImprimirDANFEImpl.lerArquivo(fileProt);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (xmlFile == null) {
                        file = PathFileFinder.getINSTANCE().findXMLFile(nota.getId(), nota.getAmbiente(), nota.getDataGerada());
                        System.out.println("Printing file: " + file);
                        try {
                            xmlFile = ImprimirDANFEImpl.lerArquivo(file);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (xmlFile == null) {
                        xmlFile = nota.getXmlString();
                    }
                } else {
                    xmlFile = nota.getXmlString();
                    String prot = nota.getProtocoloXML();
                    if (prot != null && !prot.trim().isEmpty()) {
                        prot = prot.replaceFirst("<\\?xml[^>]+>", "");
                        prot = prot.replace("xmlns=\"http://www.portalfiscal.inf.br/nfe\" xmlns=\"http://www.w3.org/2000/09/xmldsig#\"", "xmlns=\"http://www.portalfiscal.inf.br/nfe\"");
                        prot = prot.trim();
                    }
                    xmlFile = prot != null && prot.contains("<protNFe") ? "<nfeProc>" + xmlFile + prot + "</nfeProc>" : "<nfeProc>" + xmlFile + "</nfeProc>";
                }
                print = "";
                if (PropriedadesMain.isPrinter()) {
                    print = PrintFinder.getInstance().findPrint(nota.getId());
                }
                protocolo = "";
                if (nota.getProtocolo() != null) {
                    protocolo = ImprimirDANFEImpl.makeFormat(nota.getProtocolo().replace("|", " "));
                }
                prop = new Hashtable<String, String>();
                System.out.println("Protocolo: " + protocolo);
                System.out.println("Printer: " + print);
                prop.put("PROTOCOLO", protocolo);
                prop.put("PARAMETROSCRIPT1", print);
                if (nota.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.CANCELADA)) {
                    prop.put("CANCELADA", nota.getId());
                }
                try {
                    String sql = "SELECT o FROM EventoInfo as o where o.event.infEvento.chNFe = '" + nota.getId().replace("NFe", "") + "' and o.estado = :e order by o.event.infEvento.nSeqEvento desc ";
                    Query query = this.daoEvento.criarQuery(sql);
                    query.setParameter("e", (Object)EstadoNFe.ESTADO_NFE.AUTORIZADA);
                    List result = query.getResultList();
                    if (result.size() <= 0) break block78;
                    String data = "";
                    String correcao = "";
                    try {
                        EventoInfo cce = (EventoInfo)result.get(0);
                        String dataformated = cce.getEvent().getInfEvento().getDhEvento();
                        dataformated = dataformated.replace("-02:00", "");
                        dataformated = dataformated.replace("-03:00", "");
                        if (dataformated.indexOf("|") > 0) {
                            String[] dt = dataformated.split("\\|", -1);
                            dataformated = dt[1];
                        }
                        data = sdfcceBrazil.format(sdfcce.parse(dataformated));
                        correcao = cce.getEvent().getInfEvento().getDetEvento().getXCorrecao();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    System.out.println(correcao);
                    prop.put("CORRECAO", "CARTA DE CORRECAO|DATA DE EMISSAO: " + data + "|" + correcao);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (xmlFile.contains("01771935000215") && xmlFile.contains("01771935001610")) {
                tipo = "PDF";
            }
            if (infoMarketplace != null && !infoMarketplace.isEmpty() && infoMarketplace.indexOf(124) > 0) {
                try {
                    GerenciadorChavesNota c;
                    FileWriter fw123;
                    String newLine = infoMarketplace;
                    String pedido = "";
                    String demi = "";
                    if (newLine.split("\\|", -1).length > 2) {
                        pedido = newLine.split("\\|", -1)[1];
                        demi = newLine.split("\\|", -1)[2];
                    } else {
                        pedido = newLine.split("\\|", -1)[0];
                        if (newLine.split("\\|", -1).length > 1) {
                            demi = newLine.split("\\|", -1)[1];
                        }
                    }
                    if (newLine.contains("OLIST")) {
                        if (rb != null && rb.containsKey("caminho_webservice")) {
                            fw123 = new FileWriter(new File(rb.getString("caminho_webservice")).getAbsoluteFile() + File.separator + nota.getId() + "_" + pedido + ".txt");
                            fw123.write(pedido);
                            fw123.close();
                        }
                    } else if (newLine.contains("ANYM")) {
                        if (rb != null && rb.containsKey("caminho_anym")) {
                            fw123 = new FileWriter(new File(rb.getString("caminho_anym")).getAbsoluteFile() + File.separator + nota.getId() + "_" + pedido + ".txt");
                            c = new GerenciadorChavesNota(nota.getId());
                            fw123.write(String.valueOf(nota.getId()) + "|" + c.getNumeroNota() + "|" + c.getSerie() + "|" + demi + "|" + pedido);
                            fw123.close();
                        }
                    } else if (newLine.contains("INFR")) {
                        if (rb != null && rb.containsKey("caminho_infracommerce")) {
                            fw123 = new FileWriter(new File(rb.getString("caminho_infracommerce")).getAbsoluteFile() + File.separator + nota.getId() + "_" + pedido + ".txt");
                            c = new GerenciadorChavesNota(nota.getId());
                            fw123.write(String.valueOf(nota.getId()) + "|" + c.getNumeroNota() + "|" + c.getSerie() + "|" + demi + "|" + pedido);
                            fw123.close();
                        }
                    } else if (newLine.contains("Site") && rb != null && rb.containsKey("caminho_site")) {
                        fw123 = new FileWriter(new File(rb.getString("caminho_site")).getAbsoluteFile() + File.separator + nota.getId() + "_" + pedido + ".txt");
                        fw123.write(infoMarketplace.replace("Site|", ""));
                        fw123.close();
                    }
                    if (!tipo.contains("MINIDANFE") && !tipo.contains("IMPRIMIR/PDF")) break block79;
                    XMLGenerator xmls = new XMLGenerator("br.com.tti.nfev310");
                    TNFe tnfe1 = (TNFe)((JAXBElement)xmls.toObject(nota.getXmlString())).getValue();
                    long qVol = 0L;
                    for (TNFe.InfNFe.Transp.Vol v : tnfe1.getInfNFe().getTransp().getVol()) {
                        qVol += new Long(v.getQVol()).longValue();
                    }
                    String TXT = String.valueOf(tnfe1.getInfNFe().getId()) + "|" + protocolo + "|" + ((TNFe.InfNFe.Det)tnfe1.getInfNFe().getDet().get(0)).getProd().getCFOP() + "|" + tnfe1.getInfNFe().getIde().getTpNF() + "|" + tnfe1.getInfNFe().getIde().getNNF() + "|" + tnfe1.getInfNFe().getIde().getSerie() + "|" + tnfe1.getInfNFe().getIde().getDhEmi() + "|" + tnfe1.getInfNFe().getEmit().getXNome() + "|" + tnfe1.getInfNFe().getEmit().getEnderEmit().getUF() + "|" + (tnfe1.getInfNFe().getEmit().getCNPJ() != null && !tnfe1.getInfNFe().getEmit().getCNPJ().equals("") ? tnfe1.getInfNFe().getEmit().getCNPJ() : tnfe1.getInfNFe().getEmit().getCPF()) + "|" + tnfe1.getInfNFe().getEmit().getIE() + "|" + tnfe1.getInfNFe().getDest().getXNome() + "|" + tnfe1.getInfNFe().getDest().getEnderDest().getXLgr() + "|" + tnfe1.getInfNFe().getDest().getEnderDest().getNro() + "|" + tnfe1.getInfNFe().getDest().getEnderDest().getXBairro() + "|" + tnfe1.getInfNFe().getDest().getEnderDest().getCEP() + "|" + tnfe1.getInfNFe().getDest().getEnderDest().getXMun() + "|" + tnfe1.getInfNFe().getDest().getEnderDest().getUF() + "|" + (tnfe1.getInfNFe().getDest().getCNPJ() != null && !tnfe1.getInfNFe().getDest().getCNPJ().equals("") ? tnfe1.getInfNFe().getDest().getCNPJ() : tnfe1.getInfNFe().getDest().getCPF()) + "|" + (tnfe1.getInfNFe().getDest().getIE() == null ? "" : tnfe1.getInfNFe().getDest().getIE()) + "|" + tnfe1.getInfNFe().getTotal().getICMSTot().getVNF() + "|" + "87/2015" + "|" + "|" + "|" + "|" + tnfe1.getInfNFe().getInfAdic().getInfCpl();
                    if (tnfe1.getInfNFe().getEntrega() != null) {
                        TXT = String.valueOf(TXT) + "|" + tnfe1.getInfNFe().getEntrega().getCPF();
                    }
                    TXT = String.valueOf(TXT) + "|" + qVol;
                    TXT = String.valueOf(TXT) + "\n";
                    if (!tipo.contains("MINIDANFE/VIEW") && !tipo.contains("MINIDANFE/TXT")) {
                        String caminhoMiniDanfe = null;
                        try {
                            if (rb != null && rb.containsKey("caminho_mini_danfe") && (caminhoMiniDanfe = rb.getString("caminho_mini_danfe")) != null && !caminhoMiniDanfe.equals("")) {
                                FileWriter fw1232 = new FileWriter(new File(caminhoMiniDanfe).getAbsoluteFile() + File.separator + nota.getId() + "_" + pedido + ".txt");
                                fw1232.write(String.valueOf(pedido) + "|" + TXT);
                                fw1232.close();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (tipo.contains("MINIDANFE")) {
                        tipo = "IMPRIMIR/PDF";
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        prop.put("PARAMETROSCRIPT2", tipo);
        prop.put("DATAGERADA", dfnormal.format(nota.getDataGerada()));
        String boleto = "";
        try {
            if (PropriedadesMain.isBoleto() && (boleto = BoletoManager.getXmls().get(nota.getId())) != null) {
                System.out.println("BOLETO:" + boleto);
                prop.put("BOLETO", boleto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Imprimindo DANFE da Nota " + nota.getId() + " em impressora: " + print);
        try {
            xmlFile = this.tirarCabecalho(xmlFile);
            if (nota.getModoOperacao() == PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC || nota.getModoOperacao() == PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC) {
                System.out.println("Imprimindo modo DPEC");
                GerenciadorProxy.notificarImpressao(nota.getId(), "dpec", xmlFile, prop);
                NFeLogger.log(nota.getId(), nota.getAmbiente(), nota.getModoOperacao(), EstadoNFe.ESTADO_NFE.IMPRESSA_CONT, null, idUsuario);
            }
            if (nota.getModoOperacao() == PropriedadesSistema.MODO_OP.CONTINGENCIA) {
                CacheNotas.obterInstancia().ajustarImpressaCont(nota.getId(), nota.getAmbiente());
                GerenciadorProxy.notificarImpressao(nota.getId(), "Contingencia", xmlFile, prop);
                NFeLogger.log(nota.getId(), nota.getAmbiente(), nota.getModoOperacao(), EstadoNFe.ESTADO_NFE.IMPRESSA_CONT, null, idUsuario);
            }
            if (nota.getModoOperacao() == PropriedadesSistema.MODO_OP.NORMAL || nota.getModoOperacao() == PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN || nota.getModoOperacao() == PropriedadesSistema.MODO_OP.SVC_RS || nota.getModoOperacao() == PropriedadesSistema.MODO_OP.SVC_AN) {
                GerenciadorProxy.notificarImpressao(nota.getId(), "Normal", xmlFile, prop);
                NFeLogger.log(nota.getId(), nota.getAmbiente(), nota.getModoOperacao(), EstadoNFe.ESTADO_NFE.IMPRESSA_NORMAL, null, idUsuario);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (casoUnilog) {
            try {
                boolean ok = barrier.awaitQuiescence(30L, TimeUnit.SECONDS);
                if (!ok) {
                    System.out.println("Aviso: threads ainda ativas ap\u00c3\u00b3s 30s; seguindo assim mesmo.");
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            String pdfDir = PathFileFinder.getINSTANCE().findPDFPath(idNota, ambiente, dataGerada);
            Path pdf = Paths.get(pdfDir, String.valueOf(idNota) + ".pdf");
            PdfReadyChecker.Config cfg = new PdfReadyChecker.Config();
            cfg.minStableMillis = 2000L;
            cfg.checkPdfEof = true;
            cfg.trySharedLock = true;
            cfg.tryPdfBoxOpen = false;
            cfg.hardTimeoutMillis = TimeUnit.SECONDS.toMillis(45L);
            try {
                PdfReadyChecker.Result ok = PdfReadyChecker.waitUntilReady(pdf, cfg);
                if (!ok.ready) {
                    System.out.println("PDF ainda n\u00c3\u00a3o pronto: " + ok.reason);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (fileProt == null) {
                System.out.println("procNFe n\u00c3\u00a3o encontrado para nota " + nota.getId());
            } else {
                UnilogZ025 z = UnilogZ025.parseFromMotivo(motivoErro);
                Path proc = Paths.get(fileProt, new String[0]);
                Path inbox = Paths.get(rb.getString("caminho_unilog"), new String[0]);
                try {
                    String idempotency = null;
                    String overrideUrlBillings = null;
                    String overrideUrlOutbounds = null;
                    Integer warehouseCode = 8;
                    if (!nota_cancelada) {
                        Path txt = NfeTxtGenerator.generateTxtAuto(proc, inbox, z, idempotency, overrideUrlBillings, overrideUrlOutbounds, warehouseCode);
                        System.out.println("UNILOG Gerado: " + txt);
                    } else {
                        String id = nota.getId();
                        if (id.charAt(0) > '9') {
                            id = id.substring(3);
                        }
                        Path txt = NfeTxtGenerator.generateTxtOutboundCancellation(proc, nota.getCnpj(), inbox, z, idempotency, overrideUrlBillings, overrideUrlOutbounds, warehouseCode, id);
                        System.out.println("UNILOG Gerado Cancelamento: " + txt);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Erro ao gerar o txt da UNILOG EXPRESS");
                }
            }
        }
    }

    public String obterTxtMiniDanfe(EstadoNFe nota, String tipo, boolean email, String etiquetas) {
        String TXT;
        block10: {
            String dadosMarketplace;
            System.out.println("Obtendo TXT da Mini-DANFE da Nota " + nota.getId());
            TXT = "";
            String protocolo = "";
            if (nota.getProtocolo() != null) {
                protocolo = ImprimirDANFEImpl.makeFormat(nota.getProtocolo().replace("|", " "));
            }
            if ((dadosMarketplace = this.obterInfoMarketplace(nota)) != null && !dadosMarketplace.isEmpty()) {
                try {
                    String newLine = dadosMarketplace;
                    String pedido = newLine.split("\\|", -1)[1];
                    String demi = newLine.split("\\|", -1)[2];
                    if (!tipo.contains("MINIDANFE") && !tipo.contains("IMPRIMIR/PDF")) break block10;
                    XMLGenerator xmls = new XMLGenerator("br.com.tti.nfev310");
                    TNFe tnfe1 = (TNFe)((JAXBElement)xmls.toObject(nota.getXmlString())).getValue();
                    long qVol = 0L;
                    for (TNFe.InfNFe.Transp.Vol v : tnfe1.getInfNFe().getTransp().getVol()) {
                        qVol += new Long(v.getQVol()).longValue();
                    }
                    TXT = String.valueOf(tnfe1.getInfNFe().getId()) + "|" + protocolo + "|" + ((TNFe.InfNFe.Det)tnfe1.getInfNFe().getDet().get(0)).getProd().getCFOP() + "|" + tnfe1.getInfNFe().getIde().getTpNF() + "|" + tnfe1.getInfNFe().getIde().getNNF() + "|" + tnfe1.getInfNFe().getIde().getSerie() + "|" + tnfe1.getInfNFe().getIde().getDhEmi() + "|" + tnfe1.getInfNFe().getEmit().getXNome() + "|" + tnfe1.getInfNFe().getEmit().getEnderEmit().getUF() + "|" + (tnfe1.getInfNFe().getEmit().getCNPJ() != null && !tnfe1.getInfNFe().getEmit().getCNPJ().equals("") ? tnfe1.getInfNFe().getEmit().getCNPJ() : tnfe1.getInfNFe().getEmit().getCPF()) + "|" + tnfe1.getInfNFe().getEmit().getIE() + "|" + tnfe1.getInfNFe().getDest().getXNome() + "|" + tnfe1.getInfNFe().getDest().getEnderDest().getXLgr() + "|" + tnfe1.getInfNFe().getDest().getEnderDest().getNro() + "|" + tnfe1.getInfNFe().getDest().getEnderDest().getXBairro() + "|" + tnfe1.getInfNFe().getDest().getEnderDest().getCEP() + "|" + tnfe1.getInfNFe().getDest().getEnderDest().getXMun() + "|" + tnfe1.getInfNFe().getDest().getEnderDest().getUF() + "|" + (tnfe1.getInfNFe().getDest().getCNPJ() != null && !tnfe1.getInfNFe().getDest().getCNPJ().equals("") ? tnfe1.getInfNFe().getDest().getCNPJ() : tnfe1.getInfNFe().getDest().getCPF()) + "|" + (tnfe1.getInfNFe().getDest().getIE() == null ? "" : tnfe1.getInfNFe().getDest().getIE()) + "|" + tnfe1.getInfNFe().getTotal().getICMSTot().getVNF() + "|" + "87/2015" + "|" + "|" + "|" + "|" + tnfe1.getInfNFe().getInfAdic().getInfCpl() + "|" + tnfe1.getInfNFe().getEntrega().getCPF() + "|" + qVol + "\n";
                    if (!tipo.contains("MINIDANFE/VIEW") && !tipo.contains("MINIDANFE/TXT")) {
                        String caminhoMiniDanfe = null;
                        try {
                            ResourceBundle rb = ResourceBundle.getBundle("olist");
                            if (rb != null && rb.containsKey("caminho_mini_danfe") && (caminhoMiniDanfe = rb.getString("caminho_mini_danfe")) != null && !caminhoMiniDanfe.equals("")) {
                                FileWriter fw123 = new FileWriter(new File(caminhoMiniDanfe).getAbsoluteFile() + File.separator + nota.getId() + "_" + pedido + ".txt");
                                fw123.write(String.valueOf(pedido) + "|" + TXT);
                                fw123.close();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (tipo.contains("MINIDANFE")) {
                        tipo = "IMPRIMIR/PDF";
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return TXT;
    }

    public byte[] obterPdfMiniDanfe(EstadoNFe nota, String tipo, boolean email, String etiquetas) {
        String dadosMarketplacePdf;
        System.out.println("Obtendo PDF da Mini-DANFE da Nota " + nota.getId());
        byte[] bytes = null;
        String protocolo = "";
        if (nota.getProtocolo() != null) {
            protocolo = ImprimirDANFEImpl.makeFormat(nota.getProtocolo().replace("|", " "));
        }
        if ((dadosMarketplacePdf = this.obterInfoMarketplace(nota)) != null && !dadosMarketplacePdf.isEmpty()) {
            try {
                String newLine = dadosMarketplacePdf;
                String pedido = newLine.split("\\|", -1)[1];
                String demi = newLine.split("\\|", -1)[2];
                if (tipo.contains("MINIDANFE") || tipo.contains("IMPRIMIR/PDF")) {
                    XMLGenerator xmls = new XMLGenerator("br.com.tti.nfev310");
                    TNFe tnfe1 = (TNFe)((JAXBElement)xmls.toObject(nota.getXmlString())).getValue();
                    String chave = tnfe1.getInfNFe().getId().substring(3);
                    String cfop = ((TNFe.InfNFe.Det)tnfe1.getInfNFe().getDet().get(0)).getProd().getCFOP().replaceAll(".", "");
                    String sCfop = String.valueOf(((TNFe.InfNFe.Det)tnfe1.getInfNFe().getDet().get(0)).getProd().getCFOP().substring(0, 1)) + "." + ((TNFe.InfNFe.Det)tnfe1.getInfNFe().getDet().get(0)).getProd().getCFOP().substring(1);
                    cfop = ResourceBundle.getBundle("cfop").getString(sCfop);
                    cfop = cfop == null ? "" : cfop.toUpperCase();
                    String entrada_saida = tnfe1.getInfNFe().getIde().getTpNF();
                    String numero_nota = tnfe1.getInfNFe().getIde().getNNF();
                    String serie_nota = tnfe1.getInfNFe().getIde().getSerie();
                    String data_emissao = tnfe1.getInfNFe().getIde().getDhEmi();
                    String emitente_nome = tnfe1.getInfNFe().getEmit().getXNome();
                    String emitente_uf = tnfe1.getInfNFe().getEmit().getEnderEmit().getUF().value();
                    String emitente_cnpj_cpf = tnfe1.getInfNFe().getEmit().getCNPJ() != null && !tnfe1.getInfNFe().getEmit().getCNPJ().equals("") ? tnfe1.getInfNFe().getEmit().getCNPJ() : tnfe1.getInfNFe().getEmit().getCPF();
                    String emitente_ie = tnfe1.getInfNFe().getEmit().getIE();
                    String destinatario_nome = tnfe1.getInfNFe().getDest().getXNome();
                    String destinatario_xlgr = tnfe1.getInfNFe().getDest().getEnderDest().getXLgr();
                    String destinatario_nro = tnfe1.getInfNFe().getDest().getEnderDest().getNro();
                    String destinatario_xbairro = tnfe1.getInfNFe().getDest().getEnderDest().getXBairro();
                    String destinatario_cep = tnfe1.getInfNFe().getDest().getEnderDest().getCEP();
                    String destinatario_xmun = tnfe1.getInfNFe().getDest().getEnderDest().getXMun();
                    String destinatario_uf = tnfe1.getInfNFe().getDest().getEnderDest().getUF().value();
                    String destinatario_cnpj_cpf = tnfe1.getInfNFe().getDest().getCNPJ() != null && !tnfe1.getInfNFe().getDest().getCNPJ().equals("") ? tnfe1.getInfNFe().getDest().getCNPJ() : tnfe1.getInfNFe().getDest().getCPF();
                    String destinatario_ie = tnfe1.getInfNFe().getDest().getIE() == null ? "" : tnfe1.getInfNFe().getDest().getIE();
                    String total_nota_fiscal = tnfe1.getInfNFe().getTotal().getICMSTot().getVNF();
                    String EC = "87/2015";
                    String total_FECP = "";
                    String total_ICMS_uf_origem = "";
                    String total_ICMS_uf_destino = "";
                    String observacao = tnfe1.getInfNFe().getInfAdic().getInfCpl();
                    String entrega = tnfe1.getInfNFe().getEntrega().getCPF();
                    String remessa = observacao.substring(observacao.indexOf("# Remessa: ") + 11, observacao.indexOf("#", observacao.indexOf("# Remessa: ") + 11));
                    if (remessa == null) {
                        remessa = "";
                    }
                    long qVol = 0L;
                    for (TNFe.InfNFe.Transp.Vol v : tnfe1.getInfNFe().getTransp().getVol()) {
                        qVol += new Long(v.getQVol()).longValue();
                    }
                    JRDataSourceGeneric rsReport = new JRDataSourceGeneric();
                    rsReport.add(chave, protocolo, cfop, entrada_saida, numero_nota, serie_nota, data_emissao, emitente_nome, emitente_uf, emitente_cnpj_cpf, emitente_ie, destinatario_nome, destinatario_xlgr, destinatario_nro, destinatario_xbairro, destinatario_cep, destinatario_xmun, destinatario_uf, destinatario_cnpj_cpf, destinatario_ie, total_nota_fiscal, EC, total_FECP, total_ICMS_uf_origem, total_ICMS_uf_destino, remessa, observacao, Long.toString(qVol));
                    String pathRoot = ConfiguracaoSys.configuracao.getConfiguracaoSistema().getConf().getDiretorioArquivos();
                    if (pathRoot == null) {
                        pathRoot = "/opt/TTINFe";
                    }
                    HashMap<String, String> hm = new HashMap<String, String>();
                    File f = new File(String.valueOf(pathRoot) + "/logo/logo.png");
                    if (f.exists()) {
                        hm.put("imagens", String.valueOf(pathRoot) + "/logo/logo.png");
                    }
                    JasperPrint jprint = JasperFillManager.fillReport((String)(String.valueOf(pathRoot) + "/jasper/mini_DANFE.jasper"), hm, (JRDataSource)rsReport);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    JRPdfExporter exporter = new JRPdfExporter();
                    SimpleJasperReportsContext jrc = new SimpleJasperReportsContext();
                    JasperExportManager jem = JasperExportManager.getInstance((JasperReportsContext)jrc);
                    JasperExportManager.exportReportToPdfStream((JasperPrint)jprint, (OutputStream)bos);
                    bytes = bos.toByteArray();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bytes;
    }

    private void addCorrecao(String xml) {
        if (xml.contains("<infAdic>")) {
            int pos1 = xml.indexOf("<infAdic>");
            int n = xml.indexOf("</infAdic>");
        }
    }

    @Override
    public void imprimirLote(String idLote, String tpAmb, String idUsuario) {
        EntidadeId loteId = new EntidadeId(idLote, tpAmb);
        EstadoLote lote = this.daoLote.buscarPorIdObject(loteId);
        if (lote != null) {
            this.daoLote.refresh(lote);
            Set<EstadoNFe> notas = lote.getNotas();
            if (notas != null) {
                for (EstadoNFe estadoNFe : notas) {
                    this.imprimirNota(estadoNFe, "IMPRIMIR/PDF", true, null, idUsuario);
                }
            }
        }
    }

    @Override
    public void imprimirNota(String idNota, String tpAmb, String tipo, boolean email, String etiqueta, String idUsuario) {
        EstadoNFe nota = null;
        try {
            nota = GerenciadorProxy.getGerenciador().getEstadoNFe(idNota, tpAmb);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.imprimirNota(nota, tipo, email, etiqueta, idUsuario);
    }

    public String obterTxtMiniDanfe(String idNota, String tpAmb, String tipo, boolean email, String etiqueta) {
        EstadoNFe nota = null;
        try {
            nota = GerenciadorProxy.getGerenciador().getEstadoNFe(idNota, tpAmb);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.obterTxtMiniDanfe(nota, tipo, email, etiqueta);
    }

    public byte[] obterPdfMiniDanfe(String idNota, String tpAmb, String tipo, boolean email, String etiqueta) {
        EstadoNFe nota = null;
        try {
            nota = GerenciadorProxy.getGerenciador().getEstadoNFe(idNota, tpAmb);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.obterPdfMiniDanfe(nota, tipo, email, etiqueta);
    }

    public static String lerArquivo(String file) {
        String xml = "";
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        String linha = "";
        String coding = "ISO-8859-1";
        coding = PropriedadesMain.isUtf() ? "ISO-8859-1" : "UTF-8";
        BufferedReader r = new BufferedReader(new InputStreamReader(fis));
        try {
            while ((linha = r.readLine()) != null) {
                xml = String.valueOf(xml) + linha;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fis.close();
            r.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return xml;
    }

    public static void main(String[] args) {
        String xml = ImprimirDANFEImpl.lerArquivo("C:/TNFMP4N000000000005478S00280273000218R02101894000131D20100607.xml");
    }

    public void enviarEmailFiles(String idNota, String tpAmb, String emails, boolean pdf, boolean xml, boolean cce) throws Exception {
        File f;
        EstadoNFe nota = null;
        try {
            nota = GerenciadorProxy.getGerenciador().getEstadoNFe(idNota, tpAmb);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        String xmlfilename = null;
        Vector<String> files = new Vector<String>();
        if (xml && (f = new File(xmlfilename = PathFileFinder.getINSTANCE().findXMLProtFile(nota.getId(), tpAmb, nota.getDataGerada()))).exists()) {
            files.add(xmlfilename);
        }
        String pdffilename = null;
        if (pdf) {
            pdffilename = PathFileFinder.getINSTANCE().findPDFPath(nota.getId(), tpAmb, nota.getDataGerada());
            File f2 = new File(pdffilename = String.valueOf(pdffilename) + "/" + idNota + ".pdf");
            if (f2.exists()) {
                files.add(pdffilename);
            }
        }
        String ccefilename = null;
        if (cce) {
            ccefilename = PathFileFinder.getINSTANCE().findXMLEventoPath(idNota, tpAmb, nota.getDataGerada());
            File f3 = new File(ccefilename = String.valueOf(ccefilename) + "/" + idNota.replace("NFe", "CCe") + ".xml");
            if (f3.exists()) {
                files.add(ccefilename);
            }
            ccefilename = PathFileFinder.getINSTANCE().findPDFPath(idNota, tpAmb, nota.getDataGerada());
            ccefilename = String.valueOf(pdffilename) + "/" + idNota.replace("NFe", "") + "_CCe.pdf";
            f3 = new File(ccefilename);
            if (f3.exists()) {
                files.add(ccefilename);
            }
        }
        System.out.println("files:" + files.toString());
        String[] filess = new String[files.size()];
        files.toArray(filess);
        this.sender.sendCNPJDBEmail(idNota, tpAmb, emails, filess);
    }

    public void enviarEmailBoleto(String idNota, String tpAmb, String emails) throws Exception {
        EstadoNFe nota = null;
        try {
            nota = GerenciadorProxy.getGerenciador().getEstadoNFe(idNota, tpAmb);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        Vector<String> files = new Vector<String>();
        String pathDanfeBoleto = PathFileFinder.getINSTANCE().findPDFPath(idNota, tpAmb, nota.getDataGerada());
        pathDanfeBoleto = pathDanfeBoleto.replace("PDF", "BOLETOS");
        pathDanfeBoleto = String.valueOf(pathDanfeBoleto) + "/" + idNota + ".pdf";
        File f = new File(pathDanfeBoleto);
        if (f.exists()) {
            files.add(pathDanfeBoleto);
        }
        System.out.println("files:" + files.toString());
        String[] filess = new String[files.size()];
        files.toArray(filess);
        this.sender.sendCNPJDBEmail(idNota, tpAmb, emails, filess);
    }

    @Override
    public void enviarDenegadaEmail(String idNota, String tpAmb) throws Exception {
        EstadoNFe nota = null;
        try {
            nota = GerenciadorProxy.getGerenciador().getEstadoNFe(idNota, tpAmb);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        System.out.println("Enviando XML da Nota " + nota.getId());
        GerenciadorChavesNota chave = new GerenciadorChavesNota(nota.getId());
        String filename = null;
        String path = null;
        try {
            path = this.former.createDenegadaFile(nota.getId(), tpAmb, nota.getCnpj(), String.valueOf(nota.getId()) + "_prot.xml", nota.getDataGerada());
            filename = this.former.getFilename();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void enviarEmail(String idNota, String tpAmb) throws Exception {
        EstadoNFe nota = null;
        try {
            nota = GerenciadorProxy.getGerenciador().getEstadoNFe(idNota, tpAmb);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        System.out.println("Enviando XML da Nota " + nota.getId());
        GerenciadorChavesNota chave = new GerenciadorChavesNota(nota.getId());
        String filename = null;
        String path = null;
        try {
            path = this.former.createFile(nota.getId(), tpAmb, nota.getCnpj(), String.valueOf(nota.getId()) + "_prot.xml", nota.getDataGerada(), nota.getMotivoErro() != null && !nota.getMotivoErro().isEmpty());
            filename = this.former.getFilename();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (PropriedadesMain.isEmail()) {
            try {
                if (filename != null && this.sender != null) {
                    String cnpjtransp = ImprimirDANFEImpl.obterCNPJTransp(nota.getXmlString());
                    SendEmailThread sendert = new SendEmailThread(this, this.sender, nota.getId(), tpAmb, nota.getCnpj(), nota.getCnpjDestino(), cnpjtransp, new String[]{filename}, path);
                    Thread t = new Thread(sendert);
                    t.start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public void enviarEmail2_DEPRECATED(String idNota, String tpAmb, String idUsuario) throws Exception {
        EstadoNFe nota = null;
        try {
            nota = GerenciadorProxy.getGerenciador().getEstadoNFe(idNota, tpAmb);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        System.out.println("Enviando XML da Nota " + nota.getId());
        GerenciadorChavesNota chave = new GerenciadorChavesNota(nota.getId());
        String filename = null;
        String path = null;
        try {
            path = this.former.createFile(nota.getId(), tpAmb, nota.getCnpj(), "NFe_" + chave.getCnpj() + "_" + Integer.parseInt(chave.getSerie()) + "_" + chave.getNumeroNota() + "_prot.xml", nota.getDataGerada(), nota.getMotivoErro() != null && !nota.getMotivoErro().isEmpty());
            filename = this.former.getFilename();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (PropriedadesMain.isEmail()) {
            try {
                if (filename != null && this.sender != null) {
                    String cnpjtransp = ImprimirDANFEImpl.obterCNPJTransp(nota.getXmlString());
                    SendEmailThread sendert = new SendEmailThread(this, this.sender, nota.getId(), tpAmb, nota.getCnpj(), nota.getCnpjDestino(), cnpjtransp, new String[]{filename}, path);
                    Thread t = new Thread(sendert);
                    t.start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String xmlFile = null;
        if (PropriedadesMain.isPrintfile()) {
            String file = "";
            if (path != null) {
                file = String.valueOf(path) + "/";
            }
            file = PathFileFinder.getINSTANCE().findXMLFileOld(nota.getId(), tpAmb, nota.getDataGerada());
            System.out.println("Printing file: " + file);
            try {
                xmlFile = ImprimirDANFEImpl.lerArquivo(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (xmlFile == null) {
                xmlFile = nota.getXmlString();
            }
        } else {
            xmlFile = nota.getXmlString();
        }
        String print = "";
        if (PropriedadesMain.isPrinter()) {
            print = PrintFinder.getInstance().findPrint(nota.getId());
        }
        String protocolo = "";
        if (nota.getProtocolo() != null) {
            protocolo = ImprimirDANFEImpl.makeFormat(nota.getProtocolo().replace("|", " "));
        }
        Hashtable<String, String> prop = new Hashtable<String, String>();
        System.out.println("Protocolo: " + protocolo);
        System.out.println("Printer: " + print);
        prop.put("PROTOCOLO", protocolo);
        prop.put("PARAMETROSCRIPT1", print);
        prop.put("PARAMETROSCRIPT2", "PDF");
        prop.put("DATAGERADA", dfnormal.format(nota.getDataGerada()));
        String boleto = "";
        try {
            if (PropriedadesMain.isBoleto() && (boleto = BoletoManager.getXmls().get(nota.getId())) != null) {
                System.out.println("BOLETO:" + boleto);
                prop.put("BOLETO", boleto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Gerando PDF DANFE da Nota " + nota.getId() + " em impressora: " + print);
        try {
            xmlFile = this.tirarCabecalho(xmlFile);
            if (nota.getModoOperacao() == PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC) {
                System.out.println("Imprimindo modo DPEC");
                GerenciadorProxy.notificarImpressao(nota.getId(), "dpec", xmlFile, prop);
                NFeLogger.log(nota.getId(), nota.getAmbiente(), nota.getModoOperacao(), EstadoNFe.ESTADO_NFE.IMPRESSA_CONT, null, idUsuario);
            }
            if (nota.getModoOperacao() == PropriedadesSistema.MODO_OP.CONTINGENCIA) {
                CacheNotas.obterInstancia().ajustarImpressaCont(nota.getId(), nota.getAmbiente());
                GerenciadorProxy.notificarImpressao(nota.getId(), "Contingencia", xmlFile, prop);
                NFeLogger.log(nota.getId(), nota.getAmbiente(), nota.getModoOperacao(), EstadoNFe.ESTADO_NFE.IMPRESSA_CONT, null, idUsuario);
            }
            if (nota.getModoOperacao() == PropriedadesSistema.MODO_OP.NORMAL || nota.getModoOperacao() == PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN) {
                GerenciadorProxy.notificarImpressao(nota.getId(), "Normal", xmlFile, prop);
                NFeLogger.log(nota.getId(), nota.getAmbiente(), nota.getModoOperacao(), EstadoNFe.ESTADO_NFE.IMPRESSA_NORMAL, null, idUsuario);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void reImprimirBoleto(String idNota, String tpAmb) throws Exception {
    }
}

