/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.dpec;

import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import br.com.tti.dpec.classes.TDPEC;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class CheckNFeDPEC {
    private static String file = ".dpec_nfe";
    private static Vector<String> nfes = new Vector();
    private static FileWriter fw;

    public CheckNFeDPEC() {
        CheckNFeDPEC.loadDPECs();
    }

    private static void loadDPECs() {
        File[] files;
        String dir = ConfiguracaoSys.getPastaWrapper();
        XMLGenerator xmlDpec = new XMLGenerator("br.com.tti.dpec.classes");
        File f = new File(dir);
        File[] fileArray = files = f.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            System.out.println(file.getName());
            if (file.getName().startsWith("DPEC")) {
                try {
                    TDPEC dpec = (TDPEC)xmlDpec.toObjectFromFile(file);
                    List<TDPEC.InfDPEC.ResNFe> res = dpec.getInfDPEC().getResNFe();
                    for (TDPEC.InfDPEC.ResNFe resNFe : res) {
                        System.out.println(resNFe.getChNFe());
                        nfes.add("NFe" + resNFe.getChNFe());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        try {
            fw = new FileWriter(file, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadFile() {
        try {
            FileInputStream fs = new FileInputStream(file);
            DataInputStream is = new DataInputStream(fs);
            String line = is.readLine();
            while (line != null) {
                nfes.add(line);
                line = is.readLine();
            }
            is.close();
            fs.close();
        }
        catch (Exception e) {
            try {
                fw = new FileWriter(file, true);
            }
            catch (Exception e1) {
                e.printStackTrace();
            }
        }
        try {
            fw = new FileWriter(file, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isNFeDPEC(String nfe) {
        return nfes.contains(nfe);
    }

    public void registerNFe(String nfe) {
        try {
            nfes.add(nfe);
            fw.append(String.valueOf(nfe) + "\n");
            fw.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

