/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.dpec.sender;

import br.com.taragona.nfe.clientreferencia.ReferenciaGerenciador;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.sender.DispatchFactory;
import br.com.taragona.nfe.sender.InvokerDispatch;
import br.com.taragona.nfe.serviceclients.ConfigurarSSLProperties;
import br.com.taragona.nfe.util.EnviarNota;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.SenderConf;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import br.com.tti.dpec.classes.TRetDPEC;
import java.rmi.RemoteException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;

public class SenderDPEC {
    private SenderConf config;
    private DispatchFactory dFactory;
    private InvokerDispatch dInvoker;

    public SenderDPEC(GerenciadorInterface gerenciador) {
        try {
            this.config = gerenciador.obterSenderConfig();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this.dFactory = new DispatchFactory();
        this.dInvoker = new InvokerDispatch();
        this.dFactory.setUrlServicosDpecProd(this.config.getUrlServicosDpecProd());
        this.dFactory.setUrlServicosDpecHom(this.config.getUrlServicosDpecHom());
        this.dFactory.setNomeServico(this.config.getNomeServico());
        this.dFactory.setNamespaceNames(this.config.getNamespaceNames());
        this.dFactory.setPortNames(this.config.getPortNames());
    }

    private String extracResult(String xmlSoap) {
        int pos1 = xmlSoap.indexOf("<retDPEC");
        int pos2 = xmlSoap.indexOf("</sceRecepcaoDPECResult>");
        if (pos1 != -1 && pos2 != -1) {
            return xmlSoap.substring(pos1, pos2);
        }
        return null;
    }

    public String send(String data, String ambient, String idUsuario) {
        String header = this.makeHeader();
        String url = this.dFactory.obterURL("RecepcaoDPEC", "dpec", ambient);
        System.out.println("Data:" + data);
        System.out.println("HEader:" + header);
        System.out.println("Enviando DPEC a: " + url);
        Dispatch<SOAPMessage> dispatch = this.dFactory.createDispath(url);
        String result = this.dInvoker.invoke(dispatch, header, data, PropriedadesSistema.ID_SERVICO_RECEPCAO_DPEC);
        System.out.println("Resultado:" + result);
        return this.extracResult(result);
    }

    public String makeHeader() {
        String xmlString = "<versaoDados>1.01</versaoDados>";
        return xmlString;
    }

    public String makeData() {
        String data = null;
        try {
            data = EnviarNota.lerArquivo("/home/cnoriega/DPEC_17249111001887_230720091124_2.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public void sendDpecFile(String file) {
    }

    public void make(String idUsuario) {
        String header = this.makeHeader();
        String data = this.makeData();
        XMLGenerator gen = new XMLGenerator("br.com.tti.dpec.classes");
        String result = this.send(data, PropriedadesSistema.ID_HOMOLOGACAO, idUsuario);
        System.out.println(result);
        try {
            TRetDPEC ret = (TRetDPEC)gen.toObject(result);
            System.out.println(ret.getInfDPECReg().getCStat());
            System.out.println(ret.getInfDPECReg().getXMotivo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println();
    }

    public static void main(String[] args) {
        ConfigurarSSLProperties.ajustarPropriedadesFwd("/home/cnoriega/data/NFe/certificados/myroot.jks", "/home/cnoriega/Itambe/itambe.pfx", "crhisn", "itambe");
        GerenciadorInterface ger = null;
        try {
            ger = ReferenciaGerenciador.obterReferenciaGerenciador("localhost");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SenderDPEC test = new SenderDPEC(ger);
        test.make(null);
    }
}

