/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.email;

import br.com.taragona.nfe.persistence.CadastroEmail;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.List;
import javax.persistence.Query;

public class EmailConsomer
implements Runnable {
    private static EmailConsomer INSTANCE = null;
    private String directory = PropriedadesMain.getOutros();
    private DAOGenerico<CadastroEmail> daoEmail = new DAOGenerico(CadastroEmail.class);

    public static EmailConsomer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EmailConsomer();
            Thread t = new Thread(INSTANCE);
            t.start();
        }
        return INSTANCE;
    }

    private EmailConsomer() {
    }

    private Hashtable<String, String> readEmails(File file) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)fis, Charset.forName("ISO-8859-1")));
            String line = r.readLine();
            while (line != null) {
                System.out.println("Reading:" + line);
                String[] splits = line.split("=");
                if (splits.length == 2) {
                    table.put(splits[0].trim(), splits[1].trim());
                }
                if (splits.length == 1) {
                    table.put(splits[0].trim(), "");
                }
                line = r.readLine();
            }
            r.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return table;
    }

    public void updateEmails(Hashtable<String, String> table) {
        for (String cnpj : table.keySet()) {
            CadastroEmail cad;
            Query q;
            List list;
            if (cnpj.endsWith("_assunto") || cnpj.endsWith("_mensagem")) {
                cnpj = cnpj.replace("_assunto", "");
                cnpj = cnpj.replace("_mensagem", "");
            }
            if ((list = (q = this.daoEmail.criarQuery("select e from CadastroEmail as e where e.cnpj = '" + cnpj + "'")).getResultList()).isEmpty()) {
                cad = new CadastroEmail();
                cad.setCnpj(cnpj);
                cad.setEmails(table.get(cnpj));
                cad.setSubject(table.get(String.valueOf(cnpj) + "_assunto"));
                cad.setMessage(table.get(String.valueOf(cnpj) + "_mensagem"));
                this.daoEmail.salvar(cad);
                this.daoEmail.flush();
                continue;
            }
            cad = (CadastroEmail)list.get(0);
            cad.setEmails(table.get(cnpj));
            cad.setSubject(table.get(String.valueOf(cnpj) + "_assunto"));
            cad.setMessage(table.get(String.valueOf(cnpj) + "_mensagem"));
            this.daoEmail.unir(cad);
            this.daoEmail.flush();
        }
    }

    public CadastroEmail findEmails(String cnpj) {
        List list;
        block6: {
            this.daoEmail.clear();
            if (cnpj == null || cnpj.trim().isEmpty()) {
                return null;
            }
            Query q = this.daoEmail.criarQuery("select e from CadastroEmail as e where e.cnpj = '" + cnpj + "'");
            CadastroEmail cad = null;
            try {
                list = q.getResultList();
                if (list.size() != 0) break block6;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return cad;
            }
        }
        CadastroEmail cc = (CadastroEmail)list.get(0);
        try {
            this.daoEmail.refresh(cc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cc;
    }

    private void readFiles() {
        File[] files;
        File dir = new File(this.directory);
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getAbsolutePath().endsWith(".txt") || file.getAbsolutePath().endsWith(".properties")) {
                System.out.println("Tratando arquivo Email:" + file.getAbsolutePath());
                Hashtable<String, String> table = this.readEmails(file);
                this.updateEmails(table);
                boolean ok = true;
                while (ok) {
                    ok = file.delete();
                }
            }
            ++n2;
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.readFiles();
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
        String[] splits = "1234567890=".split("=");
        System.out.println(splits.length);
        PropriedadesMain.processarComandos(args);
        BaseDadosConfig bd = new BaseDadosConfig();
        bd.setNomeDriver(ConfiguracaoSys.getDRIVER());
        bd.setUsuario(ConfiguracaoSys.getUSER_NAME());
        bd.setSenha(ConfiguracaoSys.getPASSWORD());
        bd.setUrl(ConfiguracaoSys.getURL_CONECTION());
        bd.setToplinkProp("create-tables");
        PropriedadesSistema.setBdConfig(bd);
        EmailConsomer c = new EmailConsomer();
        c.readFiles();
    }
}

