/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.event;

import br.com.taragona.nfe.danfe.ImprimirDANFEImpl;
import br.com.taragona.nfe.email.MailSender;
import br.com.taragona.nfe.event.EventManagerInterface;
import br.com.taragona.nfe.event.EventXMLCreator;
import br.com.taragona.nfe.event.EventoSendThread;
import br.com.taragona.nfe.event.xml.classes.ObjectFactory;
import br.com.taragona.nfe.event.xml.classes.TEnvEvento;
import br.com.taragona.nfe.event.xml.classes.ret.TRetEnvEvento;
import br.com.taragona.nfe.event.xml.classes.ret.TretEvento;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EntidadeId;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.EventoInfo;
import br.com.taragona.nfe.tools.PathFileFinder;
import br.com.taragona.nfe.util.CodigoNFeManager;
import br.com.taragona.nfe.util.DelayTable;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.IDSetManager;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.UFTable;
import br.com.taragona.nfe.util.xml.XMLFactory;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Query;
import javax.xml.bind.JAXBElement;

public class EventManagerImpl
implements EventManagerInterface {
    private DAOGenerico<EventoInfo> daoEvent = new DAOGenerico(EventoInfo.class);
    private DAOGenerico<EstadoNFe> daoxml = new DAOGenerico(EstadoNFe.class);
    private XMLGenerator gen = new XMLGenerator("br.com.taragona.nfe.event.xml.classes");
    private XMLGenerator genret = new XMLGenerator("br.com.taragona.nfe.event.xml.classes.ret");
    private ObjectFactory factory = new ObjectFactory();
    private String cnpj;
    private String UF;
    private MailSender sender;
    private ImprimirDANFEImpl print;
    private SimpleDateFormat sdfnordeste = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:00'-04:00'");
    private SimpleDateFormat sdfcentral = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:00'-03:00'");
    private SimpleDateFormat sdfsemfuso = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:00");

    public EventManagerImpl() {
        this.sender = new MailSender();
        this.print = new ImprimirDANFEImpl();
    }

    @Override
    public List<EventoInfo> obterEventos(String keyxml, String tpAmb, Hashtable<String, String> props) {
        System.out.println("Find events for:" + keyxml);
        if (keyxml.startsWith("NFe")) {
            keyxml = keyxml.replace("NFe", "");
        }
        String sql = "SELECT o FROM EventoInfo as o where o.event.infEvento.chNFe = '" + keyxml + "' and o.event.infEvento.tpAmb = '" + tpAmb + "' and o.event.infEvento.tpEvento = '110110' order by o.dataGerada desc ";
        Query query = this.daoEvent.criarQuery(sql);
        return query.getResultList();
    }

    public List<EventoInfo> obterEventosSequence(String keyxml, String tpAmb, Hashtable<String, String> props) {
        if (keyxml.startsWith("NFe")) {
            keyxml = keyxml.replace("NFe", "");
        }
        String sql = "SELECT o FROM EventoInfo as o where o.event.infEvento.chNFe = '" + keyxml + "' and o.event.infEvento.tpAmb = '" + tpAmb + "' and o.estado = :e and o.event.infEvento.tpEvento = '110110' order by o.dataGerada desc ";
        Query query = this.daoEvent.criarQuery(sql);
        query.setParameter("e", (Object)EstadoNFe.ESTADO_NFE.AUTORIZADA);
        return query.getResultList();
    }

    @Override
    public String adicionarEvento(String keyxml, String tpAmb, EventoInfo info, Hashtable<String, String> props, String idUsuario) throws RemoteException {
        EventoInfo lastevent;
        String lastnumberb;
        List<EventoInfo> oldevents = this.obterEventosSequence(keyxml, tpAmb, null);
        int nseqn = 1;
        if (oldevents != null && oldevents.size() >= 1 && (lastnumberb = (lastevent = oldevents.get(0)).getEvent().getInfEvento().getNSeqEvento()) != null) {
            nseqn = Integer.parseInt(lastnumberb);
            ++nseqn;
        }
        info.setEstado(EstadoNFe.ESTADO_NFE.GERADA);
        info.setDataGerada(Calendar.getInstance().getTime());
        info.getEvent().getInfEvento().setNSeqEvento(String.valueOf(nseqn));
        info.getEvent().setVersao("1.00");
        long currentlonf = Calendar.getInstance().getTimeInMillis();
        Date currentdata = new Date(currentlonf);
        try {
            String delay = DelayTable.delay.getString(info.getEvent().getInfEvento().getCOrgao());
            if (delay.contains("+")) {
                delay = delay.replace("+", "");
                currentdata = new Date(currentlonf + (long)(Integer.parseInt(delay) * 60) * 1000L);
            } else {
                delay = delay.replace("-", "");
                currentdata = new Date(currentlonf - (long)(Integer.parseInt(delay) * 60) * 1000L);
            }
        }
        catch (Exception delay) {
            // empty catch block
        }
        String fusohorario = "-03:00";
        String dhevento = "";
        try {
            fusohorario = UFTable.fuso.getString(info.getEvent().getInfEvento().getCOrgao());
            dhevento = String.valueOf(this.sdfsemfuso.format(currentdata)) + fusohorario;
        }
        catch (Exception e) {
            System.out.println("nao foi possivel usar o arquivo fusohorario.properties");
            dhevento = info.getEvent().getInfEvento().getCOrgao().equals("42") || info.getEvent().getInfEvento().getCOrgao().equals("35") || info.getEvent().getInfEvento().getCOrgao().equals("33") || info.getEvent().getInfEvento().getCOrgao().equals("31") || info.getEvent().getInfEvento().getCOrgao().equals("32") || info.getEvent().getInfEvento().getCOrgao().equals("43") || info.getEvent().getInfEvento().getCOrgao().equals("53") || info.getEvent().getInfEvento().getCOrgao().equals("52") || info.getEvent().getInfEvento().getCOrgao().equals("41") || info.getEvent().getInfEvento().getCOrgao().equals("51") || info.getEvent().getInfEvento().getCOrgao().equals("50") ? this.sdfcentral.format(currentdata) : this.sdfnordeste.format(currentdata);
        }
        info.getEvent().getInfEvento().setDhEvento(dhevento);
        String xCondUso = ImprimirDANFEImpl.lerArquivo("xCondUso.txt");
        String tipoamb = XMLFactory.obterTipoAmbiente(info.getEvent().getInfEvento().getCNPJ(), tpAmb);
        info.getEvent().getInfEvento().setTpAmb(tipoamb);
        try {
            info.getEvent().getInfEvento().getDetEvento().setXCondUso(new String(xCondUso.getBytes(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        String id = String.valueOf(info.getEvent().getInfEvento().getTpEvento()) + info.getEvent().getInfEvento().getChNFe() + String.format("%02d", nseqn);
        info.getEvent().setVersao("1.00");
        info.getEvent().getInfEvento().setId("ID" + id);
        String xml = null;
        try {
            this.daoEvent.salvar(info);
            xml = this.toXMLString(info);
            xml = this.repareXML(info.getEvent().getInfEvento().getCNPJ(), xml);
            FileWriter fw = new FileWriter("ultimo_evento.xml");
            fw.write(xml);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String resultxml = null;
        try {
            resultxml = GerenciadorProxy.enviarMensagemXML(PropriedadesSistema.ID_SERVICO_RECEPCAO_EVENTO, info.getEvent().getInfEvento().getCNPJ(), "", xml, info.getEvent().getInfEvento().getCOrgao(), idUsuario);
        }
        catch (Exception e) {
            throw new RemoteException(e.getLocalizedMessage(), e.fillInStackTrace());
        }
        if (resultxml != null) {
            info.setEstado(EstadoNFe.ESTADO_NFE.ENVIADA);
            info.setDataEnviada(Calendar.getInstance().getTime());
            info.setDataAtualizada(Calendar.getInstance().getTime());
            String rets = this.processResult(info, resultxml);
            String endtag = "</retEnvEvento>";
            int pos1 = resultxml.indexOf("<retEnvEvento");
            int pos2 = resultxml.indexOf(endtag);
            if (pos1 != -1 && pos2 != -1) {
                resultxml = resultxml.substring(pos1, pos2 + endtag.length());
            }
            info.setXmlString(xml);
            info.setProtocoloXML(resultxml);
            this.daoEvent.unir(info);
            this.daoEvent.flush();
            if (info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.AUTORIZADA)) {
                if (!keyxml.startsWith("NFe")) {
                    keyxml = "NFe" + keyxml;
                }
                EntidadeId eid = new EntidadeId(keyxml, tpAmb);
                EstadoNFe xmlinfo = this.daoxml.buscarPorIdObject(eid);
                xmlinfo.setCartacorrecao(EstadoNFe.ESTADO_NFE.AUTORIZADA);
                this.daoxml.unir(xmlinfo);
                this.daoxml.flush();
                String pathevento = PathFileFinder.getINSTANCE().findXMLEventoPath(keyxml, tpAmb, Calendar.getInstance().getTime());
                String ccefile = String.valueOf(pathevento) + "/" + "CCe" + keyxml.replace("NFe", "") + ".xml";
                try {
                    EventXMLCreator xmlc = new EventXMLCreator(info);
                    FileWriter fw = new FileWriter(ccefile);
                    fw.write(xmlc.extractXML());
                    fw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String pdfpath = PathFileFinder.getINSTANCE().findPDFPath(keyxml, tpAmb, xmlinfo.getDataGerada());
                String pdffile = String.valueOf(pdfpath) + "/" + keyxml + ".pdf";
                File file = new File(pdffile);
                long lasmodified = file.lastModified();
                this.print.imprimirNota(keyxml, tpAmb, "PDF", false, null, idUsuario);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                long newmodified = file.lastModified();
                int counter = 0;
                while (lasmodified == newmodified) {
                    System.out.println("esperando criar PDF...");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (++counter >= 3) break;
                    newmodified = file.lastModified();
                }
                String[] filesnames = new String[]{ccefile, pdffile};
                String cnpjdest = xmlinfo.getCnpjDestino();
                String cnpjtransp = ImprimirDANFEImpl.obterCNPJTransp(xmlinfo.getXmlString());
                EventoSendThread envsend = new EventoSendThread(this.sender, filesnames, keyxml, tpAmb, cnpjdest, cnpjtransp);
                Thread t = new Thread(envsend);
                t.start();
            } else {
                if (!keyxml.startsWith("NFe")) {
                    keyxml = "NFe" + keyxml;
                }
                EntidadeId eid = new EntidadeId(keyxml, tpAmb);
                EstadoNFe xmlinfo = this.daoxml.buscarPorIdObject(eid);
                xmlinfo.setCartacorrecao(EstadoNFe.ESTADO_NFE.REJEITADA);
                this.daoxml.unir(xmlinfo);
            }
            GerenciadorProxy.notificarEventoCCe(keyxml, rets);
            return rets;
        }
        throw new RemoteException("Evento sem retorno da sefaz");
    }

    public String processResult(EventoInfo event, String xml) {
        String endtag = "</retEnvEvento>";
        int pos1 = xml.indexOf("<retEnvEvento");
        int pos2 = xml.indexOf(endtag);
        if (pos1 != -1 && pos2 != -1) {
            xml = xml.substring(pos1, pos2 + endtag.length());
        }
        try {
            JAXBElement ret = (JAXBElement)this.genret.toObject(xml);
            String cstat = ((TRetEnvEvento)ret.getValue()).getCStat();
            System.out.println(cstat);
            CodigoNFeManager.insereCodigo(Integer.valueOf(cstat), ((TRetEnvEvento)ret.getValue()).getXMotivo());
            String autorizada = "";
            if (cstat.equals("128")) {
                List<TretEvento> results = ((TRetEnvEvento)ret.getValue()).getRetEvento();
                Iterator<TretEvento> iterator = results.iterator();
                if (iterator.hasNext()) {
                    TretEvento rett = iterator.next();
                    if (rett.getInfEvento().getCStat().equals("135") || rett.getInfEvento().getCStat().equals("136")) {
                        event.setEstado(EstadoNFe.ESTADO_NFE.AUTORIZADA);
                        event.setDataAutorizada(Calendar.getInstance().getTime());
                        event.setDataAtualizada(Calendar.getInstance().getTime());
                        autorizada = "|" + rett.getInfEvento().getNProt() + "|" + rett.getInfEvento().getDhRegEvento();
                    } else {
                        event.setEstado(EstadoNFe.ESTADO_NFE.REJEITADA);
                        event.setMensagem(rett.getInfEvento().getXMotivo());
                        event.setDataAtualizada(Calendar.getInstance().getTime());
                    }
                    System.out.println(event.getEstado().toString());
                    return String.valueOf(rett.getInfEvento().getCStat()) + "|" + rett.getInfEvento().getXMotivo() + autorizada;
                }
            } else {
                event.setEstado(EstadoNFe.ESTADO_NFE.ERRO);
                event.setMensagem(((TRetEnvEvento)ret.getValue()).getXMotivo());
                event.setDataAtualizada(Calendar.getInstance().getTime());
            }
            return String.valueOf(((TRetEnvEvento)ret.getValue()).getCStat()) + "|" + ((TRetEnvEvento)ret.getValue()).getXMotivo() + "||";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String repareXML(String cnpj, String xml) {
        FileWriter fw;
        try {
            fw = new FileWriter("C:\\preassinado.xml");
            fw.write(xml);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        xml = xml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "");
        try {
            xml = GerenciadorProxy.gerenciador.assinar(cnpj, xml, "infEvento");
            xml = xml.replace("<envEvento versao=\"1.00\">", "<envEvento versao=\"1.00\" xmlns=\"http://www.portalfiscal.inf.br/nfe\">");
            fw = new FileWriter("C:\\postpreassinado.xml");
            fw.write(xml);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xml;
    }

    private String toXMLString(EventoInfo info) {
        TEnvEvento envevento = new TEnvEvento();
        envevento.setIdLote(IDSetManager.getNexIdSet().toString());
        envevento.getEvento().add(info.getEvent());
        envevento.setVersao("1.00");
        try {
            String xml = this.gen.toXMLString(envevento);
            return xml;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String createXML(EventoInfo info) {
        TEnvEvento envevento = this.factory.createTEnvEvento();
        envevento.setVersao("1.00");
        envevento.getEvento().add(info.getEvent());
        String xmlevento = null;
        try {
            xmlevento = this.gen.toXMLString(envevento);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xmlevento;
    }

    @Override
    public String enviarEvento(String idevento, String keyxml, String tpAmb, Hashtable<String, String> props, String idUsuario) throws RemoteException {
        return null;
    }

    public static void main(String[] args) {
        System.out.println(String.format("%02d", "13"));
    }

    @Override
    public String xmlCCe(String keyxml, String tpAmb, int num) throws RemoteException {
        String sql = "SELECT o FROM EventoInfo as o where o.event.infEvento.chNFe = '" + keyxml.replace("NFe", "") + "' and o.event.infEvento.tpAmb = '" + tpAmb + "' and o.estado = :e and o.event.infEvento.tpEvento ='110110' order by o.event.infEvento.nSeqEvento desc ";
        System.out.println(sql);
        Query query = this.daoEvent.criarQuery(sql);
        query.setParameter("e", (Object)EstadoNFe.ESTADO_NFE.AUTORIZADA);
        List result = query.getResultList();
        if (result.size() > 0) {
            return ((EventoInfo)result.get(0)).getXmlString();
        }
        return null;
    }
}

