/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.gerenciador;

import br.com.taragona.nfe.cockpitserver.CockpitPartch;
import br.com.taragona.nfe.controle.Controle;
import br.com.taragona.nfe.controle.ControleInterface;
import br.com.taragona.nfe.danfe.ImprimirThread;
import br.com.taragona.nfe.dpec.sender.SenderDPEC;
import br.com.taragona.nfe.email.CheckResendMail;
import br.com.taragona.nfe.email.EmailConsomer;
import br.com.taragona.nfe.email.ExcelCCEConsumer;
import br.com.taragona.nfe.email.ExcelRecreateConsumer2;
import br.com.taragona.nfe.erpinterface.InterfaceERP;
import br.com.taragona.nfe.event.EventManagerImpl;
import br.com.taragona.nfe.event.EventManagerInterface;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.gerenciador.ListenerChecker;
import br.com.taragona.nfe.gerenciador.ListenerConectorThread;
import br.com.taragona.nfe.gerenciador.ListenerThread;
import br.com.taragona.nfe.gerenciador.NotificationThread;
import br.com.taragona.nfe.mensageiro.Mensageiro;
import br.com.taragona.nfe.mensageiro.MensageiroRemote;
import br.com.taragona.nfe.mensageiro.states.StatePersitence;
import br.com.taragona.nfe.nfecockpitdesktop.data.Perfil;
import br.com.taragona.nfe.nfecockpitdesktop.data.Usuario;
import br.com.taragona.nfe.nfecockpitdesktop.gerenciadorlistener.GerenciadorListener;
import br.com.taragona.nfe.persistence.CadastroEmail;
import br.com.taragona.nfe.persistence.CodigoNFe;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.Empresa;
import br.com.taragona.nfe.persistence.EmpresaLFU;
import br.com.taragona.nfe.persistence.EntidadeCnpj;
import br.com.taragona.nfe.persistence.EntidadeId;
import br.com.taragona.nfe.persistence.EntidadeLFU;
import br.com.taragona.nfe.persistence.EstadoLote;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.EstadoRecibo;
import br.com.taragona.nfe.persistence.EventoInfo;
import br.com.taragona.nfe.persistence.ExtraXMLInfo;
import br.com.taragona.nfe.persistence.LogEnvioEmail;
import br.com.taragona.nfe.persistence.LogNFe;
import br.com.taragona.nfe.persistence.Notificacao;
import br.com.taragona.nfe.sender.SenderPort;
import br.com.taragona.nfe.sender.SenderRemote;
import br.com.taragona.nfe.sender.util.ConfiguracaoXML;
import br.com.taragona.nfe.tools.ExcelDocumentGenerator;
import br.com.taragona.nfe.util.BoletoManager;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.DBChecker;
import br.com.taragona.nfe.util.EmailFinder;
import br.com.taragona.nfe.util.GerenciadorSenhas;
import br.com.taragona.nfe.util.ParChave;
import br.com.taragona.nfe.util.PrintFinder;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.TentarDeNovoExecutor;
import br.com.taragona.nfe.util.XMLProtExtractor;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import br.com.taragona.nfe.util.data.MensageiroConfig;
import br.com.taragona.nfe.util.data.SenderConf;
import br.com.taragona.nfe.util.data.ServicosConfig;
import br.com.tti.sefaz.remote.DBConfig;
import br.com.tti.sefaz.systemconfig.XMLConfigSystem;
import br.com.tti.sefaz.util.MainParameters;
import br.com.tti.sefaz.wrapper.WrapperSender;
import br.com.tti.sefaz.wrapper.WrapperSenderV310;
import br.com.tti.ttinfe.printer.PSGeneratorPrinter;
import br.com.tti.xmldb.XMLDBInterfaceProvider;
import br.com.tti.xmldb.XMLDBProviderFactory;
import br.com.tti.xmldb.exist.CreateXPathQuery;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Query;
import nfeimpressao.TaragonaInt;

public class GerenciadorOnce
implements GerenciadorInterface {
    public static boolean isBindJar = false;
    private Hashtable<String, MensageiroRemote> mensageiros;
    private Hashtable<String, ControleInterface> controladores;
    private Hashtable<String, EventManagerInterface> eventmanagers;
    private Vector<GerenciadorListener> listeners;
    private Vector<GerenciadorListener> conectores;
    private Vector<GerenciadorListener> removeListeners;
    private Vector<GerenciadorListener> removeConectores;
    private Hashtable<String, SenderRemote> senders;
    private Vector<InterfaceERP> interfaces;
    private Vector<TaragonaInt> impressoes;
    private Hashtable<ParChave, String> tipoServicos = new Hashtable();
    private Hashtable<String, Long> timeouts = new Hashtable();
    private Hashtable<String, Integer> numeroNotas = new Hashtable();
    private Hashtable<String, Long> tamanhoArquivos = new Hashtable();
    private Hashtable<String, Long> tempoProcessamento = new Hashtable();
    private GerenciadorSenhas senhas;
    private SenderDPEC senderDpec;
    private StatePersitence state;
    private XMLProtExtractor extractor;
    private int sizeLFU = 30;
    private SenderRemote senderForSign;
    private final long startupStart;
    private long lastStageMark;
    private Hashtable<String, TaragonaInt> stubs = new Hashtable();
    private CockpitPartch server;
    private Connection cx;

    public GerenciadorOnce() {
        this.lastStageMark = this.startupStart = System.currentTimeMillis();
        PropriedadesSistema.setBdConfig(this.obterBDConfig());
        this.state = new StatePersitence("estados.txt");
        this.extractor = new XMLProtExtractor(ConfiguracaoSys.getTipoAmbiente());
        this.senderDpec = new SenderDPEC(this);
        this.mensageiros = new Hashtable();
        this.controladores = new Hashtable();
        this.eventmanagers = new Hashtable();
        this.interfaces = new Vector();
        this.impressoes = new Vector();
        this.listeners = new Vector();
        this.conectores = new Vector();
        this.removeListeners = new Vector();
        this.removeConectores = new Vector();
        this.senders = new Hashtable();
        this.senhas = new GerenciadorSenhas();
        this.server = new CockpitPartch();
        this.logTempoEtapa("Estruturas iniciais");
        SenderPort sender = null;
        WrapperSender senderv200 = null;
        WrapperSenderV310 senderv310 = null;
        try {
            sender = new SenderPort(this, ConfiguracaoSys.getArquivoServicos(), null);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            senderv200 = new WrapperSender((GerenciadorInterface)this, null);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            senderv310 = new WrapperSenderV310((GerenciadorInterface)this, null);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            this.senderForSign = new WrapperSenderV310((GerenciadorInterface)this, null);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.logTempoEtapa("Instancia de senders");
        for (String cnpj : ConfiguracaoSys.obterCNPJsRegistrados()) {
            Enumeration<ParChave> chavesEnum = ConfiguracaoSys.getCnpjsTipo().keys();
            while (chavesEnum.hasMoreElements()) {
                ParChave chave = chavesEnum.nextElement();
                if (chave == null || !chave.getChave1().equals(cnpj)) continue;
                ParChave chave_normal = new ParChave(chave.getChave1(), chave.getChave2());
                String tipo = ConfiguracaoSys.getCnpjsTipo().get(chave);
                if (tipo.endsWith("v200")) {
                    this.senders.put(cnpj, (SenderRemote)senderv200);
                    ParChave chave_v200 = new ParChave(String.valueOf(chave.getChave1()) + "v200", chave.getChave2());
                    this.tipoServicos.put(chave_normal, tipo.replace("v200", ""));
                    this.tipoServicos.put(chave_v200, tipo.replace("v200", ""));
                    continue;
                }
                if (tipo.endsWith("v310")) {
                    this.senders.put(cnpj, (SenderRemote)senderv310);
                    ParChave chave_v310 = new ParChave(String.valueOf(chave.getChave1()) + "v310", chave.getChave2());
                    this.tipoServicos.put(chave_normal, tipo.replace("v310", ""));
                    this.tipoServicos.put(chave_v310, tipo.replace("v310", ""));
                    continue;
                }
                try {
                    this.senders.put(cnpj, sender);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.tipoServicos.put(chave_normal, tipo);
            }
            this.numeroNotas.put(cnpj, ConfiguracaoSys.getNNotas().get(cnpj));
            this.timeouts.put(cnpj, ConfiguracaoSys.getTimeouts().get(cnpj));
            this.tempoProcessamento.put(cnpj, ConfiguracaoSys.getTempoProc().get(cnpj));
            this.tamanhoArquivos.put(cnpj, ConfiguracaoSys.getTamanhoLote().get(cnpj));
        }
        this.logTempoEtapa("Configuracao por CNPJ");
        try {
            this.inicializar();
            this.logTempoEtapa("Inicializar()");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void carregarModoOp() {
    }

    private void logTempoEtapa(String etapa) {
        long agora = System.currentTimeMillis();
        long delta = agora - this.lastStageMark;
        long total = agora - this.startupStart;
        System.out.println("Tempo etapa [" + etapa + "]:+" + delta + " ms (total " + total + " ms)");
        this.lastStageMark = agora;
    }

    public void inicializar() throws Exception {
        this.mensageiros.put("123", new Mensageiro(this));
        this.controladores.put("123", new Controle(this));
        this.logTempoEtapa("Mensageiro/Controle");
        this.eventmanagers.put("123", new EventManagerImpl());
        this.logTempoEtapa("EventManager");
        if (PropriedadesMain.isEmail()) {
            EmailConsomer.getInstance();
            this.logTempoEtapa("EmailConsumer");
        }
        System.out.println("Iniciando leitura de planilha");
        ExcelCCEConsumer.getInstance(ConfiguracaoSys.getTipoAmbiente(), null);
        this.logTempoEtapa("ExcelCCEConsumer");
        System.out.println("Iniciando leitura de PDF/XML");
        ExcelRecreateConsumer2.getInstance(ConfiguracaoSys.getTipoAmbiente());
        this.logTempoEtapa("ExcelRecreateConsumer2");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                CheckResendMail.getInstance(ConfiguracaoSys.getTipoAmbiente());
            }
        }).start();
        DBChecker.init();
        this.logTempoEtapa("DBChecker");
        ListenerChecker.initChecker(this.listeners, this.removeListeners);
        ListenerChecker.initChecker(this.conectores, this.removeConectores);
        this.logTempoEtapa("ListenerChecker");
        if (PropriedadesMain.isChecar()) {
            TentarDeNovoExecutor.init();
            this.logTempoEtapa("TentarDeNovoExecutor");
        }
    }

    @Override
    public void enviarNota(String CNPJEmitente, String CNPJDestino, String idNota, String tpAmb, String nota, Date data, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.enviarNota(CNPJEmitente, CNPJDestino, idNota, tpAmb, nota, data, idUsuario);
    }

    @Override
    public void enviarNota(String CNPJEmitente, String CNPJDestino, String idNota, String tpAmb, String nota, Date data, Hashtable<String, Object> props, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.enviarNota(CNPJEmitente, CNPJDestino, idNota, tpAmb, nota, data, props, idUsuario);
    }

    @Override
    public String enviarEvento(String idevento, String keyxml, String tpAmb, Hashtable<String, String> props, String idUsuario) throws RemoteException {
        Collection<EventManagerInterface> eventmngs = this.eventmanagers.values();
        EventManagerInterface event = eventmngs.iterator().next();
        return event.enviarEvento(idevento, keyxml, tpAmb, props, idUsuario);
    }

    @Override
    public String consultarNota(String idNota, String tpAmb, String idUsuario) throws RemoteException {
        Collection<ControleInterface> ctrls = this.controladores.values();
        ControleInterface ctrl = ctrls.iterator().next();
        return ctrl.consultarNota(idNota, tpAmb, idUsuario);
    }

    @Override
    public String consultarNotaXml(String idNota, String tpAmb, String idUsuario) throws RemoteException {
        Collection<ControleInterface> ctrls = this.controladores.values();
        ControleInterface ctrl = ctrls.iterator().next();
        return ctrl.consultarNotaXml(idNota, tpAmb, idUsuario);
    }

    @Override
    public void enviarNotaErro(String cnpj, String cnpjdest, String idNota, String tpAmb, String xml, String erro, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.enviarNotaErro(cnpj, cnpjdest, idNota, tpAmb, xml, erro, idUsuario);
    }

    @Override
    public void enviarNotaErro(String cnpj, String idNota, String tpAmb, String xml, String erro, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.enviarNotaErro(cnpj, idNota, tpAmb, xml, erro, idUsuario);
    }

    @Override
    public synchronized void tentarEnvioNotas(String cnpj, String tpAmb, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.tentarEnvioNotas(cnpj, tpAmb, idUsuario);
    }

    @Override
    public void checarConsistencia(Vector<String> chaves, String tpAmb, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.checarConsistencia(chaves, tpAmb, idUsuario);
    }

    @Override
    public void cancelarNota(String cnpj, String mod, String serie, String numero, String just, String tpAmb, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.cancelarNota(cnpj, mod, serie, numero, just, tpAmb, idUsuario);
    }

    @Override
    public void cancelarNota(String cnpj, String idNota, String tpAmb, String justificativa, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.cancelarNota(cnpj, idNota, tpAmb, justificativa, idUsuario);
    }

    @Override
    public String inutilizarNota(String UF, String ano, String cnpj, String mod, String serie, String ini, String fim, String just, String tpAmb, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        return mensageiro.inutilizarNota(UF, ano, cnpj, mod, serie, ini, fim, just, tpAmb, idUsuario);
    }

    @Override
    public void inutilizarNumero(String idNota, String tpAmb, String justificativa, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.inutilizarNumero(idNota, tpAmb, justificativa, idUsuario);
    }

    @Override
    public MensageiroRemote obterMensageiro(String id) throws RemoteException {
        MensageiroRemote mensageiro = this.mensageiros.get(id);
        if (mensageiro == null) {
            throw new RemoteException("Mensageiro com id: " + id + " nao registrado");
        }
        return mensageiro;
    }

    @Override
    public ControleInterface obterControlador(String id) throws RemoteException {
        ControleInterface controle = this.controladores.get(id);
        if (controle == null) {
            throw new RemoteException("Controle com id: " + id + " nao registrado");
        }
        return controle;
    }

    @Override
    public void registrarControle(String id, ControleInterface controle) throws RemoteException {
        this.controladores.put(id, controle);
        System.out.println("Controle registrado: " + id + " list-> " + this.controladores.toString());
    }

    @Override
    public void registrarMensageiro(String id, MensageiroRemote mensageiro) throws RemoteException {
        this.mensageiros.put(id, mensageiro);
        System.out.println("Mensageiro registrado: " + id + " list-> " + this.mensageiros.toString());
    }

    @Override
    public Vector<String> obterMensageiros() throws RemoteException {
        Vector<String> msns = new Vector<String>();
        for (String ip : this.mensageiros.keySet()) {
            msns.add(ip);
        }
        return msns;
    }

    private void adicionarObjeto(String cnpj, Hashtable hash, Object obj) {
        Vector<Object> lista = (Vector<Object>)hash.get(cnpj);
        if (lista == null) {
            lista = new Vector<Object>();
        }
        if (!lista.contains(obj)) {
            lista.add(obj);
        }
        hash.put(cnpj, lista);
    }

    @Override
    public Vector<String> obterControles() throws RemoteException {
        Vector<String> ctrls = new Vector<String>();
        for (String ip : this.controladores.keySet()) {
            ctrls.add(ip);
        }
        return ctrls;
    }

    private boolean isMensageiroAtivo(String cnpj) {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        boolean temAtivo = false;
        for (MensageiroRemote msn : msns) {
            try {
                msn.getEstado(cnpj);
            }
            catch (Exception e) {
                continue;
            }
            temAtivo = true;
        }
        return temAtivo;
    }

    @Override
    public synchronized void mudarEstadoContingencia(String cnpj, String tpAmb) throws RemoteException {
        if (this.state.getState(cnpj) != PropriedadesSistema.MODO_OP.CONTINGENCIA) {
            this.state.setState(cnpj, PropriedadesSistema.MODO_OP.CONTINGENCIA);
            Collection<ControleInterface> ctrls = this.controladores.values();
            for (ControleInterface ctrl : ctrls) {
                ctrl.mudarEstadoContingencia(cnpj);
            }
            Collection<MensageiroRemote> msns = this.mensageiros.values();
            for (MensageiroRemote msn : msns) {
                msn.mudarEstadoContingencia(cnpj, tpAmb);
            }
            this.changeOp(cnpj, PropriedadesSistema.MODO_OP.CONTINGENCIA.toString(), tpAmb);
        }
    }

    @Override
    public synchronized void mudarEstadoNormalEnvioContingencia(String cnpj, String tpAmb, String idUsuario) throws RemoteException {
        this.state.setState(cnpj, PropriedadesSistema.MODO_OP.NORMAL);
        Collection<ControleInterface> ctrls = this.controladores.values();
        for (ControleInterface ctrl : ctrls) {
            ctrl.mudarEstadoNormal(cnpj);
        }
        this.mensageiros.get("123").mudarEstadoNormal(cnpj, tpAmb, idUsuario);
    }

    @Override
    public void mudarEstadoNormalSemEnvio(String cnpj, String tpAmb) throws RemoteException {
        if (this.state.getState(cnpj) != PropriedadesSistema.MODO_OP.NORMAL) {
            this.state.setState(cnpj, PropriedadesSistema.MODO_OP.NORMAL);
            Collection<ControleInterface> ctrls = this.controladores.values();
            for (ControleInterface ctrl : ctrls) {
                ctrl.mudarEstadoNormal(cnpj);
            }
            Collection<MensageiroRemote> msns = this.mensageiros.values();
            for (MensageiroRemote msn : msns) {
                msn.mudarEstadoNormalSemEnvio(cnpj, tpAmb);
            }
            this.changeOp(cnpj, PropriedadesSistema.MODO_OP.NORMAL.toString(), tpAmb);
        }
    }

    @Override
    public Hashtable[] obterTodosServicos() throws RemoteException {
        return ConfiguracaoSys.obterTodosServicos();
    }

    @Override
    public int estadoOperacao(String cnpj) throws RemoteException {
        PropriedadesSistema.MODO_OP estado = this.state.getState(cnpj);
        if (estado == PropriedadesSistema.MODO_OP.CONTINGENCIA) {
            return 0;
        }
        if (estado == PropriedadesSistema.MODO_OP.NORMAL) {
            return 1;
        }
        if (estado == PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC) {
            return 3;
        }
        if (estado == PropriedadesSistema.MODO_OP.SVC_AN) {
            return 6;
        }
        if (estado == PropriedadesSistema.MODO_OP.SVC_RS) {
            return 7;
        }
        if (estado == PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC) {
            return 8;
        }
        return 4;
    }

    @Override
    public Vector<String> obterCNPJRegistrados() throws RemoteException {
        return ConfiguracaoSys.obterCNPJsRegistrados();
    }

    @Override
    public void registrarListener(GerenciadorListener listener) throws RemoteException {
        System.out.println("registrando listener: " + listener);
        try {
            String tipo = listener.tipoListener();
            if (tipo != null && tipo.startsWith("CONECTOR")) {
                this.conectores.add(listener);
            } else {
                this.listeners.add(listener);
            }
        }
        catch (Exception e) {
            System.out.println("ERRO: " + e.getLocalizedMessage());
            System.out.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            System.out.println("%%%%%%%%%%%%% CONECTOR VERSAO ANTIGA %%%%%%%%%%%%%");
            System.out.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            this.conectores.removeIf(l -> {
                try {
                    l.tipoListener();
                    return false;
                }
                catch (Exception ex) {
                    return true;
                }
            });
            this.listeners.add(listener);
        }
    }

    @Override
    public void registrarImpressao(TaragonaInt impressao) throws RemoteException {
        int i = this.impressoes.size() - 1;
        while (i >= 0) {
            TaragonaInt imp = this.impressoes.get(i);
            this.impressoes.remove(i);
            --i;
        }
        this.impressoes.add(impressao);
        System.out.println("Impressao registrado: " + impressao.toString());
    }

    @Override
    public synchronized void imprimir(String chaveNota, String estado, String xml, Hashtable<String, String> prop) throws RemoteException {
        try {
            Vector<TaragonaInt> remove = new Vector<TaragonaInt>();
            for (TaragonaInt imp : this.impressoes) {
                try {
                    ImprimirThread r = new ImprimirThread(imp, chaveNota, estado, xml, prop);
                    Thread t = new Thread(r);
                    t.start();
                }
                catch (Exception e) {
                    System.out.println("Eliminando impressao:" + e.getLocalizedMessage());
                    remove.add(imp);
                }
            }
            for (TaragonaInt tar : remove) {
                this.impressoes.remove(tar);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Erro na chamada de impressao");
        }
    }

    @Override
    public String assinar(String cnpj, String xml, String tag) throws RemoteException {
        System.out.println("sender selecionado para assinar:" + this.senderForSign);
        return this.senderForSign.assinarCNPJ(cnpj, xml, tag);
    }

    @Override
    public Hashtable<String, Hashtable<String, Object>> readAllPFXPRoperties() throws RemoteException {
        Collection<SenderRemote> sendersCNPJ = this.senders.values();
        SenderRemote sender = sendersCNPJ.iterator().next();
        return sender.readAllPFXPRoperties();
    }

    @Override
    public void atualizarLote(EstadoLote lote) throws RemoteException {
        for (GerenciadorListener lis : this.listeners) {
            try {
                lis.atualizarLote(lote);
            }
            catch (Exception e) {
                System.out.println("Eliminando listener:" + e.getMessage());
            }
        }
    }

    @Override
    public void atualizarInut(String serie, String cnpj, String numero, String codigo, String something, String modo) throws RemoteException {
        try {
            for (GerenciadorListener lis : this.listeners) {
                try {
                    lis.atualizarInut(serie, cnpj, numero, codigo, something, modo);
                }
                catch (Exception e) {
                    System.out.println("Problemas:" + e.getLocalizedMessage());
                }
            }
        }
        catch (Exception e) {
            System.out.println("Erro atualizando nota cockpit");
        }
    }

    @Override
    public void changeOp(String cnpj, String tpEmis, String tpAmb) throws RemoteException {
        try {
            for (GerenciadorListener lis : this.listeners) {
                try {
                    lis.changeOp(cnpj, tpEmis, tpAmb);
                }
                catch (Exception e) {
                    System.out.println("Problemas:" + e.getLocalizedMessage());
                }
            }
        }
        catch (Exception e) {
            System.out.println("Erro atualizando nota cockpit");
        }
    }

    @Override
    public void atualizarNota(EstadoNFe nota) throws RemoteException {
        for (GerenciadorListener lis : this.listeners) {
            ListenerThread lt = new ListenerThread(lis, nota, this.removeListeners);
            Thread t = new Thread(lt);
            t.start();
        }
    }

    @Override
    public void notificarNotaConector(EstadoNFe nota) throws RemoteException {
        for (GerenciadorListener lis : this.conectores) {
            ListenerConectorThread lt = new ListenerConectorThread(lis, nota, this.removeConectores);
            Thread t = new Thread(lt);
            t.start();
        }
    }

    @Override
    public void notificarEventoCCe(String chave, String response) throws RemoteException {
        for (GerenciadorListener lis : this.conectores) {
            try {
                lis.notificarEventoCCE(chave, response);
            }
            catch (Exception e) {
                System.out.println("Eliminando impressao:" + e.getLocalizedMessage());
                this.removeConectores.add(lis);
            }
        }
    }

    @Override
    public void notificarArquivos(Notificacao not) throws RemoteException {
        this.server.salvarNot(not);
        for (GerenciadorListener lis : this.listeners) {
            NotificationThread nt = new NotificationThread(lis, not, this.removeListeners);
            Thread t = new Thread(nt);
            t.start();
        }
    }

    @Override
    public List<Notificacao> obterNotificacoes(Date d1, Date d2) throws RemoteException {
        return this.server.obterNotificacoes(d1, d2);
    }

    @Override
    public String enviarMensagemXML(String idServico, String cnpj, String cabecalho, String xml, Hashtable prop, String idUsuario) throws RemoteException {
        String tpAmb = CockpitPartch.getValueByTag(xml, "tpAmb");
        Collection<SenderRemote> sendersCNPJ = this.senders.values();
        SenderRemote sender = this.senders.get(cnpj);
        try {
            if (tpAmb != null && !tpAmb.equals("")) {
                if (tpAmb.equals("1")) {
                    prop.put("TIPO", "producao");
                } else {
                    prop.put("TIPO", "homologacao");
                }
            } else if (cnpj == null) {
                prop.put("TIPO", ConfiguracaoSys.getTipoAmbiente());
            } else {
                prop.put("TIPO", this.tipoServicos.get(cnpj));
                PropriedadesSistema.MODO_OP modo = this.state.getState(cnpj);
                if (modo.equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN)) {
                    prop.put("UFREAL", prop.get("UF"));
                    prop.put("UF", "scan");
                }
                if (modo.equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC)) {
                    prop.put("UFREAL", prop.get("UF"));
                    prop.put("UF", "91");
                }
                if (modo.equals((Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC)) {
                    prop.put("UF", "dpec");
                }
                if (modo.equals((Object)PropriedadesSistema.MODO_OP.SVC_AN)) {
                    prop.put("UFREAL", prop.get("UF"));
                    prop.put("UF", "svcan");
                }
                if (modo.equals((Object)PropriedadesSistema.MODO_OP.SVC_RS)) {
                    prop.put("UFREAL", prop.get("UF"));
                    prop.put("UF", "svcrs");
                }
            }
            if (prop.get("UF").equals("dpec")) {
                return this.senderDpec.send(xml, prop.get("TIPO").toString(), idUsuario);
            }
            System.out.println("Prop:" + prop.toString());
            return sender.enviarMensagemXML(idServico, cnpj, cabecalho, xml, prop, idUsuario);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void registrarSender(String cnpj, SenderRemote sender) throws RemoteException {
        this.senders.put(cnpj, sender);
        System.out.println("Sender registrado: " + cnpj + " sender: " + sender);
    }

    @Override
    public void registrarInterface(String id, InterfaceERP retorno) throws RemoteException {
        this.interfaces.clear();
        this.interfaces.add(retorno);
        System.out.println("Interface registrada: " + id + " list-> " + this.interfaces.toString());
    }

    @Override
    public void notificarNotasCancelamentoERP(String[] idNotas, String tpAmb) throws RemoteException {
        Vector<InterfaceERP> remove = new Vector<InterfaceERP>();
        for (InterfaceERP interf : this.interfaces) {
            try {
                interf.notificarNotasCancelamentoERP(idNotas, tpAmb);
            }
            catch (RemoteException e) {
                System.out.println("Eliminando interface ERP:" + e.getMessage());
                remove.add(interf);
            }
        }
        for (InterfaceERP r : remove) {
            this.interfaces.remove(r);
        }
    }

    @Override
    public void notificarNotaERP(String chave, String tpAmb, String modo, String protocolo) throws RemoteException {
        Vector<InterfaceERP> remove = new Vector<InterfaceERP>();
        for (InterfaceERP interf : this.interfaces) {
            try {
                System.out.println("Notificando ERP");
                interf.notificarNotaERP(chave, tpAmb, modo, protocolo);
            }
            catch (RemoteException e) {
                System.out.println("Eliminando interface ERP:" + e.getMessage());
                remove.add(interf);
            }
        }
        for (InterfaceERP r : remove) {
            this.interfaces.remove(r);
        }
    }

    @Override
    public void retornoExcecao(String chaveNFe, String tpAmb, String metodoAraujoInt, String mensagemExcecao) throws RemoteException {
        Vector<InterfaceERP> remove = new Vector<InterfaceERP>();
        System.out.println("Passando execao!!");
        for (InterfaceERP interf : this.interfaces) {
            try {
                interf.retornoExcecao(chaveNFe, tpAmb, metodoAraujoInt, mensagemExcecao);
            }
            catch (RemoteException e) {
                System.out.println("Eliminando interface ERP:" + e.getMessage());
                remove.add(interf);
            }
        }
        for (InterfaceERP r : remove) {
            this.interfaces.remove(r);
        }
    }

    @Override
    public void notificarProtocoloCancelamentoContingecia(String chaveNota, String tpAmb, String protocolo) throws RemoteException {
        Vector<InterfaceERP> remove = new Vector<InterfaceERP>();
        for (InterfaceERP interf : this.interfaces) {
            try {
                interf.notificarProtocoloCancelamentoContingecia(chaveNota, tpAmb, protocolo);
            }
            catch (RemoteException e) {
                System.out.println("Eliminando interface ERP:" + e.getMessage());
                remove.add(interf);
            }
        }
        for (InterfaceERP r : remove) {
            this.interfaces.remove(r);
        }
    }

    @Override
    public void notificarProtocoloCancelamentoNormal(String chaveNota, String tpAmb, String protocolo) throws RemoteException {
        Vector<InterfaceERP> remove = new Vector<InterfaceERP>();
        for (InterfaceERP interf : this.interfaces) {
            try {
                interf.notificarProtocoloCancelamentoNormal(chaveNota, tpAmb, protocolo);
            }
            catch (RemoteException e) {
                System.out.println("Eliminando interface ERP:" + e.getMessage());
                remove.add(interf);
            }
        }
        for (InterfaceERP r : remove) {
            this.interfaces.remove(r);
        }
    }

    @Override
    public void notificarProtocoloInutilizcaoContingecia(String chaveNota, String tpAmb, String protocolo) throws RemoteException {
        Vector<InterfaceERP> remove = new Vector<InterfaceERP>();
        for (InterfaceERP interf : this.interfaces) {
            try {
                interf.notificarProtocoloInutilizcaoContingecia(chaveNota, tpAmb, protocolo);
            }
            catch (RemoteException e) {
                System.out.println("Eliminando interface ERP:" + e.getMessage());
                remove.add(interf);
            }
        }
        for (InterfaceERP r : remove) {
            this.interfaces.remove(r);
        }
    }

    @Override
    public void notificarProtocoloInutilizcaoNormal(String chaveNota, String tpAmb, String protocolo) throws RemoteException {
        Vector<InterfaceERP> remove = new Vector<InterfaceERP>();
        for (InterfaceERP interf : this.interfaces) {
            try {
                interf.notificarProtocoloInutilizcaoNormal(chaveNota, tpAmb, protocolo);
            }
            catch (RemoteException e) {
                System.out.println("Eliminando interface ERP:" + e.getMessage());
                remove.add(interf);
            }
        }
        for (InterfaceERP r : remove) {
            this.interfaces.remove(r);
        }
    }

    @Override
    public String obterTrustStore() throws RemoteException {
        return ConfiguracaoSys.getTrustStore();
    }

    @Override
    public void reImprimirNota(String idNota, String tpAmb, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.reImprimirNota(idNota, tpAmb, idUsuario);
    }

    @Override
    public void reImprimirNota(String idNota, String tpAmb, String tipo, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.reImprimirNota(idNota, tpAmb, tipo, idUsuario);
    }

    @Override
    public String obterTxtMiniDanfe(String idNota, String tpAmb, String tipo) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        return mensageiro.obterTxtMiniDanfe(idNota, tpAmb, tipo);
    }

    @Override
    public byte[] obterPdfMiniDanfe(String idNota, String tpAmb, String tipo) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        return mensageiro.obterPdfMiniDanfe(idNota, tpAmb, tipo);
    }

    @Override
    public void enviarEmailNota(String id, String tpAmb, Hashtable<String, String> props) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.sendEmail(id, tpAmb, props);
    }

    @Override
    public void enviarEmailNota(String id, String tpAmb) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.sendEmail(id, tpAmb, null);
    }

    @Override
    public void registrarUsuario(Usuario usuario, Perfil perfil) throws RemoteException {
        this.server.registrarUsuario(usuario, perfil);
    }

    @Override
    public void removerUsuario(Usuario usuario) throws RemoteException {
        this.server.removerUsuario(usuario);
    }

    @Override
    public Usuario obterUsuario(String login, String senha) throws RemoteException {
        return this.server.obterUsuario(login, senha);
    }

    @Override
    public boolean login(String login, String senha) throws RemoteException {
        return this.server.login(login, senha);
    }

    @Override
    public List<LogNFe> obterHistorico(String idNota, String tpAmb) throws RemoteException {
        return this.server.obterHistorico(idNota, tpAmb);
    }

    @Override
    public List<LogEnvioEmail> logemail(String keyxml, String tpAmb, Hashtable<String, String> props) throws RemoteException {
        return this.server.logEmail(keyxml, tpAmb);
    }

    @Override
    public Vector obterNotas(String tpAmb, Date d1, Date d2) throws RemoteException {
        return this.server.obterNotas(tpAmb, d1, d2);
    }

    @Override
    public Vector<EstadoNFe> obterNotas(String tpAmb, String CNPJDestinatario, String serie, String n1, String n2, Date d1, Date d2) throws RemoteException {
        return this.server.obterNotas(tpAmb, CNPJDestinatario, serie, n1, n2, d1, d2);
    }

    @Override
    public Vector<EstadoLote> obterLotes(String tpAmb, Date d1) throws RemoteException {
        return this.server.obterLotes(tpAmb, d1);
    }

    @Override
    public CodigoNFe obterCodigo(int codigo) throws RemoteException {
        return this.server.obterCodigo(codigo);
    }

    @Override
    public void ajustarSenhas(Hashtable<String, String> senhas) throws RemoteException {
        for (String arquivo : senhas.keySet()) {
            this.senhas.salvarSenha(arquivo, senhas.get(arquivo));
        }
        try {
            this.senders.clear();
            SenderPort s = new SenderPort(this, ConfiguracaoSys.getArquivoServicos(), null);
            this.senders.put("123", s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean checarSenha(String arquivo, String senha) throws RemoteException {
        return this.senhas.checarSenha(arquivo, senha);
    }

    @Override
    public EstadoLote obterLote(String idNota, String tpAmb) throws RemoteException {
        return this.server.obterLote(idNota, tpAmb);
    }

    @Override
    public Vector<EstadoNFe> obterNotas(String idLote, String tpAmb) throws RemoteException {
        return this.server.obterNotas(idLote, tpAmb);
    }

    @Override
    public EstadoRecibo obterRecibo(String idLote, String tpAmb) throws RemoteException {
        return this.server.obterRecibo(idLote, tpAmb);
    }

    @Override
    public void notificarControle(String cnpj, String idLote, String recibo, Set<String> notas, String tpAmb, String idUsuario) throws RemoteException {
        Collection<ControleInterface> ctrls = this.controladores.values();
        ControleInterface ctrl = ctrls.iterator().next();
        ctrl.notificarControle(cnpj, idLote, recibo, notas, tpAmb, idUsuario);
    }

    @Override
    public void trocarSenha(String login, String senha) throws RemoteException {
        this.server.trocarSenha(login, senha);
    }

    @Override
    public Hashtable<String, String> obterNomesFantasia() throws RemoteException {
        return ConfiguracaoSys.getNomesFantasia();
    }

    @Override
    public void ajustarTipoServico(String cnpj, String tipo) throws RemoteException {
        ParChave chave = new ParChave(cnpj, tipo);
        this.tipoServicos.put(chave, tipo);
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        for (MensageiroRemote msn : msns) {
            msn.ajustarTipoServicos(this.tipoServicos);
        }
    }

    @Override
    public String obterTipoServico(String cnpj) throws RemoteException {
        return this.tipoServicos.get(cnpj);
    }

    @Override
    public void ajustarMensageiroConfig(String cnpj, MensageiroConfig conf) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        for (MensageiroRemote msn : msns) {
            msn.numeroNotas(cnpj, conf.getNumeroNotas());
            msn.timeOut(cnpj, conf.getTimeout());
            msn.tamanhoLote(cnpj, conf.getTamanhoLote());
        }
        Collection<ControleInterface> ctrls = this.controladores.values();
        for (ControleInterface ctrl : ctrls) {
            ctrl.tempoProcessamento(cnpj, conf.getTempoProc());
        }
        this.numeroNotas.put(cnpj, conf.getNumeroNotas());
        this.timeouts.put(cnpj, conf.getTimeout());
        this.tamanhoArquivos.put(cnpj, conf.getTamanhoLote());
        this.tempoProcessamento.put(cnpj, conf.getTempoProc());
    }

    @Override
    public MensageiroConfig obterMensageiroConfig(String cnpj) throws RemoteException {
        MensageiroConfig conf = new MensageiroConfig();
        conf.setOp(this.state.getState(cnpj));
        conf.setNumeroNotas(this.numeroNotas.get(cnpj));
        conf.setTimeout(this.timeouts.get(cnpj));
        conf.setTempoProc(this.tempoProcessamento.get(cnpj));
        conf.setTamanhoLote(this.tamanhoArquivos.get(cnpj));
        conf.setCnpj(cnpj);
        return conf;
    }

    @Override
    public void ajustarServicosConfig(ServicosConfig conf) throws RemoteException {
    }

    @Override
    public ServicosConfig obterServicosConfig() throws RemoteException {
        ServicosConfig conf = new ServicosConfig();
        conf.setArquivosPFX(ConfiguracaoSys.getKeyFiles());
        conf.setTodosEsquemas(ConfiguracaoSys.getVersaoEsquema());
        conf.setCnpjsUf(ConfiguracaoSys.getCnpjsUF());
        conf.setUfs(ConfiguracaoSys.obterUFsCadastrados());
        conf.setArquivoServicos(ConfiguracaoSys.getArquivoServicos());
        conf.setPfxDeTransmissao(ConfiguracaoSys.getPfxDeTransmissao());
        conf.setTipoAmbiente(ConfiguracaoSys.getTipoAmbiente());
        conf.setTrustStore(ConfiguracaoSys.getTrustStore());
        return conf;
    }

    @Override
    public Hashtable<ParChave, String> obterTipoServicos() throws RemoteException {
        return this.tipoServicos;
    }

    @Override
    public BaseDadosConfig obterBDConfig() {
        BaseDadosConfig conf = new BaseDadosConfig();
        conf.setUrl(ConfiguracaoSys.getURL_CONECTION());
        conf.setSenha(ConfiguracaoSys.getPASSWORD());
        conf.setUsuario(ConfiguracaoSys.getUSER_NAME());
        conf.setNomeDriver(ConfiguracaoSys.getDRIVER());
        conf.setToplinkProp(ConfiguracaoSys.getToplinkProp());
        Hashtable<String, String> prop = new Hashtable<String, String>();
        prop.put("WRAPPERDIR", ConfiguracaoSys.getPastaWrapper());
        conf.setProp(prop);
        return conf;
    }

    @Override
    public void ajustarTodosServicos(Hashtable[] servicos) throws RemoteException {
        ConfiguracaoSys.ajustarTodosServicos(servicos);
        Collection<SenderRemote> senderss = this.senders.values();
        for (SenderRemote senderRemote : senderss) {
        }
    }

    @Override
    public SenderConf obterSenderConfig() throws RemoteException {
        SenderConf conf = new SenderConf();
        ConfiguracaoXML senderConfig = ConfiguracaoSys.getSenderConfig();
        Hashtable<String, Class> classs = senderConfig.getClasses();
        Hashtable<String, String> class_s = new Hashtable<String, String>();
        for (String t : classs.keySet()) {
            class_s.put(t, classs.get(t).getCanonicalName());
        }
        conf.setClasses(class_s);
        conf.setNamespaceNames(senderConfig.getNamespaceNames());
        conf.setNomeOperacao(senderConfig.getNomeOperacao());
        conf.setNomeServico(senderConfig.getNomeServico());
        conf.setPortNames(senderConfig.getPortNames());
        conf.setUrlServicosHomolgacao(senderConfig.getUrlServicosHomolgacao());
        conf.setUrlServicosNormal(senderConfig.getUrlServicosNormal());
        conf.setUrlServicosScan(senderConfig.getUrlServicosScan());
        conf.setUrlServicosDpecHom(senderConfig.getUrlServicosDpecHomologacao());
        conf.setUrlServicosDpecProd(senderConfig.getUrlServicosDpecProducao());
        return conf;
    }

    @Override
    public void todoEmContingencia(String tpAmb, String idUsuario) throws RemoteException {
        Vector<String> cnpjs = this.obterCNPJRegistrados();
        for (String cnpj : cnpjs) {
            System.out.println("enviando: " + cnpj);
            this.mudarEstadoNormalEnvioContingencia(cnpj, tpAmb, idUsuario);
        }
    }

    @Override
    public void criarDpec(String cnpj, String tpAmb) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.criarDpec(cnpj, tpAmb);
    }

    @Override
    public void enviarNotasDpec(String cnpj, String tpAmb, String idUsuario) throws RemoteException {
        this.mudarEstadoNormalSemEnvio(cnpj, tpAmb);
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.enviarNotasDpec(cnpj, tpAmb, idUsuario);
    }

    @Override
    public void enviarNotasEPEC(String cnpj, String tpAmb, String idUsuario) throws RemoteException {
        this.mudarEstadoNormalSemEnvio(cnpj, tpAmb);
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.enviarNotasEPEC(cnpj, tpAmb, idUsuario);
    }

    @Override
    public void mudarEstadoDpec(String cnpj, String tpAmb) throws RemoteException {
        this.state.setState(cnpj, PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC);
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.mudarEstadoDpec(cnpj, tpAmb);
        this.changeOp(cnpj, "DPEC", "2");
    }

    @Override
    public void changeModeTo(String cnpj, PropriedadesSistema.MODO_OP modoop, Hashtable<String, Object> params) throws RemoteException {
        this.state.setState(cnpj, modoop);
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.changeModeTo(cnpj, modoop, params);
        this.changeOp(cnpj, modoop.toString(), "");
    }

    @Override
    public String obterXml(String idNota, String tpAmb) throws RemoteException {
        return this.server.obterXml(idNota, tpAmb);
    }

    @Override
    public void findProtocol(String cnpj, String serie, String numero, String tpAmb, String idUsuario) throws RemoteException {
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.findProtocol(cnpj, serie, numero, tpAmb, idUsuario);
    }

    @Override
    public Vector<String> findPrinters() throws RemoteException {
        if (PropriedadesMain.isPrinter()) {
            return PrintFinder.getInstance().findPrinter();
        }
        return new Vector<String>();
    }

    @Override
    public Hashtable<String, String> obterImpressorasDefault() throws RemoteException {
        return PrintFinder.getInstance().obterImpressorasDefault();
    }

    @Override
    public Hashtable<String, String> obterImpressorasPermitidas() throws RemoteException {
        return PrintFinder.getInstance().obterImpressorasPermitidas();
    }

    @Override
    public void setPrinter(String codigo, String printer) throws RemoteException {
        PrintFinder.getInstance().setPrinter(codigo, printer);
    }

    @Override
    public Vector<EstadoNFe> findNota(String tpAmb, String cnpj, String serie, String ini, String fim, Date data) throws RemoteException {
        return this.server.findNota(tpAmb, cnpj, serie, ini, fim, data);
    }

    @Override
    public void mudarEstadoScan(String cnpj, String tpAmb) throws RemoteException {
        System.out.println("Mudando SCAN");
        this.state.setState(cnpj, PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN);
        Collection<MensageiroRemote> msns = this.mensageiros.values();
        MensageiroRemote mensageiro = msns.iterator().next();
        mensageiro.mudarEstadoScan(cnpj, tpAmb);
        this.changeOp(cnpj, "SCAN", "2");
    }

    @Override
    public void addBoletoXML(String id, String xml) throws RemoteException {
        BoletoManager.getXmls().put(id, xml);
    }

    @Override
    public byte[] downloadPDF(String id, String tpAmb, String idUsuario) throws RemoteException {
        return this.server.downloadPDF(id, tpAmb, idUsuario);
    }

    @Override
    public String dowloadLog(File file, Hashtable<String, String> props) throws RemoteException {
        return this.server.dowloadLog(file, props);
    }

    @Override
    public Vector<File> logList(Hashtable<String, String> props) throws RemoteException {
        return this.server.logList(props);
    }

    @Override
    public Vector<EstadoNFe> obterNotas(String tpAmb, Vector<String> cnpjs, String serie, String n1, String n2, Date d1, Date d2) throws RemoteException {
        Vector<EstadoNFe> notas = this.server.obterNotas(tpAmb, cnpjs, serie, n1, n2, d1, d2);
        return notas;
    }

    @Override
    public void notificarArquivoNaoTratado(String nomeArquivo, String motivo, String chave) throws RemoteException {
    }

    @Override
    public Vector<String> obterEmails(String cnpj) throws RemoteException {
        return null;
    }

    @Override
    public void persistPrintKey(String id, String key) throws RemoteException {
        PrintFinder.getInstance().persistPrintKey(id, key);
    }

    @Override
    public void setEmail(String codigo, String emaildest, String emailtransp) throws RemoteException {
        EmailFinder.getEmailsdest().put(codigo, emaildest);
        EmailFinder.getEmailstransp().put(codigo, emailtransp);
    }

    @Override
    public CadastroEmail getEmails(String cnpj) throws RemoteException {
        CadastroEmail cad = EmailConsomer.getInstance().findEmails(cnpj);
        return cad;
    }

    @Override
    public void updateEmail(Hashtable<String, String> table) throws RemoteException {
        EmailConsomer.getInstance().updateEmails(table);
    }

    @Override
    public String adicionarEvento(String keyxml, String tpAmb, EventoInfo info, Hashtable<String, String> props, String idUsuario) throws RemoteException {
        Collection<EventManagerInterface> eventmngs = this.eventmanagers.values();
        EventManagerInterface event = eventmngs.iterator().next();
        return event.adicionarEvento(keyxml, tpAmb, info, props, idUsuario);
    }

    @Override
    public String xmlCCe(String id, String tpAmb, int number) throws RemoteException {
        Collection<EventManagerInterface> eventmngs = this.eventmanagers.values();
        EventManagerInterface event = eventmngs.iterator().next();
        return event.xmlCCe(id, tpAmb, 0);
    }

    @Override
    public List<EventoInfo> obterEventos(String keyxml, String tpAmb, Hashtable<String, String> props) throws RemoteException {
        Collection<EventManagerInterface> eventmngs = this.eventmanagers.values();
        EventManagerInterface event = eventmngs.iterator().next();
        return event.obterEventos(keyxml, tpAmb, props);
    }

    @Override
    public EstadoNFe getEstadoNFe(String id, String tpAmb) throws RemoteException {
        return this.server.getEstadoNFe(id, tpAmb);
    }

    @Override
    public void registerOperacao(Hashtable<String, String> props) throws RemoteException {
    }

    private Connection getConn() {
        XMLConfigSystem config = XMLConfigSystem.getInstance((String)MainParameters.getXml());
        config.make();
        DBConfig dbconfig = config.getDbConfig();
        Connection cx = null;
        try {
            Class.forName(dbconfig.getDriver());
            cx = DriverManager.getConnection(dbconfig.getUrl(), dbconfig.getUser(), dbconfig.getPassword());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cx;
    }

    @Override
    public Hashtable<String, Object> genericRemoteCall(Hashtable<String, Object> params, String tpAmb, String idUsuario) throws RemoteException {
        System.out.println(params.toString());
        if (params != null && params.containsKey("allusers")) {
            String nome;
            String login = params.get("login").toString();
            List<Usuario> users = this.server.findUser(login, nome = params.get("nome").toString());
            if (users != null) {
                Hashtable<String, Object> pp = new Hashtable<String, Object>();
                pp.put("users", users);
                return pp;
            }
            return null;
        }
        if (params != null && params.containsKey("statuscancel")) {
            if (this.cx == null) {
                this.cx = this.getConn();
            }
            String ss = null;
            try {
                Statement stat = this.cx.createStatement();
                ResultSet result = stat.executeQuery("select STATUSCANCINUT from EstadoNFe where id = '" + params.get("statuscancel") + "' and ambiente='" + tpAmb + "'");
                if (result.next()) {
                    ss = result.getString("STATUSCANCINUT");
                }
                result.close();
                stat.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ss != null) {
                Hashtable<String, Object> pp = new Hashtable<String, Object>();
                pp.put("status", ss);
                return pp;
            }
            return null;
        }
        if (params != null && params.containsKey("gerarxmlpdf")) {
            Collection<MensageiroRemote> msns = this.mensageiros.values();
            MensageiroRemote mensageiro = msns.iterator().next();
            String idNota = params.get("gerarxmlpdf").toString();
            try {
                mensageiro.gerarXMLProt(idNota, tpAmb, idUsuario);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
        if (params != null && params.containsKey("downloadps")) {
            String id = params.get("downloadps").toString();
            byte[] psfile = this.server.downloadPS(id, tpAmb);
            Hashtable<String, Object> result = new Hashtable<String, Object>();
            if (psfile != null) {
                result.put("downloadps", psfile);
            }
            return result;
        }
        if (params != null && params.containsKey("b2bxml")) {
            String id = params.get("keyxml").toString();
            DAOGenerico<ExtraXMLInfo> daoExtrainfo = new DAOGenerico<ExtraXMLInfo>(ExtraXMLInfo.class);
            EntidadeId eid = new EntidadeId(id, tpAmb);
            ExtraXMLInfo info = (ExtraXMLInfo)daoExtrainfo.buscarPorIdObject(eid);
            boolean isnew = false;
            if (info == null) {
                info = new ExtraXMLInfo();
                isnew = true;
            }
            info.setId(id);
            info.setXmlstring(params.get("b2bxml").toString());
            info.setAmbiente(tpAmb);
            info.setDataatualizacao(Calendar.getInstance().getTime());
            info.setVersao(info.getVersao() + 1);
            if (isnew) {
                daoExtrainfo.salvar(info);
            } else {
                daoExtrainfo.unir(info);
            }
            daoExtrainfo.flush();
            daoExtrainfo.close();
            daoExtrainfo = null;
        }
        if (params != null && params.containsKey("xmlcce")) {
            Hashtable<String, Object> response = new Hashtable<String, Object>();
            response.put("xmlcce", this.xmlCCe(params.get("xmlcce").toString(), tpAmb, 0));
            return response;
        }
        if (params != null && params.containsKey("excelreport")) {
            Vector infos = (Vector)params.get("excelreport");
            ExcelDocumentGenerator gen = new ExcelDocumentGenerator(null, infos);
            gen.create();
            Hashtable<String, Object> result = new Hashtable<String, Object>();
            File excelfile = gen.generateExcelFile();
            if (excelfile != null) {
                result.put("downloadexcel", excelfile);
            }
            return result;
        }
        return null;
    }

    @Override
    public byte[] downloadFile(String filename, File file, Hashtable<String, Object> props) throws RemoteException {
        try {
            while (!file.exists() || file.length() == 0L) {
                Thread.sleep(500L);
            }
            byte[] buffer = new byte[(int)file.length()];
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file.getAbsolutePath()));
            input.read(buffer, 0, buffer.length);
            input.close();
            return buffer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public File process(String tpAmb, Vector<String> cnpjsemit, Vector<String> cnpjsdest, Date d1, Date d2, Hashtable<String, String> props) throws RemoteException {
        try {
            return this.extractor.process(tpAmb, cnpjsemit, cnpjsdest, d1, d2, props);
        }
        catch (Exception e) {
            throw new RemoteException(e.getLocalizedMessage(), e.getCause());
        }
    }

    @Override
    public File process(String tpAmb, Vector<String> xmls) throws RemoteException {
        try {
            return this.extractor.process(tpAmb, xmls);
        }
        catch (Exception e) {
            throw new RemoteException(e.getLocalizedMessage(), e.getCause());
        }
    }

    @Override
    public Vector<EstadoNFe> findXMLDocument(String query, Hashtable<String, Object> params, Hashtable<String, String> tablequery) throws RemoteException {
        XMLDBInterfaceProvider provider = XMLDBProviderFactory.createProvider();
        try {
            if (query == null) {
                CreateXPathQuery creator = new CreateXPathQuery();
                query = creator.createXPathQueryFromHashtable(tablequery);
            }
            System.out.println("XPathQuery:" + query);
            Vector<EstadoNFe> res = provider.findXMLDocument(query, params);
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException(e.getLocalizedMessage(), e.getCause());
        }
    }

    @Override
    public String saveXMLDocument(String id, String xml, Hashtable<String, String> prop) throws RemoteException {
        XMLDBInterfaceProvider provider = XMLDBProviderFactory.createProvider();
        try {
            return provider.saveXMLDocument(id, xml, prop);
        }
        catch (Exception e) {
            throw new RemoteException(e.getLocalizedMessage(), e.getCause());
        }
    }

    @Override
    public File createRelatorio(Hashtable<String, String> headerdata, Vector<EstadoNFe> infos) throws RemoteException {
        PSGeneratorPrinter generator = new PSGeneratorPrinter(headerdata, infos);
        generator.create();
        return generator.generatePDF();
    }

    @Override
    public List<Empresa> empresasLFU(String tpAmb, String login) throws RemoteException {
        DAOGenerico daoEmp = new DAOGenerico(Empresa.class);
        DAOGenerico daoluf = new DAOGenerico(EmpresaLFU.class);
        EntidadeLFU eLFU = new EntidadeLFU(login, tpAmb);
        ArrayList<Empresa> lista = new ArrayList<Empresa>();
        EmpresaLFU empresasluf = (EmpresaLFU)daoluf.buscarPorIdObject(eLFU);
        if (empresasluf != null) {
            Vector<String> cnpjs = empresasluf.getCnpjs();
            for (String cnpj : cnpjs) {
                EntidadeCnpj eCnpj = new EntidadeCnpj(cnpj, tpAmb);
                Empresa emp = (Empresa)daoEmp.buscarPorIdObject(eCnpj);
                lista.add(emp);
            }
        }
        daoluf.close();
        daoluf = null;
        daoEmp.close();
        daoEmp = null;
        return lista;
    }

    @Override
    public void registerEmpresaLFU(String tpAmb, String login, Empresa emp) throws RemoteException {
        Vector<String> empresascnpj;
        DAOGenerico<EmpresaLFU> daoluf = new DAOGenerico<EmpresaLFU>(EmpresaLFU.class);
        EntidadeLFU eLFU = new EntidadeLFU(login, tpAmb);
        EmpresaLFU empresasluf = (EmpresaLFU)daoluf.buscarPorIdObject(eLFU);
        boolean isnew = false;
        if (empresasluf == null) {
            empresasluf = new EmpresaLFU();
            empresasluf.setLogin(login);
            empresasluf.setAmbiente(tpAmb);
            empresasluf.setCnpjs(new Vector<String>());
            isnew = true;
        }
        if ((empresascnpj = empresasluf.getCnpjs()).size() > this.sizeLFU) {
            empresascnpj.remove(empresascnpj.size() - 1);
            empresascnpj.insertElementAt(emp.getCnpj(), 0);
        } else if (!empresascnpj.contains(emp.getCnpj())) {
            empresascnpj.add(emp.getCnpj());
        }
        empresasluf.setCnpjs(empresascnpj);
        if (isnew) {
            daoluf.salvar(empresasluf);
        } else {
            daoluf.unir(empresasluf);
        }
        daoluf.flush();
        daoluf.close();
        daoluf = null;
    }

    @Override
    public List<Empresa> findEmpresa(String tpAmb, String cnpj, String razaosocial, Hashtable<String, Object> params) throws RemoteException {
        DAOGenerico daoEmp = new DAOGenerico(Empresa.class);
        Empresa.TIPO_EMPRESA type = (Empresa.TIPO_EMPRESA)((Object)params.get("type"));
        String sql = "SELECT * FROM EMPRESA\n";
        sql = String.valueOf(sql) + " WHERE AMBIENTE = '" + tpAmb + "'\n";
        sql = String.valueOf(sql) + "   AND TIPO = " + type.ordinal() + "\n";
        sql = String.valueOf(sql) + "   AND LOWER(CNPJ) LIKE '%" + cnpj.toLowerCase() + "%'\n";
        sql = String.valueOf(sql) + "   AND LOWER(NOME) LIKE '%" + razaosocial.toLowerCase() + "%'\n";
        sql = String.valueOf(sql) + "order by NOME asc";
        System.out.println("Query findEmpresa: \n" + sql);
        Query q = daoEmp.criarNativeQuery(sql);
        List o = q.getResultList();
        daoEmp.close();
        daoEmp = null;
        return o;
    }
}

