/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.main;

import br.com.taragona.nfe.clientreferencia.ReferenciaGerenciador;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.sender.SenderPort;
import br.com.taragona.nfe.sender.SenderRemote;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.ServicosConfig;
import br.com.tti.sefaz.util.MainParameters;
import br.com.tti.sefaz.wrapper.WrapperSender;
import br.com.tti.sefaz.wrapper.WrapperSenderV310;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

public class IniciarSender {
    private static String OBJECTNAME = "assinador";
    private String objname = "//localhost/" + OBJECTNAME;
    private GerenciadorInterface gerenciador = this.obterGerenciador();
    private ServicosConfig servicosConfig;

    public IniciarSender() {
        if (this.gerenciador == null) {
            System.out.println("nao foi possivel conectar com o gerenciador!");
            System.exit(-1001);
        }
        try {
            PropriedadesSistema.setBdConfig(this.gerenciador.obterBDConfig());
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        if (this.gerenciador == null) {
            System.out.println("Gerenciador nao encontrado!");
            System.exit(100);
        }
        Object sender = null;
        for (String cnpj : PropriedadesMain.getCnpjs()) {
            System.out.println("Iniciando Sender para CNPJ: " + cnpj);
            if (!ConfiguracaoSys.getCnpjsTipo().containsKey(cnpj)) {
                System.out.println("CNPJ nao cadastrado no configuracao.xml: " + cnpj);
                System.exit(-1000);
            }
            if (ConfiguracaoSys.getCnpjsTipo().get(cnpj).endsWith("v200")) {
                try {
                    sender = new WrapperSender(this.gerenciador, MainParameters.getPfx());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (ConfiguracaoSys.getCnpjsTipo().get(cnpj).endsWith("v310")) {
                try {
                    sender = new WrapperSenderV310(this.gerenciador, MainParameters.getPfx());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    sender = new SenderPort(this.gerenciador, ConfiguracaoSys.getArquivoServicos(), MainParameters.getPfx());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Sender: " + sender);
            try {
                SenderRemote senderStub = (SenderRemote)UnicastRemoteObject.exportObject((Remote)sender, 0);
                this.gerenciador.registrarSender(cnpj, senderStub);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private GerenciadorInterface obterGerenciador() {
        Vector<String> ips = PropriedadesMain.getIps();
        GerenciadorInterface ger = null;
        for (String ip : ips) {
            try {
                ger = ReferenciaGerenciador.obterReferenciaGerenciador(ip);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ger;
    }

    public static void main(String[] argv) {
        System.setProperty("javax.net.ssl.keyStore", "C:\\TTINFE2.0\\certificados\\kion_2015.pfx");
        System.setProperty("javax.net.ssl.keyStorePassword", "kion2015");
        System.setProperty("javax.net.ssl.keyStoreType", "PKCS12");
        PropriedadesMain.processarComandos(argv);
        MainParameters.processArguments((String[])argv);
        IniciarSender i = new IniciarSender();
        System.out.println("Sender Iniciado");
    }
}

