/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.mensageiro;

import br.com.taragona.nfe.mensageiro.MonitorarBoletosThread;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class MonitorarBoletosScheduler {
    private static final MonitorarBoletosScheduler INSTANCE = new MonitorarBoletosScheduler();
    private final ScheduledExecutorService executor;

    private MonitorarBoletosScheduler() {
        final AtomicInteger count = new AtomicInteger(1);
        this.executor = Executors.newScheduledThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors() / 2), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "monitorar-boletos-" + count.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        });
    }

    public static MonitorarBoletosScheduler getInstance() {
        return INSTANCE;
    }

    public void iniciarMonitoramento(MonitorarBoletosThread tarefa) {
        this.agendar(tarefa, 0L);
    }

    public void agendar(MonitorarBoletosThread tarefa, long delayMillis) {
        this.executor.schedule(tarefa, delayMillis, TimeUnit.MILLISECONDS);
    }
}

