/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.mensageiro;

import br.com.taragona.nfe.danfe.ImprimirDANFEImpl;
import br.com.taragona.nfe.danfe.SendEmailThread;
import br.com.taragona.nfe.email.MailSender;
import br.com.taragona.nfe.mensageiro.MonitorarBoletosScheduler;
import br.com.taragona.nfe.mensageiro.MonitorarBoletosService;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EntidadeId;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.tools.PathFileFinder;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.PropriedadesMain;
import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.NodeList;

public class MonitorarBoletosThread
implements Runnable {
    private final MonitorarBoletosService monitorService;
    private String idNota;
    private String tpAmb;
    private String nota;
    private String CNPJEmitente;
    private String CNPJDestino;
    private Date data;
    private String idUsuario;
    private String numeroNota;
    private String pathXml;
    private String pathProtXml;
    private String pathBoletos;
    private String pathDanfe;
    private String pathDanfeBoleto;
    private String pathDanfeBoletoFile;
    private List<String> boletos;
    private List<String> duplicatas;
    private final long inicioMonitoramento;
    private boolean reagendado;
    private static final long TEMPO_MAX_ESPERA = TimeUnit.HOURS.toMillis(24L);
    private static final long INTERVALO_VERIFICACAO = TimeUnit.MINUTES.toMillis(5L);

    public MonitorarBoletosThread(String idNota, String tpAmb, String nota, String CNPJEmitente, String CNPJDestino, Date data, String idUsuario, MonitorarBoletosService monitorService) {
        this.monitorService = monitorService;
        this.idNota = idNota;
        this.tpAmb = tpAmb;
        this.nota = nota;
        this.CNPJEmitente = CNPJEmitente;
        this.CNPJDestino = CNPJDestino;
        this.data = data;
        this.idUsuario = idUsuario;
        this.pathBoletos = PropriedadesMain.getSAPBoletoPath();
        this.pathDanfe = "";
        this.boletos = new ArrayList<String>();
        this.duplicatas = this.extrairDuplicatas(nota);
        this.pathXml = PathFileFinder.getINSTANCE().findXMLPath(idNota, tpAmb, data);
        this.pathProtXml = PathFileFinder.getINSTANCE().findXMLProtFile(idNota, tpAmb, data);
        this.pathDanfe = PathFileFinder.getINSTANCE().findPDFPath(idNota, tpAmb, data);
        this.pathDanfeBoleto = this.pathDanfe.replace("PDF", "BOLETOS");
        this.pathDanfe = String.valueOf(this.pathDanfe) + "/" + idNota + ".pdf";
        File fileDanfeBoleto = new File(this.pathDanfeBoleto);
        if (!fileDanfeBoleto.exists()) {
            fileDanfeBoleto.mkdirs();
        }
        this.pathDanfeBoletoFile = String.valueOf(this.pathDanfeBoleto) + "/" + idNota + ".pdf";
        this.inicioMonitoramento = System.currentTimeMillis();
        this.reagendado = false;
        GerenciadorChavesNota c = new GerenciadorChavesNota(idNota);
        this.numeroNota = String.format("%09d", (int)new Integer(c.getNumeroNota()));
    }

    private List<String> extrairDuplicatas(String xml) {
        ArrayList<String> duplicatas = new ArrayList<String>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            org.w3c.dom.Document doc = builder.parse(new ByteArrayInputStream(xml.getBytes()));
            NodeList nodes = doc.getElementsByTagName("dup");
            int i = 0;
            while (i < nodes.getLength()) {
                duplicatas.add(nodes.item(i).getTextContent());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return duplicatas;
    }

    @Override
    public void run() {
        try {
            this.reagendado = false;
            if (this.duplicatas.isEmpty()) {
                return;
            }
            if (!this.arquivoPronto(this.pathDanfe)) {
                this.reprogramarVerificacao("DANFE ainda n\u00e3o dispon\u00edvel para a nota " + this.idNota);
                return;
            }
            if (!this.boletosGerados()) {
                if (System.currentTimeMillis() - this.inicioMonitoramento > TEMPO_MAX_ESPERA) {
                    System.err.println("Tempo maximo de espera atingido para a nota " + this.idNota);
                    return;
                }
                this.reprogramarVerificacao("Boletos ainda nao encontrados para a nota " + this.idNota);
                return;
            }
            this.processarNotaComBoletos();
        }
        finally {
            if (!this.reagendado && this.monitorService != null) {
                this.monitorService.notificarConclusao(this.idNota, this.tpAmb);
            }
        }
    }

    private void reprogramarVerificacao(String motivo) {
        this.reagendado = true;
        MonitorarBoletosScheduler.getInstance().agendar(this, INTERVALO_VERIFICACAO);
    }

    private boolean boletosGerados() {
        this.boletos.clear();
        File dir = new File(this.pathBoletos);
        if (!dir.exists()) {
            return false;
        }
        File[] arquivos = dir.listFiles((d, name) -> name.contains(this.numeroNota));
        if (arquivos == null) {
            return false;
        }
        if (arquivos.length == this.duplicatas.size()) {
            File[] fileArray = arquivos;
            int n = arquivos.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.boletos.add(f.getAbsolutePath());
                ++n2;
            }
            return !this.boletos.isEmpty();
        }
        return false;
    }

    private void processarNotaComBoletos() {
        block9: {
            ArrayList<String> anexos = new ArrayList<String>();
            anexos.add(this.pathProtXml);
            Document document = new Document();
            try {
                PdfCopy copy = new PdfCopy(document, (OutputStream)new FileOutputStream(this.pathDanfeBoletoFile));
                document.open();
                PdfReader reader = new PdfReader((InputStream)new FileInputStream(this.pathDanfe));
                int numPages = reader.getNumberOfPages();
                int i = 1;
                while (i <= numPages) {
                    copy.addPage(copy.getImportedPage(reader, i));
                    ++i;
                }
                reader.close();
                for (String boleto : this.boletos) {
                    FileInputStream fis = new FileInputStream(boleto);
                    reader = new PdfReader((InputStream)fis);
                    numPages = reader.getNumberOfPages();
                    int i2 = 1;
                    while (i2 <= numPages) {
                        copy.addPage(copy.getImportedPage(reader, i2));
                        ++i2;
                    }
                    reader.close();
                    fis.close();
                    String destino = MonitorarBoletosThread.moverArquivo(boleto, this.pathDanfeBoleto);
                    if (destino == null) continue;
                    anexos.add(destino);
                }
                document.close();
                DAOGenerico<EstadoNFe> daoNota = new DAOGenerico<EstadoNFe>(EstadoNFe.class);
                EntidadeId eid = new EntidadeId(this.idNota, this.tpAmb);
                EstadoNFe nfe = (EstadoNFe)daoNota.buscarPorIdObject(eid);
                if (nfe != null && !nfe.getImportouBoleto()) {
                    nfe.setImportouBoleto(true);
                    daoNota.salvar(nfe);
                }
                if (!PropriedadesMain.isEmail()) break block9;
                try {
                    if (!anexos.isEmpty()) {
                        MailSender sender = new MailSender();
                        String cnpjtransp = ImprimirDANFEImpl.obterCNPJTransp(this.nota);
                        SendEmailThread sendert = new SendEmailThread(null, sender, this.idNota, this.tpAmb, this.CNPJEmitente, this.CNPJDestino, cnpjtransp, anexos.toArray(new String[0]), this.pathXml);
                        Thread t = new Thread(sendert);
                        t.start();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String moverArquivo(String origem, String destino) {
        Path origemPath = Paths.get(origem, new String[0]);
        Path destinoDir = Paths.get(destino, new String[0]);
        Path destinoPath = destinoDir.resolve(origemPath.getFileName());
        try {
            Files.move(origemPath, destinoPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            System.err.println("Erro ao mover " + origem + ": " + e.getMessage());
        }
        return destinoPath.toString();
    }

    public static String copiarEApagar(String origem, String destinoDir) {
        Path origemPath = Paths.get(origem, new String[0]);
        Path destinoPath = Paths.get(destinoDir, origemPath.getFileName().toString());
        try {
            Files.createDirectories(Paths.get(destinoDir, new String[0]), new FileAttribute[0]);
            Files.copy(origemPath, destinoPath, StandardCopyOption.REPLACE_EXISTING);
            if (Files.size(origemPath) == Files.size(destinoPath)) {
                Files.delete(origemPath);
                return destinoPath.toString();
            }
            Files.delete(destinoPath);
            throw new IOException("C\u00f3pia incompleta detectada");
        }
        catch (IOException e) {
            System.err.println("Erro ao copiar e apagar " + origem + ": " + e.getMessage());
            return null;
        }
    }

    private boolean arquivoPronto(String filePath) {
        block13: {
            File file = new File(filePath);
            if (!file.exists() || file.length() == 0L) {
                return false;
            }
            Throwable throwable = null;
            Object var4_6 = null;
            FileInputStream fis = new FileInputStream(file);
            try {
                PdfReader reader = new PdfReader((InputStream)fis);
                reader.close();
                if (fis == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
            fis.close();
        }
        return true;
    }
}

