/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.mensageiro.caches;

import br.com.taragona.nfe.mensageiro.Mensageiro;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EntidadeId;
import br.com.taragona.nfe.persistence.EstadoLote;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.db.QuickDB;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import br.com.taragona.nfe.xmlgenerator.FileManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class CacheLotesPendentes {
    private static Long ID_LOTE = 0L;
    private static CacheLotesPendentes INSTANCIA = null;
    private DAOGenerico<EstadoLote> daoLote;
    private DAOGenerico<EstadoNFe> daoNota;
    private QuickDB quick;

    public static CacheLotesPendentes obterInstancia() {
        if (INSTANCIA == null) {
            INSTANCIA = new CacheLotesPendentes();
        }
        return INSTANCIA;
    }

    private CacheLotesPendentes() {
        BaseDadosConfig bdConfig = PropriedadesSistema.getBdConfig();
        this.quick = new QuickDB(bdConfig.getUrl(), bdConfig.getUsuario(), bdConfig.getSenha());
        this.daoLote = new DAOGenerico(EstadoLote.class);
        this.daoNota = new DAOGenerico(EstadoNFe.class);
    }

    public void cacheLotePendente(String lote, String id, String tpAmb, String cnpj, Set<String> notas) {
        EntidadeId loteId = new EntidadeId(id, tpAmb);
        EstadoLote estado = this.daoLote.buscarPorIdObject(loteId);
        if (estado == null) {
            estado = new EstadoLote();
            estado.setId(id);
            estado.setAmbiente(tpAmb);
            estado.setEstado(EstadoLote.ESTADO_LOTE.GERADO);
            estado.setEstadoOperacao(Mensageiro.modoAtual.get(cnpj));
            estado.setData(new Date());
            estado.setCnpj(cnpj);
            estado.setUltimaTentativa(new Date());
            estado.setNumeroTentativa(0);
            estado.setNotas(null);
            this.daoLote.salvar(estado);
            this.daoLote.flush();
            this.quick.associarLote(id, notas);
            this.daoNota.clear();
            this.daoLote.clear();
        } else {
            estado.setEstado(EstadoLote.ESTADO_LOTE.GERADO);
            estado.setEstadoOperacao(Mensageiro.modoAtual.get(cnpj));
            estado.setData(new Date());
            estado.setCnpj(cnpj);
            estado.setUltimaTentativa(new Date());
            estado.setNumeroTentativa(0);
            estado.setNotas(null);
            this.daoLote.unir(estado);
            this.daoLote.flush();
            this.quick.associarLote(id, notas);
            this.daoNota.clear();
            this.daoLote.clear();
        }
    }

    public synchronized String obterLotePendenteAsString(String id, String tpAmb) {
        try {
            EntidadeId loteId = new EntidadeId(id, tpAmb);
            EstadoLote estado = this.daoLote.buscarPorIdObject(loteId);
            if (estado != null) {
                return estado.getXmlString();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public synchronized EstadoLote obterLotePendente(String id, String tpAmb) {
        EntidadeId loteId = new EntidadeId(id, tpAmb);
        return this.daoLote.buscarPorIdObject(loteId);
    }

    public synchronized Collection<String> obterLotesPendentesAsString() {
        List<EstadoLote> lotesEstado = this.daoLote.obterElementos();
        Vector<String> lotes = new Vector<String>();
        for (EstadoLote estadoLote : lotesEstado) {
            if (estadoLote.getEstado() != EstadoLote.ESTADO_LOTE.GERADO) continue;
            try {
                File file = FileManager.obterArquivoLote(estadoLote.getId());
                FileReader fr = new FileReader(file);
                BufferedReader br = new BufferedReader(fr);
                String lote = new String();
                String tempo = br.readLine();
                while (tempo != null) {
                    lote = String.valueOf(lote) + tempo;
                    tempo = br.readLine();
                }
                br.close();
                fr.close();
                lotes.add(lote);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return lotes;
    }

    public synchronized void ajustarEstadoNFe(String idLote, String tpAmb, Long estado) {
        EntidadeId loteId = new EntidadeId(idLote, tpAmb);
        EstadoLote estadoLote = this.daoLote.buscarPorIdObject(loteId);
        if (estadoLote != null) {
            estadoLote.setEstadoNFe(estado);
            this.daoLote.unir(estadoLote);
        }
    }

    public synchronized void ajustarErroEnvio(String idLote, String tpAmb, int numeroTentantica) {
        EntidadeId loteId = new EntidadeId(idLote, tpAmb);
        EstadoLote estado = this.daoLote.buscarPorIdObject(loteId);
        if (estado != null) {
            this.daoLote.refresh(estado);
            estado.setEstado(EstadoLote.ESTADO_LOTE.ERRO_ENVIO);
            estado.setUltimaTentativa(new Date());
            estado.setNumeroTentativa(++numeroTentantica);
            this.daoLote.unir(estado);
        }
    }

    public synchronized void ajustarEstadoSemNotas(String idLote, String tpAmb, EstadoLote.ESTADO_LOTE est) {
        EntidadeId loteId = new EntidadeId(idLote, tpAmb);
        EstadoLote estado = this.daoLote.buscarPorIdObject(loteId);
        if (estado != null) {
            this.daoLote.refresh(estado);
            estado.setEstado(est);
            estado.setData(new Date());
            this.daoLote.unir(estado);
            GerenciadorProxy.notificarLote(estado);
        }
    }

    public synchronized void ajustarEstado(String idLote, String tpAmb, EstadoLote.ESTADO_LOTE est) {
        EntidadeId loteId = new EntidadeId(idLote, tpAmb);
        EstadoLote estado = this.daoLote.buscarPorIdObject(loteId);
        if (estado != null) {
            this.daoLote.refresh(estado);
            estado.setEstado(est);
            estado.setData(new Date());
            this.daoLote.unir(estado);
            GerenciadorProxy.notificarLote(estado);
            Set<EstadoNFe> notas = estado.getNotas();
            if (notas != null) {
                for (EstadoNFe estadoNFe : notas) {
                    if (est == EstadoLote.ESTADO_LOTE.GERADO) {
                        estadoNFe.setEstado(EstadoNFe.ESTADO_NFE.GERADA);
                    }
                    if (est == EstadoLote.ESTADO_LOTE.ERRO_ENVIO) {
                        estadoNFe.setEstado(EstadoNFe.ESTADO_NFE.ERRO_ENVIO);
                    }
                    if (est == EstadoLote.ESTADO_LOTE.TENTANDO_ENVIO) {
                        estadoNFe.setEstado(EstadoNFe.ESTADO_NFE.TENTANDO_ENVIO);
                    }
                    if (est == EstadoLote.ESTADO_LOTE.TEMPO_PROCESSAMENTO_LIMITE) {
                        estadoNFe.setEstado(EstadoNFe.ESTADO_NFE.TEMPO_PROCESSAMENTO_LIMITE);
                    }
                    if (est == EstadoLote.ESTADO_LOTE.ERRO_ESQUEMA) {
                        estadoNFe.setEstado(EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA);
                    }
                    this.daoNota.unir(estadoNFe);
                    GerenciadorProxy.notificarNota(estadoNFe);
                }
            }
        }
    }

    public synchronized void ajustarAEnviado(String idLote, String tpAmb) {
        EntidadeId loteId = new EntidadeId(idLote, tpAmb);
        EstadoLote estado = this.daoLote.buscarPorIdObject(loteId);
        this.daoLote.refresh(estado);
        if (estado != null) {
            estado.setEstado(EstadoLote.ESTADO_LOTE.ENVIADO);
            estado.setDataEnvio(new Date());
            this.daoLote.unir(estado);
            GerenciadorProxy.notificarLote(estado);
        }
    }

    public synchronized void ajustarATentarEnviado(String idLote, String tpAmb) {
        EntidadeId loteId = new EntidadeId(idLote, tpAmb);
        EstadoLote estado = this.daoLote.buscarPorIdObject(loteId);
        this.daoLote.refresh(estado);
        this.daoLote.unir(estado);
        if (estado != null) {
            estado.setEstado(EstadoLote.ESTADO_LOTE.TENTANDO_ENVIO);
            estado.setDataEnvio(new Date());
            this.daoLote.unir(estado);
            GerenciadorProxy.notificarLote(estado);
        }
    }

    public synchronized void ajustarNormal(String idLote, String tpAmb) {
        EntidadeId loteId = new EntidadeId(idLote, tpAmb);
        EstadoLote estado = this.daoLote.buscarPorIdObject(loteId);
        this.daoLote.refresh(estado);
        if (estado != null) {
            estado.setEstadoOperacao(PropriedadesSistema.MODO_OP.NORMAL);
            this.daoLote.unir(estado);
        }
    }

    public synchronized void ajustarContingencia(String idLote, String tpAmb) {
        EntidadeId loteId = new EntidadeId(idLote, tpAmb);
        EstadoLote estado = this.daoLote.buscarPorIdObject(loteId);
        if (estado != null) {
            this.daoLote.refresh(estado);
            if (estado != null) {
                estado.setEstadoOperacao(PropriedadesSistema.MODO_OP.CONTINGENCIA);
                this.daoLote.unir(estado);
            }
            Set<EstadoNFe> notas = estado.getNotas();
            for (EstadoNFe estadoNFe : notas) {
                estadoNFe.setModoOperacao(PropriedadesSistema.MODO_OP.CONTINGENCIA);
                this.daoNota.unir(estadoNFe);
            }
        }
    }

    public synchronized void ajustarContingenciaDpec(String idLote, String tpAmb) {
        EntidadeId loteId = new EntidadeId(idLote, tpAmb);
        EstadoLote estado = this.daoLote.buscarPorIdObject(loteId);
        if (estado != null) {
            this.daoLote.refresh(estado);
            if (estado != null) {
                estado.setEstadoOperacao(PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC);
                this.daoLote.unir(estado);
            }
            Set<EstadoNFe> notas = estado.getNotas();
            for (EstadoNFe estadoNFe : notas) {
                estadoNFe.setModoOperacao(PropriedadesSistema.MODO_OP.CONTINGENCIA_DPEC);
                this.daoNota.unir(estadoNFe);
            }
        }
    }

    public synchronized void ajustarTempoDeTentativa(String idLote, String tpAmb) {
        EntidadeId loteId = new EntidadeId(idLote, tpAmb);
        EstadoLote lote = this.daoLote.buscarPorIdObject(loteId);
        this.daoLote.refresh(lote);
        lote.setUltimaTentativa(new Date());
        lote.setNumeroTentativa(lote.getNumeroTentativa() + 1);
        this.daoLote.unir(lote);
    }

    public synchronized void removerLote(String idLote, String tpAmb) {
        EntidadeId loteId = new EntidadeId(idLote, tpAmb);
        EstadoLote lote = this.daoLote.buscarPorIdObject(loteId);
        if (lote != null) {
            this.daoLote.refresh(lote);
            Set<EstadoNFe> notas = lote.getNotas();
            for (EstadoNFe estadoNFe : notas) {
                estadoNFe.setLote(null);
                this.daoNota.unir(estadoNFe);
            }
            this.daoLote.remover(idLote);
        }
    }

    public synchronized void flushcache() {
        this.daoLote.flush();
        this.daoLote.clear();
    }
}

