/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.mensageiro.caches;

import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EntidadeId;
import br.com.taragona.nfe.persistence.EstadoLote;
import br.com.taragona.nfe.persistence.EstadoRecibo;
import br.com.taragona.nfe.persistence.db.QuickDB;
import br.com.taragona.nfe.util.CodigoNFeManager;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import br.com.tti.nfev310.retreci.TRetEnviNFe;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBElement;

public class CacheRecibos {
    private static CacheRecibos INSTANCIA = null;
    private DAOGenerico<EstadoRecibo> daoRecibos;
    private DAOGenerico<EstadoLote> daoLotes;
    private XMLGenerator xmls = new XMLGenerator("br.com.taragona.nfe.classes.recepcao");
    private QuickDB quick;

    public static CacheRecibos obterInstancia() {
        if (INSTANCIA == null) {
            INSTANCIA = new CacheRecibos();
        }
        return INSTANCIA;
    }

    public CacheRecibos() {
        this.daoRecibos = new DAOGenerico(EstadoRecibo.class);
        this.daoLotes = new DAOGenerico(EstadoLote.class);
        BaseDadosConfig bdConfig = PropriedadesSistema.getBdConfig();
        this.quick = new QuickDB(bdConfig.getUrl(), bdConfig.getUsuario(), bdConfig.getSenha());
    }

    public synchronized void cacheRecibo(String tpAmb, TRetEnviNFe recibo) {
        try {
            EstadoRecibo estado = new EstadoRecibo();
            estado.setId(recibo.getInfRec().getNRec());
            estado.setAmbiente(tpAmb);
            estado.setEstado(EstadoRecibo.ESTADO_RECIBO.PENDENTE);
            estado.setDataRecebido(new Date());
            estado.setEstadoNFe(Long.parseLong(recibo.getCStat()));
            estado.setXmlString(this.xmls.toXMLString(recibo));
            estado.setIdLote(null);
            this.daoRecibos.salvar(estado);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void cacheReciboWithLote(TRetEnviNFe recibo, String idLote, String tpAmb, String xmlrecibo) {
        try {
            System.out.println("recibo--->" + recibo.getInfRec().getNRec());
            EstadoRecibo estadoRecibo = new EstadoRecibo();
            estadoRecibo.setId(recibo.getInfRec().getNRec());
            estadoRecibo.setAmbiente(tpAmb);
            estadoRecibo.setEstado(EstadoRecibo.ESTADO_RECIBO.PENDENTE);
            estadoRecibo.setDataRecebido(new Date());
            estadoRecibo.setEstadoNFe(Long.parseLong(recibo.getCStat()));
            estadoRecibo.setXmlString(xmlrecibo);
            estadoRecibo.setIdLote(idLote);
            EntidadeId loteId = new EntidadeId(idLote, tpAmb);
            EstadoLote estadoLote = this.daoLotes.buscarPorIdObject(loteId);
            this.daoLotes.refresh(estadoLote);
            estadoLote.setNumeroRecibo(recibo.getInfRec().getNRec());
            estadoLote.setEstadoRecibo(EstadoLote.ESTADO_RECIBO.PENDENTE);
            estadoLote.setDataRecebementoRecibo(new Date());
            estadoRecibo.setCnpj(estadoLote.getCnpj());
            this.daoLotes.unir(estadoLote);
            this.daoRecibos.salvar(estadoRecibo);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public EstadoRecibo obterRecibo(String nRecibo, String tpAmb) {
        EntidadeId reciboId = new EntidadeId(nRecibo, tpAmb);
        EstadoRecibo recibo = this.daoRecibos.buscarPorIdObject(reciboId);
        if (recibo != null) {
            this.daoRecibos.refresh(recibo);
            return recibo;
        }
        return null;
    }

    public Collection<TRetEnviNFe> obterRecibosPendentes() {
        List<EstadoRecibo> recibosEstados = this.daoRecibos.obterElementos();
        Vector<TRetEnviNFe> recibos = new Vector<TRetEnviNFe>();
        for (EstadoRecibo estadoRecibo : recibosEstados) {
            if (estadoRecibo.getEstado() != EstadoRecibo.ESTADO_RECIBO.PENDENTE) continue;
            try {
                JAXBElement element = (JAXBElement)this.xmls.toObject(estadoRecibo.getXmlString());
                recibos.add((TRetEnviNFe)element.getValue());
                CodigoNFeManager.insereCodigo(Integer.valueOf(((TRetEnviNFe)element.getValue()).getCStat()), ((TRetEnviNFe)element.getValue()).getXMotivo());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return recibos;
    }

    public Collection<EstadoRecibo> obterRecibosPendentesDB() {
        List<EstadoRecibo> recibos = this.daoRecibos.obterElementos();
        Vector<EstadoRecibo> pendentes = new Vector<EstadoRecibo>();
        for (EstadoRecibo estadoRecibo : recibos) {
            EntidadeId reciboId = new EntidadeId(estadoRecibo.getIdLote(), estadoRecibo.getAmbiente());
            EstadoLote lote = this.daoLotes.buscarPorIdObject(reciboId);
            if (estadoRecibo.getEstado() != EstadoRecibo.ESTADO_RECIBO.PENDENTE || lote.getEstadoOperacao() == PropriedadesSistema.MODO_OP.CONTINGENCIA) continue;
            pendentes.add(estadoRecibo);
        }
        return pendentes;
    }

    public Collection<EstadoRecibo> obterRecibosPendentesDB(String tpAmb, String cnpj) {
        Vector<String> ids = this.quick.obterIdLotesPendendetsDB("EstadoRecibo");
        Vector<EstadoRecibo> pendentes = new Vector<EstadoRecibo>();
        for (String id : ids) {
            EntidadeId reciboId = new EntidadeId(id, tpAmb);
            EstadoRecibo recibo = this.daoRecibos.buscarPorIdObject(reciboId);
            if (recibo.getEstado() != EstadoRecibo.ESTADO_RECIBO.PENDENTE || !recibo.getCnpj().equals(cnpj)) continue;
            pendentes.add(recibo);
        }
        return pendentes;
    }

    public synchronized void estadoRecibo(String id, String tpAmb, boolean foiUsado) {
        EntidadeId reciboId = new EntidadeId(id, tpAmb);
        EstadoRecibo estadoRecibo = this.daoRecibos.buscarPorIdObject(reciboId);
        if (estadoRecibo == null) {
            return;
        }
        if (foiUsado) {
            estadoRecibo.setEstado(EstadoRecibo.ESTADO_RECIBO.CHECADO);
            estadoRecibo.setDataProcessamento(new Date());
        } else {
            estadoRecibo.setEstado(EstadoRecibo.ESTADO_RECIBO.PENDENTE);
        }
        this.daoRecibos.unir(estadoRecibo);
    }

    public void removeRecibo(String id) {
        this.daoRecibos.remover(id);
    }
}

