/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.mensageiro.states;

import br.com.taragona.nfe.util.PropriedadesSistema;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class StatePersitence {
    private String statefile;
    private Hashtable<String, PropriedadesSistema.MODO_OP> modes;

    public StatePersitence(String file) {
        this.statefile = file;
    }

    private void loadStates() throws Exception {
        this.modes = new Hashtable();
        FileInputStream f = new FileInputStream(this.statefile);
        DataInputStream dis = new DataInputStream(f);
        String line = dis.readLine();
        while (line != null) {
            String[] parts = line.split("=");
            String cnpj = parts[0].trim();
            String estado = parts[1].trim();
            PropriedadesSistema.MODO_OP modo = null;
            try {
                modo = PropriedadesSistema.MODO_OP.valueOf(estado);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (modo != null) {
                this.modes.put(cnpj, modo);
            }
            line = dis.readLine();
        }
    }

    private void loadFile() {
        ResourceBundle bundle = ResourceBundle.getBundle(this.statefile);
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String state = bundle.getString(key);
            PropriedadesSistema.MODO_OP mod = PropriedadesSistema.MODO_OP.valueOf(state);
            this.modes.put(key, mod);
        }
    }

    private void writeFile() throws Exception {
        FileWriter fw = new FileWriter(this.statefile);
        for (String cnpj : this.modes.keySet()) {
            PropriedadesSistema.MODO_OP modo = this.modes.get(cnpj);
            fw.write(String.valueOf(cnpj) + "=" + modo.toString() + "\n");
        }
        fw.close();
    }

    public PropriedadesSistema.MODO_OP getState(String cnpj) {
        PropriedadesSistema.MODO_OP modo;
        if (this.modes == null) {
            try {
                this.loadStates();
            }
            catch (Exception e) {
                e.printStackTrace();
                File f = new File(this.statefile);
                try {
                    f.createNewFile();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                return null;
            }
        }
        if ((modo = this.modes.get(cnpj)) == null) {
            modo = PropriedadesSistema.MODO_OP.NORMAL;
            this.modes.put(cnpj, modo);
        }
        return modo;
    }

    public void setState(String cnpj, PropriedadesSistema.MODO_OP modo) {
        if (this.modes == null) {
            try {
                this.loadStates();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.modes.put(cnpj, modo);
        try {
            this.writeFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        StatePersitence sp = new StatePersitence("/home/cnoriega/t.txt");
        System.out.println((Object)sp.getState("123432"));
        sp.setState("12343", PropriedadesSistema.MODO_OP.NORMAL);
        System.out.println((Object)sp.getState("12343"));
    }
}

