/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.persistence;

import br.com.taragona.nfe.persistence.DAOGenerico;
import java.util.HashMap;
import java.util.Map;

public final class DAOFactory {
    private static final ThreadLocal<Map<Class<?>, DAOGenerico<?>>> THREAD_CACHE = new ThreadLocal<Map<Class<?>, DAOGenerico<?>>>(){

        @Override
        protected Map<Class<?>, DAOGenerico<?>> initialValue() {
            return new HashMap();
        }
    };

    private DAOFactory() {
    }

    public static <T> DAOGenerico<T> getDAO(Class<T> clazz) {
        Map<Class<?>, DAOGenerico<?>> cache = THREAD_CACHE.get();
        DAOGenerico<Object> dao = cache.get(clazz);
        if (dao == null) {
            dao = new DAOGenerico(clazz);
            cache.put(clazz, dao);
        }
        return dao;
    }

    public static DAOGenerico getDAOUnchecked(Class clazz) {
        return DAOFactory.getDAO(clazz);
    }

    public static void clearThreadCache() {
        Map<Class<?>, DAOGenerico<?>> cache = THREAD_CACHE.get();
        for (DAOGenerico<?> dao : cache.values()) {
            try {
                dao.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        cache.clear();
        THREAD_CACHE.remove();
    }
}

