/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.persistence;

import br.com.taragona.nfe.persistence.EntidadeId;
import br.com.taragona.nfe.persistence.EstadoLote;
import br.com.taragona.nfe.util.PropriedadesSistema;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@IdClass(value=EntidadeId.class)
public class EstadoNFe
implements Serializable {
    private static final long serialVersionUID = -6946350959465408277L;
    @Id
    private String id;
    @Id
    @Column(name="AMBIENTE", nullable=false, length=1)
    private String ambiente = "2";
    private ESTADO_NFE estado;
    @Lob
    private String protocoloXML;
    @Lob
    private String protocoloCancelamentoXML;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataGerada;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataEnviada;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataAutorizada;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataAtualizada;
    private boolean assinada;
    private Long estadoNFe;
    @Lob
    private String xmlString;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="LOTE_ID", referencedColumnName="ID"), @JoinColumn(name="AMBIENTE", referencedColumnName="AMBIENTE", nullable=false, insertable=false, updatable=false)})
    private EstadoLote lote;
    private PropriedadesSistema.MODO_OP modoOperacao;
    private String protocolo;
    @Lob
    private String xmlStringRecibo;
    private String cnpj;
    private String cnpjDestino;
    @Lob
    @Column(length=1024)
    private String motivoErro;
    private ESTADO_NFE cartacorrecao;
    private String cnpjTransp;
    private String STATUSCANCINUT;
    private String serverName;
    private boolean gerouBoleto;
    private boolean importouBoleto;
    @Lob
    private String observacao;
    @Lob
    @Column(length=1024)
    private String outros;
    @Transient
    private String emailDest;
    @Transient
    private String emailTrans;

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public boolean getGerouBoleto() {
        return this.gerouBoleto;
    }

    public void setGerouBoleto(boolean gerouBoleto) {
        this.gerouBoleto = gerouBoleto;
    }

    public boolean getImportouBoleto() {
        return this.importouBoleto;
    }

    public void setImportouBoleto(boolean importouBoleto) {
        this.importouBoleto = importouBoleto;
    }

    public String getSTATUSCANCINUT() {
        return this.STATUSCANCINUT;
    }

    public void setSTATUSCANCINUT(String sTATUSCANCINUT) {
        this.STATUSCANCINUT = sTATUSCANCINUT;
    }

    public Date getDataActualizada() {
        return this.dataAtualizada;
    }

    public void setDataActualizada(Date dataActualizacao) {
        this.dataAtualizada = dataActualizacao;
    }

    public ESTADO_NFE getEstado() {
        return this.estado;
    }

    public void setEstado(ESTADO_NFE estado) {
        this.estado = estado;
    }

    public String getId() {
        return this.id;
    }

    public String getAmbiente() {
        return this.ambiente;
    }

    public boolean isAssinada() {
        return this.assinada;
    }

    public void setAssinada(boolean assinada) {
        this.assinada = assinada;
    }

    public Long getEstadoNFe() {
        return this.estadoNFe;
    }

    public void setEstadoNFe(Long estadoNFe) {
        this.estadoNFe = estadoNFe;
    }

    public String getXmlString() {
        return this.xmlString;
    }

    public void setXmlString(String xmlString) {
        this.xmlString = xmlString;
        this.initializeAmbiente();
    }

    public EstadoLote getLote() {
        return this.lote;
    }

    public void setLote(EstadoLote lote) {
        this.lote = lote;
    }

    public Date getDataEnviada() {
        return this.dataEnviada;
    }

    public void setDataEnviada(Date dataEnviada) {
        this.dataEnviada = dataEnviada;
    }

    public Date getDataGerada() {
        return this.dataGerada;
    }

    public void setDataGerada(Date dataGerada) {
        this.dataGerada = dataGerada;
    }

    public Date getDataAutorizada() {
        return this.dataAutorizada;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAmbiente(String ambiente) {
        this.ambiente = ambiente;
        this.initializeAmbiente();
    }

    public void setDataAutorizada(Date dataAutorizada) {
        this.dataAutorizada = dataAutorizada;
    }

    public String getXmlStringRecibo() {
        return this.xmlStringRecibo;
    }

    public void setXmlStringRecibo(String xmlStringRecibo) {
        this.xmlStringRecibo = xmlStringRecibo;
    }

    public PropriedadesSistema.MODO_OP getModoOperacao() {
        return this.modoOperacao;
    }

    public void setModoOperacao(PropriedadesSistema.MODO_OP modoOperacao) {
        this.modoOperacao = modoOperacao;
    }

    public String getProtocoloXML() {
        return this.protocoloXML;
    }

    public void setProtocoloXML(String protocoloXML) {
        this.protocoloXML = protocoloXML;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EstadoNFe)) {
            return false;
        }
        EstadoNFe other = (EstadoNFe)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "br.com.taragona.nfe.persistence.EstadoNFe[id=" + this.id + "]";
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public String getCnpjDestino() {
        return this.cnpjDestino;
    }

    public void setCnpjDestino(String cnpjDestino) {
        this.cnpjDestino = cnpjDestino;
    }

    public String getProtocolo() {
        return this.protocolo;
    }

    public void setProtocolo(String protocolo) {
        this.protocolo = protocolo;
    }

    public String getMotivoErro() {
        return this.motivoErro;
    }

    public void setMotivoErro(String motivoErro) {
        this.motivoErro = motivoErro;
    }

    public ESTADO_NFE getCartacorrecao() {
        return this.cartacorrecao;
    }

    public void setCartacorrecao(ESTADO_NFE cartacorrecao) {
        this.cartacorrecao = cartacorrecao;
    }

    public String getProtocoloCancelamentoXML() {
        return this.protocoloCancelamentoXML;
    }

    public void setProtocoloCancelamentoXML(String protocoloCancelamentoXML) {
        this.protocoloCancelamentoXML = protocoloCancelamentoXML;
    }

    public String getCnpjTransp() {
        return this.cnpjTransp;
    }

    public void setCnpjTransp(String cnpjTransp) {
        this.cnpjTransp = cnpjTransp;
    }

    public String getEmailDest() {
        return this.emailDest;
    }

    public void setEmailDest(String emailDest) {
        this.emailDest = emailDest;
    }

    public String getEmailTrans() {
        return this.emailTrans;
    }

    public void setEmailTrans(String emailTrans) {
        this.emailTrans = emailTrans;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String getOutros() {
        return this.outros;
    }

    public void setOutros(String outros) {
        this.outros = outros;
    }

    private void initializeAmbiente() {
        if ((this.ambiente == null || this.ambiente.equals("")) && this.xmlString != null && this.xmlString.contains("<tpAmb>")) {
            int startIndex = this.xmlString.indexOf("<tpAmb>") + 7;
            int endIndex = this.xmlString.indexOf("</tpAmb>");
            if (startIndex >= 0 && endIndex > startIndex) {
                this.ambiente = this.xmlString.substring(startIndex, endIndex);
            }
        }
    }

    public static enum ESTADO_NFE {
        USO_DENEGADO,
        REJEITADA,
        AUTORIZADA,
        GERADA,
        ASSINADA,
        ENVIADA,
        ERRO_VALIDACAO,
        IMPRESSA_NORMAL,
        IMPRESSA_CONT,
        CANCELADA,
        INUTILIZADA,
        TENTANDO_ENVIO,
        ERRO_ENVIO,
        RESULTADO_SEFAZ,
        ERRO,
        PEDIDO_CANCELAMENTO,
        ERRO_ESQUEMA,
        TEMPO_PROCESSAMENTO_LIMITE,
        ERRO_ESQUEMA_LOTE,
        ERRO_CANCELAMENTO,
        ERRO_INUTILIZACAO,
        ERRO_IMPRESSAO,
        IMPRESSA_LASER,
        CANCELADA_CONTINGENCIA,
        ERRO_XML_SEFAZ,
        CANCELAR_SAIDA_CONTINGENCIA,
        DPEC_ENVIADO,
        PROBLEMAS_DPEC_ENVIADO,
        EPEC_AUTORIZADO,
        EPEC_REJEITADO,
        MINI_DANFE;

    }
}

