/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.persistence;

import br.com.taragona.nfe.persistence.EntidadeId;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@IdClass(value=EntidadeId.class)
public class ExtraXMLInfo
implements Serializable {
    private static final long serialVersionUID = 3558735340335136133L;
    @Id
    private String id;
    @Id
    @Column(name="AMBIENTE", length=1)
    private String ambiente = "2";
    @Lob
    private String xmlstring;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataatualizacao;
    private int versao;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(String ambiente) {
        this.ambiente = ambiente;
        this.initializeAmbiente();
    }

    public String getXmlstring() {
        return this.xmlstring;
    }

    public void setXmlstring(String xmlstring) {
        this.xmlstring = xmlstring;
        this.initializeAmbiente();
    }

    public Date getDataatualizacao() {
        return this.dataatualizacao;
    }

    public void setDataatualizacao(Date dataatualizacao) {
        this.dataatualizacao = dataatualizacao;
    }

    public int getVersao() {
        return this.versao;
    }

    public void setVersao(int versao) {
        this.versao = versao;
    }

    private void initializeAmbiente() {
        if ((this.ambiente == null || this.ambiente.equals("")) && this.xmlstring != null && this.xmlstring.contains("<tpAmb>")) {
            int startIndex = this.xmlstring.indexOf("<tpAmb>") + 7;
            int endIndex = this.xmlstring.indexOf("</tpAmb>");
            if (startIndex >= 0 && endIndex > startIndex) {
                this.ambiente = this.xmlstring.substring(startIndex, endIndex);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtraXMLInfo other = (ExtraXMLInfo)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

