/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.persistence;

import br.com.taragona.nfe.persistence.XMLBoletoId;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@IdClass(value=XMLBoletoId.class)
public class XMLBoleto
implements Serializable {
    private static final long serialVersionUID = -2226388891320138000L;
    @Id
    private String chavenfe;
    @Id
    @Column(name="AMBIENTE", nullable=false, length=1)
    private String ambiente = "2";
    @Lob
    private String xmlboleto;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date atualizacao;

    public String getChavenfe() {
        return this.chavenfe;
    }

    public void setChavenfe(String chavenfe) {
        this.chavenfe = chavenfe;
    }

    public String getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(String ambiente) {
        this.ambiente = ambiente;
        this.initializeAmbiente();
    }

    public String getXmlboleto() {
        return this.xmlboleto;
    }

    public void setXmlboleto(String xmlboleto) {
        this.xmlboleto = xmlboleto;
    }

    public Date getAtualizacao() {
        return this.atualizacao;
    }

    public void setAtualizacao(Date atualizacao) {
        this.atualizacao = atualizacao;
    }

    private void initializeAmbiente() {
        if ((this.ambiente == null || this.ambiente.equals("")) && this.xmlboleto != null && this.xmlboleto.contains("<tpAmb>")) {
            int startIndex = this.xmlboleto.indexOf("<tpAmb>") + 7;
            int endIndex = this.xmlboleto.indexOf("</tpAmb>");
            if (startIndex >= 0 && endIndex > startIndex) {
                this.ambiente = this.xmlboleto.substring(startIndex, endIndex);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.chavenfe == null ? 0 : this.chavenfe.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLBoleto other = (XMLBoleto)obj;
        return !(this.chavenfe == null ? other.chavenfe != null : !this.chavenfe.equals(other.chavenfe));
    }
}

