/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.sender;

import assinador.AssinadorInt;
import assinador.Main;
import assinador.pkcs11.AssinadorPKCS11;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.sender.SenderRemote;
import br.com.taragona.nfe.serviceclients.ConfigurarSSLProperties;
import br.com.taragona.nfe.serviceclients.NFeClient;
import br.com.taragona.nfe.serviceclients.NFeClientFactory;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.GerenciadorSenhas;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.TecladoPassword;
import br.com.taragona.nfe.util.data.ServicosConfig;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.security.x509.X509CertImpl;

public class Sender
implements SenderRemote {
    public static PropriedadesSistema.MODO_OP modoAtual;
    private AssinadorInt assinador;
    private GerenciadorInterface gerenciador;
    private Hashtable<String, AssinadorInt> assinadores;
    private String pfxDeTransmissao;
    private String trustStore;
    private GerenciadorSenhas senhas;
    protected ServicosConfig servicosConfig;

    public Sender(GerenciadorInterface gerenciador, String pfxTransmissao) throws Exception {
        this.gerenciador = gerenciador;
        this.servicosConfig = gerenciador.obterServicosConfig();
        this.pfxDeTransmissao = pfxTransmissao == null ? this.servicosConfig.getPfxDeTransmissao() : pfxTransmissao;
        this.trustStore = this.servicosConfig.getTrustStore();
        this.assinadores = new Hashtable();
        this.senhas = new GerenciadorSenhas();
        GerenciadorProxy.setGerenciador(gerenciador);
        Hashtable[] servicos = null;
        String senha = this.senhas.obterSenha(this.pfxDeTransmissao);
        if (senha == null) {
            senha = TecladoPassword.obterPassword("Digite a senha do arquivo PFX para transmissao " + this.pfxDeTransmissao + ":");
            this.assinador = new Main(this.pfxDeTransmissao, senha);
            this.senhas.salvarSenha(this.pfxDeTransmissao, senha);
        } else {
            this.assinador = new Main(this.pfxDeTransmissao, senha);
        }
        ConfigurarSSLProperties.ajustarPropriedadesFwd(this.trustStore, this.pfxDeTransmissao, "crhisn", senha);
        try {
            servicos = gerenciador.obterTodosServicos();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        NFeClientFactory.setServicosCNPJ(servicos[0]);
        NFeClientFactory.setServicosCNPJScan(servicos[1]);
        this.inicializarAssinadores();
    }

    @Override
    public Hashtable<String, Hashtable<String, Object>> readAllPFXPRoperties() {
        Hashtable<String, Hashtable<String, Object>> prop = new Hashtable<String, Hashtable<String, Object>>();
        Hashtable<String[], String> cnpjspfxs = this.servicosConfig.getArquivosPFX();
        for (String[] cnpjlist : cnpjspfxs.keySet()) {
            String pfxfile = cnpjspfxs.get(cnpjlist);
            if (!pfxfile.endsWith(".pfx")) continue;
            prop.put(pfxfile, this.readPFXProperties(pfxfile));
        }
        return prop;
    }

    public Hashtable<String, Object> readPFXProperties(String certificado) {
        String senha = this.senhas.obterSenha(certificado);
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("pkcs12");
        }
        catch (KeyStoreException ex) {
            System.out.println("Nao conseguiu criar keystore com pkcs12");
        }
        try {
            new FileInputStream(certificado);
        }
        catch (FileNotFoundException e) {
            System.out.println("Arquivo nao encontrado: " + certificado);
        }
        try {
            ks.load(new FileInputStream(certificado), senha.toCharArray());
        }
        catch (IOException ex) {
            System.out.println("Senha digitada invalida");
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println("Algoritmo do certificado invalido");
        }
        catch (CertificateException ex) {
            System.out.println("Certificado ou senha invalidos");
        }
        Enumeration<String> aliases = null;
        try {
            aliases = ks.aliases();
        }
        catch (KeyStoreException ex) {
            System.out.println("Nenhuma entrada no keystore");
        }
        KeyStore.PrivateKeyEntry entry = null;
        try {
            while (aliases.hasMoreElements()) {
                String alias1 = aliases.nextElement();
                if (!ks.isKeyEntry(alias1)) continue;
                entry = (KeyStore.PrivateKeyEntry)ks.getEntry(alias1, new KeyStore.PasswordProtection(senha.toCharArray()));
                Certificate certificate = entry.getCertificate();
                X509CertImpl cc = (X509CertImpl)certificate;
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                props.put("NA", cc.getNotAfter());
                props.put("NB", cc.getNotBefore());
                props.put("CN", cc.getSubjectX500Principal().toString());
                return props;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public void inicializarAssinadores() {
        try {
            Hashtable<String[], String> cnpjs = this.servicosConfig.getArquivosPFX();
            for (String[] cnpjss : cnpjs.keySet()) {
                int n;
                String arquivopfx = cnpjs.get(cnpjss);
                Main a = null;
                if (arquivopfx.endsWith(".pfx")) {
                    String senha = this.senhas.obterSenha(arquivopfx);
                    if (senha == null) {
                        senha = TecladoPassword.obterPassword("Digite a senha do arquivo PFX para assinatura " + arquivopfx + ": ");
                        a = new Main(arquivopfx, senha);
                        this.senhas.salvarSenha(arquivopfx, senha);
                    } else {
                        a = new Main(arquivopfx, senha);
                    }
                    String[] stringArray = cnpjss;
                    n = cnpjss.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String cnpj = stringArray[n2];
                        this.assinadores.put(cnpj, a);
                        ++n2;
                    }
                    continue;
                }
                String config = PropriedadesMain.getConfig();
                String senha = this.senhas.obterSenha(config);
                if (senha == null) {
                    senha = TecladoPassword.obterPassword("Digite o PIN:");
                    a = new AssinadorPKCS11(config, senha);
                    this.senhas.salvarSenha(config, senha);
                } else {
                    a = new AssinadorPKCS11(config, senha);
                }
                String[] stringArray = cnpjss;
                int n3 = cnpjss.length;
                n = 0;
                while (n < n3) {
                    String cnpj = stringArray[n];
                    this.assinadores.put(cnpj, a);
                    ++n;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String enviarMensagemXML(String idServico, String cnpj, String cabecalho, String xml, Hashtable prop, String idUsuario) throws RemoteException {
        try {
            System.out.println("idServico: " + idServico);
            NFeClient cliente = NFeClientFactory.criarCliente(Class.forName(idServico), cnpj);
            return cliente.enviarMensagem(cabecalho, xml, idUsuario);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            RemoteException re = new RemoteException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
        return null;
    }

    @Override
    public String assinar(String xml, String tag) throws RemoteException {
        System.out.println("Assinando Nota:" + xml);
        return this.assinador.assina(xml, tag);
    }

    @Override
    public String assinarCNPJ(String cnpj, String xml, String tag) throws RemoteException {
        System.out.println("assinando CNPJ: " + cnpj);
        try {
            return this.assinadores.get(cnpj.trim()).assina(xml, tag);
        }
        catch (Exception e) {
            System.out.println("Assinador Erro:" + cnpj);
            System.out.println(e.getMessage());
            return null;
        }
    }

    private String assinarXml(String cnpj, String xml, String tag) {
        try {
            return this.assinar(xml, tag);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void write(String str) {
        try {
            FileWriter fw = new FileWriter("/home/cnoriega/.sss");
            fw.write(str);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void ajustarServicos(Hashtable<String, Hashtable<Class, String>>[] servicos) throws RemoteException {
        NFeClientFactory.setServicosCNPJ(servicos[0]);
        NFeClientFactory.setServicosCNPJScan(servicos[1]);
        try {
            for (String cnpj : servicos[1].keySet()) {
                NFeClientFactory.reiniciarClientesScan(cnpj);
            }
            for (String cnpj : servicos[0].keySet()) {
                NFeClientFactory.reiniciarClientesNormal(cnpj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void usarServicosScan() throws RemoteException {
        try {
            NFeClientFactory.reiniciarTodosClientesScan();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        modoAtual = PropriedadesSistema.MODO_OP.CONTINGENCIA_SCAN;
    }

    @Override
    public void usarServicosNormal() throws RemoteException {
        try {
            NFeClientFactory.reiniciarTodosClientesNormal();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        modoAtual = PropriedadesSistema.MODO_OP.NORMAL;
    }
}

