/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.sender;

import br.com.taragona.nfe.dpec.sender.SenderDPEC;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.sender.DispatchFactory;
import br.com.taragona.nfe.sender.Invoker;
import br.com.taragona.nfe.sender.InvokerDispatch;
import br.com.taragona.nfe.sender.PortFactory;
import br.com.taragona.nfe.sender.Sender;
import br.com.taragona.nfe.util.data.SenderConf;
import br.com.taragona.nfe.util.logger.LoggingJava;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.logging.Level;

public class SenderPort
extends Sender {
    private PortFactory factory = new PortFactory();
    private Invoker invoker;
    private SenderConf config;
    private DispatchFactory dFactory;
    private InvokerDispatch dInvoker;
    private SenderDPEC senderDpec;

    public SenderPort(GerenciadorInterface gerenciador, String fileConfig, String pfxTransmissao) throws Exception {
        super(gerenciador, pfxTransmissao);
        this.senderDpec = new SenderDPEC(gerenciador);
        this.dFactory = new DispatchFactory();
        this.dInvoker = new InvokerDispatch();
        this.config = gerenciador.obterSenderConfig();
        Hashtable<String, String> class_s = this.config.getClasses();
        Hashtable<String, Class> classs = new Hashtable<String, Class>();
        for (String t : class_s.keySet()) {
            Class<?> c = Class.forName(class_s.get(t));
            classs.put(t, c);
        }
        this.factory.setNamespaceNames(this.config.getNamespaceNames());
        this.factory.setPortNames(this.config.getPortNames());
        this.factory.setUrlServicosHomolgacao(this.config.getUrlServicosHomolgacao());
        this.factory.setUrlServicosNormal(this.config.getUrlServicosNormal());
        this.factory.setUrlServicosScan(this.config.getUrlServicosScan());
        this.factory.setUrlServicosDpecHom(this.config.getUrlServicosDpecHom());
        this.factory.setClassServices(classs);
        this.factory.setNomeServico(this.config.getNomeServico());
        this.invoker = new Invoker();
        this.invoker.setOperationNames(this.config.getNomeOperacao());
        this.invoker.setClassServices(classs);
    }

    @Override
    public String enviarMensagemXML(String idServico, String cnpj, String cabecalho, String xml, Hashtable prop, String idUsuario) throws RemoteException {
        String uf = (String)prop.get("UF");
        String tipo = (String)prop.get("TIPO");
        if (uf.equals("dpec")) {
            return this.senderDpec.send(xml, tipo, idUsuario);
        }
        Object port = this.factory.criarPort(idServico, uf, tipo);
        String result = this.invoker.invokePort(idServico, port, cabecalho, xml);
        LoggingJava.logger.log(Level.WARNING, "Resultado XML:" + result);
        return result;
    }
}

