/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.sender.util;

import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.xml.sender.ConfiguracaoServico;
import br.com.taragona.nfe.util.xml.sender.NFeServico;
import br.com.taragona.nfe.util.xml.sender.NFeServicos;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import java.io.File;
import java.io.FileWriter;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBElement;

public class ConfiguracaoXML {
    private Hashtable<String, Hashtable<String, String>> urlServicosNormal;
    private Hashtable<String, Hashtable<String, String>> urlServicosScan;
    private Hashtable<String, Hashtable<String, String>> urlServicosHomolgacao;
    private Hashtable<String, Hashtable<String, String>> urlServicosDpecHomologacao;
    private Hashtable<String, Hashtable<String, String>> urlServicosDpecProducao;
    private Hashtable<String, String> portNames;
    private Hashtable<String, String> namespaceNames;
    private Hashtable<String, String> nomeOperacao;
    private Hashtable<String, String> nomeServico;
    private Hashtable<String, Class> classes;
    private Vector<String> ufs;
    private NFeServicos sevicos;
    private XMLGenerator generator = new XMLGenerator("br.com.taragona.nfe.util.xml.sender");
    private String nomeFile;

    public ConfiguracaoXML(String nomeFile) {
        this.nomeFile = nomeFile;
        File f = new File(nomeFile);
        try {
            this.sevicos = (NFeServicos)((JAXBElement)this.generator.toObjectFromFile(f)).getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.namespaceNames = new Hashtable();
        this.portNames = new Hashtable();
        this.nomeOperacao = new Hashtable();
        this.nomeServico = new Hashtable();
        this.classes = new Hashtable();
        this.urlServicosScan = new Hashtable();
        this.urlServicosNormal = new Hashtable();
        this.urlServicosHomolgacao = new Hashtable();
        this.urlServicosDpecHomologacao = new Hashtable();
        this.urlServicosDpecProducao = new Hashtable();
        this.ufs = new Vector();
    }

    private void ajustarServico(Hashtable<String, String> urls, String tipo, String uf) {
        List<NFeServico> nfeServicos = this.sevicos.getNFeServico();
        for (NFeServico servico : nfeServicos) {
            String s;
            String[] ufs = servico.getUf();
            String[] tipos = servico.getTipo();
            Vector<String> ufsv = new Vector<String>();
            Vector<String> tiposv = new Vector<String>();
            String[] stringArray = tipos;
            int n = tipos.length;
            int n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                tiposv.add(s);
                ++n2;
            }
            stringArray = ufs;
            n = ufs.length;
            n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                ufsv.add(s);
                ++n2;
            }
            if (!tiposv.contains(tipo) || !ufsv.contains(uf)) continue;
            List<ConfiguracaoServico> servicos = servico.getServico();
            for (ConfiguracaoServico conf : servicos) {
                for (String id_servico : urls.keySet()) {
                    String nova_url = urls.get(id_servico);
                    if (!conf.getId().equals(id_servico)) continue;
                    conf.setUrl(nova_url);
                }
            }
        }
    }

    public void ajustarServico(Hashtable<String, Hashtable<String, String>> urls, String tipo) {
        for (String uf : urls.keySet()) {
            this.ajustarServico(urls.get(uf), tipo, uf);
        }
    }

    public void serialize() {
        try {
            String xml = this.generator.toXMLString(this.sevicos);
            FileWriter fw = new FileWriter(this.nomeFile);
            fw.write(xml);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parse() {
        List<NFeServico> nfeServicos = this.sevicos.getNFeServico();
        for (NFeServico servico : nfeServicos) {
            String[] ufs = servico.getUf();
            String[] tipos = servico.getTipo();
            List<ConfiguracaoServico> servicos = servico.getServico();
            String[] stringArray = ufs;
            int n = ufs.length;
            int n2 = 0;
            while (n2 < n) {
                String uf = stringArray[n2];
                String[] stringArray2 = tipos;
                int n3 = tipos.length;
                int n4 = 0;
                while (n4 < n3) {
                    String tipo = stringArray2[n4];
                    if (uf.equals("dpec") && tipo.equals(PropriedadesSistema.ID_HOMOLOGACAO)) {
                        for (ConfiguracaoServico conf : servicos) {
                            this.adicionarData(this.urlServicosDpecHomologacao, uf, conf.getId(), conf.getUrl());
                            this.portNames.put(conf.getUrl(), conf.getNomePorta());
                            this.namespaceNames.put(conf.getUrl(), conf.getNameSpace());
                            this.nomeOperacao.put(conf.getId(), conf.getNomeOperacao());
                            this.nomeServico.put(conf.getUrl(), conf.getNomeServico());
                            try {
                                this.classes.put(conf.getId(), this.getClass().getClassLoader().loadClass(conf.getClassName()));
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (uf.equals("dpec") && tipo.equals(PropriedadesSistema.ID_PRODUCAO)) {
                        for (ConfiguracaoServico conf : servicos) {
                            this.adicionarData(this.urlServicosDpecProducao, uf, conf.getId(), conf.getUrl());
                            this.portNames.put(conf.getUrl(), conf.getNomePorta());
                            this.namespaceNames.put(conf.getUrl(), conf.getNameSpace());
                            this.nomeOperacao.put(conf.getId(), conf.getNomeOperacao());
                            this.nomeServico.put(conf.getUrl(), conf.getNomeServico());
                            try {
                                this.classes.put(conf.getId(), this.getClass().getClassLoader().loadClass(conf.getClassName()));
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (tipo.equals(PropriedadesSistema.ID_PRODUCAO)) {
                        for (ConfiguracaoServico conf : servicos) {
                            this.adicionarData(this.urlServicosNormal, uf, conf.getId(), conf.getUrl());
                            this.portNames.put(conf.getUrl(), conf.getNomePorta());
                            this.namespaceNames.put(conf.getUrl(), conf.getNameSpace());
                            this.nomeOperacao.put(conf.getId(), conf.getNomeOperacao());
                            this.nomeServico.put(conf.getUrl(), conf.getNomeServico());
                            try {
                                this.classes.put(conf.getId(), this.getClass().getClassLoader().loadClass(conf.getClassName()));
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (tipo.equals(PropriedadesSistema.ID_HOMOLOGACAO)) {
                        for (ConfiguracaoServico conf : servicos) {
                            this.adicionarData(this.urlServicosHomolgacao, uf, conf.getId(), conf.getUrl());
                            this.portNames.put(conf.getUrl(), conf.getNomePorta());
                            this.namespaceNames.put(conf.getUrl(), conf.getNameSpace());
                            this.nomeOperacao.put(conf.getId(), conf.getNomeOperacao());
                            this.nomeServico.put(conf.getUrl(), conf.getNomeServico());
                            try {
                                this.classes.put(conf.getId(), this.getClass().getClassLoader().loadClass(conf.getClassName()));
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (tipo.equals(PropriedadesSistema.ID_SCAN)) {
                        for (ConfiguracaoServico conf : servicos) {
                            this.adicionarData(this.urlServicosScan, uf, conf.getId(), conf.getUrl());
                            this.portNames.put(conf.getUrl(), conf.getNomePorta());
                            this.namespaceNames.put(conf.getUrl(), conf.getNameSpace());
                            this.nomeOperacao.put(conf.getId(), conf.getNomeOperacao());
                            this.nomeServico.put(conf.getUrl(), conf.getNomeServico());
                            try {
                                this.classes.put(conf.getId(), this.getClass().getClassLoader().loadClass(conf.getClassName()));
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ++n4;
                }
                if (!this.ufs.contains(uf)) {
                    this.ufs.add(uf);
                }
                ++n2;
            }
        }
    }

    private void adicionarData(Hashtable<String, Hashtable<String, String>> t, String uf, String idServico, String data) {
        Hashtable<String, String> ufs = t.get(uf);
        if (ufs == null) {
            ufs = new Hashtable();
        }
        ufs.put(idServico, data);
        t.put(uf, ufs);
    }

    public Hashtable<String, Hashtable<String, String>> getUrlServicosNormal() {
        return this.urlServicosNormal;
    }

    public Hashtable<String, Hashtable<String, String>> getUrlServicosScan() {
        return this.urlServicosScan;
    }

    public Hashtable<String, Hashtable<String, String>> getUrlServicosHomolgacao() {
        return this.urlServicosHomolgacao;
    }

    public Hashtable<String, String> getPortNames() {
        return this.portNames;
    }

    public Hashtable<String, String> getNamespaceNames() {
        return this.namespaceNames;
    }

    public Hashtable<String, String> getNomeOperacao() {
        return this.nomeOperacao;
    }

    public Hashtable<String, String> getNomeServico() {
        return this.nomeServico;
    }

    public Vector<String> getUfs() {
        return this.ufs;
    }

    public void setUfs(Vector<String> ufs) {
        this.ufs = ufs;
    }

    public static void main(String[] args) {
        ConfiguracaoXML cfg = new ConfiguracaoXML("/home/cnoriega/Itambe/servicos.xml");
        cfg.parse();
        System.out.println(cfg.getUfs().toString());
        String url = cfg.getUrlServicosHomolgacao().get("dpec").get("RetRecepcaoDPEC");
        System.out.println(cfg.getNomeServico().get(url));
    }

    public Hashtable<String, Class> getClasses() {
        return this.classes;
    }

    public Hashtable<String, Hashtable<String, String>> getUrlServicosDpecHomologacao() {
        return this.urlServicosDpecHomologacao;
    }

    public Hashtable<String, Hashtable<String, String>> getUrlServicosDpecProducao() {
        return this.urlServicosDpecProducao;
    }
}

