/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.serviceclients;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;

public class ConvertPKCS12ToJKS {
    private String INPUT_KEYSTORE_FILE;
    private String KEYSTORE_PASSWORD;
    private String OUTPUT_KEYSTORE_FILE;

    public ConvertPKCS12ToJKS(String pfxFile, String pfxSenha) {
        this.INPUT_KEYSTORE_FILE = pfxFile;
        this.KEYSTORE_PASSWORD = pfxSenha;
        this.OUTPUT_KEYSTORE_FILE = pfxFile.replace("pfx", "jks");
    }

    public void make() {
        try {
            KeyStore inputKeyStore = KeyStore.getInstance("PKCS12");
            FileInputStream fis = new FileInputStream(this.INPUT_KEYSTORE_FILE);
            char[] nPassword = null;
            nPassword = this.KEYSTORE_PASSWORD == null || this.KEYSTORE_PASSWORD.trim().equals("") ? null : this.KEYSTORE_PASSWORD.toCharArray();
            inputKeyStore.load(fis, nPassword);
            fis.close();
            KeyStore outputKeyStore = KeyStore.getInstance("JKS");
            outputKeyStore.load(null, this.KEYSTORE_PASSWORD.toCharArray());
            Enumeration<String> enum2 = inputKeyStore.aliases();
            while (enum2.hasMoreElements()) {
                String keyAlias = enum2.nextElement();
                System.out.println("alias=[" + keyAlias + "]");
                if (!inputKeyStore.isKeyEntry(keyAlias)) continue;
                Key key = inputKeyStore.getKey(keyAlias, nPassword);
                Certificate[] certChain = inputKeyStore.getCertificateChain(keyAlias);
                outputKeyStore.setKeyEntry("outkey", key, this.KEYSTORE_PASSWORD.toCharArray(), certChain);
            }
            FileOutputStream out = new FileOutputStream(this.OUTPUT_KEYSTORE_FILE);
            outputKeyStore.store(out, nPassword);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getOUTPUT_KEYSTORE_FILE() {
        return this.OUTPUT_KEYSTORE_FILE;
    }

    public static void main(String[] args) {
        ConvertPKCS12ToJKS cv = new ConvertPKCS12ToJKS(null, null);
        cv.make();
    }
}

