/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.serviceclients;

import br.com.taragona.nfe.serviceclients.NFeClient;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.util.Hashtable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class NFeClientFactory {
    public static Hashtable<String, Hashtable<Class, NFeClient>> clientesCNPJ = new Hashtable();
    public static Hashtable<String, SSLSocketFactory> socketFactoy = new Hashtable();
    private static Hashtable<String, Hashtable<Class, String>> servicosCNPJ = new Hashtable();
    private static Hashtable<String, Hashtable<Class, String>> servicosCNPJScan = new Hashtable();

    public static NFeClient criarCliente(Class c, String cnpj) {
        NFeClient cliente;
        Hashtable<Class<Object>, NFeClient> clientes = clientesCNPJ.get(cnpj);
        if (clientes == null) {
            clientes = new Hashtable();
        }
        if ((cliente = clientes.get(c)) != null) {
            return cliente;
        }
        try {
            Constructor construtor = c.getConstructor(String.class, String.class);
            cliente = (NFeClient)construtor.newInstance(cnpj, NFeClientFactory.obterURL(c, cnpj));
            clientes.put(c, cliente);
            clientesCNPJ.put(cnpj, clientes);
            return cliente;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        clientesCNPJ.put(cnpj, new Hashtable());
        return null;
    }

    public static void reiniciarClientesScan(String cnpj) throws Exception {
        Hashtable<Class, NFeClient> servicos = clientesCNPJ.get(cnpj);
        for (Class c : servicos.keySet()) {
            servicos.get(c).reInicializarServico(NFeClientFactory.obterURLScan(c, cnpj));
        }
    }

    public static void reiniciarTodosClientesScan() throws Exception {
        for (String cnpj : clientesCNPJ.keySet()) {
            Hashtable<Class, NFeClient> servicos = clientesCNPJ.get(cnpj);
            for (Class c : servicos.keySet()) {
                servicos.get(c).reInicializarServico(NFeClientFactory.obterURLScan(c, cnpj));
            }
        }
    }

    public static void reiniciarTodosClientesNormal() throws Exception {
        for (String cnpj : clientesCNPJ.keySet()) {
            Hashtable<Class, NFeClient> servicos = clientesCNPJ.get(cnpj);
            for (Class c : servicos.keySet()) {
                servicos.get(c).reInicializarServico(NFeClientFactory.obterURL(c, cnpj));
            }
        }
    }

    public static void reiniciarClientesNormal(String cnpj) throws Exception {
        Hashtable<Class, NFeClient> servicos = clientesCNPJ.get(cnpj);
        for (Class c : servicos.keySet()) {
            servicos.get(c).reInicializarServico(NFeClientFactory.obterURL(c, cnpj));
        }
    }

    public static String obterURL(Class c, String CNPJ) {
        return servicosCNPJ.get(CNPJ).get(c);
    }

    public static String obterURLScan(Class c, String CNPJ) {
        return servicosCNPJScan.get(CNPJ).get(c);
    }

    public static SSLSocketFactory obterContext(String cnpj, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("pkcs12");
        FileInputStream keyFile = new FileInputStream("/home/cnoriega/codecamp/certificado/cert.pfx");
        keyStore.load(keyFile, password.toCharArray());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("PKCS11");
        keyManagerFactory.init(keyStore, password.toCharArray());
        String trustStorePath = "/home/cnoriega/codecamp/certificado/cert.pfx";
        KeyStore trustStore = KeyStore.getInstance("pkcs12");
        FileInputStream trustFile = new FileInputStream(trustStorePath);
        trustStore.load(trustFile, password.toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        SSLContext context = SSLContext.getInstance("SSLv3");
        context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return context.getSocketFactory();
    }

    public static void criarSocketFactory(String cnpj, String password) {
        try {
            socketFactoy.put(cnpj, NFeClientFactory.obterContext(cnpj, password));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setServicosCNPJ(Hashtable<String, Hashtable<Class, String>> servicosCNPJ) {
        NFeClientFactory.servicosCNPJ = servicosCNPJ;
    }

    public static void setServicosCNPJScan(Hashtable<String, Hashtable<Class, String>> servicosCNPJScan) {
        NFeClientFactory.servicosCNPJScan = servicosCNPJScan;
    }
}

