/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.tools;

import br.com.taragona.nfe.clientreferencia.ReferenciaGerenciador;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.persistence.Query;

public class CheckCanceladas {
    private String nomeArquivo;
    private SimpleDateFormat dfin;
    private DAOGenerico<EstadoNFe> dao;
    private GerenciadorInterface ger;
    private FileWriter fw;

    public CheckCanceladas(String nome) {
        this.nomeArquivo = nome;
        this.dfin = new SimpleDateFormat("yyyyMMdd");
        this.dao = new DAOGenerico(EstadoNFe.class);
        try {
            this.ger = ReferenciaGerenciador.obterReferenciaGerenciador("localhost");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            this.fw = new FileWriter("saida.log", true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String tirarEsp(String str) {
        String[] partes = str.split(" ");
        return partes[0];
    }

    public void process(String tpAmb, String idUsuario) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(new File(this.nomeArquivo)));
        String line = br.readLine();
        while (line != null) {
            System.out.println("Reading line:" + line);
            this.fw.write("Reading line:" + line);
            try {
                String[] tokens = line.split("\\;");
                String numero = tokens[0].trim();
                String data = tokens[3].trim();
                String cnpj = this.tirarEsp(tokens[6].trim());
                String serie = tokens[7].trim();
                List<EstadoNFe> matched = this.find(cnpj, data, serie, numero);
                System.out.println("Achou os seguintes registros:" + matched.size());
                this.fw.write("Achou os seguintes registros:" + matched.size());
                for (EstadoNFe nfe : matched) {
                    String res = this.ger.consultarNota(nfe.getId(), tpAmb, idUsuario);
                    this.salvarResultado(nfe, res, line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            line = br.readLine();
        }
    }

    public void salvarResultado(EstadoNFe nfe, String resultado, String linhaorigina) {
        try {
            this.fw.write("Nota: " + linhaorigina + " chave NFe: " + nfe.getId() + " estado: " + resultado);
            this.fw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String fillZeros(String serie, int length) {
        Integer i = null;
        try {
            i = Integer.parseInt(serie);
        }
        catch (Exception e) {
            return "";
        }
        String str = i.toString();
        int size = length - str.length();
        int ii = 0;
        while (ii < size) {
            str = "0" + str;
            ++ii;
        }
        return str;
    }

    private String extractData(String str) {
        return str.substring(2, 6);
    }

    public List<EstadoNFe> find(String cnpj, String data, String serie, String numero) {
        String sql = "select e from EstadoNFe as e where e.id like '%" + this.extractData(data) + "%" + cnpj + "%55" + this.fillZeros(serie, 3) + this.fillZeros(numero, 9) + "%'";
        System.out.println("Quering:" + sql);
        try {
            this.fw.write("Quering:" + sql);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Query q = this.dao.criarQuery(sql);
        List r = q.getResultList();
        return r;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.fw.close();
    }

    public static void main(String[] argv) {
        PropriedadesMain.processarComandos(argv);
        BaseDadosConfig bd = new BaseDadosConfig();
        bd.setNomeDriver(ConfiguracaoSys.getDRIVER());
        bd.setUsuario(ConfiguracaoSys.getUSER_NAME());
        bd.setSenha(ConfiguracaoSys.getPASSWORD());
        bd.setUrl(ConfiguracaoSys.getURL_CONECTION());
        bd.setToplinkProp("update");
        PropriedadesSistema.setBdConfig(bd);
        CheckCanceladas c = new CheckCanceladas(PropriedadesMain.getOutros());
        try {
            c.process(ConfiguracaoSys.getTipoAmbiente(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

