/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.tools;

import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.PropriedadesMain;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;

public class PathFileFinder {
    private static PathFileFinder INSTANCE = null;
    private ResourceBundle rb;
    private ResourceBundle rbextra;
    private SimpleDateFormat dffano = new SimpleDateFormat("yyyy");
    private SimpleDateFormat dffmes = new SimpleDateFormat("MMM_yyyy");
    private SimpleDateFormat dffdia = new SimpleDateFormat("dd_MMM");

    public static PathFileFinder getINSTANCE() {
        if (INSTANCE == null) {
            INSTANCE = new PathFileFinder();
        }
        return INSTANCE;
    }

    public PathFileFinder() {
        try {
            this.rb = ResourceBundle.getBundle("pastas_cnpj");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.rbextra = ResourceBundle.getBundle("pastas_cnpj_extra");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String findPDFPath(String id, String tpAmb, Date dataGerada) {
        String pastaano = this.dffano.format(dataGerada);
        String pastames = this.dffmes.format(dataGerada);
        String pastadia = this.dffdia.format(dataGerada);
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        String path = null;
        try {
            path = this.rb.getString(chave.getCnpj());
            path = tpAmb.equals("1") ? path.replace("XML", "PRODUCAO/XML") : path.replace("XML", "HOMOLOGACAO/XML");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (path == null) {
            path = "";
        } else {
            path = path.replace("XML", "PDF");
            path = PropriedadesMain.isJunto() ? String.valueOf(path) + "/" : (PropriedadesMain.isMes() ? String.valueOf(path) + "/" + pastaano + "/" + pastames : String.valueOf(path) + "/" + pastaano + "/" + pastames + "/" + pastadia);
        }
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        return path;
    }

    public String findPSPath(String id, String tpAmb, Date dataGerada) {
        String pastaano = this.dffano.format(dataGerada);
        String pastames = this.dffmes.format(dataGerada);
        String pastadia = this.dffdia.format(dataGerada);
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        String path = null;
        try {
            path = this.rb.getString(chave.getCnpj());
            path = tpAmb.equals("1") ? path.replace("XML", "PRODUCAO/XML") : path.replace("XML", "HOMOLOGACAO/XML");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (path == null) {
            path = "";
        } else {
            path = path.replace("XML", "PS");
            path = PropriedadesMain.isJunto() ? String.valueOf(path) + "/" : (PropriedadesMain.isMes() ? String.valueOf(path) + "/" + pastaano + "/" + pastames : String.valueOf(path) + "/" + pastaano + "/" + pastames + "/" + pastadia);
        }
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        return path;
    }

    public String findXMLDenegadaPath(String id, String tpAmb, Date dataGerada) {
        String pastaano = this.dffano.format(dataGerada);
        String pastames = this.dffmes.format(dataGerada);
        String pastadia = this.dffdia.format(dataGerada);
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        String path = null;
        try {
            path = this.rb.getString(chave.getCnpj());
            path = tpAmb.equals("1") ? path.replace("XML", "PRODUCAO/XML") : path.replace("XML", "HOMOLOGACAO/XML");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (path == null) {
            path = "";
        } else {
            path = path.replace("XML", "DENEGADA");
            path = PropriedadesMain.isJunto() ? String.valueOf(path) + "/" : (PropriedadesMain.isMes() ? String.valueOf(path) + "/" + pastaano + "/" + pastames : String.valueOf(path) + "/" + pastaano + "/" + pastames + "/" + pastadia);
        }
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        return path;
    }

    public String findXMLPath(String id, String tpAmb, Date dataGerada) {
        String pastaano = this.dffano.format(dataGerada);
        String pastames = this.dffmes.format(dataGerada);
        String pastadia = this.dffdia.format(dataGerada);
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        String path = null;
        try {
            path = this.rb.getString(chave.getCnpj());
            path = tpAmb.equals("1") ? path.replace("XML", "PRODUCAO/XML") : path.replace("XML", "HOMOLOGACAO/XML");
        }
        catch (Exception exception) {
            // empty catch block
        }
        path = path == null ? "" : (PropriedadesMain.isJunto() ? String.valueOf(path) + "/" : (PropriedadesMain.isMes() ? String.valueOf(path) + "/" + pastaano + "/" + pastames : String.valueOf(path) + "/" + pastaano + "/" + pastames + "/" + pastadia));
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        return path;
    }

    public String findXMLPathExtra(String id, String tpAmb, Date dataGerada) {
        String pastaano = this.dffano.format(dataGerada);
        String pastames = this.dffmes.format(dataGerada);
        String pastadia = this.dffdia.format(dataGerada);
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        String path = null;
        try {
            path = this.rbextra.getString(chave.getCnpj());
            path = tpAmb.equals("1") ? path.replace("XML", "PRODUCAO/XML") : path.replace("XML", "HOMOLOGACAO/XML");
        }
        catch (Exception exception) {
            // empty catch block
        }
        path = path == null ? "" : String.valueOf(path) + "/";
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        return path;
    }

    public String findXMLPathOld(String id, String tpAmb, Date dataGerada) {
        String path;
        block2: {
            String pastaano = this.dffano.format(dataGerada);
            String pastames = this.dffmes.format(dataGerada);
            String pastadia = this.dffdia.format(dataGerada);
            GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
            path = null;
            try {
                path = this.rb.getString(chave.getCnpj());
                path = tpAmb.equals("1") ? path.replace("XML", "PRODUCAO/XML") : path.replace("XML", "HOMOLOGACAO/XML");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (path != null) break block2;
            path = "";
        }
        return path;
    }

    public String findCFOPXML(String id, String tpAmb, Date dataGerada) {
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        String path = null;
        try {
            System.out.println("cnpj: " + chave.getCnpj());
            path = this.rb.getString(chave.getCnpj());
            path = tpAmb.equals("1") ? path.replace("XML", "PRODUCAO/XML") : path.replace("XML", "HOMOLOGACAO/XML");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (path == null) {
            System.out.println("Caminho do cnpj para o XML n\u00c3\u00a3o foi encontrado em pastas_cnpj.properties !\n");
            path = "";
        } else {
            path = path.replace("XML", "XML_CFOP");
            System.out.println("path: " + path);
        }
        return path;
    }

    public String findPDFPathOld(String id, String tpAmb, Date dataGerada) {
        String pastaano = this.dffano.format(dataGerada);
        String pastames = this.dffmes.format(dataGerada);
        String pastadia = this.dffdia.format(dataGerada);
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        String path = null;
        try {
            path = this.rb.getString(chave.getCnpj());
            path = tpAmb.equals("1") ? path.replace("XML", "PRODUCAO/XML") : path.replace("XML", "HOMOLOGACAO/XML");
        }
        catch (Exception exception) {
            // empty catch block
        }
        path = path == null ? "" : path.replace("XML", "PDF");
        return path;
    }

    public String findXMLProtFile(String id, String tpAmb, Date dataGerada) {
        String path = this.findXMLPath(id, tpAmb, dataGerada);
        String file = String.valueOf(path) + "/" + id + "_prot.xml";
        return file;
    }

    public String findXMLFile(String id, String tpAmb, Date dataGerada) {
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        String path = this.findXMLPath(id, tpAmb, dataGerada);
        String file = String.valueOf(path) + "/" + "NFe_" + chave.getCnpj() + "_" + Integer.parseInt(chave.getSerie()) + "_" + Integer.parseInt(chave.getNumeroNota()) + ".xml";
        return file;
    }

    public String findXMLDPECPath(String cnpj, Date dataGerada) {
        String pastaano = this.dffano.format(dataGerada);
        String pastames = this.dffmes.format(dataGerada);
        String pastadia = this.dffdia.format(dataGerada);
        String path = null;
        try {
            path = this.rb.getString(cnpj);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (path == null) {
            path = "";
        } else {
            path = path.replace("XML", "DPEC");
            path = PropriedadesMain.isJunto() ? String.valueOf(path) + "/" : (PropriedadesMain.isMes() ? String.valueOf(path) + "/" + pastaano + "/" + pastames : String.valueOf(path) + "/" + pastaano + "/" + pastames + "/" + pastadia);
        }
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        return path;
    }

    public String findXMLEPECPath(String id, String tpAmb, Date dataGerada) {
        String pastaano = this.dffano.format(dataGerada);
        String pastames = this.dffmes.format(dataGerada);
        String pastadia = this.dffdia.format(dataGerada);
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        String path = null;
        try {
            path = this.rb.getString(chave.getCnpj());
            path = tpAmb.equals("1") ? path.replace("XML", "PRODUCAO/XML") : path.replace("XML", "HOMOLOGACAO/XML");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (path == null) {
            path = "";
        } else {
            path = path.replace("XML", "EPEC");
            path = PropriedadesMain.isJunto() ? String.valueOf(path) + "/" : (PropriedadesMain.isMes() ? String.valueOf(path) + "/" + pastaano + "/" + pastames : String.valueOf(path) + "/" + pastaano + "/" + pastames + "/" + pastadia);
        }
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        return path;
    }

    public String findXMLCancelPath(String id, String tpAmb, Date dataGerada) {
        String pastaano = this.dffano.format(dataGerada);
        String pastames = this.dffmes.format(dataGerada);
        String pastadia = this.dffdia.format(dataGerada);
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        String path = null;
        try {
            path = this.rb.getString(chave.getCnpj());
            path = tpAmb.equals("1") ? path.replace("XML", "PRODUCAO/XML") : path.replace("XML", "HOMOLOGACAO/XML");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (path == null) {
            path = "";
        } else {
            path = path.replace("XML", "CANCELAMENTO");
            path = PropriedadesMain.isJunto() ? String.valueOf(path) + "/" : (PropriedadesMain.isMes() ? String.valueOf(path) + "/" + pastaano + "/" + pastames : String.valueOf(path) + "/" + pastaano + "/" + pastames + "/" + pastadia);
        }
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        return path;
    }

    public String findXMLInutPath(String id, String tpAmb, Date dataGerada) {
        String pastaano = this.dffano.format(dataGerada);
        String pastames = this.dffmes.format(dataGerada);
        String pastadia = this.dffdia.format(dataGerada);
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        String path = null;
        try {
            path = this.rb.getString(chave.getCnpj());
            path = tpAmb.equals("1") ? path.replace("XML", "PRODUCAO/XML") : path.replace("XML", "HOMOLOGACAO/XML");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (path == null) {
            path = "";
        } else {
            path = path.replace("XML", "INUTILIZADO");
            path = PropriedadesMain.isJunto() ? String.valueOf(path) + "/" : (PropriedadesMain.isMes() ? String.valueOf(path) + "/" + pastaano + "/" + pastames : String.valueOf(path) + "/" + pastaano + "/" + pastames + "/" + pastadia);
        }
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        return path;
    }

    public String findXMLEventoPath(String id, String tpAmb, Date dataGerada) {
        String pastaano = this.dffano.format(dataGerada);
        String pastames = this.dffmes.format(dataGerada);
        String pastadia = this.dffdia.format(dataGerada);
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        String path = null;
        try {
            path = this.rb.getString(chave.getCnpj());
            path = tpAmb.equals("1") ? path.replace("XML", "PRODUCAO/XML") : path.replace("XML", "HOMOLOGACAO/XML");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (path == null) {
            path = "";
        } else {
            path = path.replace("XML", "CARTACORRECAO");
            path = PropriedadesMain.isJunto() ? String.valueOf(path) + "/" : (PropriedadesMain.isMes() ? String.valueOf(path) + "/" + pastaano + "/" + pastames : String.valueOf(path) + "/" + pastaano + "/" + pastames + "/" + pastadia);
        }
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        return path;
    }

    public String findRetornoPath(String cnpj, String tpAmb, Date dataGerada) {
        String pastaano = this.dffano.format(dataGerada);
        String pastames = this.dffmes.format(dataGerada);
        String pastadia = this.dffdia.format(dataGerada);
        String path = null;
        try {
            path = this.rb.getString(cnpj);
            path = tpAmb.equals("1") ? path.replace("XML", "PRODUCAO/XML") : path.replace("XML", "HOMOLOGACAO/XML");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (path == null) {
            path = "";
        } else {
            path = path.replace("XML", "RETORNO");
            path = PropriedadesMain.isJunto() ? String.valueOf(path) + "/" : (PropriedadesMain.isMes() ? String.valueOf(path) + "/" + pastaano + "/" + pastames : String.valueOf(path) + "/" + pastaano + "/" + pastames + "/" + pastadia);
        }
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        return path;
    }

    public String findXMLFileOld(String id, String tpAmb, Date dataGerada) {
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        String path = this.findXMLPathOld(id, tpAmb, dataGerada);
        String file = String.valueOf(path) + "/" + "NFe_" + chave.getCnpj() + "_" + Integer.parseInt(chave.getSerie()) + "_" + Integer.parseInt(chave.getNumeroNota()) + ".xml";
        return file;
    }
}

