/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.tools;

import br.com.taragona.nfe.persistence.GNRE;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.tti.sefaz.persistence.dao.DAO;
import br.com.tti.sefaz.persistence.dao.DaoFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Calendar;
import java.util.Date;

public class PrintGNRE {
    private DAO<GNRE> daognre = DaoFactory.createDAO(GNRE.class);
    private File pasta = new File(PropriedadesMain.getConfig());

    public void print(String id, Date dataimpressao, String cnpjemitente, String uf) {
        try {
            File[] pdffiles = this.pasta.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File arg0, String arg1) {
                    return arg1.toLowerCase().endsWith(".pdf");
                }
            });
            GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
            File gnrepdf = null;
            File[] fileArray = pdffiles;
            int n = pdffiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().startsWith(chave.getNumeroNota())) {
                    gnrepdf = file;
                    break;
                }
                ++n2;
            }
            GNRE reggnre = new GNRE();
            reggnre.setId(id);
            reggnre.setFilename(gnrepdf.getAbsolutePath());
            reggnre.setCnpjemitente(cnpjemitente);
            reggnre.setDateimpressao(Calendar.getInstance().getTime());
            reggnre.setUf(uf);
            if (gnrepdf == null) {
                reggnre.setEstado(GNRE.ESTADO_GNRE.SEM_PDF);
            } else {
                reggnre.setEstado(GNRE.ESTADO_GNRE.COMPLETO);
            }
            GNRE exists = (GNRE)this.daognre.findEntity((Object)reggnre.getId());
            if (exists == null) {
                this.daognre.saveEntity((Object)reggnre);
            } else {
                this.daognre.updateEntity((Object)reggnre);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

