/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.tools;

import br.com.tti.sefaz.log.MyLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ZipCreator {
    private File[] rootdir;

    public ZipCreator(File rootdir) {
        this.rootdir = new File[]{rootdir};
    }

    public ZipCreator(File[] rootdir) {
        this.rootdir = rootdir;
    }

    public File process() {
        try {
            File outputfile = File.createTempFile("zipoutput", ".zip");
            List<ZipEntry> files = this.createZip(outputfile, this.rootdir);
            for (ZipEntry zipEntry : files) {
                MyLogger.getLog().info("zipped file:" + zipEntry.getName());
            }
            return outputfile;
        }
        catch (Exception e) {
            MyLogger.getLog().log(Level.INFO, e.getLocalizedMessage(), e);
            return null;
        }
    }

    public List<ZipEntry> createZip(File zipfile, File ... files) throws Exception {
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            List<ZipEntry> listaEntradasZip;
            if (!zipfile.getName().toLowerCase().endsWith(".zip")) {
                zipfile = new File(String.valueOf(zipfile.getAbsolutePath()) + ".zip");
            }
            fos = new FileOutputStream(zipfile);
            bos = new BufferedOutputStream(fos);
            List<ZipEntry> list = listaEntradasZip = this.createZip(bos, files);
            return list;
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e) {
                    MyLogger.getLog().log(Level.INFO, e.getLocalizedMessage(), e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    MyLogger.getLog().log(Level.INFO, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    public List<ZipEntry> createZip(OutputStream os, File[] arquivos) throws Exception, Exception {
        if (arquivos == null || arquivos.length < 1) {
            throw new ZipException("Zip entry empty");
        }
        ArrayList<ZipEntry> zipentries = new ArrayList<ZipEntry>();
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(os);
            int i = 0;
            while (i < arquivos.length) {
                String caminhoInicial = arquivos[i].getParent();
                List<ZipEntry> novasEntradas = this.addFileEntryToZip(zos, arquivos[i], caminhoInicial);
                if (novasEntradas != null) {
                    zipentries.addAll(novasEntradas);
                }
                ++i;
            }
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (Exception e) {
                    MyLogger.getLog().log(Level.INFO, e.getLocalizedMessage(), e);
                }
            }
        }
        return zipentries;
    }

    private List<ZipEntry> addFileEntryToZip(ZipOutputStream zos, File arquivo, String caminhoInicial) throws Exception {
        int filesize = (int)arquivo.length();
        ArrayList<ZipEntry> listaEntradasZip = new ArrayList<ZipEntry>();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        byte[] buffer = new byte[filesize];
        try {
            if (arquivo.isDirectory()) {
                File[] arquivos = arquivo.listFiles();
                int i = 0;
                while (i < arquivos.length) {
                    List<ZipEntry> novasEntradas = this.addFileEntryToZip(zos, arquivos[i], caminhoInicial);
                    if (novasEntradas != null) {
                        listaEntradasZip.addAll(novasEntradas);
                    }
                    ++i;
                }
                ArrayList<ZipEntry> arrayList = listaEntradasZip;
                return arrayList;
            }
            String caminhoEntradaZip = null;
            int idx = arquivo.getAbsolutePath().indexOf(caminhoInicial);
            if (idx >= 0) {
                caminhoEntradaZip = arquivo.getAbsolutePath().substring(idx + caminhoInicial.length() + 1);
            }
            ZipEntry entrada = new ZipEntry(caminhoEntradaZip);
            zos.putNextEntry(entrada);
            zos.setMethod(8);
            fis = new FileInputStream(arquivo);
            bis = new BufferedInputStream(fis, filesize);
            int bytesLidos = 0;
            while ((bytesLidos = bis.read(buffer, 0, filesize)) != -1) {
                zos.write(buffer, 0, bytesLidos);
            }
            listaEntradasZip.add(entrada);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {
                    MyLogger.getLog().log(Level.INFO, e.getLocalizedMessage(), e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    MyLogger.getLog().log(Level.INFO, e.getLocalizedMessage(), e);
                }
            }
        }
        return listaEntradasZip;
    }

    public static void main(String[] args) {
        try {
            ZipCreator extractor = new ZipCreator(new File("C:\\50630466000149"));
            File file = extractor.process();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

