/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.unilog;

import br.com.taragona.nfe.classes.recepcao.TNFe;
import br.com.taragona.nfe.classes.recepcao.TNfeProc;
import br.com.taragona.nfe.classes.recepcao.TProtNFe;
import br.com.taragona.nfe.unilog.UnilogZ025;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import nfetexto.util.GerChave;

public final class NfeTxtGenerator {
    private static final String PACKAGE_JAXB = "br.com.taragona.nfe.classes.recepcao";
    private static final String ORDER_TYPE_PED = "PED";
    private static final String SALES_B2B = "B2B";
    private static final String SALES_B2C = "B2C";

    private NfeTxtGenerator() {
    }

    public static Path generateTxtAuto(Path procNfeXml, Path inboxDir, UnilogZ025 z025, String idempotency, String overrideUrlBillings, String overrideUrlOutbounds, Integer warehouseCodeOpt) throws Exception {
        boolean isB2C;
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TNfeProc.class, TProtNFe.class});
        Unmarshaller um = ctx.createUnmarshaller();
        Object root = um.unmarshal(procNfeXml.toFile());
        NfeView v = NfeView.from(root);
        if (v.chave == null || v.chave.length() != 44) {
            throw new IllegalStateException("Chave NF-e n\u00c3\u00a3o encontrada no procNFe: " + procNfeXml);
        }
        String feito = procNfeXml.getParent().toString();
        feito = "feito" + File.separator + v.chave.substring(6, 20) + File.separator + feito.substring(feito.indexOf(String.valueOf(File.separator) + "XML" + File.separator) + 5);
        Path doneDir = inboxDir.resolveSibling(feito);
        Files.createDirectories(doneDir, new FileAttribute[0]);
        Path done = doneDir.resolve(String.valueOf(v.chave) + ".txt");
        if (Files.isRegularFile(done, new LinkOption[0])) {
            return done;
        }
        String orderType = NfeTxtGenerator.coalesceStr(z025 != null ? z025.orderType : null, v.tpNF != null && v.tpNF == 1 ? "NFS" : ORDER_TYPE_PED);
        boolean bl = isB2C = orderType != null && !ORDER_TYPE_PED.equalsIgnoreCase(orderType);
        if (!isB2C) {
            String idem = NfeTxtGenerator.coalesceStr(idempotency, "nota-" + v.chave);
            return NfeTxtGenerator.generateTxt(procNfeXml, inboxDir, z025, idem, overrideUrlBillings);
        }
        String outboundsJson = NfeTxtGenerator.buildOutboundsJson(procNfeXml, z025, v, orderType, SALES_B2C, warehouseCodeOpt);
        StringBuilder txt = new StringBuilder();
        txt.append("request_inline=").append(outboundsJson).append("\n");
        txt.append("idempotency=").append(NfeTxtGenerator.coalesceStr(idempotency, "out-" + v.chave)).append("\n");
        if (NfeTxtGenerator.notBlank(overrideUrlOutbounds)) {
            txt.append("override_url=").append(overrideUrlOutbounds).append("\n");
        }
        Files.createDirectories(inboxDir, new FileAttribute[0]);
        Path out = inboxDir.resolve(String.valueOf(v.chave) + ".txt");
        if (!out.toFile().exists()) {
            Files.write(out, txt.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        return out;
    }

    public static Path generateTxt(Path procNfeXml, Path inboxDir, UnilogZ025 z025, String idempotency, String overrideUrl) throws Exception {
        String customerName;
        String orderSeries;
        Objects.requireNonNull(procNfeXml, "procNfeXml");
        Objects.requireNonNull(inboxDir, "inboxDir");
        JAXBContext ctx = JAXBContext.newInstance((String)PACKAGE_JAXB);
        Unmarshaller um = ctx.createUnmarshaller();
        Object root = um.unmarshal(procNfeXml.toFile());
        NfeView v = NfeView.from(root);
        if (v.chave == null || v.chave.length() != 44) {
            throw new IllegalStateException("Chave NF-e n\u00c3\u00a3o encontrada no procNFe: " + procNfeXml);
        }
        String feito = procNfeXml.getParent().toString();
        feito = "feito" + File.separator + v.chave.substring(6, 20) + File.separator + feito.substring(feito.indexOf(String.valueOf(File.separator) + "XML" + File.separator) + 5);
        Path doneDir = inboxDir.resolveSibling(feito);
        Files.createDirectories(doneDir, new FileAttribute[0]);
        Path done = doneDir.resolve(String.valueOf(v.chave) + ".txt");
        if (Files.isRegularFile(done, new LinkOption[0])) {
            return done;
        }
        StringBuilder ini = new StringBuilder();
        ini.append("[order]\n");
        String orderDate = NfeTxtGenerator.coalesceStr(z025 != null ? z025.orderDate : null, v.ideDhEmi, NfeTxtGenerator.nowIso());
        ini.append("orderDate=").append(NfeTxtGenerator.q(orderDate)).append("\n");
        String orderNumber = NfeTxtGenerator.coalesceStr(z025 != null ? z025.orderNumber : null);
        if (orderNumber != null) {
            ini.append("orderNumber=").append(NfeTxtGenerator.q(orderNumber)).append("\n");
        }
        if ((orderSeries = NfeTxtGenerator.coalesceStr(z025 != null ? z025.orderSeries : null, v.ideSerie != null ? String.valueOf(v.ideSerie) : null)) != null) {
            ini.append("orderSeries=").append(NfeTxtGenerator.q(orderSeries)).append("\n");
        }
        String orderType = NfeTxtGenerator.coalesceStr(z025 != null ? z025.orderType : null, v.tpNF != null && v.tpNF == 1 ? "NFS" : "NFE");
        ini.append("orderType=").append(NfeTxtGenerator.q(orderType)).append("\n");
        String customerCnpj = NfeTxtGenerator.coalesceStr(z025 != null ? z025.customerCnpj : null);
        if (customerCnpj != null) {
            ini.append("customerCnpj=").append(NfeTxtGenerator.q(customerCnpj)).append("\n");
        }
        if ((customerName = NfeTxtGenerator.coalesceStr(z025 != null ? z025.customerName : null, v.destNome)) != null) {
            ini.append("customerName=").append(NfeTxtGenerator.q(customerName)).append("\n");
        }
        ini.append("\n");
        ini.append("[invoice]\n");
        if (v.ideNNF != null) {
            ini.append("invoiceNumber=").append(NfeTxtGenerator.q(String.valueOf(v.ideNNF))).append("\n");
        }
        if (v.chave != null) {
            ini.append("nfeAccessKey=").append(NfeTxtGenerator.q(v.chave)).append("\n");
        }
        if (v.ideSerie != null) {
            ini.append("invoiceSeries=").append(NfeTxtGenerator.q(String.valueOf(v.ideSerie))).append("\n");
        }
        if (v.tpNF != null) {
            ini.append("invoiceType=").append(NfeTxtGenerator.q(String.valueOf(v.tpNF))).append("\n");
        }
        if (NfeTxtGenerator.notBlank(v.ideDhEmi)) {
            ini.append("issueDate=").append(NfeTxtGenerator.q(v.ideDhEmi)).append("\n");
        }
        if (NfeTxtGenerator.notBlank(v.protDhRecbto)) {
            ini.append("protocolDate=").append(NfeTxtGenerator.q(v.protDhRecbto)).append("\n");
        }
        if (NfeTxtGenerator.notBlank(v.protNProt)) {
            ini.append("nfeProtocol=").append(NfeTxtGenerator.q(v.protNProt)).append("\n");
        }
        ini.append("\n");
        ini.append("[invoice.mainValues]\n");
        ini.append("totalProductsAmount=").append(NfeTxtGenerator.num0(v.totVProd)).append("\n");
        ini.append("totalInvoiceAmount=").append(NfeTxtGenerator.num0(v.totVNF)).append("\n");
        ini.append("freightAmount=").append(NfeTxtGenerator.num0(v.totVFrete)).append("\n");
        ini.append("insuranceAmount=").append(NfeTxtGenerator.num0(v.totVSeg)).append("\n");
        ini.append("totalDiscountAmount=").append(NfeTxtGenerator.num0(v.totVDesc)).append("\n");
        ini.append("otherExpensesAmount=").append(NfeTxtGenerator.num0(v.totVOutro)).append("\n\n");
        ini.append("[invoice.taxes]\n");
        ini.append("icmsAmount=").append(NfeTxtGenerator.num0(v.totVICMS)).append("\n");
        ini.append("icmsStAmount=").append(NfeTxtGenerator.num0(v.totVST)).append("\n");
        ini.append("ipiAmount=").append(NfeTxtGenerator.num0(v.totVIPI)).append("\n");
        ini.append("pisAmount=").append(NfeTxtGenerator.num0(v.totVPIS)).append("\n");
        ini.append("cofinsAmount=").append(NfeTxtGenerator.num0(v.totVCOFINS)).append("\n");
        ini.append("estimatedTaxAmount=0.0\n\n");
        ini.append("[invoice.retentions]\n");
        ini.append("icmsRetentionAmount=0.0\n");
        ini.append("pisRetentionAmount=0.0\n");
        ini.append("cofinsRetentionAmount=0.0\n");
        ini.append("csllRetentionAmount=0.0\n");
        ini.append("irRetentionAmount=0.0\n");
        ini.append("issRetentionAmount=0.0\n");
        ini.append("inssRetentionAmount=0.0\n\n");
        ini.append("[invoice.calculationBasis]\n");
        ini.append("icmsBasis=").append(NfeTxtGenerator.num0(v.totVBC)).append("\n");
        ini.append("icmsStBasis=").append(NfeTxtGenerator.num0(v.totVBCST)).append("\n");
        ini.append("importTaxAmount=").append(NfeTxtGenerator.num0(v.totVII)).append("\n");
        ini.append("fcpAmount=").append(NfeTxtGenerator.num0(v.totVFCP)).append("\n\n");
        if (z025 != null && NfeTxtGenerator.notBlank(z025.carrierCnpj)) {
            ini.append("; carrierCnpj=").append(NfeTxtGenerator.q(z025.carrierCnpj)).append("\n\n");
        }
        if (NfeTxtGenerator.notBlank(idempotency)) {
            ini.append("idempotency=").append(idempotency).append("\n");
        }
        if (NfeTxtGenerator.notBlank(overrideUrl)) {
            ini.append("override_url=").append(overrideUrl).append("\n");
        }
        Files.createDirectories(inboxDir, new FileAttribute[0]);
        Path out = inboxDir.resolve(String.valueOf(v.chave) + ".txt");
        Files.write(out, ini.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return out;
    }

    public static Path generateTxt(Path procNfeXml, Path inboxDir) throws Exception {
        return NfeTxtGenerator.generateTxt(procNfeXml, inboxDir, null, null, null);
    }

    public static Path generateTxt(Path procNfeXml, Path inboxDir, UnilogZ025 z025) throws Exception {
        return NfeTxtGenerator.generateTxt(procNfeXml, inboxDir, z025, null, null);
    }

    public static Path generateTxt(Path procNfeXml, Path inboxDir, String idempotency, String overrideUrl) throws Exception {
        return NfeTxtGenerator.generateTxt(procNfeXml, inboxDir, null, idempotency, overrideUrl);
    }

    private static String q(String s) {
        if (s == null) {
            return "\"\"";
        }
        String esc = s.replace("\\", "\\\\").replace("\"", "\\\"");
        return "\"" + esc + "\"";
    }

    private static String num0(BigDecimal v) {
        if (v == null) {
            return "0.0";
        }
        String s = v.stripTrailingZeros().toPlainString();
        if (!s.contains(".")) {
            s = String.valueOf(s) + ".0";
        }
        return s;
    }

    private static boolean notBlank(String s) {
        return s != null && !s.trim().isEmpty();
    }

    @SafeVarargs
    private static String coalesceStr(String ... vals) {
        if (vals == null) {
            return null;
        }
        String[] stringArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            if (v != null && !v.trim().isEmpty()) {
                return v;
            }
            ++n2;
        }
        return null;
    }

    private static String nowIso() {
        return OffsetDateTime.now(ZoneOffset.UTC).toString();
    }

    private static Object call(Object obj, String method) {
        if (obj == null) {
            return null;
        }
        try {
            return obj.getClass().getMethod(method, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static BigDecimal toBDAny(Object holder, String ... methodNames) {
        if (holder == null || methodNames == null) {
            return null;
        }
        String[] stringArray = methodNames;
        int n = methodNames.length;
        int n2 = 0;
        while (n2 < n) {
            String s;
            String m = stringArray[n2];
            Object v = NfeTxtGenerator.call(holder, m);
            if (v != null && !(s = v.toString().trim()).isEmpty()) {
                return new BigDecimal(s);
            }
            ++n2;
        }
        return null;
    }

    private static boolean appendPair(StringBuilder sb, boolean first, String key, String val) {
        if (val == null || val.trim().isEmpty()) {
            return first;
        }
        if (!first) {
            sb.append(',');
        }
        sb.append('\"').append(key).append('\"').append(':').append(NfeTxtGenerator.j(val));
        return false;
    }

    private static String j(String s) {
        if (s == null) {
            return "null";
        }
        String esc = s.replace("\\", "\\\\").replace("\"", "\\\"");
        return "\"" + esc + "\"";
    }

    private static String num(BigDecimal v) {
        if (v == null) {
            return "0.0";
        }
        String s = v.stripTrailingZeros().toPlainString();
        if (!s.contains(".")) {
            s = String.valueOf(s) + ".0";
        }
        return s;
    }

    private static String str(Object o) {
        return o == null ? null : o.toString();
    }

    private static String buildOutboundsJson(Path procNfeXml, UnilogZ025 z025, NfeView v, String orderType, String salesChannel, Integer warehouseCode) throws Exception {
        String cfop;
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TNfeProc.class, TProtNFe.class});
        Unmarshaller um = ctx.createUnmarshaller();
        Object root = um.unmarshal(procNfeXml.toFile());
        if (root instanceof JAXBElement) {
            root = ((JAXBElement)root).getValue();
        }
        TNfeProc proc = (TNfeProc)root;
        TNFe nfe = proc.getNFe();
        TNFe.InfNFe inf = nfe.getInfNFe();
        String orderNumber = NfeTxtGenerator.coalesceStr(v.ideNNF != null ? String.valueOf(v.ideNNF) : null);
        String orderSeries = NfeTxtGenerator.coalesceStr(v.ideSerie != null ? String.valueOf(v.ideSerie) : null);
        long volumeQty = 0L;
        if (inf.getTransp() != null && inf.getTransp().getVol() != null) {
            for (TNFe.InfNFe.Transp.Vol vol : inf.getTransp().getVol()) {
                Object qv = NfeTxtGenerator.call(vol, "getQVol");
                if (qv == null) continue;
                try {
                    volumeQty += Long.parseLong(qv.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (volumeQty == 0L) {
            volumeQty = 1L;
        }
        String destCnpjCpf = null;
        String destName = null;
        String destUF = null;
        String destCidade = null;
        String personType = null;
        String destCEP = null;
        String destLogradouro = null;
        String destNro = null;
        String destBairro = null;
        String destCompl = null;
        if (inf.getDest() != null) {
            destCnpjCpf = NfeTxtGenerator.coalesceStr(inf.getDest().getCNPJ(), inf.getDest().getCPF());
            destName = inf.getDest().getXNome();
            if (inf.getDest().getEnderDest() != null) {
                destUF = NfeTxtGenerator.str((Object)inf.getDest().getEnderDest().getUF());
                destCidade = NfeTxtGenerator.str(inf.getDest().getEnderDest().getXMun());
                personType = inf.getDest().getCPF() != null && !inf.getDest().getCPF().isEmpty() ? NfeTxtGenerator.str("F") : (inf.getDest().getCNPJ() != null && !inf.getDest().getCNPJ().isEmpty() ? NfeTxtGenerator.str("J") : "");
                destCEP = NfeTxtGenerator.str(inf.getDest().getEnderDest().getCEP());
                destLogradouro = NfeTxtGenerator.str(inf.getDest().getEnderDest().getXLgr());
                destNro = NfeTxtGenerator.str(inf.getDest().getEnderDest().getNro());
                destBairro = NfeTxtGenerator.str(inf.getDest().getEnderDest().getXBairro());
                destCompl = NfeTxtGenerator.str(inf.getDest().getEnderDest().getXCpl());
            }
        }
        String carrierCnpjCpf = null;
        String carrierName = null;
        if (inf.getTransp() != null && inf.getTransp().getTransporta() != null) {
            carrierCnpjCpf = NfeTxtGenerator.coalesceStr(inf.getTransp().getTransporta().getCNPJ(), inf.getTransp().getTransporta().getCPF());
            carrierName = NfeTxtGenerator.str(inf.getTransp().getTransporta().getXNome());
        }
        StringBuilder items = new StringBuilder();
        items.append("[");
        boolean first = true;
        for (TNFe.InfNFe.Det det : inf.getDet()) {
            if (det.getProd() == null) continue;
            String ean = NfeTxtGenerator.coalesceStr(det.getProd().getCEANTrib(), det.getProd().getCEAN());
            if (ean != null && "SEM GTIN".equalsIgnoreCase(ean)) {
                ean = null;
            }
            BigDecimal qCom = NfeView.toBD(det.getProd().getQCom());
            BigDecimal vUnCom = NfeView.toBD(det.getProd().getVUnCom());
            BigDecimal vUn = NfeView.toBD(det.getProd().getVUnCom());
            BigDecimal qTrib = NfeView.toBD(det.getProd().getQTrib());
            BigDecimal vUnTrib = NfeView.toBD(det.getProd().getVUnTrib());
            BigDecimal fiscalUnitValue = vUnTrib;
            if (fiscalUnitValue == null) {
                if (qTrib != null && qTrib.signum() > 0 && qCom != null && vUnCom != null) {
                    BigDecimal vProd = vUnCom.multiply(qCom);
                    fiscalUnitValue = vProd.divide(qTrib, 10, RoundingMode.HALF_UP);
                } else {
                    fiscalUnitValue = vUnCom;
                }
            }
            if (!first) {
                items.append(',');
            }
            first = false;
            items.append("{");
            items.append("\"productClass\":").append(NfeTxtGenerator.j("07")).append(",");
            if (ean != null) {
                items.append("\"ean\":").append(NfeTxtGenerator.j(ean)).append(",");
            }
            items.append("\"purchaseUnitFactor\": 1,");
            String purchaseUnitType = nfe.getInfNFe().getTransp().getVol().get(0).getEsp();
            if (purchaseUnitType == null || purchaseUnitType.trim().isEmpty()) {
                purchaseUnitType = "UNIDADE";
            }
            items.append("\"purchaseUnitType\":").append("\"" + purchaseUnitType + "\"").append(",");
            items.append("\"quantity\":").append(NfeTxtGenerator.num(qCom)).append(",");
            if (vUn != null) {
                items.append("\"unitValue\":").append(NfeTxtGenerator.num(vUn)).append(",");
            }
            if (vUn != null) {
                items.append("\"fiscalUnitValue\":").append(NfeTxtGenerator.num(vUnTrib)).append("");
            }
            items.append("}");
        }
        items.append("]");
        String issueDateIso = v.ideDhEmi;
        String authDateIso = v.protDhRecbto;
        BigDecimal totProd = v.totVProd;
        BigDecimal totNF = v.totVNF;
        BigDecimal vFrete = v.totVFrete;
        BigDecimal vSeg = v.totVSeg;
        BigDecimal vDesc = v.totVDesc;
        StringBuilder sb = new StringBuilder(2048);
        sb.append("{\"orders\":[{");
        if (warehouseCode != null) {
            sb.append("\"wareHouseCode\":").append(warehouseCode).append(",");
        }
        sb.append("\"orderNumber\":").append(NfeTxtGenerator.j(orderNumber)).append(",");
        sb.append("\"orderSeries\":").append(NfeTxtGenerator.j(orderSeries)).append(",");
        sb.append("\"orderType\":").append(NfeTxtGenerator.j(orderType)).append(",");
        sb.append("\"volumeQuantity\":").append(volumeQty).append(",");
        if (v.chave != null) {
            sb.append("\"nfeAccessKey\":").append(NfeTxtGenerator.j(v.chave)).append(",");
        }
        if (authDateIso != null) {
            sb.append("\"nfeAuthorizationDate\":").append(NfeTxtGenerator.j(authDateIso)).append(",");
        }
        if (NfeTxtGenerator.notBlank(v.protNProt)) {
            sb.append("\"nfeProtocol\":").append(NfeTxtGenerator.q(v.protNProt)).append(",");
        }
        if (v.ideDhEmi != null) {
            sb.append("\"issueDate\":").append(NfeTxtGenerator.j(v.ideDhEmi)).append(",");
        }
        if (issueDateIso != null) {
            sb.append("\"expectedMovementDate\":").append(NfeTxtGenerator.j(issueDateIso)).append(",");
        }
        if (vFrete != null) {
            sb.append("\"freightValue\":").append(NfeTxtGenerator.num(vFrete)).append(",");
        }
        if (vSeg != null) {
            sb.append("\"insuranceValue\":").append(NfeTxtGenerator.num(vSeg)).append(",");
        }
        if (vDesc != null) {
            sb.append("\"discountValue\":").append(NfeTxtGenerator.num(vDesc)).append(",");
        }
        if (totNF != null) {
            sb.append("\"totalOrderValue\":").append(NfeTxtGenerator.num(totNF)).append(",");
        }
        if (totProd != null) {
            sb.append("\"totalProductValue\":").append(NfeTxtGenerator.num(totProd)).append(",");
        }
        if ((cfop = NfeTxtGenerator.str(nfe.getInfNFe().getDet().get(0).getProd().getCFOP())) != null) {
            sb.append("\"cfop\":").append(NfeTxtGenerator.j(cfop)).append(",");
        }
        if (salesChannel != null) {
            sb.append("\"salesChannel\":").append(NfeTxtGenerator.j(salesChannel)).append(",");
        }
        sb.append("\"customer\":{");
        boolean cFirst = true;
        cFirst = NfeTxtGenerator.appendPair(sb, cFirst, "cnpjCpf", destCnpjCpf);
        cFirst = NfeTxtGenerator.appendPair(sb, cFirst, "name", destName);
        cFirst = NfeTxtGenerator.appendPair(sb, cFirst, "address", destLogradouro);
        cFirst = NfeTxtGenerator.appendPair(sb, cFirst, "number", destNro);
        cFirst = NfeTxtGenerator.appendPair(sb, cFirst, "neighborhood", destBairro);
        cFirst = NfeTxtGenerator.appendPair(sb, cFirst, "zipCode", destCEP);
        cFirst = NfeTxtGenerator.appendPair(sb, cFirst, "city", destCidade);
        cFirst = NfeTxtGenerator.appendPair(sb, cFirst, "personType", personType);
        cFirst = NfeTxtGenerator.appendPair(sb, cFirst, "state", destUF);
        cFirst = NfeTxtGenerator.appendPair(sb, cFirst, "complement", destCompl);
        sb.append("},");
        sb.append("\"shippingAddress\":{");
        boolean sFirst = true;
        sFirst = NfeTxtGenerator.appendPair(sb, sFirst, "cnpjCpf", destCnpjCpf);
        sFirst = NfeTxtGenerator.appendPair(sb, sFirst, "name", destName);
        sFirst = NfeTxtGenerator.appendPair(sb, sFirst, "address", destLogradouro);
        sFirst = NfeTxtGenerator.appendPair(sb, sFirst, "number", destNro);
        sFirst = NfeTxtGenerator.appendPair(sb, sFirst, "neighborhood", destBairro);
        sFirst = NfeTxtGenerator.appendPair(sb, sFirst, "zipCode", destCEP);
        sFirst = NfeTxtGenerator.appendPair(sb, sFirst, "city", destCidade);
        sFirst = NfeTxtGenerator.appendPair(sb, sFirst, "state", destUF);
        sFirst = NfeTxtGenerator.appendPair(sb, sFirst, "complement", destCompl);
        sb.append("},");
        if (carrierCnpjCpf != null || carrierName != null) {
            sb.append("\"carrier\":{");
            boolean kFirst = true;
            kFirst = NfeTxtGenerator.appendPair(sb, kFirst, "cnpjCpf", carrierCnpjCpf);
            kFirst = NfeTxtGenerator.appendPair(sb, kFirst, "name", carrierName);
            sb.append("},");
        }
        sb.append("\"items\":").append((CharSequence)items);
        sb.append("}]}");
        return sb.toString();
    }

    public static Path generateTxtOutboundCancellation(Path procNfeXml, String cnpj, Path inboxDir, UnilogZ025 z025, String idempotency, String overrideUrlBillings, String overrideUrlOutbounds, Integer warehouseCode, String accessKey) throws Exception {
        GerChave chave;
        String feito = procNfeXml.getParent().toString();
        feito = "feito" + File.separator + accessKey.substring(6, 20) + File.separator + feito.substring(feito.indexOf(String.valueOf(File.separator) + "XML" + File.separator) + 5);
        Path doneDir = inboxDir.resolveSibling(feito);
        Files.createDirectories(doneDir, new FileAttribute[0]);
        Path done = doneDir.resolve(String.valueOf(accessKey) + "_cancelamento.txt");
        if (Files.isRegularFile(done, new LinkOption[0])) {
            return done;
        }
        StringBuilder json = new StringBuilder(2048);
        json.append("{");
        if (z025.customerCnpj != null) {
            json.append("\"cnpjCpf\":").append("\"" + z025.customerCnpj + "\"").append(",");
        }
        if (warehouseCode != null) {
            json.append("\"wareHouseCode\":").append(warehouseCode).append(",");
        }
        if (z025.orderSeries != null) {
            json.append("\"series\":").append("\"" + z025.orderSeries + "\"").append(",");
        }
        if (z025.orderType != null) {
            json.append("\"type\":").append("\"" + z025.orderType + "\"").append(",");
        }
        if (z025.orderType.equals(ORDER_TYPE_PED)) {
            if (z025.orderNumber != null) {
                json.append("\"number\":").append("\"" + z025.orderNumber + "\"").append(",");
            }
        } else if (accessKey != null && (chave = new GerChave(accessKey)) != null && chave.getNumeroNota() != null && !chave.getNumeroNota().isEmpty()) {
            json.append("\"number\":").append("\"" + chave.getNumeroNota() + "\"").append(",");
        }
        if (accessKey != null) {
            json.append("\"accessKey\":").append("\"" + accessKey + "\"");
        }
        json.append("}");
        StringBuilder txt = new StringBuilder();
        txt.append("request_inline_cancellation=").append(json.toString()).append("\n");
        txt.append("idempotency=").append(NfeTxtGenerator.coalesceStr(idempotency, "cancelamento-" + accessKey)).append("\n");
        if (NfeTxtGenerator.notBlank(overrideUrlOutbounds)) {
            txt.append("override_url=").append(overrideUrlOutbounds).append("\n");
        }
        Files.createDirectories(inboxDir, new FileAttribute[0]);
        Path out = inboxDir.resolve(String.valueOf(accessKey) + "_cancelamento.txt");
        Files.write(out, txt.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return out;
    }

    static final class NfeView {
        String chave;
        String ideDhEmi;
        Integer ideNNF;
        Integer ideSerie;
        Integer tpNF;
        String protNProt;
        String protDhRecbto;
        String destCnpj;
        String destNome;
        BigDecimal totVProd;
        BigDecimal totVNF;
        BigDecimal totVFrete;
        BigDecimal totVSeg;
        BigDecimal totVDesc;
        BigDecimal totVOutro;
        BigDecimal totVICMS;
        BigDecimal totVST;
        BigDecimal totVIPI;
        BigDecimal totVPIS;
        BigDecimal totVCOFINS;
        BigDecimal totVBC;
        BigDecimal totVBCST;
        BigDecimal totVII;
        BigDecimal totVFCP;

        NfeView() {
        }

        static NfeView from(Object root) {
            String ch;
            Object val;
            NfeView v = new NfeView();
            if (root instanceof JAXBElement && (val = ((JAXBElement)root).getValue()) != null) {
                root = val;
            }
            if (!(root instanceof TNfeProc)) {
                throw new IllegalArgumentException("Raiz n\u00c3\u00a3o \u00c3\u00a9 TNfeProc: " + (root == null ? "null" : root.getClass()));
            }
            TNfeProc proc = (TNfeProc)root;
            TNFe nfe = proc.getNFe();
            if (nfe == null || nfe.getInfNFe() == null) {
                throw new IllegalStateException("NFe/InfNFe ausentes no procNFe.");
            }
            TNFe.InfNFe inf = nfe.getInfNFe();
            TProtNFe prot = proc.getProtNFe();
            String id = inf.getId();
            if (id != null && id.startsWith("NFe") && id.length() >= 47) {
                v.chave = id.substring(3);
            }
            if ((v.chave == null || v.chave.length() != 44) && prot != null && prot.getInfProt() != null && (ch = prot.getInfProt().getChNFe()) != null && ch.length() == 44) {
                v.chave = ch;
            }
            if (inf.getIde() != null) {
                if (inf.getIde().getDhEmi() != null) {
                    v.ideDhEmi = inf.getIde().getDhEmi().toString();
                } else if (inf.getIde().getDEmi() != null) {
                    v.ideDhEmi = String.valueOf(inf.getIde().getDEmi().toString()) + "T00:00:00-03:00";
                }
                v.ideNNF = NfeView.tryParseInt(inf.getIde().getNNF());
                v.ideSerie = NfeView.tryParseInt(inf.getIde().getSerie());
                v.tpNF = NfeView.tryParseInt(inf.getIde().getTpNF());
            }
            if (prot != null && prot.getInfProt() != null) {
                v.protNProt = prot.getInfProt().getNProt();
                if (prot.getInfProt().getDhRecbto() != null) {
                    v.protDhRecbto = prot.getInfProt().getDhRecbto().toString();
                }
            }
            if (inf.getDest() != null) {
                v.destCnpj = NfeView.firstNonNull(inf.getDest().getCNPJ(), inf.getDest().getCPF());
                v.destNome = inf.getDest().getXNome();
            }
            if (inf.getTotal() != null && inf.getTotal().getICMSTot() != null) {
                TNFe.InfNFe.Total.ICMSTot t = inf.getTotal().getICMSTot();
                v.totVProd = NfeView.toBD(t.getVProd());
                v.totVNF = NfeView.toBD(t.getVNF());
                v.totVFrete = NfeView.toBD(t.getVFrete());
                v.totVSeg = NfeView.toBD(t.getVSeg());
                v.totVDesc = NfeView.toBD(t.getVDesc());
                v.totVOutro = NfeView.toBD(t.getVOutro());
                v.totVICMS = NfeView.toBD(t.getVICMS());
                v.totVST = NfeTxtGenerator.toBDAny(t, new String[]{"getVICMSST", "getVST"});
                v.totVIPI = NfeView.toBD(t.getVIPI());
                v.totVPIS = NfeView.toBD(t.getVPIS());
                v.totVCOFINS = NfeView.toBD(t.getVCOFINS());
                v.totVBC = NfeView.toBD(t.getVBC());
                v.totVBCST = NfeView.toBD(t.getVBCST());
                v.totVII = NfeView.toBD(t.getVII());
                v.totVFCP = NfeTxtGenerator.toBDAny(t, new String[]{"getVFCP", "getVFCPUFDest", "getVFCPST"});
            }
            return v;
        }

        static Integer tryParseInt(Object o) {
            if (o == null) {
                return null;
            }
            String s = o.toString().trim();
            if (s.isEmpty()) {
                return null;
            }
            try {
                return Integer.valueOf(s);
            }
            catch (Exception e) {
                return null;
            }
        }

        static BigDecimal toBD(Object o) {
            if (o == null) {
                return null;
            }
            String s = o.toString().trim();
            if (s.isEmpty()) {
                return null;
            }
            return new BigDecimal(s);
        }

        static String firstNonNull(String a, String b) {
            return a != null && !a.isEmpty() ? a : b;
        }
    }
}

