/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.util;

import br.com.taragona.nfe.sender.util.ConfiguracaoXML;
import br.com.taragona.nfe.util.ParChave;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.xml.sender.config.ArquivoConfiguracao;
import br.com.taragona.nfe.util.xml.sender.config.Cnpjinfo;
import br.com.taragona.nfe.util.xml.sender.config.Cnpjs;
import br.com.taragona.nfe.util.xml.sender.config.Entrada;
import br.com.taragona.nfe.util.xml.sender.config.ListaVersoes;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBElement;

public class ConfiguracaoSys {
    public static ArquivoConfiguracao configuracao;
    private static String tipoAmbiente;
    private static String ipGerenciador;
    private static String ipAssinador;
    private static String pfxDeTransmissao;
    private static String trustStore;
    private static PropriedadesSistema.MODO_OP modoOperacao;
    private static String URL_BANCO_DADOS;
    private static String USER_NAME;
    private static String DRIVER;
    private static String PASSWORD;
    private static String TOPLINK_PROP;
    private static String pastaWrapper;
    private static String arquivoServicos;
    private static String urlxmldb;
    private static String senhaxmldb;
    private static Hashtable<String, String> cnpjsUF;
    private static Hashtable<ParChave, String> cnpjsTipo;
    private static ConfiguracaoXML senderConfig;
    private static Hashtable<String, Hashtable<String, String>> versaoEsquema;
    private static Hashtable<String, Long> timeouts;
    private static Hashtable<String, String> tipoenvio;
    private static Hashtable<String, Long> tempoProc;
    private static Hashtable<String, Integer> nNotas;
    private static Hashtable<String, Long> tamanhoLote;
    private static Hashtable<String[], String> keyFiles;
    private static Hashtable<String, String> trustFiles;
    private static Hashtable<String, String> nomesFantasia;
    private static Hashtable<String, String> eMails;
    private static Hashtable<String, String> casos;

    static {
        modoOperacao = PropriedadesSistema.MODO_OP.NORMAL;
        TOPLINK_PROP = "update";
        cnpjsUF = new Hashtable();
        cnpjsTipo = new Hashtable();
        versaoEsquema = new Hashtable();
        timeouts = new Hashtable();
        tipoenvio = new Hashtable();
        tempoProc = new Hashtable();
        nNotas = new Hashtable();
        tamanhoLote = new Hashtable();
        keyFiles = new Hashtable();
        trustFiles = new Hashtable();
        nomesFantasia = new Hashtable();
        eMails = new Hashtable();
        casos = new Hashtable();
        ConfiguracaoSys.lerConfiguracao();
        ConfiguracaoSys.lerConfiguracaoServicos();
        ConfiguracaoSys.inicializarModoOp();
        ConfiguracaoSys.inicializarBD();
    }

    public static void lerConfiguracaoServicos() {
        senderConfig = new ConfiguracaoXML(configuracao.getConfiguracaoSistema().getConf().getArquivoServicos());
        senderConfig.parse();
        arquivoServicos = configuracao.getConfiguracaoSistema().getConf().getArquivoServicos();
    }

    public static void inicializarBD() {
        URL_BANCO_DADOS = configuracao.getConfiguracaoSistema().getConf().getUrlBancoDados();
        PASSWORD = configuracao.getConfiguracaoSistema().getConf().getPassword();
        TOPLINK_PROP = configuracao.getConfiguracaoSistema().getConf().getToplinkProp();
        if (TOPLINK_PROP == null || TOPLINK_PROP.trim().isEmpty()) {
            TOPLINK_PROP = "update";
        }
        USER_NAME = configuracao.getConfiguracaoSistema().getConf().getUsuario();
        DRIVER = configuracao.getConfiguracaoSistema().getConf().getDriver();
        urlxmldb = configuracao.getConfiguracaoSistema().getConf().getUrlXMLDB();
        senhaxmldb = configuracao.getConfiguracaoSistema().getConf().getSenhaXMLDB();
    }

    public static void inicializarModoOp() {
        String modo = configuracao.getConfiguracaoSistema().getConf().getModoOperacao();
        modoOperacao = modo.equals("normal") ? PropriedadesSistema.MODO_OP.NORMAL : (modo.equals("contingencia") ? PropriedadesSistema.MODO_OP.CONTINGENCIA : PropriedadesSistema.MODO_OP.NORMAL);
    }

    public static PropriedadesSistema.MODO_OP getModoOperacao() {
        return modoOperacao;
    }

    public static void setModoOperacao(PropriedadesSistema.MODO_OP modoOperacao) {
        ConfiguracaoSys.modoOperacao = modoOperacao;
    }

    public static String getURL_CONECTION() {
        return URL_BANCO_DADOS;
    }

    public static void setURL_CONECTION(String url_conection) {
        URL_BANCO_DADOS = url_conection;
    }

    public static String getDRIVER() {
        return DRIVER;
    }

    public static void setDRIVER(String driver) {
        DRIVER = driver;
    }

    public static String getUSER_NAME() {
        return USER_NAME;
    }

    public static void setUSER_NAME(String user_name) {
        USER_NAME = user_name;
    }

    public static String getPASSWORD() {
        return PASSWORD;
    }

    public static void setPASSWORD(String password) {
        PASSWORD = password;
    }

    public static String getToplinkProp() {
        return TOPLINK_PROP;
    }

    public static void setToplinkProp(String toplinkProp) {
        TOPLINK_PROP = toplinkProp;
    }

    public static String obterVersaoUF(Class c, String UF) {
        Hashtable<String, String> entradas = versaoEsquema.get(UF);
        for (String nomeClasse : entradas.keySet()) {
            if (!c.getSimpleName().toLowerCase().equals("t" + nomeClasse.toLowerCase())) continue;
            return entradas.get(nomeClasse);
        }
        return null;
    }

    public static void lerConfiguracao() {
        try {
            XMLGenerator xmls = new XMLGenerator("br.com.taragona.nfe.util.xml.sender.config");
            FileInputStream in = new FileInputStream(PropriedadesMain.getXml());
            DataInputStream dis = new DataInputStream(in);
            String line = dis.readLine();
            String all = new String();
            while (line != null) {
                all = String.valueOf(all) + line;
                line = dis.readLine();
            }
            configuracao = (ArquivoConfiguracao)((JAXBElement)xmls.toObject(all)).getValue();
            pastaWrapper = configuracao.getConfiguracaoSistema().getConf().getDiretorioArquivos();
            List<Cnpjs> cadastros = configuracao.getCnpjsCadastrados().getCadastro();
            for (Cnpjs cadastro : cadastros) {
                List<Cnpjinfo> cnpjs = cadastro.getCnpjInfo();
                Vector<Object> cnpjsv = new Vector<Object>();
                for (Cnpjinfo cnpjinfo : cnpjs) {
                    String CNPJ = cnpjinfo.getCnpj().trim();
                    nNotas.put(CNPJ, Integer.parseInt(cadastro.getNNotas()));
                    timeouts.put(CNPJ, Long.parseLong(cadastro.getTimeout()));
                    tipoenvio.put(CNPJ, cadastro.getEnvio() == null ? "" : cadastro.getEnvio());
                    tempoProc.put(CNPJ, Long.parseLong(cadastro.getTempoProc()));
                    tamanhoLote.put(CNPJ, Long.parseLong(cadastro.getTamanhoLote()));
                    cnpjsUF.put(CNPJ, cadastro.getUF());
                    String tipo = cadastro.getTipo();
                    tipo = tipo.toLowerCase().startsWith("producao") ? "producao" : "homologacao";
                    cnpjsTipo.put(new ParChave(CNPJ, tipo), cadastro.getTipo());
                    nomesFantasia.put(CNPJ, cnpjinfo.getNomeFantasia());
                    if (cadastro.getEmails() != null) {
                        eMails.put(CNPJ, cadastro.getEmails());
                    }
                    if (cadastro.getCasos() != null) {
                        casos.put(CNPJ, cadastro.getCasos());
                    }
                    cnpjsv.add(CNPJ);
                }
                String[] cnpjss = new String[cnpjsv.size()];
                cnpjsv.toArray(cnpjss);
                keyFiles.put(cnpjss, cadastro.getPfx());
            }
            List<ListaVersoes> esquemas = configuracao.getVersoesEsquemas().getVersao();
            for (ListaVersoes versoes : esquemas) {
                String[] ufs;
                Hashtable<String, String> versoes_hash = new Hashtable<String, String>();
                List<Entrada> elementos = versoes.getElementos();
                for (Entrada entrada : elementos) {
                    versoes_hash.put(entrada.getNomeEsquema().toLowerCase(), entrada.getVersaoEsquema());
                }
                String[] stringArray = ufs = versoes.getUfs();
                int n = ufs.length;
                int n2 = 0;
                while (n2 < n) {
                    String uf = stringArray[n2];
                    versaoEsquema.put(uf, versoes_hash);
                    ++n2;
                }
            }
            ipGerenciador = configuracao.getConfiguracaoSistema().getConf().getIpGerenciador();
            ipAssinador = configuracao.getConfiguracaoSistema().getConf().getIpAssinador();
            pfxDeTransmissao = configuracao.getConfiguracaoSistema().getConf().getPfxDeTransmissao();
            trustStore = configuracao.getConfiguracaoSistema().getConf().getTrustStore();
            tipoAmbiente = configuracao.getConfiguracaoSistema().getConf().getTipoAmbiente();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Vector<String> obterCNPJsRegistrados() {
        Vector<String> urlsv = new Vector<String>();
        List<Cnpjs> cadastros = configuracao.getCnpjsCadastrados().getCadastro();
        for (Cnpjs cadastro : cadastros) {
            List<Cnpjinfo> cnpjs = cadastro.getCnpjInfo();
            for (Cnpjinfo cnpjinfo : cnpjs) {
                urlsv.add(cnpjinfo.getCnpj().trim());
            }
        }
        return urlsv;
    }

    public static String getIpGerenciador() {
        return ipGerenciador;
    }

    public static String getIpAssinador() {
        return ipAssinador;
    }

    public static String obterKeyFile(String cnpj) {
        return keyFiles.get(cnpj);
    }

    public static String obterTrustStore(String cnpj) {
        return trustFiles.get(cnpj);
    }

    public static Hashtable[] obterTodosServicos() {
        Hashtable<String, Hashtable<String, String>> servNormal = senderConfig.getUrlServicosNormal();
        Hashtable<String, Hashtable<String, String>> servHomologacao = senderConfig.getUrlServicosHomolgacao();
        Hashtable<String, Hashtable<String, String>> servScan = senderConfig.getUrlServicosScan();
        Hashtable[] todos = new Hashtable[]{servNormal, servHomologacao, servScan};
        return todos;
    }

    public static void ajustarTodosServicos(Hashtable[] servicos) {
        Hashtable servNormal = servicos[0];
        Hashtable servHomologacao = servicos[1];
        Hashtable servScan = servicos[2];
        senderConfig.ajustarServico(servNormal, PropriedadesSistema.ID_PRODUCAO);
        senderConfig.ajustarServico(servHomologacao, PropriedadesSistema.ID_HOMOLOGACAO);
        senderConfig.ajustarServico(servScan, PropriedadesSistema.ID_SCAN);
        senderConfig.serialize();
        senderConfig.parse();
    }

    public static Vector<String> obterUFsCadastrados() {
        return senderConfig.getUfs();
    }

    public static Hashtable<String, Hashtable<String, String>> getVersaoEsquema() {
        return versaoEsquema;
    }

    public static Hashtable<String[], String> getKeyFiles() {
        return keyFiles;
    }

    public static Hashtable<String, String> getTrustFiles() {
        return trustFiles;
    }

    public static Hashtable<String, Long> getTimeouts() {
        return timeouts;
    }

    public static Hashtable<String, Long> getTempoProc() {
        return tempoProc;
    }

    public static Hashtable<String, Integer> getNNotas() {
        return nNotas;
    }

    public static Hashtable<String, Long> getTamanhoLote() {
        return tamanhoLote;
    }

    public static String getPfxDeTransmissao() {
        return pfxDeTransmissao;
    }

    public static String getTrustStore() {
        return trustStore;
    }

    public static String getTipoAmbiente() {
        return tipoAmbiente;
    }

    public static void main(String[] args) {
        System.out.println("->" + ConfiguracaoSys.getTipoAmbiente());
    }

    public static Hashtable<String, String> getCnpjsUF() {
        return cnpjsUF;
    }

    public static String getArquivoServicos() {
        return arquivoServicos;
    }

    public static Hashtable<String, String> getNomesFantasia() {
        return nomesFantasia;
    }

    public static ConfiguracaoXML getSenderConfig() {
        return senderConfig;
    }

    public static Hashtable<String, String> getEMails() {
        return eMails;
    }

    public static Hashtable<String, String> getCasos() {
        return casos;
    }

    public static Hashtable<ParChave, String> getCnpjsTipo() {
        return cnpjsTipo;
    }

    public static Hashtable<String, String> getTipoEnvio() {
        return tipoenvio;
    }

    public static String getPastaWrapper() {
        return pastaWrapper;
    }

    public static String getUrlxmldb() {
        return urlxmldb;
    }

    public static String getSenhaxmldb() {
        return senhaxmldb;
    }

    public static void setPastaWrapper(String pastaWrapper) {
        ConfiguracaoSys.pastaWrapper = pastaWrapper;
    }
}

