/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.util;

import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import br.com.taragona.nfe.util.logger.LoggingJava;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.persistence.Query;

public class ExtrairNotasProtocolos {
    private DAOGenerico<EstadoNFe> dao;
    private String path;
    private SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy hh:mm");

    public ExtrairNotasProtocolos(String path) {
        this.dao = new DAOGenerico(EstadoNFe.class);
        this.path = path;
    }

    public ExtrairNotasProtocolos() {
    }

    public void extrairNotas() {
        List<EstadoNFe> notas = this.obterNotas();
        for (EstadoNFe nota : notas) {
            try {
                FileWriter fw = new FileWriter(String.valueOf(this.path) + "/" + nota.getId() + ".xml");
                if (nota.getXmlString() != null) {
                    fw.write(nota.getXmlString());
                }
                fw.write("\n");
                if (nota.getProtocoloXML() != null) {
                    fw.write(nota.getProtocoloXML());
                }
                fw.close();
            }
            catch (IOException e) {
                LoggingJava.logger.info("Nota nao gerada: " + nota.getId());
                e.printStackTrace();
            }
        }
    }

    public List<EstadoNFe> obterNotas() {
        Vector<String> cnpjs = PropriedadesMain.getCnpjs();
        Query q = null;
        if (cnpjs.size() == 0) {
            q = this.dao.criarQuery("select e from EstadoNFe as e where (e.estado = :estado or e.estadoNFe = :codigo or e.estadoNFe = :codigo2) and (e.dataGerada >= :d1 and e.dataGerada <= :d2)");
            q.setParameter("estado", (Object)EstadoNFe.ESTADO_NFE.AUTORIZADA);
            q.setParameter("codigo", (Object)100L);
            q.setParameter("codigo2", (Object)150L);
            q.setParameter("d1", (Object)this.obterDataLow(PropriedadesMain.getData_inicio()));
            q.setParameter("d2", (Object)this.obterDataHigh(PropriedadesMain.getData_fim()));
        }
        if (cnpjs.size() != 0) {
            q = this.dao.criarQuery("select e from EstadoNFe as e where (e.estado = :estado or e.estadoNFe = :codigo or e.estadoNFe = :codigo2) and (e.cnpj = :cnpj) and (e.dataGerada >= :d1 and e.dataGerada <= :d2)");
            q.setParameter("estado", (Object)EstadoNFe.ESTADO_NFE.AUTORIZADA);
            q.setParameter("codigo", (Object)100L);
            q.setParameter("codigo2", (Object)150L);
            q.setParameter("cnpj", (Object)cnpjs.get(0));
            q.setParameter("d1", (Object)this.obterDataLow(PropriedadesMain.getData_inicio()));
            q.setParameter("d2", (Object)this.obterDataHigh(PropriedadesMain.getData_fim()));
        }
        List notas = q.getResultList();
        return notas;
    }

    private Date obterDataLow(String d1) {
        d1 = String.valueOf(d1) + " 00:59";
        try {
            return this.format.parse(d1);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Date obterDataHigh(String d1) {
        d1 = String.valueOf(d1) + " 23:59";
        try {
            return this.format.parse(d1);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        PropriedadesMain.processarComandos(args);
        BaseDadosConfig bd = new BaseDadosConfig();
        bd.setNomeDriver(ConfiguracaoSys.getDRIVER());
        bd.setUsuario(ConfiguracaoSys.getUSER_NAME());
        bd.setSenha(ConfiguracaoSys.getPASSWORD());
        bd.setUrl(ConfiguracaoSys.getURL_CONECTION());
        bd.setToplinkProp("update");
        PropriedadesSistema.setBdConfig(bd);
        ExtrairNotasProtocolos e1 = new ExtrairNotasProtocolos(PropriedadesMain.getOutros());
        e1.extrairNotas();
    }
}

